'use strict'; // code generated by pbf v3.2.1

var LicenseType = self.LicenseType = {
    "STREAMING": {
        "value": 1,
        "options": {}
    },
    "OFFLINE": {
        "value": 2,
        "options": {}
    }
};

var ProtocolVersion = self.ProtocolVersion = {
    "VERSION_2_0": {
        "value": 20,
        "options": {}
    },
    "VERSION_2_1": {
        "value": 21,
        "options": {}
    }
};

// LicenseIdentification ========================================

var LicenseIdentification = self.LicenseIdentification = {};

LicenseIdentification.read = function (pbf, end) {
    return pbf.readFields(LicenseIdentification._readField, {request_id: null, session_id: null, purchase_id: null, type: 0, version: 0, provider_session_token: null}, end);
};
LicenseIdentification._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.request_id = pbf.readBytes();
    else if (tag === 2) obj.session_id = pbf.readBytes();
    else if (tag === 3) obj.purchase_id = pbf.readBytes();
    else if (tag === 4) obj.type = pbf.readVarint();
    else if (tag === 5) obj.version = pbf.readVarint(true);
    else if (tag === 6) obj.provider_session_token = pbf.readBytes();
};
LicenseIdentification.write = function (obj, pbf) {
    if (obj.request_id) pbf.writeBytesField(1, obj.request_id);
    if (obj.session_id) pbf.writeBytesField(2, obj.session_id);
    if (obj.purchase_id) pbf.writeBytesField(3, obj.purchase_id);
    if (obj.type) pbf.writeVarintField(4, obj.type);
    if (obj.version) pbf.writeVarintField(5, obj.version);
    if (obj.provider_session_token) pbf.writeBytesField(6, obj.provider_session_token);
};

// License ========================================

var License = self.License = {};

License.read = function (pbf, end) {
    return pbf.readFields(License._readField, {id: null, policy: null, key: [], license_start_time: 0, remote_attestation_verified: false, provider_client_token: null}, end);
};
License._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.id = LicenseIdentification.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 2) obj.policy = License.Policy.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 3) obj.key.push(License.KeyContainer.read(pbf, pbf.readVarint() + pbf.pos));
    else if (tag === 4) obj.license_start_time = pbf.readVarint(true);
    else if (tag === 5) obj.remote_attestation_verified = pbf.readBoolean();
    else if (tag === 6) obj.provider_client_token = pbf.readBytes();
};
License.write = function (obj, pbf) {
    if (obj.id) pbf.writeMessage(1, LicenseIdentification.write, obj.id);
    if (obj.policy) pbf.writeMessage(2, License.Policy.write, obj.policy);
    if (obj.key) for (var i = 0; i < obj.key.length; i++) pbf.writeMessage(3, License.KeyContainer.write, obj.key[i]);
    if (obj.license_start_time) pbf.writeVarintField(4, obj.license_start_time);
    if (obj.remote_attestation_verified) pbf.writeBooleanField(5, obj.remote_attestation_verified);
    if (obj.provider_client_token) pbf.writeBytesField(6, obj.provider_client_token);
};

// License.Policy ========================================

License.Policy = {};

License.Policy.read = function (pbf, end) {
    return pbf.readFields(License.Policy._readField, {can_play: false, can_persist: false, can_renew: false, rental_duration_seconds: 0, playback_duration_seconds: 0, license_duration_seconds: 0, renewal_recovery_duration_seconds: 0, renewal_server_url: "", renewal_delay_seconds: 0, renewal_retry_interval_seconds: 0, renew_with_usage: false, renew_with_client_id: false}, end);
};
License.Policy._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.can_play = pbf.readBoolean();
    else if (tag === 2) obj.can_persist = pbf.readBoolean();
    else if (tag === 3) obj.can_renew = pbf.readBoolean();
    else if (tag === 4) obj.rental_duration_seconds = pbf.readVarint(true);
    else if (tag === 5) obj.playback_duration_seconds = pbf.readVarint(true);
    else if (tag === 6) obj.license_duration_seconds = pbf.readVarint(true);
    else if (tag === 7) obj.renewal_recovery_duration_seconds = pbf.readVarint(true);
    else if (tag === 8) obj.renewal_server_url = pbf.readString();
    else if (tag === 9) obj.renewal_delay_seconds = pbf.readVarint(true);
    else if (tag === 10) obj.renewal_retry_interval_seconds = pbf.readVarint(true);
    else if (tag === 11) obj.renew_with_usage = pbf.readBoolean();
    else if (tag === 12) obj.renew_with_client_id = pbf.readBoolean();
};
License.Policy.write = function (obj, pbf) {
    if (obj.can_play) pbf.writeBooleanField(1, obj.can_play);
    if (obj.can_persist) pbf.writeBooleanField(2, obj.can_persist);
    if (obj.can_renew) pbf.writeBooleanField(3, obj.can_renew);
    if (obj.rental_duration_seconds) pbf.writeVarintField(4, obj.rental_duration_seconds);
    if (obj.playback_duration_seconds) pbf.writeVarintField(5, obj.playback_duration_seconds);
    if (obj.license_duration_seconds) pbf.writeVarintField(6, obj.license_duration_seconds);
    if (obj.renewal_recovery_duration_seconds) pbf.writeVarintField(7, obj.renewal_recovery_duration_seconds);
    if (obj.renewal_server_url) pbf.writeStringField(8, obj.renewal_server_url);
    if (obj.renewal_delay_seconds) pbf.writeVarintField(9, obj.renewal_delay_seconds);
    if (obj.renewal_retry_interval_seconds) pbf.writeVarintField(10, obj.renewal_retry_interval_seconds);
    if (obj.renew_with_usage) pbf.writeBooleanField(11, obj.renew_with_usage);
    if (obj.renew_with_client_id) pbf.writeBooleanField(12, obj.renew_with_client_id);
};

// License.KeyContainer ========================================

License.KeyContainer = {};

License.KeyContainer.read = function (pbf, end) {
    return pbf.readFields(License.KeyContainer._readField, {id: null, iv: null, key: null, type: 0, level: {"value":1,"options":{}}, required_protection: null, requested_protection: null, key_control: null, operator_session_key_permissions: null, video_resolution_constraints: [], anti_rollback_usage_table: false}, end);
};
License.KeyContainer._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.id = pbf.readBytes();
    else if (tag === 2) obj.iv = pbf.readBytes();
    else if (tag === 3) obj.key = pbf.readBytes();
    else if (tag === 4) obj.type = pbf.readVarint();
    else if (tag === 5) obj.level = pbf.readVarint();
    else if (tag === 6) obj.required_protection = License.KeyContainer.OutputProtection.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 7) obj.requested_protection = License.KeyContainer.OutputProtection.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 8) obj.key_control = License.KeyContainer.KeyControl.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 9) obj.operator_session_key_permissions = License.KeyContainer.OperatorSessionKeyPermissions.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 10) obj.video_resolution_constraints.push(License.KeyContainer.VideoResolutionConstraint.read(pbf, pbf.readVarint() + pbf.pos));
    else if (tag === 11) obj.anti_rollback_usage_table = pbf.readBoolean();
};
License.KeyContainer.write = function (obj, pbf) {
    if (obj.id) pbf.writeBytesField(1, obj.id);
    if (obj.iv) pbf.writeBytesField(2, obj.iv);
    if (obj.key) pbf.writeBytesField(3, obj.key);
    if (obj.type) pbf.writeVarintField(4, obj.type);
    if (obj.level != undefined && obj.level !== {"value":1,"options":{}}) pbf.writeVarintField(5, obj.level);
    if (obj.required_protection) pbf.writeMessage(6, License.KeyContainer.OutputProtection.write, obj.required_protection);
    if (obj.requested_protection) pbf.writeMessage(7, License.KeyContainer.OutputProtection.write, obj.requested_protection);
    if (obj.key_control) pbf.writeMessage(8, License.KeyContainer.KeyControl.write, obj.key_control);
    if (obj.operator_session_key_permissions) pbf.writeMessage(9, License.KeyContainer.OperatorSessionKeyPermissions.write, obj.operator_session_key_permissions);
    if (obj.video_resolution_constraints) for (var i = 0; i < obj.video_resolution_constraints.length; i++) pbf.writeMessage(10, License.KeyContainer.VideoResolutionConstraint.write, obj.video_resolution_constraints[i]);
    if (obj.anti_rollback_usage_table) pbf.writeBooleanField(11, obj.anti_rollback_usage_table);
};

License.KeyContainer.KeyType = {
    "SIGNING": {
        "value": 1,
        "options": {}
    },
    "CONTENT": {
        "value": 2,
        "options": {}
    },
    "KEY_CONTROL": {
        "value": 3,
        "options": {}
    },
    "OPERATOR_SESSION": {
        "value": 4,
        "options": {}
    }
};

License.KeyContainer.SecurityLevel = {
    "SW_SECURE_CRYPTO": {
        "value": 1,
        "options": {}
    },
    "SW_SECURE_DECODE": {
        "value": 2,
        "options": {}
    },
    "HW_SECURE_CRYPTO": {
        "value": 3,
        "options": {}
    },
    "HW_SECURE_DECODE": {
        "value": 4,
        "options": {}
    },
    "HW_SECURE_ALL": {
        "value": 5,
        "options": {}
    }
};

// License.KeyContainer.KeyControl ========================================

License.KeyContainer.KeyControl = {};

License.KeyContainer.KeyControl.read = function (pbf, end) {
    return pbf.readFields(License.KeyContainer.KeyControl._readField, {key_control_block: null, iv: null}, end);
};
License.KeyContainer.KeyControl._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.key_control_block = pbf.readBytes();
    else if (tag === 2) obj.iv = pbf.readBytes();
};
License.KeyContainer.KeyControl.write = function (obj, pbf) {
    if (obj.key_control_block) pbf.writeBytesField(1, obj.key_control_block);
    if (obj.iv) pbf.writeBytesField(2, obj.iv);
};

// License.KeyContainer.OutputProtection ========================================

License.KeyContainer.OutputProtection = {};

License.KeyContainer.OutputProtection.read = function (pbf, end) {
    return pbf.readFields(License.KeyContainer.OutputProtection._readField, {hdcp: {"value":0,"options":{}}, cgms_flags: {"value":42,"options":{}}}, end);
};
License.KeyContainer.OutputProtection._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.hdcp = pbf.readVarint();
    else if (tag === 2) obj.cgms_flags = pbf.readVarint();
};
License.KeyContainer.OutputProtection.write = function (obj, pbf) {
    if (obj.hdcp != undefined && obj.hdcp !== {"value":0,"options":{}}) pbf.writeVarintField(1, obj.hdcp);
    if (obj.cgms_flags != undefined && obj.cgms_flags !== {"value":42,"options":{}}) pbf.writeVarintField(2, obj.cgms_flags);
};

License.KeyContainer.OutputProtection.HDCP = {
    "HDCP_NONE": {
        "value": 0,
        "options": {}
    },
    "HDCP_V1": {
        "value": 1,
        "options": {}
    },
    "HDCP_V2": {
        "value": 2,
        "options": {}
    },
    "HDCP_V2_1": {
        "value": 3,
        "options": {}
    },
    "HDCP_V2_2": {
        "value": 4,
        "options": {}
    },
    "HDCP_NO_DIGITAL_OUTPUT": {
        "value": 255,
        "options": {}
    }
};

License.KeyContainer.OutputProtection.CGMS = {
    "CGMS_NONE": {
        "value": 42,
        "options": {}
    },
    "COPY_FREE": {
        "value": 0,
        "options": {}
    },
    "COPY_ONCE": {
        "value": 2,
        "options": {}
    },
    "COPY_NEVER": {
        "value": 3,
        "options": {}
    }
};

// License.KeyContainer.VideoResolutionConstraint ========================================

License.KeyContainer.VideoResolutionConstraint = {};

License.KeyContainer.VideoResolutionConstraint.read = function (pbf, end) {
    return pbf.readFields(License.KeyContainer.VideoResolutionConstraint._readField, {min_resolution_pixels: 0, max_resolution_pixels: 0, required_protection: null}, end);
};
License.KeyContainer.VideoResolutionConstraint._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.min_resolution_pixels = pbf.readVarint();
    else if (tag === 2) obj.max_resolution_pixels = pbf.readVarint();
    else if (tag === 3) obj.required_protection = License.KeyContainer.OutputProtection.read(pbf, pbf.readVarint() + pbf.pos);
};
License.KeyContainer.VideoResolutionConstraint.write = function (obj, pbf) {
    if (obj.min_resolution_pixels) pbf.writeVarintField(1, obj.min_resolution_pixels);
    if (obj.max_resolution_pixels) pbf.writeVarintField(2, obj.max_resolution_pixels);
    if (obj.required_protection) pbf.writeMessage(3, License.KeyContainer.OutputProtection.write, obj.required_protection);
};

// License.KeyContainer.OperatorSessionKeyPermissions ========================================

License.KeyContainer.OperatorSessionKeyPermissions = {};

License.KeyContainer.OperatorSessionKeyPermissions.read = function (pbf, end) {
    return pbf.readFields(License.KeyContainer.OperatorSessionKeyPermissions._readField, {allow_encrypt: false, allow_decrypt: false, allow_sign: false, allow_signature_verify: false}, end);
};
License.KeyContainer.OperatorSessionKeyPermissions._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.allow_encrypt = pbf.readBoolean();
    else if (tag === 2) obj.allow_decrypt = pbf.readBoolean();
    else if (tag === 3) obj.allow_sign = pbf.readBoolean();
    else if (tag === 4) obj.allow_signature_verify = pbf.readBoolean();
};
License.KeyContainer.OperatorSessionKeyPermissions.write = function (obj, pbf) {
    if (obj.allow_encrypt) pbf.writeBooleanField(1, obj.allow_encrypt);
    if (obj.allow_decrypt) pbf.writeBooleanField(2, obj.allow_decrypt);
    if (obj.allow_sign) pbf.writeBooleanField(3, obj.allow_sign);
    if (obj.allow_signature_verify) pbf.writeBooleanField(4, obj.allow_signature_verify);
};

// LicenseRequest ========================================

var LicenseRequest = self.LicenseRequest = {};

LicenseRequest.read = function (pbf, end) {
    return pbf.readFields(LicenseRequest._readField, {client_id: null, content_id: null, type: 0, request_time: 0, key_control_nonce_deprecated: null, protocol_version: {"value":20,"options":{}}, key_control_nonce: 0, encrypted_client_id: null}, end);
};
LicenseRequest._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.client_id = ClientIdentification.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 2) obj.content_id = LicenseRequest.ContentIdentification.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 3) obj.type = pbf.readVarint();
    else if (tag === 4) obj.request_time = pbf.readVarint(true);
    else if (tag === 5) obj.key_control_nonce_deprecated = pbf.readBytes();
    else if (tag === 6) obj.protocol_version = pbf.readVarint();
    else if (tag === 7) obj.key_control_nonce = pbf.readVarint();
    else if (tag === 8) obj.encrypted_client_id = EncryptedClientIdentification.read(pbf, pbf.readVarint() + pbf.pos);
};
LicenseRequest.write = function (obj, pbf) {
    if (obj.client_id) pbf.writeMessage(1, ClientIdentification.write, obj.client_id);
    if (obj.content_id) pbf.writeMessage(2, LicenseRequest.ContentIdentification.write, obj.content_id);
    if (obj.type) pbf.writeVarintField(3, obj.type);
    if (obj.request_time) pbf.writeVarintField(4, obj.request_time);
    if (obj.key_control_nonce_deprecated) pbf.writeBytesField(5, obj.key_control_nonce_deprecated);
    if (obj.protocol_version != undefined && obj.protocol_version !== {"value":20,"options":{}}) pbf.writeVarintField(6, obj.protocol_version);
    if (obj.key_control_nonce) pbf.writeVarintField(7, obj.key_control_nonce);
    if (obj.encrypted_client_id) pbf.writeMessage(8, EncryptedClientIdentification.write, obj.encrypted_client_id);
};

LicenseRequest.RequestType = {
    "NEW": {
        "value": 1,
        "options": {}
    },
    "RENEWAL": {
        "value": 2,
        "options": {}
    },
    "RELEASE": {
        "value": 3,
        "options": {}
    }
};

// LicenseRequest.ContentIdentification ========================================

LicenseRequest.ContentIdentification = {};

LicenseRequest.ContentIdentification.read = function (pbf, end) {
    return pbf.readFields(LicenseRequest.ContentIdentification._readField, {cenc_id: null, webm_id: null, license: null}, end);
};
LicenseRequest.ContentIdentification._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.cenc_id = LicenseRequest.ContentIdentification.CENC.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 2) obj.webm_id = LicenseRequest.ContentIdentification.WebM.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 3) obj.license = LicenseRequest.ContentIdentification.ExistingLicense.read(pbf, pbf.readVarint() + pbf.pos);
};
LicenseRequest.ContentIdentification.write = function (obj, pbf) {
    if (obj.cenc_id) pbf.writeMessage(1, LicenseRequest.ContentIdentification.CENC.write, obj.cenc_id);
    if (obj.webm_id) pbf.writeMessage(2, LicenseRequest.ContentIdentification.WebM.write, obj.webm_id);
    if (obj.license) pbf.writeMessage(3, LicenseRequest.ContentIdentification.ExistingLicense.write, obj.license);
};

// LicenseRequest.ContentIdentification.CENC ========================================

LicenseRequest.ContentIdentification.CENC = {};

LicenseRequest.ContentIdentification.CENC.read = function (pbf, end) {
    return pbf.readFields(LicenseRequest.ContentIdentification.CENC._readField, {pssh: [], license_type: 0, request_id: null}, end);
};
LicenseRequest.ContentIdentification.CENC._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.pssh.push(pbf.readBytes());
    else if (tag === 2) obj.license_type = pbf.readVarint();
    else if (tag === 3) obj.request_id = pbf.readBytes();
};
LicenseRequest.ContentIdentification.CENC.write = function (obj, pbf) {
    if (obj.pssh) for (var i = 0; i < obj.pssh.length; i++) pbf.writeBytesField(1, obj.pssh[i]);
    if (obj.license_type) pbf.writeVarintField(2, obj.license_type);
    if (obj.request_id) pbf.writeBytesField(3, obj.request_id);
};

// LicenseRequest.ContentIdentification.WebM ========================================

LicenseRequest.ContentIdentification.WebM = {};

LicenseRequest.ContentIdentification.WebM.read = function (pbf, end) {
    return pbf.readFields(LicenseRequest.ContentIdentification.WebM._readField, {header: null, license_type: 0, request_id: null}, end);
};
LicenseRequest.ContentIdentification.WebM._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.header = pbf.readBytes();
    else if (tag === 2) obj.license_type = pbf.readVarint();
    else if (tag === 3) obj.request_id = pbf.readBytes();
};
LicenseRequest.ContentIdentification.WebM.write = function (obj, pbf) {
    if (obj.header) pbf.writeBytesField(1, obj.header);
    if (obj.license_type) pbf.writeVarintField(2, obj.license_type);
    if (obj.request_id) pbf.writeBytesField(3, obj.request_id);
};

// LicenseRequest.ContentIdentification.ExistingLicense ========================================

LicenseRequest.ContentIdentification.ExistingLicense = {};

LicenseRequest.ContentIdentification.ExistingLicense.read = function (pbf, end) {
    return pbf.readFields(LicenseRequest.ContentIdentification.ExistingLicense._readField, {license_id: null, seconds_since_started: 0, seconds_since_last_played: 0, session_usage_table_entry: null}, end);
};
LicenseRequest.ContentIdentification.ExistingLicense._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.license_id = LicenseIdentification.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 2) obj.seconds_since_started = pbf.readVarint(true);
    else if (tag === 3) obj.seconds_since_last_played = pbf.readVarint(true);
    else if (tag === 4) obj.session_usage_table_entry = pbf.readBytes();
};
LicenseRequest.ContentIdentification.ExistingLicense.write = function (obj, pbf) {
    if (obj.license_id) pbf.writeMessage(1, LicenseIdentification.write, obj.license_id);
    if (obj.seconds_since_started) pbf.writeVarintField(2, obj.seconds_since_started);
    if (obj.seconds_since_last_played) pbf.writeVarintField(3, obj.seconds_since_last_played);
    if (obj.session_usage_table_entry) pbf.writeBytesField(4, obj.session_usage_table_entry);
};

// LicenseError ========================================

var LicenseError = self.LicenseError = {};

LicenseError.read = function (pbf, end) {
    return pbf.readFields(LicenseError._readField, {error_code: 0}, end);
};
LicenseError._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.error_code = pbf.readVarint();
};
LicenseError.write = function (obj, pbf) {
    if (obj.error_code) pbf.writeVarintField(1, obj.error_code);
};

LicenseError.Error = {
    "INVALID_DEVICE_CERTIFICATE": {
        "value": 1,
        "options": {}
    },
    "REVOKED_DEVICE_CERTIFICATE": {
        "value": 2,
        "options": {}
    },
    "SERVICE_UNAVAILABLE": {
        "value": 3,
        "options": {}
    }
};

// RemoteAttestation ========================================

var RemoteAttestation = self.RemoteAttestation = {};

RemoteAttestation.read = function (pbf, end) {
    return pbf.readFields(RemoteAttestation._readField, {certificate: null, salt: null, signature: null}, end);
};
RemoteAttestation._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.certificate = EncryptedClientIdentification.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 2) obj.salt = pbf.readBytes();
    else if (tag === 3) obj.signature = pbf.readBytes();
};
RemoteAttestation.write = function (obj, pbf) {
    if (obj.certificate) pbf.writeMessage(1, EncryptedClientIdentification.write, obj.certificate);
    if (obj.salt) pbf.writeBytesField(2, obj.salt);
    if (obj.signature) pbf.writeBytesField(3, obj.signature);
};

// SignedMessage ========================================

var SignedMessage = self.SignedMessage = {};

SignedMessage.read = function (pbf, end) {
    return pbf.readFields(SignedMessage._readField, {type: 0, msg: null, signature: null, session_key: null, remote_attestation: null}, end);
};
SignedMessage._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.type = pbf.readVarint();
    else if (tag === 2) obj.msg = pbf.readBytes();
    else if (tag === 3) obj.signature = pbf.readBytes();
    else if (tag === 4) obj.session_key = pbf.readBytes();
    else if (tag === 5) obj.remote_attestation = RemoteAttestation.read(pbf, pbf.readVarint() + pbf.pos);
};
SignedMessage.write = function (obj, pbf) {
    if (obj.type) pbf.writeVarintField(1, obj.type);
    if (obj.msg) pbf.writeBytesField(2, obj.msg);
    if (obj.signature) pbf.writeBytesField(3, obj.signature);
    if (obj.session_key) pbf.writeBytesField(4, obj.session_key);
    if (obj.remote_attestation) pbf.writeMessage(5, RemoteAttestation.write, obj.remote_attestation);
};

SignedMessage.MessageType = {
    "LICENSE_REQUEST": {
        "value": 1,
        "options": {}
    },
    "LICENSE": {
        "value": 2,
        "options": {}
    },
    "ERROR_RESPONSE": {
        "value": 3,
        "options": {}
    },
    "SERVICE_CERTIFICATE_REQUEST": {
        "value": 4,
        "options": {}
    },
    "SERVICE_CERTIFICATE": {
        "value": 5,
        "options": {}
    }
};

// ProvisioningOptions ========================================

var ProvisioningOptions = self.ProvisioningOptions = {};

ProvisioningOptions.read = function (pbf, end) {
    return pbf.readFields(ProvisioningOptions._readField, {certificate_type: 0, certificate_authority: ""}, end);
};
ProvisioningOptions._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.certificate_type = pbf.readVarint();
    else if (tag === 2) obj.certificate_authority = pbf.readString();
};
ProvisioningOptions.write = function (obj, pbf) {
    if (obj.certificate_type) pbf.writeVarintField(1, obj.certificate_type);
    if (obj.certificate_authority) pbf.writeStringField(2, obj.certificate_authority);
};

ProvisioningOptions.CertificateType = {
    "WIDEVINE_DRM": {
        "value": 0,
        "options": {}
    },
    "X509": {
        "value": 1,
        "options": {}
    }
};

// ProvisioningRequest ========================================

var ProvisioningRequest = self.ProvisioningRequest = {};

ProvisioningRequest.read = function (pbf, end) {
    return pbf.readFields(ProvisioningRequest._readField, {client_id: null, nonce: null, options: null, stable_id: null}, end);
};
ProvisioningRequest._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.client_id = ClientIdentification.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 2) obj.nonce = pbf.readBytes();
    else if (tag === 3) obj.options = ProvisioningOptions.read(pbf, pbf.readVarint() + pbf.pos);
    else if (tag === 4) obj.stable_id = pbf.readBytes();
};
ProvisioningRequest.write = function (obj, pbf) {
    if (obj.client_id) pbf.writeMessage(1, ClientIdentification.write, obj.client_id);
    if (obj.nonce) pbf.writeBytesField(2, obj.nonce);
    if (obj.options) pbf.writeMessage(3, ProvisioningOptions.write, obj.options);
    if (obj.stable_id) pbf.writeBytesField(4, obj.stable_id);
};

// ProvisioningResponse ========================================

var ProvisioningResponse = self.ProvisioningResponse = {};

ProvisioningResponse.read = function (pbf, end) {
    return pbf.readFields(ProvisioningResponse._readField, {device_rsa_key: null, device_rsa_key_iv: null, device_certificate: null, nonce: null}, end);
};
ProvisioningResponse._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.device_rsa_key = pbf.readBytes();
    else if (tag === 2) obj.device_rsa_key_iv = pbf.readBytes();
    else if (tag === 3) obj.device_certificate = pbf.readBytes();
    else if (tag === 4) obj.nonce = pbf.readBytes();
};
ProvisioningResponse.write = function (obj, pbf) {
    if (obj.device_rsa_key) pbf.writeBytesField(1, obj.device_rsa_key);
    if (obj.device_rsa_key_iv) pbf.writeBytesField(2, obj.device_rsa_key_iv);
    if (obj.device_certificate) pbf.writeBytesField(3, obj.device_certificate);
    if (obj.nonce) pbf.writeBytesField(4, obj.nonce);
};

// SignedProvisioningMessage ========================================

var SignedProvisioningMessage = self.SignedProvisioningMessage = {};

SignedProvisioningMessage.read = function (pbf, end) {
    return pbf.readFields(SignedProvisioningMessage._readField, {message: null, signature: null}, end);
};
SignedProvisioningMessage._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.message = pbf.readBytes();
    else if (tag === 2) obj.signature = pbf.readBytes();
};
SignedProvisioningMessage.write = function (obj, pbf) {
    if (obj.message) pbf.writeBytesField(1, obj.message);
    if (obj.signature) pbf.writeBytesField(2, obj.signature);
};

// ClientIdentification ========================================

var ClientIdentification = self.ClientIdentification = {};

ClientIdentification.read = function (pbf, end) {
    return pbf.readFields(ClientIdentification._readField, {type: {"value":0,"options":{}}, token: null, client_info: [], provider_client_token: null, license_counter: 0, client_capabilities: null}, end);
};
ClientIdentification._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.type = pbf.readVarint();
    else if (tag === 2) obj.token = pbf.readBytes();
    else if (tag === 3) obj.client_info.push(ClientIdentification.NameValue.read(pbf, pbf.readVarint() + pbf.pos));
    else if (tag === 4) obj.provider_client_token = pbf.readBytes();
    else if (tag === 5) obj.license_counter = pbf.readVarint();
    else if (tag === 6) obj.client_capabilities = ClientIdentification.ClientCapabilities.read(pbf, pbf.readVarint() + pbf.pos);
};
ClientIdentification.write = function (obj, pbf) {
    if (obj.type != undefined && obj.type !== {"value":0,"options":{}}) pbf.writeVarintField(1, obj.type);
    if (obj.token) pbf.writeBytesField(2, obj.token);
    if (obj.client_info) for (var i = 0; i < obj.client_info.length; i++) pbf.writeMessage(3, ClientIdentification.NameValue.write, obj.client_info[i]);
    if (obj.provider_client_token) pbf.writeBytesField(4, obj.provider_client_token);
    if (obj.license_counter) pbf.writeVarintField(5, obj.license_counter);
    if (obj.client_capabilities) pbf.writeMessage(6, ClientIdentification.ClientCapabilities.write, obj.client_capabilities);
};

ClientIdentification.TokenType = {
    "KEYBOX": {
        "value": 0,
        "options": {}
    },
    "DEVICE_CERTIFICATE": {
        "value": 1,
        "options": {}
    },
    "REMOTE_ATTESTATION_CERTIFICATE": {
        "value": 2,
        "options": {}
    }
};

// ClientIdentification.NameValue ========================================

ClientIdentification.NameValue = {};

ClientIdentification.NameValue.read = function (pbf, end) {
    return pbf.readFields(ClientIdentification.NameValue._readField, {name: "", value: ""}, end);
};
ClientIdentification.NameValue._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.name = pbf.readString();
    else if (tag === 2) obj.value = pbf.readString();
};
ClientIdentification.NameValue.write = function (obj, pbf) {
    if (obj.name) pbf.writeStringField(1, obj.name);
    if (obj.value) pbf.writeStringField(2, obj.value);
};

// ClientIdentification.ClientCapabilities ========================================

ClientIdentification.ClientCapabilities = {};

ClientIdentification.ClientCapabilities.read = function (pbf, end) {
    return pbf.readFields(ClientIdentification.ClientCapabilities._readField, {client_token: false, session_token: false, video_resolution_constraints: false, max_hdcp_version: {"value":0,"options":{}}, oem_crypto_api_version: 0, anti_rollback_usage_table: false}, end);
};
ClientIdentification.ClientCapabilities._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.client_token = pbf.readBoolean();
    else if (tag === 2) obj.session_token = pbf.readBoolean();
    else if (tag === 3) obj.video_resolution_constraints = pbf.readBoolean();
    else if (tag === 4) obj.max_hdcp_version = pbf.readVarint();
    else if (tag === 5) obj.oem_crypto_api_version = pbf.readVarint();
    else if (tag === 6) obj.anti_rollback_usage_table = pbf.readBoolean();
};
ClientIdentification.ClientCapabilities.write = function (obj, pbf) {
    if (obj.client_token) pbf.writeBooleanField(1, obj.client_token);
    if (obj.session_token) pbf.writeBooleanField(2, obj.session_token);
    if (obj.video_resolution_constraints) pbf.writeBooleanField(3, obj.video_resolution_constraints);
    if (obj.max_hdcp_version != undefined && obj.max_hdcp_version !== {"value":0,"options":{}}) pbf.writeVarintField(4, obj.max_hdcp_version);
    if (obj.oem_crypto_api_version) pbf.writeVarintField(5, obj.oem_crypto_api_version);
    if (obj.anti_rollback_usage_table) pbf.writeBooleanField(6, obj.anti_rollback_usage_table);
};

ClientIdentification.ClientCapabilities.HdcpVersion = {
    "HDCP_NONE": {
        "value": 0,
        "options": {}
    },
    "HDCP_V1": {
        "value": 1,
        "options": {}
    },
    "HDCP_V2": {
        "value": 2,
        "options": {}
    },
    "HDCP_V2_1": {
        "value": 3,
        "options": {}
    },
    "HDCP_V2_2": {
        "value": 4,
        "options": {}
    },
    "HDCP_NO_DIGITAL_OUTPUT": {
        "value": 255,
        "options": {}
    }
};

// EncryptedClientIdentification ========================================

var EncryptedClientIdentification = self.EncryptedClientIdentification = {};

EncryptedClientIdentification.read = function (pbf, end) {
    return pbf.readFields(EncryptedClientIdentification._readField, {service_id: "", service_certificate_serial_number: null, encrypted_client_id: null, encrypted_client_id_iv: null, encrypted_privacy_key: null}, end);
};
EncryptedClientIdentification._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.service_id = pbf.readString();
    else if (tag === 2) obj.service_certificate_serial_number = pbf.readBytes();
    else if (tag === 3) obj.encrypted_client_id = pbf.readBytes();
    else if (tag === 4) obj.encrypted_client_id_iv = pbf.readBytes();
    else if (tag === 5) obj.encrypted_privacy_key = pbf.readBytes();
};
EncryptedClientIdentification.write = function (obj, pbf) {
    if (obj.service_id) pbf.writeStringField(1, obj.service_id);
    if (obj.service_certificate_serial_number) pbf.writeBytesField(2, obj.service_certificate_serial_number);
    if (obj.encrypted_client_id) pbf.writeBytesField(3, obj.encrypted_client_id);
    if (obj.encrypted_client_id_iv) pbf.writeBytesField(4, obj.encrypted_client_id_iv);
    if (obj.encrypted_privacy_key) pbf.writeBytesField(5, obj.encrypted_privacy_key);
};

// DeviceCertificate ========================================

var DeviceCertificate = self.DeviceCertificate = {};

DeviceCertificate.read = function (pbf, end) {
    return pbf.readFields(DeviceCertificate._readField, {type: 0, serial_number: null, creation_time_seconds: 0, public_key: null, system_id: 0, test_device_deprecated: false, service_id: ""}, end);
};
DeviceCertificate._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.type = pbf.readVarint();
    else if (tag === 2) obj.serial_number = pbf.readBytes();
    else if (tag === 3) obj.creation_time_seconds = pbf.readVarint();
    else if (tag === 4) obj.public_key = pbf.readBytes();
    else if (tag === 5) obj.system_id = pbf.readVarint();
    else if (tag === 6) obj.test_device_deprecated = pbf.readBoolean();
    else if (tag === 7) obj.service_id = pbf.readString();
};
DeviceCertificate.write = function (obj, pbf) {
    if (obj.type) pbf.writeVarintField(1, obj.type);
    if (obj.serial_number) pbf.writeBytesField(2, obj.serial_number);
    if (obj.creation_time_seconds) pbf.writeVarintField(3, obj.creation_time_seconds);
    if (obj.public_key) pbf.writeBytesField(4, obj.public_key);
    if (obj.system_id) pbf.writeVarintField(5, obj.system_id);
    if (obj.test_device_deprecated) pbf.writeBooleanField(6, obj.test_device_deprecated);
    if (obj.service_id) pbf.writeStringField(7, obj.service_id);
};

DeviceCertificate.CertificateType = {
    "ROOT": {
        "value": 0,
        "options": {}
    },
    "INTERMEDIATE": {
        "value": 1,
        "options": {}
    },
    "USER_DEVICE": {
        "value": 2,
        "options": {}
    },
    "SERVICE": {
        "value": 3,
        "options": {}
    }
};

// SignedDeviceCertificate ========================================

var SignedDeviceCertificate = self.SignedDeviceCertificate = {};

SignedDeviceCertificate.read = function (pbf, end) {
    return pbf.readFields(SignedDeviceCertificate._readField, {device_certificate: null, signature: null, signer: null}, end);
};
SignedDeviceCertificate._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.device_certificate = pbf.readBytes();
    else if (tag === 2) obj.signature = pbf.readBytes();
    else if (tag === 3) obj.signer = SignedDeviceCertificate.read(pbf, pbf.readVarint() + pbf.pos);
};
SignedDeviceCertificate.write = function (obj, pbf) {
    if (obj.device_certificate) pbf.writeBytesField(1, obj.device_certificate);
    if (obj.signature) pbf.writeBytesField(2, obj.signature);
    if (obj.signer) pbf.writeMessage(3, SignedDeviceCertificate.write, obj.signer);
};

// ProvisionedDeviceInfo ========================================

var ProvisionedDeviceInfo = self.ProvisionedDeviceInfo = {};

ProvisionedDeviceInfo.read = function (pbf, end) {
    return pbf.readFields(ProvisionedDeviceInfo._readField, {system_id: 0, soc: "", manufacturer: "", model: "", device_type: "", model_year: 0, security_level: {"value":0,"options":{}}, test_device: false}, end);
};
ProvisionedDeviceInfo._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.system_id = pbf.readVarint();
    else if (tag === 2) obj.soc = pbf.readString();
    else if (tag === 3) obj.manufacturer = pbf.readString();
    else if (tag === 4) obj.model = pbf.readString();
    else if (tag === 5) obj.device_type = pbf.readString();
    else if (tag === 6) obj.model_year = pbf.readVarint();
    else if (tag === 7) obj.security_level = pbf.readVarint();
    else if (tag === 8) obj.test_device = pbf.readBoolean();
};
ProvisionedDeviceInfo.write = function (obj, pbf) {
    if (obj.system_id) pbf.writeVarintField(1, obj.system_id);
    if (obj.soc) pbf.writeStringField(2, obj.soc);
    if (obj.manufacturer) pbf.writeStringField(3, obj.manufacturer);
    if (obj.model) pbf.writeStringField(4, obj.model);
    if (obj.device_type) pbf.writeStringField(5, obj.device_type);
    if (obj.model_year) pbf.writeVarintField(6, obj.model_year);
    if (obj.security_level != undefined && obj.security_level !== {"value":0,"options":{}}) pbf.writeVarintField(7, obj.security_level);
    if (obj.test_device) pbf.writeBooleanField(8, obj.test_device);
};

ProvisionedDeviceInfo.WvSecurityLevel = {
    "LEVEL_UNSPECIFIED": {
        "value": 0,
        "options": {}
    },
    "LEVEL_1": {
        "value": 1,
        "options": {}
    },
    "LEVEL_2": {
        "value": 2,
        "options": {}
    },
    "LEVEL_3": {
        "value": 3,
        "options": {}
    }
};

// DeviceCertificateStatus ========================================

var DeviceCertificateStatus = self.DeviceCertificateStatus = {};

DeviceCertificateStatus.read = function (pbf, end) {
    return pbf.readFields(DeviceCertificateStatus._readField, {serial_number: null, status: {"value":0,"options":{}}, device_info: null}, end);
};
DeviceCertificateStatus._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.serial_number = pbf.readBytes();
    else if (tag === 2) obj.status = pbf.readVarint();
    else if (tag === 4) obj.device_info = ProvisionedDeviceInfo.read(pbf, pbf.readVarint() + pbf.pos);
};
DeviceCertificateStatus.write = function (obj, pbf) {
    if (obj.serial_number) pbf.writeBytesField(1, obj.serial_number);
    if (obj.status != undefined && obj.status !== {"value":0,"options":{}}) pbf.writeVarintField(2, obj.status);
    if (obj.device_info) pbf.writeMessage(4, ProvisionedDeviceInfo.write, obj.device_info);
};

DeviceCertificateStatus.CertificateStatus = {
    "VALID": {
        "value": 0,
        "options": {}
    },
    "REVOKED": {
        "value": 1,
        "options": {}
    }
};

// DeviceCertificateStatusList ========================================

var DeviceCertificateStatusList = self.DeviceCertificateStatusList = {};

DeviceCertificateStatusList.read = function (pbf, end) {
    return pbf.readFields(DeviceCertificateStatusList._readField, {creation_time_seconds: 0, certificate_status: []}, end);
};
DeviceCertificateStatusList._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.creation_time_seconds = pbf.readVarint();
    else if (tag === 2) obj.certificate_status.push(DeviceCertificateStatus.read(pbf, pbf.readVarint() + pbf.pos));
};
DeviceCertificateStatusList.write = function (obj, pbf) {
    if (obj.creation_time_seconds) pbf.writeVarintField(1, obj.creation_time_seconds);
    if (obj.certificate_status) for (var i = 0; i < obj.certificate_status.length; i++) pbf.writeMessage(2, DeviceCertificateStatus.write, obj.certificate_status[i]);
};

// SignedCertificateStatusList ========================================

var SignedCertificateStatusList = self.SignedCertificateStatusList = {};

SignedCertificateStatusList.read = function (pbf, end) {
    return pbf.readFields(SignedCertificateStatusList._readField, {certificate_status_list: null, signature: null}, end);
};
SignedCertificateStatusList._readField = function (tag, obj, pbf) {
    if (tag === 1) obj.certificate_status_list = pbf.readBytes();
    else if (tag === 2) obj.signature = pbf.readBytes();
};
SignedCertificateStatusList.write = function (obj, pbf) {
    if (obj.certificate_status_list) pbf.writeBytesField(1, obj.certificate_status_list);
    if (obj.signature) pbf.writeBytesField(2, obj.signature);
};
