-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local timer = 1
local steamDataPath = "/temp/vehicles/ccf/steamcache.json"
local steamData = {}

local function updateGaugeData(moduleData, dt)
    -- first run
    if not moduleData.steamData then
        moduleData.steamData = {
            name = steamData[1],
            accID = steamData[2],
            lang = steamData[3],
        }
    end

    timer = timer + dt
    if timer > 1 then
        local data
        if zeitRadio then data = zeitRadio.getCurrentlyPlayingSongData() end
        moduleData.data = data
    end
end

local function setupGaugeData()
end

local function init()
    obj:queueGameEngineLua([[
        if Steam.accountLoggedIn then
            jsonWriteFile("]]..steamDataPath..[[", {Steam.playerName, Steam.getAccountIDStr(), Steam.language}, true)
        end
    ]])

    steamData = jsonReadFile(steamDataPath)
    if not steamData then
        steamData = {
            "Theo",
            "0",
            "english"
        }
    end
end

M.init = init
M.setupGaugeData = setupGaugeData
M.updateGaugeData = updateGaugeData

return M