-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local gaugeHTMLTexture
local vehType = "ccf_lhd"
local currentState = ""
local playerSeated = false

local saves = {}
local triggerInteracts = {}

local function loadCurrentStateBoxes()
    obj:queueGameEngineLua([[
        if zeit_ccfScreenInteract then
            zeit_ccfScreenInteract.loadBoxes("]].."vehicles/ccf/screen_triggers/"..vehType.."/"..currentState..[[.json")
        end
    ]])
end

local function sendState(state)
    if state ~= currentState then
        currentState = state
        -- inform the trigger script
        loadCurrentStateBoxes()
        -- update gauges
        gaugeHTMLTexture:streamJS("screenStateUpdate", "screenStateUpdate", {state})
    end
end

local function onPlayersChanged(bool)
    if bool then
        loadCurrentStateBoxes()
        obj:queueGameEngineLua([[
            if zeit_ccfScreenInteract then
                zeit_ccfScreenInteract.setFocusCar(]]..objectId..[[)
            end
        ]])
    end
end

local function updateGaugeData(moduleData, dt)
    if electrics.values.parkingSensorShow == 1 then
        sendState("pksa")
    else
        sendState("navi")
    end
    moduleData.dt = dt
end

local function input(triggerId)
    if triggerInteracts[triggerId] then
        triggerInteracts[triggerId][1](saves)
        gaugeHTMLTexture:streamJS("execFunc", "execFunc", {triggerInteracts[triggerId][2]:gsub("VALUE", tostring(saves[triggerId]))})
    end
end

local function updateData(path)
end

local function updateGFX(dt)
    if playerInfo.anyPlayerSeated ~= playerSeated then
        onPlayersChanged(playerInfo.anyPlayerSeated)
        playerSeated = playerInfo.anyPlayerSeated
    end
end

local function setupGaugeData(properties, htmlTexture)
    gaugeHTMLTexture = htmlTexture
    currentState = ""
    sendState("navi")
end

local function reset()
    currentState = ""
    sendState("navi")
end

local function init(jbeamData)
    triggerInteracts = jbeamData.triggerInteracts or triggerInteracts
    saves = jbeamData.saves or saves
    vehType = jbeamData.type or vehType
    obj:queueGameEngineLua([[
        extensions.reload("zeit_ccfScreenInteract")
    ]])

    for k,v in pairs(triggerInteracts) do
        local f, err = load("return "..v[1])
        if not f and err then
            print("Can't create function: "..v[1])
            print(err)
        end
        if f then
            triggerInteracts[k][1] = f()
        end
    end
end

M.reset = reset
M.init = init
M.updateGaugeData = updateGaugeData
M.updateData = updateData
M.updateGFX = updateGFX
M.setupGaugeData = setupGaugeData

M.input = input

return M