-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION


local M = {}

local timer = 1
local gaugeHTMLTexture

local function getSpeedLimit()
    -- mapmgr doesn't immediately have the data, so we have to request it from GE if needed.
    -- Alternatively call requestMap once on vehicle init.
    -- Call the function a second time to actually get a result.

    if not mapmgr.mapData then
        mapmgr.requestMap()
        return
    end

    local n1, n2 = mapmgr.findClosestRoad(obj:getPosition() or vec3(0,0,0))
    local mapNodes = mapmgr.mapData.graph
    local link = {speedLimit = 0}
    if n1 and n2 then
        link = mapNodes[n1][n2] or mapNodes[n2][n1] or {speedLimit = 0}
    end

    return link.speedLimit
end

local function updateGaugeData(moduleData, dt)
    timer = timer + dt
    if timer > 0.75 then
        local speedlimit = getSpeedLimit()

        if moduleData.speedLimit ~= speedlimit then
            gaugeHTMLTexture:streamJS("speedLimitChanged", "speedLimitChanged", speedlimit)
        end

        moduleData.speedlimit = speedlimit
        timer = 0
    end
end

local function setupGaugeData(properties, htmlTexture)
    gaugeHTMLTexture = htmlTexture
end

M.init = nop
M.setupGaugeData = setupGaugeData
M.updateGaugeData = updateGaugeData

return M