-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local saveFilePath = "settings/zeit/odometer/ccf.json"
local distance = 0
local saveTimer = 0

local function updateGFX(dt)
    if electrics.values.engineRunning ~= 0 and electrics.values.gearIndex ~= 0 then
        if not tonumber(electrics.values.wheelspeed) then return end
        if electrics.values.wheelspeed > 0.1 then
            distance = (distance or 0) + (electrics.values.wheelspeed * dt) * 0.001
        end
    end
    electrics.values.ccfOdometer = distance

    saveTimer = saveTimer + dt
    if saveTimer >= 5 then
        jsonWriteFile(saveFilePath, {distance = distance}, true)
        saveTimer = 0
    end
end

local function onInit()
	if not electrics.values["isSimpleTrafficCar"] then

		local data = jsonReadFile(saveFilePath)
		if data then
			distance = data.distance
			electrics.values.ccfOdometer = distance
		end
	else
		M.updateGFX = nop;
		M.onReset = nop;
	end
end

-- public interface
M.updateGFX = updateGFX
M.onInit = onInit
M.onReset = onInit

return M