var sounds = {
  piano_soft: {
    name: "noteblock_harp",
    title: "Note Block Harp",
    tags: "minecraft note block harp",
    image: "https://dabois.online/work/thirtydollarconvert/icons/noteblock_harp.png",
    associate: "piano",
    start: "F#4"
  },
  bell: {
    name: "noteblock_bell",
    title: "Note Block Bell",
    tags: "minecraft note block bell",
    image: "https://dabois.online/work/thirtydollarconvert/icons/noteblock_bell.png",
    associate: "chromatic percussion",
    start: "F#5",
  },
  noteblock_bass: {
    name: "noteblock_bass",
    title: "Note Block Bass",
    tags: "minecraft note block bass",
    image: "https://dabois.online/work/thirtydollarconvert/icons/noteblock_bass.png",
    associate: "",
    start: "F#3",
  },
  banjo: {
    name: "noteblock_banjo",
    title: "Note Block Banjo",
    tags: "minecraft note block banjo",
    image: "https://dabois.online/work/thirtydollarconvert/icons/noteblock_banjo.png",
    associate: "",
    start: "F#4",
  },
  pling: {
    name: "noteblock_pling",
    title: "Note Block Pling",
    tags: "minecraft note block pling",
    image: "https://dabois.online/work/thirtydollarconvert/icons/noteblock_pling.png",
    associate: "",
    start: "F#4",
  },
  xylophone: {
    name: "noteblock_xylophone",
    title: "Note Block Xylophone",
    tags: "minecraft note block xylophone",
    image: "https://dabois.online/work/thirtydollarconvert/icons/noteblock_xylophone.png",
    associate: "",
    start: "F#4",
  },
  piano_hard: {
    name: "builttoscale",
    title: "Widget",
    tags: "rhythm heaven widget built to scale",
    image: "https://dabois.online/work/thirtydollarconvert/icons/builttoscale.png",
    associate: "",
    start: "C4"
  },
  strings: {
    name: "mariopaint_swan",
    title: "Mario Paint Swan",
    tags: "mario paint swan strings",
    image: "https://dabois.online/work/thirtydollarconvert/icons/mariopaint_swan.png",
    associate: "strings",
    start: "F#4",
  },
  trumpet_soft: {
    name: "mariopaint_flower",
    title: "Mario Paint Flower",
    tags: "mario paint flower",
    image: "https://dabois.online/work/thirtydollarconvert/icons/mariopaint_flower.png",
    associate: "brass",
    start: "F#4",
  },
  acoustic_guitar: {
    name: "mariopaint_plane",
    title: "Mario Paint Plane",
    tags: "mario paint plane",
    image: "https://dabois.online/work/thirtydollarconvert/icons/mariopaint_plane.png",
    associate: "acoustic guitar",
    start: "F#4",
  },
  organ: {
    name: "mariopaint_car",
    title: "Mario Paint Car",
    tags: "mario paint car",
    image: "https://dabois.online/work/thirtydollarconvert/icons/mariopaint_car.png",
    associate: "organ",
    start: "F#4",
  },
  mariopaint_mario: {
    name: "mariopaint_mario",
    title: "Mario Paint Mario",
    tags: "mario paint mario",
    image: "https://dabois.online/work/thirtydollarconvert/icons/mariopaint_mario.png",
    associate: "",
    start: "F#4"
  },
  steel_drums: {
    name: "mariopaint_luigi",
    title: "Mario Paint Luigi",
    tags: "mario paint luigi",
    image: "https://dabois.online/work/thirtydollarconvert/icons/mariopaint_luigi.png",
    associate: "",
    start: "F#4",
  },
  beep: {
    name: "mariopaint_gameboy",
    title: "Mario Paint Gameboy",
    tags: "mario paint gameboy",
    image: "https://dabois.online/work/thirtydollarconvert/icons/mariopaint_gameboy.png",
    associate: "",
    start: "F#4",
  },
  trumpet_hard: {
    name: "🎺",
    title: "ZUNpet",
    tags: "touhou ZUNpet",
    image: "https://dabois.online/work/thirtydollarconvert/emoji/1f3ba.svg",
    associate: "",
    start: "F#4",
  },
  reed: { //TEMP
    name: "hoenn",
    title: "Hoenn Trumpet",
    tags: "pokemon hoenn",
    image: "https://dabois.online/work/thirtydollarconvert/icons/hoenn.png",
    associate: "reed",
    start: "F#4",
  },
  demented_reed: { //TEMP
    name: "choruskid",
    title: "Chorus Kid",
    tags: "rhythm kid chorus kid",
    image: "https://dabois.online/work/thirtydollarconvert/icons/choruskid.png",
    associate: "",
    start: "F#4",
  },
  electric_guitar: {
    name: "🦴",
    title: "Meglovania Note",
    tags: "undertale meglovania note",
    image: "https://dabois.online/work/thirtydollarconvert/emoji/1f9b4.svg",
    associate: "electric guitar",
    start: "D4",
  },
  synth_lead: {
    name: "🦴",
    title: "Meglovania Note",
    tags: "undertale meglovania note",
    image: "https://dabois.online/work/thirtydollarconvert/emoji/1f9b4.svg",
    associate: "synth lead",
    start: "D4"
  },
  synth_bass: {
    name: "bwomp",
    title: "Blast Processing",
    tags: "geometry dash blast processing",
    associate: "synth bass",
    image: "https://dabois.online/work/thirtydollarconvert/icons/bwomp.png",
    start: "F#3",
  },
  synth_effect: {
    name: "bwomp",
    title: "Blast Processing",
    tags: "geometry dash blast processing",
    image: "https://dabois.online/work/thirtydollarconvert/icons/bwomp.png",
    associate: "synth effects",
    start: "F#3",
  },
  bit: {
    name: "noteblock_bit",
    title: "Note Block Bit",
    tags: "minecraft note block bit",
    image: "https://dabois.online/work/thirtydollarconvert/icons/noteblock_bit.png",
    associate: "",
    start: "F#4",
  },
  timpani: {
    name: "timpani",
    title: "Timpani (Tom Drum)",
    tags: "rhythm heaven tom drum timpani",
    image: "https://dabois.online/work/thirtydollarconvert/emoji/1fa98.svg",
    associate: "",
    start: "E3",
  },
  fnf_left: {
    name: "fnf_left",
    title: "FnF Left",
    tags: "friday night funking left",
    image: "https://dabois.online/work/thirtydollarconvert/icons/fnf_left.png",
    associate: "",
    start: "F#4"
  },
  fnf_down: {
    name: "fnf_down",
    title: "FnF Down",
    tags: "friday night funking down",
    image: "https://dabois.online/work/thirtydollarconvert/icons/fnf_down.png",
    associate: "",
    start: "F#3"
  },
  fnf_up: {
    name: "fnf_up",
    title: "FnF Up",
    tags: "friday night funking up",
    image: "https://dabois.online/work/thirtydollarconvert/icons/fnf_up.png",
    associate: "",
    start: "F#4"
  },
  fnf_right: {
    name: "fnf_right",
    title: "FnF Right",
    tags: "friday night funking right",
    image: "https://dabois.online/work/thirtydollarconvert/icons/fnf_right.png",
    associate: "",
    start: "F#4"
  },
  silence: {
    name: "silence",
    title: "Silence",
    tags: "silence empty pause rest",
    image: "https://dabois.online/work/thirtydollarconvert/assets/empty.png",
    associate: "", //TEMP
  }
  
};

var drumsounds = {
  36: "tab_rows@-14", //bass drum
  40: "noteblock_snare", //snare
  46: "hammer@-6|!combine|sidestick@5", //open hi-hat
  42: "sidestick@4", //closed hi-hat
  59: "ride2", //cymbal
  57: "ride2", //cymbal
  55: "ride2", //cymbal
  45: "🪘@-16", //low tom
  47: "🪘@-8", //mid tom
  50: "🪘@-5", //high tom
  39: "👏@2", //claps
  37: "adofaikick@-1", //rim shot
  70: "shaker", //shaker
  54: "celeste_diamond", //tambourine
  77: "noteblock_click", //wood block
  64: "🏏@-16", //low conga
  63: "🏏@-9", //high conga
  77: "noteblock_click", //wood block
  56: "cowbell", //cowbell
  85: "skipshot", //castanets
}


var scale = ['C0', 'C#0', 'D0', 'D#0', 'E0', 'F0', 'F#0', 'G0', 'G#0', 'A0', 'A#0', 'B0', 'C1', 'C#1', 'D1', 'D#1', 'E1', 'F1', 'F#1', 'G1', 'G#1', 'A1', 'A#1', 'B1', 'C2', 'C#2', 'D2', 'D#2', 'E2', 'F2', 'F#2', 'G2', 'G#2', 'A2', 'A#2', 'B2', 'C3', 'C#3', 'D3', 'D#3', 'E3', 'F3', 'F#3', 'G3', 'G#3', 'A3', 'A#3', 'B3', 'C4', 'C#4', 'D4', 'D#4', 'E4', 'F4', 'F#4', 'G4', 'G#4', 'A4', 'A#4', 'B4', 'C5', 'C#5', 'D5', 'D#5', 'E5', 'F5', 'F#5', 'G5', 'G#5', 'A5', 'A#5', 'B5', 'C6', 'C#6', 'D6', 'D#6', 'E6', 'F6', 'F#6', 'G6', 'G#6', 'A6', 'A#6', 'B6', 'C7', 'C#7', 'D7', 'D#7', 'E7', 'F7', 'F#7', 'G7', 'G#7', 'A7', 'A#7', 'B7', 'C8', 'C#8', 'D8', 'D#8', 'E8', 'F8', 'F#8', 'G8', 'G#8', 'A8', 'A#8', 'B8', 'C9', 'C#9', 'D9', 'D#9', 'E9', 'F9', 'F#9', 'G9', 'G#9', 'A9', 'A#9', 'B9', 'C10'];



let $upload = document.querySelector('.file-input');
let $soundSelects = document.querySelector('.sound-selects');
let $convertButton = document.querySelector('.convert-button');
let $output = document.querySelector('.output')
let $downloadButton = document.querySelector('.download-button');
let $copyButton = document.querySelector('.copy-button');
let $soundSelect = document.querySelector(".sound-select");

var currentFile;

$upload.addEventListener("change", (e) => {
  const files = e.target.files;
  if (files.length > 0) {
    $output.value = "";
    const file = files[0];
    currentFile = file;
    console.log(file)
    parseMidi(file);
  }
});


function createSelects(tracks){
  $soundSelects.innerHTML = "";
  
  for(i=0; i<tracks.length; i++){
    track = tracks[i];

    if(track.notes.length > 0){     
      let $trackDiv = document.createElement("div");
      $trackDiv.classList.add("track");
      $trackDiv.classList.add(`track-${i}`);
    
      let beforeText = document.createTextNode(`Track ${i}: ${track.instrument.family.charAt(0).toUpperCase() + track.instrument.family.slice(1)} (${track.notes.length} notes)`);
      $trackDiv.appendChild(beforeText);

      $soundSelects.appendChild($trackDiv);

      $chosenSoundIconContainer = document.createElement("div");
      $chosenSoundIconContainer.classList.add("chosen-sound-icon-container");
      $trackDiv.appendChild($chosenSoundIconContainer);
      
      $chosenSoundIcon = document.createElement("img");
      $chosenSoundIcon.classList.add("chosen-sound-icon");
      $chosenSoundIconContainer.appendChild($chosenSoundIcon);

      if(track.instrument.family == "drums"){
        $chosenSoundIcon.src = "https://dabois.online/work/thirtydollarconvert/emoji/1f941.svg";
      }
      else {
        if(track.instrument.name == "timpani") {
          $chosenSoundIcon.src = sounds.timpani.image;
        }
        else if(track.instrument.name == "steel drums"){
          $chosenSoundIcon.src = sounds.steel_drums.image;
        }
        else if(track.instrument.family == "guitar") {
          if(track.instrument.name.includes("acoustic guitar")) {
            $chosenSoundIcon.src = sounds.acoustic_guitar.image;
          }
          else {
            $chosenSoundIcon.src = sounds.electric_guitar.image;
          }
        }
        else {
          associatingSound = Object.values(sounds).find(o => o.associate == track.instrument.family) || Object.values(sounds).find(o => o.associate == "piano");
          $chosenSoundIcon.src = associatingSound.image;
        }  
      }
  
      $hr = document.createElement("hr");
      if(i == tracks.length - 1) $hr.style.margin_bottom = 0;
      $soundSelects.appendChild($hr);

      
      /*let $select = document.createElement("select");
      $trackDiv.appendChild($select);
      
      $select.classList.add(`sound-select`);
  
      if(track.instrument.family == "drums"){
        $select.innerHTML += `<option value="drums">drums</option>`
        $select.innerHTML += `<option value="silence">silence</option>`
      } 
      else {
        var alreadyAdded = [];
        
        Object.values(sounds).forEach(sound => {
          if(!alreadyAdded.includes(sound.name)){
            $select.innerHTML += `<option value="${sound.name}">${sound.name}</option>`;
            alreadyAdded.push(sound.name)
          }
        });
      }
    
      $soundSelects.appendChild($trackDiv);

  
      if(track.instrument.family != "drums"){
        if(track.instrument.name == "timpani") {
          $select.value = 'timpani'
        }
        else if(track.instrument.name == "steel drums"){
          $select.value = sounds.steel_drums.name;
        }
        else if(track.instrument.family == "guitar") {
          if(track.instrument.name.includes("acoustic guitar")) {
            $select.value = sounds.acoustic_guitar.name;
          }
          else {
            $select.value = sounds.electric_guitar.name;
          }
        }
        else {
          associatingSound = Object.values(sounds).find(o => o.associate == track.instrument.family) || Object.values(sounds).find(o => o.associate == "piano");
          $select.value = associatingSound.name;
        }
      }*/
    }
  }
}

var $previousSoundIcon;
document.addEventListener('click', e => {
  let $current;
  
  if(e.target.classList.contains('chosen-sound-icon')){
    $current = e.target;
  }
  else if(e.target.classList.contains('chosen-sound-icon-container')){
    $current = e.target.querySelector(".chosen-sound-icon");
  }
  else {
    return;
  }
  
  if($current.src == "https://dabois.online/work/thirtydollarconvert/emoji/1f941.svg"){
    $soundSelect.classList.remove("active");
    $previousSoundIcon = null;

    if($current.parentNode.classList.contains("disabled")){
      $current.parentNode.classList.remove("disabled");
    }
    else $current.parentNode.classList.add("disabled");
  }
  else {
    if($previousSoundIcon == $current){
      $current.parentNode.classList.remove("active");
      $soundSelect.classList.remove("active");
      $previousSoundIcon = null;
    }
    else {   
      if($previousSoundIcon) $previousSoundIcon.parentNode.classList.remove("active");
      $current.parentNode.classList.add("active");
      renderSoundSelect($current, e);
      $previousSoundIcon = $current;
    }

  }

});

$soundChoices = document.querySelector(".sound-choices");
$soundSelectInput = document.querySelector(".sound-select-search").querySelector("input");

function renderSoundSelect($selectedIcon, e) {
  $soundSelectInput.value = "";

  document.querySelectorAll(".sound-choice").forEach($c => { if($c.style.display == "none") $c.style.display = "flex" });
  
  $soundSelect.classList.add("active");
  
  calculatedTop = e.clientY - ($soundSelect.offsetHeight/2) + 30;
  console.log(calculatedTop)
  if(calculatedTop > 500) {
    if(calculatedTop > 580) calculatedTop = 510;
    else calculatedTop = 472;
  }
  
  $soundSelect.style.top = calculatedTop + "px";
  $soundSelect.style.left = "540px";

  $soundChoices = document.querySelectorAll(".sound-choice");
  $soundChoices.forEach(c => c.classList.remove("chosen"));

  var $currentChoice, currentChoiceIndex;
  
  for(i = 0; i < $soundChoices.length; i++){
    if($soundChoices[i].querySelector("img").src == $selectedIcon.src) {
      $currentChoice = $soundChoices[i];
      currentChoiceIndex = i;
      break;
    }
  }

  $currentChoice.classList.add("chosen");

  column = Math.floor(currentChoiceIndex / 3);
  document.querySelector(".sound-select-content").scrollTop = column * $currentChoice.clientHeight;
    
    //console.log($currentChoice.offsetTop)
    
    //$soundSelect.scrollTop = $currentChoice.positionedOffset()[1];
}


var alreadyAdded = [];
        
Object.values(sounds).forEach(sound => {
  if(!alreadyAdded.includes(sound.name)){
    $soundChoices.innerHTML += `
<div data-tags="${sound.tags}" class="sound-choice">
  <img class="sound-choice-image" src="${sound.image}">
  <p class="sound-choice-title">${sound.title}</p>
</div>`;
    alreadyAdded.push(sound.name)
  }
});
document.querySelectorAll(".sound-choice").forEach($soundChoice => {
  $soundChoice.addEventListener("click", ()=> {
    if(!$soundChoice.classList.contains("chosen")){
      document.querySelector(".sound-choice.chosen").classList.remove("chosen");
      $soundChoice.classList.add("chosen");
      document.querySelector(".chosen-sound-icon-container.active").querySelector(".chosen-sound-icon").src = $soundChoice.querySelector("img").src
    }
  })
})

$soundSelectInput.addEventListener("input", () => {
  document.querySelectorAll(".sound-choice").forEach($c => { if($c.style.display == "none") $c.style.display = "flex" });
  let search = $soundSelectInput.value.toLowerCase().trim();
  if(search.length > 0){
    choicesArr = Array.from(document.querySelectorAll(".sound-choice"));
    results = choicesArr.filter($choice => {
      return fuzzy($choice.dataset.tags, search)
    });
    
    hiddenArr = choicesArr.filter(c => !results.includes(c));
  
    results.forEach(result => {result.style.display = "flexbox"});
    hiddenArr.forEach(hidden => {hidden.style.display = "none"});
    
    console.log(results)
  }
});

function fuzzy(str, query){
  let i = 0, n = -1, l;
  query = query.toLowerCase();
  for (; l = query[i++] ;){
    if (!~(n = str.indexOf(l, n + 1))){
      return false;
    };
  };
  return true;  
}

document.addEventListener('mousedown', function(e) {
    if(!$soundSelect.contains(e.target) && !e.target.classList.contains("chosen-sound-icon") && !e.target.classList.contains("chosen-sound-icon-container")) {
      if($previousSoundIcon) {
        $soundSelect.classList.remove("active");
        $previousSoundIcon.parentNode.classList.remove("active");
        $previousSoundIcon = null;
      }
    }
});


var currentMidi = {};

function parseMidi(file) {
  const reader = new FileReader();
  reader.onload = function (e) {
    midi = new Midi(e.target.result);
    currentMidi = midi;
    console.log(JSON.stringify(midi, undefined, 2))

    document.querySelector(".sound-select-container").classList.add("active");
    
    $downloadButton.style.cursor = "not-allowed";
    $copyButton.style.cursor = "not-allowed";
    createSelects(midi.tracks);

    //convertMidi(midi);
    
  };
  reader.readAsArrayBuffer(file);
}

$convertButton.addEventListener("click", () => {
  document.querySelector(".output-container").classList.add("active");
  convertMidi(currentMidi);
});

var output = "";

function convertMidi(midi){
  PPQ = midi.header.ppq; //ticks per quarter note

  timeSig = midi.header.timeSignatures[0].timeSignature; //assuming time sig does not change
  timeSigInQuarters = timeSig;
  if(timeSig[1] != 4){
    timeSigInQuarters = [timeSig[0] * (4 / timeSig[1]), 4];
  }

  ticksPerBar = PPQ * timeSigInQuarters[0];

  baseBPM = midi.header.tempos[0].bpm //assuming bpm does not change

  var everyNote = [];

  for(i = 0; i < midi.tracks.length; i++){
    track = midi.tracks[i]
    track.notes.forEach((note) => {
      note.track = i;
      everyNote.push(note)
    });
  }

  everyNote = everyNote.sort(({ticks:a}, {ticks:b}) => a - b);
  //console.log(everyNote)

  let tickTimings = [];
  let noteGroups = {};
  everyNote.forEach(note => {
    if(!tickTimings.includes(note.ticks)){
      tickTimings.push(note.ticks);
      noteGroups[note.ticks] = [];
    }
    noteGroups[note.ticks].push(note)
  })

  var minTickDiff = Number.MAX_VALUE;
  for (i = 0; i < tickTimings.length - 1; i++){
    if (tickTimings[i + 1] - tickTimings[i] < minTickDiff){
      minTickDiff = tickTimings[i + 1] - tickTimings[i];      
    }
  }

  var multipliedBPM = baseBPM * (ticksPerBar / minTickDiff) / timeSigInQuarters[0];

  output = `!speed@${multipliedBPM}|`

  let previousTick = 0;
  for ([tick, notes] of Object.entries(noteGroups)) {
    if(tick != 0){
      if(tick - previousTick > minTickDiff){
        //output += `${sounds.rest}=${(tick - previousTick - minTickDiff) / minTickDiff}|`
        output += `_pause=${(tick - previousTick - minTickDiff) / minTickDiff}|`
      }
    }

    var chordArray = [];
    var previousVelocity;
    
    notes.forEach(note => {
      noteTrackIndex = note.track;
      $noteSoundIcon = document.querySelector(`.track-${noteTrackIndex}`).querySelector('.chosen-sound-icon');

      var finalNoteValue = "";

      if($noteSoundIcon.src == "https://dabois.online/work/thirtydollarconvert/emoji/1f941.svg"){
        if(!$noteSoundIcon.parentNode.classList.contains("disabled")){
          finalNoteValue = drumsounds[note.midi] ? drumsounds[note.midi] : "🥁";
        }
      }
      else {
        soundsArr = Object.keys(sounds).map(key => {
          return sounds[key];
        })

        chosenSound = soundsArr.find(s => s.image == $noteSoundIcon.src);

        if(chosenSound.name != "silence"){
          pitch = note.name;
          pitchIndex = scale.indexOf(pitch);
          startIndex = scale.indexOf(chosenSound.start);
          pitchDiff = pitchIndex - startIndex;

          if(chosenSound.name == "timpani"){
            finalNoteValue = `🪘@${pitchDiff}|`;
          }
          else {
            finalNoteValue = `${chosenSound.name}@${pitchDiff}|`;
          }
        }
      }

      if (document.getElementById('volume-check').checked) {
        if(note.velocity != previousVelocity){
          finalNoteValue = `!volume@${note.velocity * 100}|` + finalNoteValue;
          previousVelocity = note.velocity;
        }
      }
      
      chordArray.push(finalNoteValue);
    
      
      /*noteSoundName = document.querySelector(`.track-${noteTrackIndex}`).querySelector('select').value;
      var finalNoteValue = "";
      
      if(noteSoundName != "silence"){
        if(noteSoundName == "drums") {
          var soundName = "";
          
          if(note.midi == "36") soundName = "tab_rows@-14" //bass drum
          else if(note.midi == "40") soundName = "noteblock_snare" //snare
          else if(note.midi == "46") soundName = "hammer@-6|!combine|sidestick@5" //open hi-hat
          else if(note.midi == "42") soundName = "sidestick@4" //closed hi-hat
          else if(note.midi == "59" || note.midi == "57" || note.midi == "55") soundName = "ride2" //cymbal
          else if(note.midi == "45") soundName = "🪘@-16" //low tom
          else if(note.midi == "47") soundName = "🪘@-8" //mid tom
          else if(note.midi == "50") soundName = "🪘@-5" //high tom
          else if(note.midi == "39") soundName = "👏@2" //claps
          else if(note.midi == "37") soundName = "adofaikick@-1" //rim shot
          else if(note.midi == "70") soundName = "shaker" //shaker
          else if(note.midi == "54") soundName = "celeste_diamond" //tambourine
          else if(note.midi == "77") soundName = "noteblock_click" //wood block
          else if(note.midi == "64") soundName = "🏏@-16" //low conga
          else if(note.midi == "63") soundName = "🏏@-9" //high conga
          else if(note.midi == "56") soundName = "cowbell" //cowbell
          else if(note.midi == "85") soundName = "skipshot" //castanets
          else soundName = "🥁";

          finalNoteValue = `${soundName}|`;
        }
        else {
          noteSound = Object.values(sounds).find(o => o.name == noteSoundName);      
          pitch = note.name;
          pitchIndex = scale.indexOf(pitch);
          startIndex = scale.indexOf(noteSound.start);
          pitchDiff = pitchIndex - startIndex;

          if(noteSoundName == "timpani"){
            finalNoteValue = `🪘@${pitchDiff}|`;
          }
          else {
            finalNoteValue = `${noteSound.name}@${pitchDiff}|`;
          }
        }

        if (document.getElementById('volume-check').checked) {
          if(note.velocity != previousVelocity){
            finalNoteValue = `!volume@${note.velocity * 100}|` + finalNoteValue;
            previousVelocity = note.velocity;
          }
        }
        
        chordArray.push(finalNoteValue);
      }*/
    })

    chordString = chordArray.join("!combine|");
    output += chordString;

    previousTick = tick;
  }

  console.log(output)

  $output.value = output;

  $downloadButton.style.cursor = "pointer";
  $copyButton.style.cursor = "pointer";

  //console.log(JSON.stringify(everyNoteChronological, undefined, 2));
  //console.log(JSON.stringify(everyNote, undefined, 2));
}

$downloadButton.addEventListener("click", () => {
  if($downloadButton.style.cursor == "pointer" || $output.value.length > 0){
    const a = document.createElement('a');
    const file = new Blob([$output.value], {type: 'text/plain'});
    a.href= URL.createObjectURL(file);
    a.download = `${currentFile.name.substring(0, currentFile.name.lastIndexOf('.')) || currentFile.name}.🗿`;
    a.click();

	  URL.revokeObjectURL(a.href);
  }
});

$copyButton.addEventListener("click", () => {
  if($copyButton.style.cursor == "pointer" || $output.value.length > 0){
    $copyButton.innerText = "Copied!";
    navigator.clipboard.writeText($output.value);
    setTimeout(()=>{
      $copyButton.innerText = "Copy to clipboard";
    },2000)
  }
});