/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.world.camera;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.util.TempVars;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\"\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"DAMPENING", "", "MAX_ANGLE", "RADIUS", "", "ROTATION_SPEED_FACTOR", "TIME_LEFT_UNTIL_BRAKES", "Lkotlin/time/Duration;", "J", "Y_BASELINE", "lookAtRotation", "Lcom/jme3/math/Quaternion;", "loc", "Lcom/jme3/math/Vector3f;", "pos", "midis2jam2"})
public final class SlideCameraControllerKt {
    private static final int RADIUS = 134;
    private static final int Y_BASELINE = 92;
    private static final double MAX_ANGLE = 0.5;
    private static final double ROTATION_SPEED_FACTOR = 0.04;
    private static final double DAMPENING = 0.6;
    private static final long TIME_LEFT_UNTIL_BRAKES = DurationKt.toDuration(20, DurationUnit.SECONDS);

    @NotNull
    public static final Quaternion lookAtRotation(@NotNull Vector3f loc, @NotNull Vector3f pos) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(pos, "pos");
        TempVars vars = TempVars.get();
        Vector3f newDirection = vars.vect1;
        Vector3f newUp = vars.vect2;
        Vector3f newLeft = vars.vect3;
        newDirection.set(pos).subtractLocal(loc).normalizeLocal();
        newUp.set(Vector3f.UNIT_Y).normalizeLocal();
        if (Intrinsics.areEqual(newUp, Vector3f.ZERO)) {
            newUp.set(Vector3f.UNIT_Y);
        }
        newLeft.set(newUp).crossLocal(newDirection).normalizeLocal();
        if (Intrinsics.areEqual(newLeft, Vector3f.ZERO)) {
            if (!(newDirection.x == 0.0f)) {
                newLeft.set(newDirection.y, -newDirection.x, 0.0f);
            } else {
                newLeft.set(0.0f, newDirection.z, -newDirection.y);
            }
        }
        newUp.set(newDirection).crossLocal(newLeft).normalizeLocal();
        vars.release();
        Quaternion quaternion = new Quaternion().fromAxes(newLeft, newUp, newDirection).normalizeLocal();
        Intrinsics.checkNotNullExpressionValue(quaternion, "normalizeLocal(...)");
        return quaternion;
    }

    public static final /* synthetic */ long access$getTIME_LEFT_UNTIL_BRAKES$p() {
        return TIME_LEFT_UNTIL_BRAKES;
    }
}

