/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.world.camera;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wysko.midis2jam2.util.Utils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0081\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001d\u00a8\u0006\u001f"}, d2={"Lorg/wysko/midis2jam2/world/camera/CameraAngle;", "", "locX", "", "locY", "locZ", "rotX", "rotY", "rotZ", "(Ljava/lang/String;IFFFFFF)V", "location", "Lcom/jme3/math/Vector3f;", "getLocation", "()Lcom/jme3/math/Vector3f;", "rotation", "Lcom/jme3/math/Quaternion;", "getRotation", "()Lcom/jme3/math/Quaternion;", "CAMERA_1A", "CAMERA_1B", "CAMERA_1C", "CAMERA_2A", "CAMERA_2B", "CAMERA_3A", "CAMERA_3B", "CAMERA_4A", "CAMERA_4B", "CAMERA_5", "CAMERA_6A", "CAMERA_6B", "Companion", "midis2jam2"})
public final class CameraAngle
extends Enum<CameraAngle> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Vector3f location;
    @NotNull
    private final Quaternion rotation;
    public static final /* enum */ CameraAngle CAMERA_1A;
    public static final /* enum */ CameraAngle CAMERA_1B;
    public static final /* enum */ CameraAngle CAMERA_1C;
    public static final /* enum */ CameraAngle CAMERA_2A;
    public static final /* enum */ CameraAngle CAMERA_2B;
    public static final /* enum */ CameraAngle CAMERA_3A;
    public static final /* enum */ CameraAngle CAMERA_3B;
    public static final /* enum */ CameraAngle CAMERA_4A;
    public static final /* enum */ CameraAngle CAMERA_4B;
    public static final /* enum */ CameraAngle CAMERA_5;
    public static final /* enum */ CameraAngle CAMERA_6A;
    public static final /* enum */ CameraAngle CAMERA_6B;
    private static final /* synthetic */ CameraAngle[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private CameraAngle(float locX, float locY, float locZ, float rotX, float rotY, float rotZ) {
        this.location = new Vector3f(locX, locY, locZ);
        Quaternion quaternion = new Quaternion().fromAngles(rotX, rotY, rotZ);
        Intrinsics.checkNotNullExpressionValue(quaternion, "fromAngles(...)");
        this.rotation = quaternion;
    }

    @NotNull
    public final Vector3f getLocation() {
        return this.location;
    }

    @NotNull
    public final Quaternion getRotation() {
        return this.rotation;
    }

    public static CameraAngle[] values() {
        return (CameraAngle[])$VALUES.clone();
    }

    public static CameraAngle valueOf(String value) {
        return Enum.valueOf(CameraAngle.class, value);
    }

    @NotNull
    public static EnumEntries<CameraAngle> getEntries() {
        return $ENTRIES;
    }

    static {
        CAMERA_1A = new CameraAngle(-2.0f, 92.0f, 134.0f, Utils.INSTANCE.rad(18.44f), Utils.INSTANCE.rad(180.0f), 0.0f);
        CAMERA_1B = new CameraAngle(60.0f, 92.0f, 124.0f, Utils.INSTANCE.rad(18.5), Utils.INSTANCE.rad(204.4), 0.0f);
        CAMERA_1C = new CameraAngle(-59.5f, 90.8f, 94.4f, Utils.INSTANCE.rad(23.9), Utils.INSTANCE.rad(153.6), 0.0f);
        CAMERA_2A = new CameraAngle(0.0f, 71.8f, 44.5f, Utils.INSTANCE.rad(15.7), Utils.INSTANCE.rad(224.9), 0.0f);
        CAMERA_2B = new CameraAngle(-35.0f, 76.4f, 33.6f, Utils.INSTANCE.rad(55.8), Utils.INSTANCE.rad(198.5), 0.0f);
        CAMERA_3A = new CameraAngle(-0.2f, 61.6f, 38.6f, Utils.INSTANCE.rad(15.5), Utils.INSTANCE.rad(180.0f), 0.0f);
        CAMERA_3B = new CameraAngle(-19.6f, 78.7f, 3.8f, Utils.INSTANCE.rad(27.7), Utils.INSTANCE.rad(163.8), 0.0f);
        CAMERA_4A = new CameraAngle(0.2f, 81.1f, 32.2f, Utils.INSTANCE.rad(21.0f), Utils.INSTANCE.rad(131.8), Utils.INSTANCE.rad(-0.5));
        CAMERA_4B = new CameraAngle(35.0f, 25.4f, -19.0f, Utils.INSTANCE.rad(-50.0f), Utils.INSTANCE.rad(119.0f), Utils.INSTANCE.rad(-2.5));
        CAMERA_5 = new CameraAngle(5.0f, 432.0f, 24.0f, Utils.INSTANCE.rad(82.875f), Utils.INSTANCE.rad(180.0f), 0.0f);
        CAMERA_6A = new CameraAngle(17.0f, 30.5f, 42.9f, Utils.INSTANCE.rad(-6.7), Utils.INSTANCE.rad(144.3), 0.0f);
        CAMERA_6B = new CameraAngle(38.8f, 58.8f, 23.5f, 2.206f, -0.635f, 0.003f);
        $VALUES = cameraAngleArray = new CameraAngle[]{CameraAngle.CAMERA_1A, CameraAngle.CAMERA_1B, CameraAngle.CAMERA_1C, CameraAngle.CAMERA_2A, CameraAngle.CAMERA_2B, CameraAngle.CAMERA_3A, CameraAngle.CAMERA_3B, CameraAngle.CAMERA_4A, CameraAngle.CAMERA_4B, CameraAngle.CAMERA_5, CameraAngle.CAMERA_6A, CameraAngle.CAMERA_6B};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/wysko/midis2jam2/world/camera/CameraAngle$Companion;", "", "()V", "handleCameraAngle", "Lorg/wysko/midis2jam2/world/camera/CameraAngle;", "currentCameraAngle", "name", "", "preventCameraFromLeaving", "", "camera", "Lcom/jme3/renderer/Camera;", "midis2jam2"})
    public static final class Companion {
        private Companion() {
        }

        public final void preventCameraFromLeaving(@NotNull Camera camera) {
            Intrinsics.checkNotNullParameter(camera, "camera");
            Vector3f location = camera.getLocation();
            camera.setLocation(new Vector3f(location.x > 0.0f ? Math.min(location.x, 400.0f) : Math.max(location.x, -400.0f), location.y > 0.0f ? Math.min(location.y, 432.0f) : Math.max(location.y, -432.0f), location.z > 0.0f ? Math.min(location.z, 400.0f) : Math.max(location.z, -400.0f)));
        }

        @NotNull
        public final CameraAngle handleCameraAngle(@NotNull CameraAngle currentCameraAngle, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)currentCameraAngle, "currentCameraAngle");
            Intrinsics.checkNotNullParameter(name, "name");
            return switch (name) {
                case "cam1" -> {
                    switch (WhenMappings.$EnumSwitchMapping$0[currentCameraAngle.ordinal()]) {
                        case 1: {
                            yield CAMERA_1B;
                        }
                        case 2: {
                            yield CAMERA_1C;
                        }
                    }
                    yield CAMERA_1A;
                }
                case "cam2" -> {
                    if (currentCameraAngle == CAMERA_2A) {
                        yield CAMERA_2B;
                    }
                    yield CAMERA_2A;
                }
                case "cam3" -> {
                    if (currentCameraAngle == CAMERA_3A) {
                        yield CAMERA_3B;
                    }
                    yield CAMERA_3A;
                }
                case "cam4" -> {
                    if (currentCameraAngle == CAMERA_4A) {
                        yield CAMERA_4B;
                    }
                    yield CAMERA_4A;
                }
                case "cam5" -> CAMERA_5;
                case "cam6" -> {
                    if (currentCameraAngle == CAMERA_6A) {
                        yield CAMERA_6B;
                    }
                    yield CAMERA_6A;
                }
                case "cam_reset" -> CAMERA_1A;
                default -> CAMERA_1A;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CameraAngle.values().length];
                try {
                    nArray[CameraAngle.CAMERA_1A.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CameraAngle.CAMERA_1B.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

