/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.world.camera;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.Instrument;
import org.wysko.midis2jam2.world.camera.AutoCamControllerKt;
import org.wysko.midis2jam2.world.camera.AutoCamPosition;
import org.wysko.midis2jam2.world.camera.AutoCamPositionType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020%H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010,J \u0010-\u001a\u00020\u00052\u0006\u0010*\u001a\u00020%2\u0006\u0010.\u001a\u00020%\u00f8\u0001\u0000\u00a2\u0006\u0004\b/\u00100J\u0006\u00101\u001a\u000202R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\u00020%X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00063"}, d2={"Lorg/wysko/midis2jam2/world/camera/AutoCamController;", "", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "startEnabled", "", "(Lorg/wysko/midis2jam2/Midis2jam2;Z)V", "angles", "", "Lorg/wysko/midis2jam2/world/camera/AutoCamPosition;", "cam", "Lcom/jme3/renderer/Camera;", "kotlin.jvm.PlatformType", "getCam", "()Lcom/jme3/renderer/Camera;", "currentLocation", "Lcom/jme3/math/Vector3f;", "getCurrentLocation", "()Lcom/jme3/math/Vector3f;", "setCurrentLocation", "(Lcom/jme3/math/Vector3f;)V", "currentRotation", "Lcom/jme3/math/Quaternion;", "getCurrentRotation", "()Lcom/jme3/math/Quaternion;", "setCurrentRotation", "(Lcom/jme3/math/Quaternion;)V", "value", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "moving", "startLocation", "startRotation", "waiting", "Lkotlin/time/Duration;", "J", "x", "", "randomCamera", "time", "randomCamera-LRDsOJo", "(J)Lorg/wysko/midis2jam2/world/camera/AutoCamPosition;", "tick", "delta", "tick-QTBD994", "(JJ)Z", "trigger", "", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAutoCamController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoCamController.kt\norg/wysko/midis2jam2/world/camera/AutoCamController\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,752:1\n3792#2:753\n4307#2,2:754\n3792#2:759\n4307#2,2:760\n766#3:756\n857#3,2:757\n766#3:762\n857#3,2:763\n766#3:765\n857#3,2:766\n288#3,2:768\n*S KotlinDebug\n*F\n+ 1 AutoCamController.kt\norg/wysko/midis2jam2/world/camera/AutoCamController\n*L\n179#1:753\n179#1:754,2\n189#1:759\n189#1:760,2\n182#1:756\n182#1:757,2\n192#1:762\n192#1:763,2\n193#1:765\n193#1:766,2\n203#1:768,2\n*E\n"})
public final class AutoCamController {
    @NotNull
    private final Midis2jam2 context;
    private boolean enabled;
    private long waiting;
    private boolean moving;
    @NotNull
    private final List<AutoCamPosition> angles;
    private float x;
    @NotNull
    private Vector3f startLocation;
    @NotNull
    private Quaternion startRotation;
    @NotNull
    private Vector3f currentLocation;
    @NotNull
    private Quaternion currentRotation;
    public static final int $stable = 8;

    public AutoCamController(@NotNull Midis2jam2 context2, boolean startEnabled) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.enabled = startEnabled;
        this.waiting = DurationKt.toDuration(0, DurationUnit.SECONDS);
        AutoCamPosition[] autoCamPositionArray = new AutoCamPosition[]{AutoCamPosition.GENERAL_A};
        this.angles = CollectionsKt.mutableListOf(autoCamPositionArray);
        Vector3f vector3f = AutoCamPosition.GENERAL_A.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue(vector3f, "clone(...)");
        this.startLocation = vector3f;
        Quaternion quaternion = AutoCamPosition.GENERAL_A.getRotation().clone();
        Intrinsics.checkNotNullExpressionValue(quaternion, "clone(...)");
        this.startRotation = quaternion;
        Vector3f vector3f2 = AutoCamPosition.GENERAL_A.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue(vector3f2, "clone(...)");
        this.currentLocation = vector3f2;
        Quaternion quaternion2 = AutoCamPosition.GENERAL_A.getRotation().clone();
        Intrinsics.checkNotNullExpressionValue(quaternion2, "clone(...)");
        this.currentRotation = quaternion2;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean value) {
        if (value && !this.enabled) {
            Vector3f vector3f = this.context.getApp().getCamera().getLocation().clone();
            Intrinsics.checkNotNullExpressionValue(vector3f, "clone(...)");
            this.startLocation = vector3f;
            Quaternion quaternion = this.context.getApp().getCamera().getRotation().clone();
            Intrinsics.checkNotNullExpressionValue(quaternion, "clone(...)");
            this.startRotation = quaternion;
        }
        this.enabled = value;
    }

    @NotNull
    public final Vector3f getCurrentLocation() {
        return this.currentLocation;
    }

    public final void setCurrentLocation(@NotNull Vector3f vector3f) {
        Intrinsics.checkNotNullParameter(vector3f, "<set-?>");
        this.currentLocation = vector3f;
    }

    @NotNull
    public final Quaternion getCurrentRotation() {
        return this.currentRotation;
    }

    public final void setCurrentRotation(@NotNull Quaternion quaternion) {
        Intrinsics.checkNotNullParameter(quaternion, "<set-?>");
        this.currentRotation = quaternion;
    }

    public final boolean tick-QTBD994(long time, long delta) {
        Cloneable it;
        Cloneable cloneable2;
        if (!this.enabled) {
            return false;
        }
        if (!this.moving) {
            if (Duration.compareTo-LRDsOJo(time, DurationKt.toDuration(0, DurationUnit.SECONDS)) > 0) {
                this.waiting = Duration.plus-LRDsOJo(this.waiting, delta);
                if (!CollectionsKt.last(this.angles).getStayHere().invoke(Duration.box-impl(time), this.context.getInstruments(), this.context).booleanValue()) {
                    this.trigger();
                }
                Vector3f vector3f = this.context.getApp().getCamera().getLocation().clone();
                Intrinsics.checkNotNullExpressionValue(vector3f, "clone(...)");
                this.startLocation = vector3f;
                Quaternion quaternion = this.context.getApp().getCamera().getRotation().clone();
                Intrinsics.checkNotNullExpressionValue(quaternion, "clone(...)");
                this.startRotation = quaternion;
            }
        }
        if (Duration.compareTo-LRDsOJo(this.waiting, AutoCamControllerKt.access$getWAIT_TIME$p()) >= 0) {
            this.waiting = Duration.Companion.getZERO-UwyO8pc();
            this.angles.add(this.randomCamera-LRDsOJo(time));
            this.moving = true;
            if (Math.random() < 0.2) {
                this.x = 1.0f;
            }
        }
        if (this.moving) {
            this.x += (float)(Duration.toDouble-impl(delta, DurationUnit.SECONDS) * (double)0.33333334f);
            if (this.x > 1.0f) {
                this.x = 0.0f;
                this.moving = false;
                Vector3f vector3f = this.context.getApp().getCamera().getLocation().clone();
                Intrinsics.checkNotNullExpressionValue(vector3f, "clone(...)");
                this.startLocation = vector3f;
                Quaternion quaternion = this.context.getApp().getCamera().getRotation().clone();
                Intrinsics.checkNotNullExpressionValue(quaternion, "clone(...)");
                this.startRotation = quaternion;
            }
        }
        Vector3f vector3f = cloneable2 = new Vector3f().interpolateLocal(this.startLocation, CollectionsKt.last(this.angles).getLocation(), AutoCamControllerKt.smooth(this.x));
        Camera camera = this.getCam();
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        this.currentLocation = it;
        camera.setLocation((Vector3f)cloneable2);
        it = cloneable2 = AutoCamControllerKt.quaternionInterpolation(this.startRotation, CollectionsKt.last(this.angles).getRotation(), AutoCamControllerKt.smooth(this.x));
        camera = this.getCam();
        boolean bl2 = false;
        this.currentRotation = it;
        camera.setRotation((Quaternion)cloneable2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final AutoCamPosition randomCamera-LRDsOJo(long time) {
        AutoCamPosition autoCamPosition;
        if (Duration.compareTo-LRDsOJo(Duration.minus-LRDsOJo(this.context.getSequence().getDuration-UwyO8pc(), time), Duration.times-UwyO8pc(AutoCamControllerKt.access$getWAIT_TIME$p(), 2.5)) < 0) {
            return AutoCamPosition.GENERAL_A;
        }
        if (Math.random() < 0.25) {
            void $this$filterTo$iv$iv;
            AutoCamPosition it;
            void $this$filterTo$iv$iv2;
            AutoCamPosition[] $this$filter$iv = AutoCamPosition.values();
            boolean $i$f$filter = false;
            AutoCamPosition[] autoCamPositionArray = $this$filter$iv;
            Iterable<void> destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == AutoCamPositionType.STAGE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List stageCameras = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = stageCameras;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (AutoCamPosition)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it != CollectionsKt.last(this.angles))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List validStageCameras = (List)destination$iv$iv2;
            autoCamPosition = (AutoCamPosition)((Object)CollectionsKt.random(validStageCameras, Random.Default));
        } else {
            Iterable $this$filterTo$iv$iv;
            Object it;
            void $this$filterTo$iv$iv3;
            void $this$filter$iv;
            AutoCamPosition[] validStageCameras = AutoCamPosition.values();
            boolean $i$f$filter = false;
            void $i$f$filter2 = $this$filter$iv;
            Iterable<void> destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                it = element$iv$iv;
                boolean bl = false;
                if (!(((AutoCamPosition)((Object)it)).getType() == AutoCamPositionType.INSTRUMENT && ((AutoCamPosition)((Object)it)).getPickMe().invoke(Duration.box-impl(time), this.context.getInstruments(), this.context) != false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validInstrumentCameras = (List)destination$iv$iv;
            Iterable $this$filter$iv3 = this.angles;
            boolean $i$f$filter22 = false;
            destination$iv$iv = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            int $i$f$filterTo2 = 0;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (AutoCamPosition)((Object)element$iv$iv);
                boolean bl = false;
                if (!(((AutoCamPosition)((Object)it)).getType() == AutoCamPositionType.INSTRUMENT)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv3 = this.context.getInstruments();
            List list2 = (List)destination$iv$iv3;
            $i$f$filter22 = false;
            $this$filterTo$iv$iv = $this$filter$iv3;
            destination$iv$iv3 = new ArrayList();
            $i$f$filterTo2 = 0;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Instrument)element$iv$iv;
                boolean bl = false;
                if (!((Instrument)it).isVisible()) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List lastUsedInstrumentCameras = CollectionsKt.takeLast(list2, RangesKt.coerceAtLeast(((List)destination$iv$iv3).size() - 2, 1));
            List notRecentlyUsedInstrumentAngles = CollectionsKt.minus((Iterable)validInstrumentCameras, CollectionsKt.toSet(lastUsedInstrumentCameras));
            if (!((Collection)notRecentlyUsedInstrumentAngles).isEmpty()) {
                autoCamPosition = (AutoCamPosition)((Object)CollectionsKt.random(notRecentlyUsedInstrumentAngles, Random.Default));
            } else {
                Object v1;
                block12: {
                    Iterable $this$firstOrNull$iv = this.angles;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        AutoCamPosition it2 = (AutoCamPosition)((Object)element$iv);
                        boolean bl = false;
                        if (!(it2.getType() == AutoCamPositionType.INSTRUMENT && it2.getPickMe().invoke(Duration.box-impl(time), this.context.getInstruments(), this.context) != false)) continue;
                        v1 = element$iv;
                        break block12;
                    }
                    v1 = null;
                }
                if ((autoCamPosition = (AutoCamPosition)v1) == null) {
                    autoCamPosition = AutoCamPosition.GENERAL_A;
                }
            }
        }
        return autoCamPosition;
    }

    public final void trigger() {
        if (!this.enabled) {
            this.x = 0.0f;
        }
        this.setEnabled(true);
        if (!this.moving) {
            this.waiting = AutoCamControllerKt.access$getWAIT_TIME$p();
        }
    }

    private final Camera getCam() {
        return this.context.getApp().getCamera();
    }
}

