/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.world.background;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingSphere;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.TextureCubeMap;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.util.SkyFactory;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jme3tools.converters.ImageToAwt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.wysko.midis2jam2.starter.configuration.BackgroundConfiguration;
import org.wysko.midis2jam2.starter.configuration.CubemapTexture;
import org.wysko.midis2jam2.world.background.BackgroundImageFormatException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH&J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lorg/wysko/midis2jam2/world/background/BackgroundFactory;", "", "assetManager", "Lcom/jme3/asset/AssetManager;", "(Lcom/jme3/asset/AssetManager;)V", "getAssetManager$midis2jam2", "()Lcom/jme3/asset/AssetManager;", "create", "Lcom/jme3/scene/Spatial;", "loadTexture", "Lcom/jme3/texture/Texture2D;", "assetPath", "", "loadTexture$midis2jam2", "rotateTexture", "texture", "Lcom/jme3/texture/Texture;", "Default", "RepeatedCubeMap", "UniqueCubeMap", "Lorg/wysko/midis2jam2/world/background/BackgroundFactory$Default;", "Lorg/wysko/midis2jam2/world/background/BackgroundFactory$RepeatedCubeMap;", "Lorg/wysko/midis2jam2/world/background/BackgroundFactory$UniqueCubeMap;", "midis2jam2"})
@StabilityInferred(parameters=0)
public abstract class BackgroundFactory {
    @NotNull
    private final AssetManager assetManager;
    public static final int $stable = 8;

    private BackgroundFactory(AssetManager assetManager2) {
        this.assetManager = assetManager2;
    }

    @NotNull
    public final AssetManager getAssetManager$midis2jam2() {
        return this.assetManager;
    }

    @NotNull
    public abstract Spatial create();

    @NotNull
    public final Texture2D loadTexture$midis2jam2(@NotNull String assetPath) {
        Intrinsics.checkNotNullParameter(assetPath, "assetPath");
        Texture texture = this.assetManager.loadTexture(assetPath);
        Intrinsics.checkNotNullExpressionValue(texture, "loadTexture(...)");
        return this.rotateTexture(texture);
    }

    private final Texture2D rotateTexture(Texture texture) {
        AffineTransform affineTransform;
        BufferedImage image = ImageToAwt.convert(texture.getImage(), false, true, 0);
        AffineTransform $this$rotateTexture_u24lambda_u240 = affineTransform = AffineTransform.getScaleInstance(-1.0, -1.0);
        boolean bl = false;
        $this$rotateTexture_u24lambda_u240.translate(-((double)image.getWidth()), -((double)image.getHeight()));
        AffineTransform tx = affineTransform;
        BufferedImage rotatedImage = new AffineTransformOp(tx, 1).filter(image, null);
        return new Texture2D(new AWTLoader().load(rotatedImage, true));
    }

    public /* synthetic */ BackgroundFactory(AssetManager assetManager2, DefaultConstructorMarker $constructor_marker) {
        this(assetManager2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/wysko/midis2jam2/world/background/BackgroundFactory$Default;", "Lorg/wysko/midis2jam2/world/background/BackgroundFactory;", "assetManager", "Lcom/jme3/asset/AssetManager;", "(Lcom/jme3/asset/AssetManager;)V", "create", "Lcom/jme3/scene/Geometry;", "loadSkyTexture", "Lcom/jme3/texture/TextureCubeMap;", "midis2jam2"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nBackgroundFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundFactory.kt\norg/wysko/midis2jam2/world/background/BackgroundFactory$Default\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
    public static final class Default
    extends BackgroundFactory {
        public static final int $stable;

        public Default(@NotNull AssetManager assetManager2) {
            Intrinsics.checkNotNullParameter(assetManager2, "assetManager");
            super(assetManager2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Geometry create() {
            void $this$create_u24lambda_u241_u24lambda_u240;
            Material material;
            Geometry geometry;
            Geometry $this$create_u24lambda_u241 = geometry = new Geometry("Sky", new Sphere(10, 10, 10.0f, false, true));
            boolean bl = false;
            $this$create_u24lambda_u241.setQueueBucket(RenderQueue.Bucket.Sky);
            $this$create_u24lambda_u241.setCullHint(Spatial.CullHint.Never);
            $this$create_u24lambda_u241.setModelBound(new BoundingSphere(Float.POSITIVE_INFINITY, Vector3f.ZERO));
            Material material2 = material = new Material(this.getAssetManager$midis2jam2(), "Common/MatDefs/Misc/Sky.j3md");
            Geometry geometry2 = $this$create_u24lambda_u241;
            boolean bl2 = false;
            $this$create_u24lambda_u241_u24lambda_u240.setVector3("NormalScale", Vector3f.UNIT_XYZ);
            $this$create_u24lambda_u241_u24lambda_u240.setTexture("Texture", this.loadSkyTexture());
            geometry2.setMaterial(material);
            $this$create_u24lambda_u241.setShadowMode(RenderQueue.ShadowMode.Off);
            return geometry;
        }

        private final TextureCubeMap loadSkyTexture() {
            Texture2D texture = this.loadTexture$midis2jam2("Assets/sky.png");
            boolean bl = false;
            Cloneable cloneable2 = new Image(texture.getImage().getFormat(), texture.getImage().getWidth(), texture.getImage().getHeight(), null, texture.getImage().getColorSpace());
            Image $this$loadSkyTexture_u24lambda_u244_u24lambda_u243 = cloneable2;
            boolean bl2 = false;
            int n = 6;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl3 = false;
                $this$loadSkyTexture_u24lambda_u244_u24lambda_u243.addData(texture.getImage().getData().get(0));
            }
            Image image = cloneable2;
            boolean bl4 = false;
            Cloneable $this$loadSkyTexture_u24lambda_u246_u24lambda_u245 = cloneable2 = new TextureCubeMap(image);
            boolean bl5 = false;
            ((Texture)$this$loadSkyTexture_u24lambda_u246_u24lambda_u245).setMagFilter(Texture.MagFilter.Nearest);
            ((Texture)$this$loadSkyTexture_u24lambda_u246_u24lambda_u245).setMinFilter(Texture.MinFilter.NearestNoMipMaps);
            ((Texture)$this$loadSkyTexture_u24lambda_u246_u24lambda_u245).setAnisotropicFilter(0);
            ((TextureCubeMap)$this$loadSkyTexture_u24lambda_u246_u24lambda_u245).setWrap(Texture.WrapMode.EdgeClamp);
            return cloneable2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/wysko/midis2jam2/world/background/BackgroundFactory$RepeatedCubeMap;", "Lorg/wysko/midis2jam2/world/background/BackgroundFactory;", "assetManager", "Lcom/jme3/asset/AssetManager;", "config", "Lorg/wysko/midis2jam2/starter/configuration/BackgroundConfiguration$RepeatedCubeMapBackground;", "(Lcom/jme3/asset/AssetManager;Lorg/wysko/midis2jam2/starter/configuration/BackgroundConfiguration$RepeatedCubeMapBackground;)V", "create", "Lcom/jme3/scene/Spatial;", "midis2jam2"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nBackgroundFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundFactory.kt\norg/wysko/midis2jam2/world/background/BackgroundFactory$RepeatedCubeMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
    public static final class RepeatedCubeMap
    extends BackgroundFactory {
        @NotNull
        private final BackgroundConfiguration.RepeatedCubeMapBackground config;
        public static final int $stable;

        public RepeatedCubeMap(@NotNull AssetManager assetManager2, @NotNull BackgroundConfiguration.RepeatedCubeMapBackground config2) {
            Intrinsics.checkNotNullParameter(assetManager2, "assetManager");
            Intrinsics.checkNotNullParameter(config2, "config");
            super(assetManager2, null);
            this.config = config2;
        }

        @Override
        @NotNull
        public Spatial create() {
            Spatial spatial;
            Texture2D $this$create_u24lambda_u241 = this.loadTexture$midis2jam2(this.config.getTexture());
            boolean bl = false;
            Spatial $this$create_u24lambda_u241_u24lambda_u240 = spatial = SkyFactory.createSky(this.getAssetManager$midis2jam2(), $this$create_u24lambda_u241, $this$create_u24lambda_u241, $this$create_u24lambda_u241, $this$create_u24lambda_u241, $this$create_u24lambda_u241, $this$create_u24lambda_u241);
            boolean bl2 = false;
            $this$create_u24lambda_u241_u24lambda_u240.setShadowMode(RenderQueue.ShadowMode.Off);
            Spatial spatial2 = spatial;
            Intrinsics.checkNotNullExpressionValue(spatial2, "with(...)");
            return spatial2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/wysko/midis2jam2/world/background/BackgroundFactory$UniqueCubeMap;", "Lorg/wysko/midis2jam2/world/background/BackgroundFactory;", "assetManager", "Lcom/jme3/asset/AssetManager;", "config", "Lorg/wysko/midis2jam2/starter/configuration/BackgroundConfiguration$UniqueCubeMapBackground;", "(Lcom/jme3/asset/AssetManager;Lorg/wysko/midis2jam2/starter/configuration/BackgroundConfiguration$UniqueCubeMapBackground;)V", "create", "Lcom/jme3/scene/Spatial;", "midis2jam2"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nBackgroundFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundFactory.kt\norg/wysko/midis2jam2/world/background/BackgroundFactory$UniqueCubeMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1549#2:164\n1620#2,3:165\n1549#2:169\n1620#2,3:170\n1#3:168\n*S KotlinDebug\n*F\n+ 1 BackgroundFactory.kt\norg/wysko/midis2jam2/world/background/BackgroundFactory$UniqueCubeMap\n*L\n118#1:164\n118#1:165,3\n132#1:169\n132#1:170,3\n*E\n"})
    public static final class UniqueCubeMap
    extends BackgroundFactory {
        @NotNull
        private final BackgroundConfiguration.UniqueCubeMapBackground config;
        public static final int $stable = 8;

        public UniqueCubeMap(@NotNull AssetManager assetManager2, @NotNull BackgroundConfiguration.UniqueCubeMapBackground config2) {
            Intrinsics.checkNotNullParameter(assetManager2, "assetManager");
            Intrinsics.checkNotNullParameter(config2, "config");
            super(assetManager2, null);
            this.config = config2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Spatial create() {
            void $this$mapTo$iv$iv;
            CubemapTexture cubemap = this.config.getCubemap();
            String[] stringArray = new String[6];
            Intrinsics.checkNotNull(cubemap.getWest());
            Intrinsics.checkNotNull(cubemap.getEast());
            Intrinsics.checkNotNull(cubemap.getNorth());
            Intrinsics.checkNotNull(cubemap.getSouth());
            Intrinsics.checkNotNull(cubemap.getUp());
            Intrinsics.checkNotNull(cubemap.getDown());
            Iterable $this$map$iv = CollectionsKt.listOf(stringArray);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.loadTexture$midis2jam2((String)p0));
            }
            List textures = (List)destination$iv$iv;
            try {
                Spatial $this$create_u24lambda_u240 = $i$f$map = SkyFactory.createSky(this.getAssetManager$midis2jam2(), (Texture)textures.get(0), (Texture)textures.get(1), (Texture)textures.get(2), (Texture)textures.get(3), (Texture)textures.get(4), (Texture)textures.get(5));
                boolean bl = false;
                $this$create_u24lambda_u240.setShadowMode(RenderQueue.ShadowMode.Off);
                Spatial spatial = $i$f$map;
                Intrinsics.checkNotNullExpressionValue(spatial, "apply(...)");
                return spatial;
            }
            catch (Exception e) {
                if (Intrinsics.areEqual(e.getMessage(), "Images must have same format")) {
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv2 = textures;
                    boolean $i$f$map2 = false;
                    Iterable bl = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        Texture2D bl2 = (Texture2D)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        collection.add(it.getImage().getFormat());
                    }
                    List list2 = (List)destination$iv$iv2;
                    throw new BackgroundImageFormatException(list2);
                }
                throw e;
            }
        }
    }
}

