/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.util;

import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wysko.midis2jam2.util.JmeDslKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\u001a!\u0010\u0014\u001a\u00020\u00152\u0019\b\u0002\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0002\b\u0019\u001a\u001e\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c\u001a\u0015\u0010\u001f\u001a\u00020\u0003*\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0086\u0002\u001a\u0015\u0010\"\u001a\u00020\u0018*\u00020\u00152\u0006\u0010#\u001a\u00020\u0003H\u0086\u0002\u001a\u0015\u0010$\u001a\u00020\u0001*\u00020\u00012\u0006\u0010%\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010&\u001a\u00020\u0018*\u00020\u00152\u0006\u0010#\u001a\u00020\u0003H\u0086\u0002\u001a\u0015\u0010'\u001a\u00020\u0001*\u00020\u00012\u0006\u0010(\u001a\u00020\u001cH\u0086\u0002\u001a\u0016\u0010)\u001a\u00020\u0018*\u00020\u0015H\u0086\u0002R\u00020\u0015\u00a2\u0006\u0002\u0010*\u001a \u0010+\u001a\u0002H,\"\b\b\u0000\u0010,*\u00020\u0003*\u0002H,H\u0086\u0002R\u00020\u0015\u00a2\u0006\u0002\u0010-\"(\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\"(\u0010\t\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\"(\u0010\u000e\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0005\"\u0004\b\u0010\u0010\u0007\"(\u0010\u0011\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0005\"\u0004\b\u0013\u0010\u0007\u00a8\u0006."}, d2={"value", "Lcom/jme3/math/Vector3f;", "loc", "Lcom/jme3/scene/Spatial;", "getLoc", "(Lcom/jme3/scene/Spatial;)Lcom/jme3/math/Vector3f;", "setLoc", "(Lcom/jme3/scene/Spatial;Lcom/jme3/math/Vector3f;)V", "Lcom/jme3/material/Material;", "material", "getMaterial", "(Lcom/jme3/scene/Spatial;)Lcom/jme3/material/Material;", "setMaterial", "(Lcom/jme3/scene/Spatial;Lcom/jme3/material/Material;)V", "rot", "getRot", "setRot", "scale", "getScale", "setScale", "node", "Lcom/jme3/scene/Node;", "initializer", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "v3", "x", "", "y", "z", "get", "index", "", "minusAssign", "spatial", "plus", "other", "plusAssign", "times", "number", "unaryMinus", "(Lcom/jme3/scene/Node;Lcom/jme3/scene/Node;)V", "unaryPlus", "T", "(Lcom/jme3/scene/Node;Lcom/jme3/scene/Spatial;)Lcom/jme3/scene/Spatial;", "midis2jam2"})
public final class JmeDslKt {
    @NotNull
    public static final Node node(@NotNull Function1<? super Node, Unit> initializer) {
        Intrinsics.checkNotNullParameter(initializer, "initializer");
        Node node2 = new Node();
        initializer.invoke(node2);
        return node2;
    }

    public static /* synthetic */ Node node$default(Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = node.1.INSTANCE;
        }
        return JmeDslKt.node(function1);
    }

    @NotNull
    public static final <T extends Spatial> T unaryPlus(@NotNull Node $context_receiver_0, @NotNull T $this$unaryPlus) {
        Intrinsics.checkNotNullParameter($this$unaryPlus, "<this>");
        Intrinsics.checkNotNullParameter($context_receiver_0, "$context_receiver_0");
        $context_receiver_0.attachChild($this$unaryPlus);
        return $this$unaryPlus;
    }

    public static final void unaryMinus(@NotNull Node $context_receiver_0, @NotNull Node $this$unaryMinus) {
        Intrinsics.checkNotNullParameter($this$unaryMinus, "<this>");
        Intrinsics.checkNotNullParameter($context_receiver_0, "$context_receiver_0");
        $this$unaryMinus.removeFromParent();
    }

    @NotNull
    public static final Vector3f getLoc(@NotNull Spatial $this$loc) {
        Intrinsics.checkNotNullParameter($this$loc, "<this>");
        Vector3f vector3f = $this$loc.getLocalTranslation();
        Intrinsics.checkNotNullExpressionValue(vector3f, "getLocalTranslation(...)");
        return vector3f;
    }

    public static final void setLoc(@NotNull Spatial $this$loc, @NotNull Vector3f value) {
        Intrinsics.checkNotNullParameter($this$loc, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        $this$loc.setLocalTranslation(value);
    }

    @NotNull
    public static final Vector3f getRot(@NotNull Spatial $this$rot) {
        Intrinsics.checkNotNullParameter($this$rot, "<this>");
        float[] q = $this$rot.getLocalRotation().toAngles(null);
        return new Vector3f(q[0], q[1], q[2]);
    }

    public static final void setRot(@NotNull Spatial $this$rot, @NotNull Vector3f value) {
        Intrinsics.checkNotNullParameter($this$rot, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        $this$rot.setLocalRotation(new Quaternion().fromAngles(value.x * ((float)Math.PI / 180), value.y * ((float)Math.PI / 180), value.z * ((float)Math.PI / 180)));
    }

    @NotNull
    public static final Vector3f getScale(@NotNull Spatial $this$scale) {
        Intrinsics.checkNotNullParameter($this$scale, "<this>");
        Vector3f vector3f = $this$scale.getLocalScale();
        Intrinsics.checkNotNullExpressionValue(vector3f, "getLocalScale(...)");
        return vector3f;
    }

    public static final void setScale(@NotNull Spatial $this$scale, @NotNull Vector3f value) {
        Intrinsics.checkNotNullParameter($this$scale, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        $this$scale.setLocalScale(value);
    }

    @NotNull
    public static final Vector3f v3(@NotNull Number x2, @NotNull Number y2, @NotNull Number z) {
        Intrinsics.checkNotNullParameter(x2, "x");
        Intrinsics.checkNotNullParameter(y2, "y");
        Intrinsics.checkNotNullParameter(z, "z");
        return new Vector3f(x2.floatValue(), y2.floatValue(), z.floatValue());
    }

    @NotNull
    public static final Spatial get(@NotNull Node $this$get, int index2) {
        Intrinsics.checkNotNullParameter($this$get, "<this>");
        Spatial spatial = $this$get.getChild(index2);
        Intrinsics.checkNotNullExpressionValue(spatial, "getChild(...)");
        return spatial;
    }

    @NotNull
    public static final Material getMaterial(@NotNull Spatial $this$material) {
        Intrinsics.checkNotNullParameter($this$material, "<this>");
        if (!($this$material instanceof Geometry)) {
            throw new IllegalStateException("Cannot get material of a non-geometry spatial".toString());
        }
        Material material = ((Geometry)$this$material).getMaterial();
        Intrinsics.checkNotNullExpressionValue(material, "getMaterial(...)");
        return material;
    }

    public static final void setMaterial(@NotNull Spatial $this$material, @NotNull Material value) {
        Intrinsics.checkNotNullParameter($this$material, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        $this$material.setMaterial(value);
    }

    public static final void plusAssign(@NotNull Node $this$plusAssign, @NotNull Spatial spatial) {
        Intrinsics.checkNotNullParameter($this$plusAssign, "<this>");
        Intrinsics.checkNotNullParameter(spatial, "spatial");
        $this$plusAssign.attachChild(spatial);
    }

    public static final void minusAssign(@NotNull Node $this$minusAssign, @NotNull Spatial spatial) {
        Intrinsics.checkNotNullParameter($this$minusAssign, "<this>");
        Intrinsics.checkNotNullParameter(spatial, "spatial");
        $this$minusAssign.detachChild(spatial);
    }

    @NotNull
    public static final Vector3f times(@NotNull Vector3f $this$times, @NotNull Number number) {
        Intrinsics.checkNotNullParameter($this$times, "<this>");
        Intrinsics.checkNotNullParameter(number, "number");
        Vector3f vector3f = $this$times.mult(number.floatValue());
        Intrinsics.checkNotNullExpressionValue(vector3f, "mult(...)");
        return vector3f;
    }

    @NotNull
    public static final Vector3f plus(@NotNull Vector3f $this$plus, @NotNull Vector3f other) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Vector3f vector3f = $this$plus.add(other);
        Intrinsics.checkNotNullExpressionValue(vector3f, "add(...)");
        return vector3f;
    }
}

