/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.util;

import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a2\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011\u001a\u0014\u0010\u0012\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"'\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0015"}, d2={"hsv", "Lkotlin/Triple;", "", "", "getHsv", "(I)Lkotlin/Triple;", "calculateHue", "r", "g", "b", "max", "delta", "calculateMaxMinDelta", "calculateSaturation", "hexStringToIntArgb", "hexColor", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "wrapToRange", "intRange", "Lkotlin/ranges/IntRange;", "midis2jam2"})
@SourceDebugExtension(value={"SMAP\nColorConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorConversion.kt\norg/wysko/midis2jam2/util/ColorConversionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class ColorConversionKt {
    @NotNull
    public static final Triple<Float, Float, Float> getHsv(int $this$hsv) {
        int r = $this$hsv >> 16 & 0xFF;
        int g = $this$hsv >> 8 & 0xFF;
        int b = $this$hsv & 0xFF;
        Triple<Integer, Integer, Integer> triple = ColorConversionKt.calculateMaxMinDelta(r, g, b);
        int max = ((Number)triple.component1()).intValue();
        int delta = ((Number)triple.component3()).intValue();
        float h = ColorConversionKt.wrapToRange(ColorConversionKt.calculateHue(r, g, b, max, delta), new IntRange(0, 360));
        float s = ColorConversionKt.calculateSaturation(max, delta);
        float v = (float)max / (float)255;
        return new Triple<Float, Float, Float>(Float.valueOf(h), Float.valueOf(s), Float.valueOf(v));
    }

    @Nullable
    public static final Integer hexStringToIntArgb(@Nullable String hexColor) {
        return hexColor != null && new Regex("^#[A-Fa-f0-9]{6}$").matches(hexColor) ? Integer.valueOf(Integer.parseUnsignedInt(StringsKt.drop(hexColor, 1), 16) | 0xFF000000) : null;
    }

    private static final Triple<Integer, Integer, Integer> calculateMaxMinDelta(int r, int g, int b) {
        int max = Math.max(r, Math.max(g, b));
        int min = Math.min(r, Math.min(g, b));
        int delta = max - min;
        return new Triple<Integer, Integer, Integer>(max, min, delta);
    }

    private static final float calculateHue(int r, int g, int b, int max, int delta) {
        return delta == 0 ? 0.0f : (max == r ? 60.0f * ((float)(g - b) / (float)delta % (float)6) : (max == g ? 60.0f * ((float)(b - r) / (float)delta + (float)2) : 60.0f * ((float)(r - g) / (float)delta + (float)4)));
    }

    private static final float calculateSaturation(int max, int delta) {
        return max == 0 ? 0.0f : (float)delta / (float)max;
    }

    private static final float wrapToRange(float $this$wrapToRange, IntRange intRange) {
        IntRange $this$wrapToRange_u24lambda_u240 = intRange;
        boolean bl = false;
        int rangeSize = $this$wrapToRange_u24lambda_u240.getLast() - $this$wrapToRange_u24lambda_u240.getFirst();
        return (($this$wrapToRange - (float)intRange.getFirst()) % (float)rangeSize + (float)rangeSize) % (float)rangeSize + (float)intRange.getFirst();
    }
}

