/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.starter.configuration;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.midis2jam2.util.LoggingKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\n\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/wysko/midis2jam2/starter/configuration/ConfigurationPreserver;", "T", "", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "file", "Ljava/io/File;", "(Lkotlinx/serialization/SerializationStrategy;Lkotlinx/serialization/DeserializationStrategy;Ljava/io/File;)V", "getConfiguration", "()Ljava/lang/Object;", "saveConfiguration", "", "configuration", "(Ljava/lang/Object;)V", "midis2jam2"})
@StabilityInferred(parameters=0)
public final class ConfigurationPreserver<T> {
    @NotNull
    private final SerializationStrategy<T> serializer;
    @NotNull
    private final DeserializationStrategy<T> deserializer;
    @NotNull
    private final File file;
    public static final int $stable = 8;

    public ConfigurationPreserver(@NotNull SerializationStrategy<? super T> serializer2, @NotNull DeserializationStrategy<? extends T> deserializer, @NotNull File file) {
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        Intrinsics.checkNotNullParameter(file, "file");
        this.serializer = serializer2;
        this.deserializer = deserializer;
        this.file = file;
    }

    public final void saveConfiguration(T configuration) {
        File $this$saveConfiguration_u24lambda_u240 = this.file;
        boolean bl = false;
        try {
            FilesKt.writeText$default($this$saveConfiguration_u24lambda_u240, Json.Default.encodeToString(this.serializer, configuration), null, 2, null);
        }
        catch (Exception e) {
            LoggingKt.logger(this).error("Failed to save configuration to file: " + $this$saveConfiguration_u24lambda_u240.getAbsolutePath(), e);
        }
    }

    @Nullable
    public final T getConfiguration() {
        T t;
        if (!this.file.exists()) {
            return null;
        }
        try {
            t = Json.Default.decodeFromString(this.deserializer, FilesKt.readText$default(this.file, null, 1, null));
        }
        catch (Exception e) {
            LoggingKt.logger(this).error("Failed to load configuration from file: " + this.file.getAbsolutePath(), e);
            t = null;
        }
        return t;
    }
}

