/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.starter;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.gervill.RealTimeSequencerProvider;
import org.wysko.midis2jam2.starter.Midis2jam2Application;
import org.wysko.midis2jam2.starter.configuration.Configuration;
import org.wysko.midis2jam2.starter.configuration.HomeConfiguration;
import org.wysko.midis2jam2.util.ErrorHandling;
import org.wysko.midis2jam2.util.LoggingKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002JF\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015\u00a8\u0006\u0018"}, d2={"Lorg/wysko/midis2jam2/starter/Execution;", "", "()V", "getAndLoadSequencer", "Lkotlin/Pair;", "Ljavax/sound/midi/Sequencer;", "Ljavax/sound/midi/Synthesizer;", "homeConfiguration", "Lorg/wysko/midis2jam2/starter/configuration/HomeConfiguration;", "midiDevice", "Ljavax/sound/midi/MidiDevice;", "sequence", "Ljavax/sound/midi/Sequence;", "start", "", "midiFile", "Ljava/io/File;", "configurations", "", "Lorg/wysko/midis2jam2/starter/configuration/Configuration;", "onStart", "Lkotlin/Function0;", "onReady", "onFinish", "midis2jam2"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nExecution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Execution.kt\norg/wysko/midis2jam2/starter/Execution\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
public final class Execution {
    @NotNull
    public static final Execution INSTANCE = new Execution();
    public static final int $stable;

    private Execution() {
    }

    public final void start(@NotNull File midiFile, @NotNull Collection<? extends Configuration> configurations, @NotNull Function0<Unit> onStart, @NotNull Function0<Unit> onReady, @NotNull Function0<Unit> onFinish) {
        Intrinsics.checkNotNullParameter(midiFile, "midiFile");
        Intrinsics.checkNotNullParameter(configurations, "configurations");
        Intrinsics.checkNotNullParameter(onStart, "onStart");
        Intrinsics.checkNotNullParameter(onReady, "onReady");
        Intrinsics.checkNotNullParameter(onFinish, "onFinish");
        BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(Dispatchers.getDefault()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onStart, configurations, midiFile, this, onFinish, onReady, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function0<Unit> $onStart;
            final /* synthetic */ Collection<Configuration> $configurations;
            final /* synthetic */ File $midiFile;
            final /* synthetic */ Execution this$0;
            final /* synthetic */ Function0<Unit> $onFinish;
            final /* synthetic */ Function0<Unit> $onReady;
            {
                this.$onStart = $onStart;
                this.$configurations = $configurations;
                this.$midiFile = $midiFile;
                this.this$0 = $receiver;
                this.$onFinish = $onFinish;
                this.$onReady = $onReady;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        this.$onStart.invoke();
                        $this$first$iv = this.$configurations;
                        $i$f$first = false;
                        var7_8 = $this$first$iv.iterator();
                        while (var7_8.hasNext()) {
                            element$iv = var7_8.next();
                            it = (Configuration)element$iv;
                            $i$a$-first-Execution$start$1$homeConfiguration$1 = false;
                            if (!(it instanceof HomeConfiguration)) continue;
                            ** GOTO lbl19
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl19:
                        // 1 sources

                        v0 = element$iv;
                        Intrinsics.checkNotNull(v0, "null cannot be cast to non-null type org.wysko.midis2jam2.starter.configuration.HomeConfiguration");
                        homeConfiguration = (HomeConfiguration)v0;
                        try {
                            $this$first$iv = MidiSystem.getSequence(this.$midiFile);
                        }
                        catch (InvalidMidiDataException e) {
                            ErrorHandling.INSTANCE.errorDisp(LoggingKt.logger(this.this$0), "The MIDI file is invalid.", e);
                            this.$onFinish.invoke();
                            return Unit.INSTANCE;
                        }
                        catch (IOException e) {
                            ErrorHandling.INSTANCE.errorDisp(LoggingKt.logger(this.this$0), "There was an error reading the MIDI file.", e);
                            this.$onFinish.invoke();
                            return Unit.INSTANCE;
                        }
                        sequence = $this$first$iv;
                        try {
                            v1 = MidiSystem.getMidiDeviceInfo();
                            Intrinsics.checkNotNullExpressionValue(v1, "getMidiDeviceInfo(...)");
                            $this$first$iv = v1;
                            $i$f$first = false;
                            for (Object element$iv : $this$first$iv) {
                                it = (MidiDevice.Info)element$iv;
                                $i$a$-first-Execution$start$1$midiDevice$1 = false;
                                if (!Intrinsics.areEqual(it.getName(), homeConfiguration.getSelectedMidiDevice())) {
                                    continue;
                                }
                                ** GOTO lbl50
                            }
                            throw new NoSuchElementException("Array contains no element matching the predicate.");
lbl50:
                            // 1 sources

                            var6_7 = MidiSystem.getMidiDevice((MidiDevice.Info)element$iv);
                        }
                        catch (MidiUnavailableException e) {
                            ErrorHandling.INSTANCE.errorDisp(LoggingKt.logger(this.this$0), "The MIDI device is unavailable due to resource restrictions.", e);
                            this.$onFinish.invoke();
                            return Unit.INSTANCE;
                        }
                        catch (IllegalArgumentException e) {
                            ErrorHandling.INSTANCE.errorDisp(LoggingKt.logger(this.this$0), "The MIDI device is not found.", e);
                            this.$onFinish.invoke();
                            return Unit.INSTANCE;
                        }
                        catch (NoSuchElementException e) {
                            ErrorHandling.INSTANCE.errorDisp(LoggingKt.logger(this.this$0), "The MIDI device is not found.", e);
                            this.$onFinish.invoke();
                            return Unit.INSTANCE;
                        }
                        midiDevice = var6_7;
                        try {
                            Intrinsics.checkNotNull(midiDevice);
                            e = Execution.access$getAndLoadSequencer(Execution.INSTANCE, homeConfiguration, midiDevice, (Sequence)sequence);
                        }
                        catch (Exception e) {
                            ErrorHandling.INSTANCE.errorDisp(LoggingKt.logger($this$launch), "There was an error.", e);
                            this.$onFinish.invoke();
                            return Unit.INSTANCE;
                        }
                        var6_7 = e;
                        sequencer = (Sequencer)var6_7.component1();
                        synthesizer = (Synthesizer)var6_7.component2();
                        this.$onReady.invoke();
                        new Midis2jam2Application(this.$midiFile, this.$configurations, this.$onFinish, sequencer, synthesizer).execute();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final Pair<Sequencer, Synthesizer> getAndLoadSequencer(HomeConfiguration homeConfiguration, MidiDevice midiDevice, Sequence sequence) {
        Pair<Sequencer, Object> pair;
        Pair<Sequencer, Object> pair2;
        RealTimeSequencerProvider provider = new RealTimeSequencerProvider();
        if (Intrinsics.areEqual(homeConfiguration.getSelectedMidiDevice(), "Gervill")) {
            MidiDevice $this$getAndLoadSequencer_u24lambda_u241 = var7_5 = MidiSystem.getSynthesizer();
            boolean bl = false;
            $this$getAndLoadSequencer_u24lambda_u241.open();
            String string = homeConfiguration.getSelectedSoundbank();
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                $this$getAndLoadSequencer_u24lambda_u241.loadAllInstruments(MidiSystem.getSoundbank(new File(it)));
            }
            synthesizer = var7_5;
            MidiDevice $this$getAndLoadSequencer_u24lambda_u242 = $this$getAndLoadSequencer_u24lambda_u241 = provider.getDevice(provider.getDeviceInfo()[0]);
            boolean bl3 = false;
            $this$getAndLoadSequencer_u24lambda_u242.getTransmitter().setReceiver(synthesizer.getReceiver());
            var7_5 = $this$getAndLoadSequencer_u24lambda_u241;
            Intrinsics.checkNotNull(var7_5, "null cannot be cast to non-null type javax.sound.midi.Sequencer");
            pair2 = TuplesKt.to((Sequencer)var7_5, synthesizer);
        } else {
            midiDevice.open();
            MidiDevice $this$getAndLoadSequencer_u24lambda_u243 = var7_5 = provider.getDevice(provider.getDeviceInfo()[0]);
            boolean bl = false;
            $this$getAndLoadSequencer_u24lambda_u243.getTransmitter().setReceiver(midiDevice.getReceiver());
            synthesizer = var7_5;
            Intrinsics.checkNotNull(synthesizer, "null cannot be cast to non-null type javax.sound.midi.Sequencer");
            pair2 = TuplesKt.to((Sequencer)synthesizer, null);
        }
        Pair<Sequencer, Object> it = pair = pair2;
        boolean bl = false;
        it.getFirst().open();
        it.getFirst().setSequence(sequence);
        return pair;
    }

    public static final /* synthetic */ Pair access$getAndLoadSequencer(Execution $this, HomeConfiguration homeConfiguration, MidiDevice midiDevice, Sequence sequence) {
        return $this.getAndLoadSequencer(homeConfiguration, midiDevice, sequence);
    }
}

