/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.midi.search;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.kmidi.StandardMidiFileParserJVM;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.StandardMidiFileReader;
import org.wysko.kmidi.midi.event.Event;
import org.wysko.kmidi.midi.event.ProgramEvent;
import org.wysko.midis2jam2.midi.search.MidiSearchEngine;
import org.wysko.midis2jam2.midi.search.MidiSearchEngineKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JB\u0010\u0013\u001a\u00020\u00142\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00140\u00182\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00140\u0018J.\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0\bH\u0002J\u0006\u0010\u001f\u001a\u00020\u0014J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010!\u001a\u00020\"H\u0002J\u0017\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010$\u001a\u00020%H\u0002\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010(\u001a\u00020\u001eH\u0002J6\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00140\u0018H\u0002J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0003H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/wysko/midis2jam2/midi/search/MidiSearchEngine;", "", "directory", "Ljava/io/File;", "searchRecursively", "", "(Ljava/io/File;Z)V", "index", "", "", "", "getIndex", "()Ljava/util/Map;", "setIndex", "(Ljava/util/Map;)V", "indexJob", "Lkotlinx/coroutines/Job;", "midiFileReader", "Lorg/wysko/kmidi/midi/StandardMidiFileReader;", "buildIndex", "", "onFinish", "Lkotlin/Function0;", "onProgress", "Lkotlin/Function1;", "Lorg/wysko/midis2jam2/midi/search/MidiSearchEngine$IndexingProgress;", "onError", "", "buildProgramChangeIndex", "sequences", "Lorg/wysko/kmidi/midi/StandardMidiFile;", "cancelIndex", "extractDataFromEvents", "track", "Lorg/wysko/kmidi/midi/StandardMidiFile$Track;", "extractProgramChangeData1Value", "event", "Lorg/wysko/kmidi/midi/event/Event;", "(Lorg/wysko/kmidi/midi/event/Event;)Ljava/lang/Byte;", "extractProgramChangeEvents", "sequence", "extractSequencesFromMidiFiles", "midiFiles", "isMidiFile", "file", "searchNonRecursively", "IndexingProgress", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMidiSearchEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MidiSearchEngine.kt\norg/wysko/midis2jam2/midi/search/MidiSearchEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,214:1\n1569#2,11:215\n1864#2,2:226\n1866#2:230\n1580#2:231\n1238#2,4:234\n1360#2:238\n1446#2,5:239\n1603#2,9:244\n1855#2:253\n1856#2:255\n1612#2:256\n1#3:228\n1#3:229\n1#3:254\n453#4:232\n403#4:233\n3792#5:257\n4307#5,2:258\n*S KotlinDebug\n*F\n+ 1 MidiSearchEngine.kt\norg/wysko/midis2jam2/midi/search/MidiSearchEngine\n*L\n139#1:215,11\n139#1:226,2\n139#1:230\n139#1:231\n157#1:234,4\n166#1:238\n166#1:239,5\n175#1:244,9\n175#1:253\n175#1:255\n175#1:256\n139#1:229\n175#1:254\n157#1:232\n157#1:233\n201#1:257\n201#1:258,2\n*E\n"})
public final class MidiSearchEngine {
    @NotNull
    private final File directory;
    private final boolean searchRecursively;
    public Map<File, ? extends List<Byte>> index;
    @Nullable
    private Job indexJob;
    @NotNull
    private final StandardMidiFileReader midiFileReader;
    public static final int $stable = 8;

    public MidiSearchEngine(@NotNull File directory, boolean searchRecursively2) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        this.directory = directory;
        this.searchRecursively = searchRecursively2;
        this.midiFileReader = new StandardMidiFileReader(null, 1, null);
    }

    @NotNull
    public final Map<File, List<Byte>> getIndex() {
        Map<File, List<Byte>> map2 = this.index;
        if (map2 != null) {
            return map2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("index");
        return null;
    }

    public final void setIndex(@NotNull Map<File, ? extends List<Byte>> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.index = map2;
    }

    public final void buildIndex(@NotNull Function0<Unit> onFinish, @NotNull Function1<? super IndexingProgress, Unit> onProgress, @NotNull Function1<? super Throwable, Unit> onError) {
        Intrinsics.checkNotNullParameter(onFinish, "onFinish");
        Intrinsics.checkNotNullParameter(onProgress, "onProgress");
        Intrinsics.checkNotNullParameter(onError, "onError");
        this.indexJob = BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(Dispatchers.getIO()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onProgress, this, onFinish, onError, null){
            int label;
            final /* synthetic */ Function1<IndexingProgress, Unit> $onProgress;
            final /* synthetic */ MidiSearchEngine this$0;
            final /* synthetic */ Function0<Unit> $onFinish;
            final /* synthetic */ Function1<Throwable, Unit> $onError;
            {
                this.$onProgress = $onProgress;
                this.this$0 = $receiver;
                this.$onFinish = $onFinish;
                this.$onError = $onError;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        try {
                            this.$onProgress.invoke(IndexingProgress.Indeterminate.INSTANCE);
                            List midiFiles = MidiSearchEngine.access$getSearchRecursively$p(this.this$0) ? MidiSearchEngine.access$searchRecursively(this.this$0, MidiSearchEngine.access$getDirectory$p(this.this$0)) : MidiSearchEngine.access$searchNonRecursively(this.this$0, MidiSearchEngine.access$getDirectory$p(this.this$0));
                            Map asSequences = MidiSearchEngine.access$extractSequencesFromMidiFiles(this.this$0, midiFiles, this.$onProgress);
                            this.this$0.setIndex(MidiSearchEngine.access$buildProgramChangeIndex(this.this$0, asSequences));
                            this.$onFinish.invoke();
                        }
                        catch (Throwable e) {
                            this.$onError.invoke(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    public static /* synthetic */ void buildIndex$default(MidiSearchEngine midiSearchEngine, Function0 function0, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = buildIndex.1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function1 = buildIndex.2.INSTANCE;
        }
        if ((n & 4) != 0) {
            function12 = buildIndex.3.INSTANCE;
        }
        midiSearchEngine.buildIndex(function0, function1, function12);
    }

    public final void cancelIndex() {
        block0: {
            Job job2 = this.indexJob;
            if (job2 == null) break block0;
            Job.DefaultImpls.cancel$default(job2, null, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<File, StandardMidiFile> extractSequencesFromMidiFiles(List<? extends File> midiFiles, Function1<? super IndexingProgress, Unit> onProgress) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Iterable $this$mapIndexedNotNull$iv = midiFiles;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            StandardMidiFile it$iv$iv;
            Pair<void, StandardMidiFile> pair;
            void file;
            Object $this$extractSequencesFromMidiFiles_u24lambda_u243_u24lambda_u240;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            File file2 = (File)element$iv$iv;
            int index2 = index$iv$iv;
            boolean bl2 = false;
            Object object = this;
            try {
                $this$extractSequencesFromMidiFiles_u24lambda_u243_u24lambda_u240 = object;
                boolean bl3 = false;
                $this$extractSequencesFromMidiFiles_u24lambda_u243_u24lambda_u240 = Result.constructor-impl(StandardMidiFileParserJVM.readFile(((MidiSearchEngine)$this$extractSequencesFromMidiFiles_u24lambda_u243_u24lambda_u240).midiFileReader, (File)file));
            }
            catch (Throwable bl3) {
                $this$extractSequencesFromMidiFiles_u24lambda_u243_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(bl3));
            }
            object = $this$extractSequencesFromMidiFiles_u24lambda_u243_u24lambda_u240;
            StandardMidiFile standardMidiFile = (StandardMidiFile)(Result.isFailure-impl(object) ? null : object);
            if (standardMidiFile != null) {
                StandardMidiFile it = standardMidiFile;
                boolean bl4 = false;
                pair = TuplesKt.to(file, it);
            } else {
                pair = null;
            }
            StandardMidiFile it = standardMidiFile = pair;
            boolean bl5 = false;
            onProgress.invoke(new IndexingProgress.Percentage((index2 + 1) * 100 / midiFiles.size()));
            if (standardMidiFile == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<File, List<Byte>> buildProgramChangeIndex(Map<File, StandardMidiFile> sequences) {
        void $this$mapValuesTo$iv$iv;
        Map<File, StandardMidiFile> $this$mapValues$iv = sequences;
        boolean $i$f$mapValues = false;
        Map<File, StandardMidiFile> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            StandardMidiFile sequence = (StandardMidiFile)entry2.getValue();
            List<Byte> list2 = this.extractProgramChangeEvents(sequence);
            map4.put(k, list2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Byte> extractProgramChangeEvents(StandardMidiFile sequence) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = sequence.getTracks();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            StandardMidiFile.Track track = (StandardMidiFile.Track)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.extractDataFromEvents(track);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Byte> extractDataFromEvents(StandardMidiFile.Track track) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = track.getEvents();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Byte it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Event event = (Event)element$iv$iv;
            boolean bl2 = false;
            if (this.extractProgramChangeData1Value(event) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Byte extractProgramChangeData1Value(Event event) {
        return event instanceof ProgramEvent ? Byte.valueOf(((ProgramEvent)event).getProgram()) : null;
    }

    private final List<File> searchRecursively(File directory) {
        return SequencesKt.toList(SequencesKt.filter(FilesKt.walk$default(directory, null, 1, null), (Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ MidiSearchEngine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return MidiSearchEngine.access$isMidiFile(this.this$0, it);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> searchNonRecursively(File directory) {
        List list2;
        File[] fileArray = directory.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void file = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull(file);
                if (!this.isMidiFile((File)file)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMidiFile(File file) {
        if (!file.isFile()) return false;
        List<String> list2 = MidiSearchEngineKt.getMIDI_FILE_EXTENSIONS();
        String string = FilesKt.getExtension(file).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        if (!list2.contains(string)) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$getSearchRecursively$p(MidiSearchEngine $this) {
        return $this.searchRecursively;
    }

    public static final /* synthetic */ List access$searchRecursively(MidiSearchEngine $this, File directory) {
        return $this.searchRecursively(directory);
    }

    public static final /* synthetic */ File access$getDirectory$p(MidiSearchEngine $this) {
        return $this.directory;
    }

    public static final /* synthetic */ List access$searchNonRecursively(MidiSearchEngine $this, File directory) {
        return $this.searchNonRecursively(directory);
    }

    public static final /* synthetic */ Map access$extractSequencesFromMidiFiles(MidiSearchEngine $this, List midiFiles, Function1 onProgress) {
        return $this.extractSequencesFromMidiFiles(midiFiles, onProgress);
    }

    public static final /* synthetic */ Map access$buildProgramChangeIndex(MidiSearchEngine $this, Map sequences) {
        return $this.buildProgramChangeIndex(sequences);
    }

    public static final /* synthetic */ boolean access$isMidiFile(MidiSearchEngine $this, File file) {
        return $this.isMidiFile(file);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lorg/wysko/midis2jam2/midi/search/MidiSearchEngine$IndexingProgress;", "", "()V", "Indeterminate", "Percentage", "Lorg/wysko/midis2jam2/midi/search/MidiSearchEngine$IndexingProgress$Indeterminate;", "Lorg/wysko/midis2jam2/midi/search/MidiSearchEngine$IndexingProgress$Percentage;", "midis2jam2"})
    @StabilityInferred(parameters=1)
    public static abstract class IndexingProgress {
        public static final int $stable;

        private IndexingProgress() {
        }

        public /* synthetic */ IndexingProgress(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/wysko/midis2jam2/midi/search/MidiSearchEngine$IndexingProgress$Indeterminate;", "Lorg/wysko/midis2jam2/midi/search/MidiSearchEngine$IndexingProgress;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "midis2jam2"})
        @StabilityInferred(parameters=1)
        public static final class Indeterminate
        extends IndexingProgress {
            @NotNull
            public static final Indeterminate INSTANCE = new Indeterminate();
            public static final int $stable;

            private Indeterminate() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Indeterminate";
            }

            public int hashCode() {
                return 199779077;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Indeterminate)) {
                    return false;
                }
                Indeterminate cfr_ignored_0 = (Indeterminate)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/wysko/midis2jam2/midi/search/MidiSearchEngine$IndexingProgress$Percentage;", "Lorg/wysko/midis2jam2/midi/search/MidiSearchEngine$IndexingProgress;", "value", "", "(I)V", "getValue", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "midis2jam2"})
        @StabilityInferred(parameters=1)
        public static final class Percentage
        extends IndexingProgress {
            private final int value;
            public static final int $stable;

            public Percentage(int value) {
                super(null);
                this.value = value;
            }

            public final int getValue() {
                return this.value;
            }

            public final int component1() {
                return this.value;
            }

            @NotNull
            public final Percentage copy(int value) {
                return new Percentage(value);
            }

            public static /* synthetic */ Percentage copy$default(Percentage percentage, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = percentage.value;
                }
                return percentage.copy(n);
            }

            @NotNull
            public String toString() {
                return "Percentage(value=" + this.value + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.value);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Percentage)) {
                    return false;
                }
                Percentage percentage = (Percentage)other;
                return this.value == percentage.value;
            }
        }
    }
}

