/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.midi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.midi.TimeBasedSequence;
import org.wysko.kmidi.midi.TimedArc;
import org.wysko.kmidi.midi.analysis.Polyphony;
import org.wysko.kmidi.midi.event.MidiEvent;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.midi.TimedArcGroup;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00040\u0001\u001a&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001*\b\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"improvedContiguousGroupDetection", "", "Lorg/wysko/midis2jam2/midi/TimedArcGroup;", "notePeriods", "Lorg/wysko/kmidi/midi/TimedArc;", "contiguousGroups", "notePeriodsModulus", "Lorg/wysko/kmidi/midi/event/MidiEvent;", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "modulus", "", "midis2jam2"})
@SourceDebugExtension(value={"SMAP\nNotePeriod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotePeriod.kt\norg/wysko/midis2jam2/midi/NotePeriodKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n766#2:140\n857#2:141\n1549#2:142\n1620#2,3:143\n858#2:146\n1855#2:147\n1855#2,2:148\n1856#2:150\n800#2,11:151\n766#2:162\n857#2,2:163\n1855#2,2:165\n*S KotlinDebug\n*F\n+ 1 NotePeriod.kt\norg/wysko/midis2jam2/midi/NotePeriodKt\n*L\n75#1:140\n75#1:141\n76#1:142\n76#1:143,3\n75#1:146\n79#1:147\n80#1:148,2\n79#1:150\n98#1:151,11\n98#1:162\n98#1:163,2\n128#1:165,2\n*E\n"})
public final class NotePeriodKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TimedArcGroup> improvedContiguousGroupDetection(@NotNull List<TimedArc> notePeriods) {
        void $this$filterTo$iv$iv;
        List<TimedArc> lookAheadNotes;
        Intrinsics.checkNotNullParameter(notePeriods, "notePeriods");
        double overlapThreshold = 0.01;
        List groups2 = new ArrayList();
        Set<TimedArc> currentGroup = new LinkedHashSet();
        int n = notePeriods.size();
        for (int i = 0; i < n; ++i) {
            TimedArc currentNote = notePeriods.get(i);
            if (currentGroup.isEmpty()) {
                currentGroup.add(currentNote);
            } else {
                boolean shouldGroup;
                TimedArc lastNote = (TimedArc)CollectionsKt.last((Iterable)currentGroup);
                boolean isOverlapping = lastNote.getEnd() > currentNote.getStart();
                boolean bl = shouldGroup = isOverlapping && !NotePeriodKt.improvedContiguousGroupDetection$shouldIgnoreOverlap(overlapThreshold, lastNote, currentNote);
                if (shouldGroup || NotePeriodKt.improvedContiguousGroupDetection$areSustainedTogether(lastNote, currentNote)) {
                    currentGroup.add(currentNote);
                } else {
                    groups2.add(new TimedArcGroup(currentGroup));
                    TimedArc[] timedArcArray = new TimedArc[]{currentNote};
                    currentGroup = SetsKt.mutableSetOf(timedArcArray);
                }
            }
            lookAheadNotes = notePeriods.subList(i + 1, notePeriods.size());
            for (TimedArc lookAheadNote : lookAheadNotes) {
                if (!NotePeriodKt.improvedContiguousGroupDetection$areSustainedTogether(currentNote, lookAheadNote)) continue;
                currentGroup.add(lookAheadNote);
            }
        }
        if (!((Collection)currentGroup).isEmpty()) {
            groups2.add(new TimedArcGroup(currentGroup));
        }
        List<TimedArc> $this$filter$iv = groups2;
        boolean $i$f$filter = false;
        lookAheadNotes = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            TimedArcGroup timedArcGroup = (TimedArcGroup)element$iv$iv;
            boolean bl = false;
            Set<TimedArc> arcs = timedArcGroup.component1();
            Iterable iterable = arcs;
            Polyphony polyphony = Polyphony.INSTANCE;
            boolean $i$f$map = false;
            void var19_28 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TimedArc timedArc = (TimedArc)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                NoteEvent[] noteEventArray = new NoteEvent[]{it.getNoteOn(), it.getNoteOff()};
                collection.add(CollectionsKt.listOf(noteEventArray));
            }
            if (!(MathKt.roundToInt(polyphony.averagePolyphony(CollectionsKt.flatten((List)destination$iv$iv2))) == 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List probablySoloGroups = (List)destination$iv$iv;
        groups2.removeAll(probablySoloGroups);
        Iterable $this$forEach$iv = probablySoloGroups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimedArcGroup soloGroup = (TimedArcGroup)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = soloGroup.getArcs();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TimedArc notePeriod = (TimedArc)element$iv2;
                boolean bl3 = false;
                groups2.add(new TimedArcGroup(SetsKt.setOf(notePeriod)));
            }
        }
        return groups2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TimedArc> notePeriodsModulus(@NotNull List<? extends MidiEvent> $this$notePeriodsModulus, @NotNull Midis2jam2 context2, int modulus) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter($this$notePeriodsModulus, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        Iterable iterable = $this$notePeriodsModulus;
        TimeBasedSequence timeBasedSequence = context2.getSequence();
        TimedArc.Companion companion = TimedArc.Companion;
        boolean $i$f$filterIsInstance = false;
        void var5_7 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof NoteEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$filterIsInstance$iv = list2;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NoteEvent it = (NoteEvent)element$iv$iv;
            boolean bl = false;
            if (!((it.getNote() + 3) % 12 == modulus)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        return companion.fromNoteEvents(timeBasedSequence, list2);
    }

    @NotNull
    public static final List<TimedArcGroup> contiguousGroups(@NotNull List<TimedArc> $this$contiguousGroups) {
        Intrinsics.checkNotNullParameter($this$contiguousGroups, "<this>");
        if ($this$contiguousGroups.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if ($this$contiguousGroups.size() == 1) {
            return CollectionsKt.listOf(new TimedArcGroup(SetsKt.setOf(CollectionsKt.first($this$contiguousGroups))));
        }
        List groups2 = new ArrayList();
        Ref.ObjectRef<Set<TimedArc>> currentGroup = new Ref.ObjectRef<Set<TimedArc>>();
        currentGroup.element = new LinkedHashSet();
        Ref.LongRef furthestTime = new Ref.LongRef();
        furthestTime.element = DurationKt.toDuration(0, DurationUnit.SECONDS);
        Iterable $this$forEach$iv = $this$contiguousGroups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimedArc notePeriod = (TimedArc)element$iv;
            boolean bl = false;
            NotePeriodKt.contiguousGroups$register(notePeriod, groups2, currentGroup, furthestTime, !((Collection)currentGroup.element).isEmpty() && Duration.compareTo-LRDsOJo(notePeriod.getStartTime-UwyO8pc(), furthestTime.element) >= 0);
        }
        if (!((Collection)currentGroup.element).isEmpty()) {
            groups2.add(new TimedArcGroup((Set)currentGroup.element));
        }
        return groups2;
    }

    private static final boolean improvedContiguousGroupDetection$shouldIgnoreOverlap(double overlapThreshold, TimedArc note1, TimedArc note2) {
        return note1.getEnd() > note2.getStart() && (double)(note1.getEnd() - note2.getStart()) < overlapThreshold;
    }

    private static final boolean improvedContiguousGroupDetection$areSustainedTogether(TimedArc note1, TimedArc note2) {
        return note1.getStart() < note2.getEnd() && note2.getStart() < note1.getEnd();
    }

    private static final void contiguousGroups$register(TimedArc $this$contiguousGroups_u24register, List<TimedArcGroup> groups2, Ref.ObjectRef<Set<TimedArc>> currentGroup, Ref.LongRef furthestTime, boolean newGroup) {
        if (newGroup) {
            groups2.add(new TimedArcGroup((Set)currentGroup.element));
            TimedArc[] timedArcArray = new TimedArc[]{$this$contiguousGroups_u24register};
            currentGroup.element = SetsKt.mutableSetOf(timedArcArray);
            furthestTime.element = $this$contiguousGroups_u24register.getEndTime-UwyO8pc();
        } else {
            ((Set)currentGroup.element).add($this$contiguousGroups_u24register);
            furthestTime.element = RangesKt.coerceAtLeast(Duration.box-impl($this$contiguousGroups_u24register.getEndTime-UwyO8pc()), Duration.box-impl(furthestTime.element)).unbox-impl();
        }
    }

    static /* synthetic */ void contiguousGroups$register$default(TimedArc timedArc, List list2, Ref.ObjectRef objectRef, Ref.LongRef longRef, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        NotePeriodKt.contiguousGroups$register(timedArc, list2, objectRef, longRef, bl);
    }
}

