/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.family.soundeffects;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.math.Quaternion;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.noise.Noise;
import org.spongepowered.noise.NoiseQuality;
import org.wysko.kmidi.midi.TimedArc;
import org.wysko.kmidi.midi.event.MidiEvent;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.SustainedInstrument;
import org.wysko.midis2jam2.util.Utils;
import org.wysko.midis2jam2.world.AssetLoaderKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\"\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006 "}, d2={"Lorg/wysko/midis2jam2/instrument/family/soundeffects/Helicopter;", "Lorg/wysko/midis2jam2/instrument/SustainedInstrument;", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "eventList", "", "Lorg/wysko/kmidi/midi/event/MidiEvent;", "(Lorg/wysko/midis2jam2/Midis2jam2;Ljava/util/List;)V", "animNode", "Lcom/jme3/scene/Node;", "force", "", "lights", "", "Lcom/jme3/scene/Spatial;", "[Lcom/jme3/scene/Spatial;", "rotXRand", "", "rotYRand", "rotZRand", "rotor", "adjustForMultipleInstances", "", "delta", "Lkotlin/time/Duration;", "adjustForMultipleInstances-LRDsOJo", "(J)V", "tick", "time", "tick-QTBD994", "(JJ)V", "Companion", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHelicopter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Helicopter.kt\norg/wysko/midis2jam2/instrument/family/soundeffects/Helicopter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n13309#2,2:212\n1855#3,2:214\n*S KotlinDebug\n*F\n+ 1 Helicopter.kt\norg/wysko/midis2jam2/instrument/family/soundeffects/Helicopter\n*L\n78#1:212,2\n81#1:214,2\n*E\n"})
public final class Helicopter
extends SustainedInstrument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float rotXRand;
    private final float rotYRand;
    private final float rotZRand;
    @NotNull
    private final Node animNode;
    @NotNull
    private final Node rotor;
    @NotNull
    private final Spatial[] lights;
    private double force;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public Helicopter(@NotNull Midis2jam2 context2, @NotNull List<? extends MidiEvent> eventList) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(eventList, "eventList");
        super(context2, eventList);
        this.animNode = new Node();
        this.rotor = new Node();
        Spatial copter = AssetLoaderKt.modelD(context2, "HelicopterBody.obj", "Helicopter.png");
        this.rotor.attachChild(context2.getAssetLoader().fakeShadow("Assets/HelicopterRotorPlane.obj", "Assets/HelicopterRotor.png"));
        int n = 0;
        Spatial[] spatialArray = new Spatial[12];
        Helicopter helicopter = this;
        while (n < 12) {
            void $this$_init__u24lambda_u242;
            Spatial spatial;
            int n2 = n++;
            Spatial spatial2 = spatial = context2.getAssetLoader().fakeShadow("Assets/HelicopterRotorPlane.obj", "Assets/HelicopterLights" + (n2 + 1) + ".png");
            int n3 = n2;
            Spatial[] spatialArray2 = spatialArray;
            boolean bl = false;
            this.rotor.attachChild((Spatial)$this$_init__u24lambda_u242);
            $this$_init__u24lambda_u242.setCullHint(Spatial.CullHint.Always);
            Unit unit = Unit.INSTANCE;
            spatialArray2[n3] = spatial;
        }
        helicopter.lights = spatialArray;
        this.rotor.setLocalTranslation(40.0f, 36.0f, 0.0f);
        this.animNode.attachChild(copter);
        this.animNode.attachChild(this.rotor);
        Spatial cap = AssetLoaderKt.modelD(context2, "HelicopterRotorCap.obj", "Helicopter.png");
        cap.setLocalTranslation(0.0f, 0.0f, 0.5f);
        this.animNode.attachChild(cap);
        Random random = new Random();
        this.rotXRand = random.nextFloat();
        this.rotYRand = random.nextFloat();
        this.rotZRand = random.nextFloat();
        this.getGeometry().attachChild(this.animNode);
    }

    @Override
    public void tick-QTBD994(long time, long delta) {
        super.tick-QTBD994(time, delta);
        Object $this$forEach$iv = this.lights;
        boolean $i$f$forEach = false;
        int n = ((Spatial[])$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            Spatial element$iv;
            Spatial it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.setCullHint(Spatial.CullHint.Always);
        }
        $this$forEach$iv = this.getCollector().getCurrentTimedArcs();
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            TimedArc it = (TimedArc)element$iv;
            boolean bl = false;
            this.lights[11 - (it.getNote() + 3) % 12].setCullHint(Spatial.CullHint.Dynamic);
        }
        if (!((Collection)this.getCollector().getCurrentTimedArcs()).isEmpty()) {
            this.force += Duration.toDouble-impl(delta, DurationUnit.SECONDS);
            this.force = RangesKt.coerceAtMost(this.force, 1.0);
        } else {
            this.force -= Duration.toDouble-impl(delta, DurationUnit.SECONDS);
            this.force = RangesKt.coerceAtLeast(this.force, 0.0);
        }
        this.rotor.rotate(new Quaternion().fromAngles(0.0f, Utils.INSTANCE.rad((double)3141 * Duration.toDouble-impl(delta, DurationUnit.SECONDS)), 0.0f));
        this.animNode.setLocalRotation(new Quaternion().fromAngles((float)(this.force * (double)0.5f * (double)Utils.INSTANCE.rad((Noise.gradientCoherentNoise3D(0.0, 0.0, Duration.toDouble-impl(time, DurationUnit.SECONDS), (int)(this.rotXRand * (float)1000), NoiseQuality.STANDARD) - 0.4) * (double)10)), (float)(this.force * (double)0.5f * (double)Utils.INSTANCE.rad((Noise.gradientCoherentNoise3D(0.0, 0.0, Duration.toDouble-impl(time, DurationUnit.SECONDS), (int)(this.rotYRand * (float)1000), NoiseQuality.STANDARD) - 0.4) * (double)10)), (float)(this.force * (double)0.5f * (double)Utils.INSTANCE.rad((Noise.gradientCoherentNoise3D(0.0, 0.0, Duration.toDouble-impl(time, DurationUnit.SECONDS), (int)(this.rotZRand * (float)1000), NoiseQuality.STANDARD) - 0.4) * (double)10))));
        this.getPlacement().setLocalRotation(new Quaternion().fromAngles(Utils.INSTANCE.rad(5.0), Utils.INSTANCE.rad(120.0), Utils.INSTANCE.rad(11.0)));
        this.animNode.setLocalTranslation(0.0f, (float)(this.force * (Noise.gradientCoherentNoise3D(0.0, 0.0, Duration.toDouble-impl(time, DurationUnit.SECONDS), (int)(this.rotZRand * (float)1000), NoiseQuality.STANDARD) - 0.4)) * (float)10, 0.0f);
        this.getPlacement().setLocalTranslation(0.0f, (float)-120 + (float)120 * Helicopter.Companion.easeInOutSine(this.force), 0.0f);
    }

    @Override
    protected void adjustForMultipleInstances-LRDsOJo(long delta) {
        this.getRoot().setLocalTranslation((float)20 + (float)50 * this.updateInstrumentIndex-LRDsOJo(delta), 40.0f, -300.0f);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0004\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/wysko/midis2jam2/instrument/family/soundeffects/Helicopter$Companion;", "", "()V", "easeInOutSine", "", "x", "", "midis2jam2"})
    public static final class Companion {
        private Companion() {
        }

        private final float easeInOutSine(Number x2) {
            return (float)(-(Math.cos(Math.PI * x2.doubleValue()) - 1.0) / (double)2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

