/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.family.percussion.drumset.kit;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.math.Quaternion;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.algorithmic.EventCollector;
import org.wysko.midis2jam2.instrument.family.percussion.PercussionInstrument;
import org.wysko.midis2jam2.instrument.family.percussion.drumset.DrumSetInstrument;
import org.wysko.midis2jam2.instrument.family.percussion.drumset.kit.ShellStyle;
import org.wysko.midis2jam2.world.AssetLoaderKt;
import org.wysko.midis2jam2.world.Axis;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001e"}, d2={"Lorg/wysko/midis2jam2/instrument/family/percussion/drumset/kit/BassDrum;", "Lorg/wysko/midis2jam2/instrument/family/percussion/drumset/DrumSetInstrument;", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "hits", "", "Lorg/wysko/kmidi/midi/event/NoteEvent$NoteOn;", "style", "Lorg/wysko/midis2jam2/instrument/family/percussion/drumset/kit/ShellStyle;", "(Lorg/wysko/midis2jam2/Midis2jam2;Ljava/util/List;Lorg/wysko/midis2jam2/instrument/family/percussion/drumset/kit/ShellStyle;)V", "beaterArm", "Lcom/jme3/scene/Spatial;", "beaterAssembly", "Lcom/jme3/scene/Node;", "drum", "eventCollector", "Lorg/wysko/midis2jam2/instrument/algorithmic/EventCollector;", "pedal", "rotationFactor", "", "beaterRotation", "Lcom/jme3/math/Quaternion;", "pedalRotation", "tick", "", "time", "Lkotlin/time/Duration;", "delta", "tick-QTBD994", "(JJ)V", "midis2jam2"})
@StabilityInferred(parameters=0)
public final class BassDrum
extends DrumSetInstrument {
    @NotNull
    private final EventCollector<NoteEvent.NoteOn> eventCollector;
    @NotNull
    private final Node beaterAssembly;
    @NotNull
    private final Spatial drum;
    @NotNull
    private final Spatial beaterArm;
    @NotNull
    private final Spatial pedal;
    private float rotationFactor;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public BassDrum(@NotNull Midis2jam2 context2, @NotNull List<NoteEvent.NoteOn> hits, @NotNull ShellStyle style) {
        void $this$pedal_u24lambda_u244;
        Spatial $this$beaterArm_u24lambda_u243;
        Spatial $this$drum_u24lambda_u241;
        Spatial $this$beaterAssembly_u24lambda_u240;
        Spatial spatial;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(hits, "hits");
        Intrinsics.checkNotNullParameter(style, "style");
        super(context2, hits);
        this.eventCollector = new EventCollector(context2, hits, null, null, 12, null);
        Node node2 = spatial = new Node();
        BassDrum bassDrum = this;
        boolean bl = false;
        this.getGeometry().attachChild($this$beaterAssembly_u24lambda_u240);
        $this$beaterAssembly_u24lambda_u240.move(0.0f, 0.0f, 1.5f);
        bassDrum.beaterAssembly = spatial;
        $this$beaterAssembly_u24lambda_u240 = spatial = AssetLoaderKt.modelD(context2, style.getBassDrumModel(), style.getShellTexture());
        bassDrum = this;
        boolean bl2 = false;
        $this$drum_u24lambda_u241.setShadowMode(RenderQueue.ShadowMode.Cast);
        this.getRecoilNode().attachChild($this$drum_u24lambda_u241);
        bassDrum.drum = spatial;
        $this$drum_u24lambda_u241 = spatial = AssetLoaderKt.modelD(context2, "DrumSet_BassDrumBeaterArm.obj", "MetalTexture.bmp");
        bassDrum = this;
        boolean bl3 = false;
        this.beaterAssembly.attachChild($this$beaterArm_u24lambda_u243);
        $this$beaterArm_u24lambda_u243.move(0.0f, 5.5f, 1.35f);
        Intrinsics.checkNotNull($this$beaterArm_u24lambda_u243, "null cannot be cast to non-null type com.jme3.scene.Node");
        Node it = $this$beaterArm_u24lambda_u243;
        boolean bl4 = false;
        it.getChildren().get(0).setMaterial(context2.reflectiveMaterial("ShinySilver.bmp"));
        it.getChildren().get(1).setMaterial(context2.diffuseMaterial("MetalTextureDark.bmp"));
        bassDrum.beaterArm = spatial;
        $this$beaterArm_u24lambda_u243 = spatial = AssetLoaderKt.modelD(context2, "DrumSet_BassDrumPedal.obj", "MetalTexture.bmp");
        bassDrum = this;
        boolean bl5 = false;
        this.beaterAssembly.attachChild((Spatial)$this$pedal_u24lambda_u244);
        $this$pedal_u24lambda_u244.move(0.0f, 0.5f, 7.5f);
        bassDrum.pedal = spatial;
        this.beaterAssembly.attachChild(AssetLoaderKt.modelD(context2, "DrumSet_BassDrumBeaterHolder.obj", "MetalTexture.bmp"));
        this.getGeometry().move(0.0f, 0.0f, -80.0f);
    }

    @Override
    public void tick-QTBD994(long time, long delta) {
        super.tick-QTBD994(time, delta);
        NoteEvent.NoteOn results = this.eventCollector.advanceCollectOne-LRDsOJo(time);
        PercussionInstrument.Companion companion = PercussionInstrument.Companion;
        Spatial spatial = this.drum;
        NoteEvent.NoteOn noteOn = results;
        byte by = noteOn != null ? noteOn.getVelocity() : (byte)0;
        Axis axis = Axis.Z;
        PercussionInstrument.Companion.recoilDrum-WPi__2c$default(companion, spatial, by, delta, -3.0f, 0.0f, axis, 16, null);
        NoteEvent.NoteOn noteOn2 = results;
        if (noteOn2 != null) {
            NoteEvent.NoteOn it = noteOn2;
            boolean bl = false;
            this.rotationFactor = 1.0f;
        }
        this.beaterArm.setLocalRotation(this.beaterRotation());
        this.pedal.setLocalRotation(this.pedalRotation());
        this.rotationFactor -= (float)(Duration.toDouble-impl(delta, DurationUnit.SECONDS) * 8.0);
        this.rotationFactor = RangesKt.coerceAtLeast(this.rotationFactor, 0.0f);
    }

    private final Quaternion beaterRotation() {
        Quaternion quaternion = new Quaternion().fromAngles(-this.rotationFactor + 0.87f, 0.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue(quaternion, "fromAngles(...)");
        return quaternion;
    }

    private final Quaternion pedalRotation() {
        Quaternion quaternion = new Quaternion().fromAngles(-this.rotationFactor * 0.5f + 0.2f, 0.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue(quaternion, "fromAngles(...)");
        return quaternion;
    }
}

