/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.family.percussion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.math.Quaternion;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.algorithmic.StickStatus;
import org.wysko.midis2jam2.instrument.algorithmic.Striker;
import org.wysko.midis2jam2.instrument.family.percussion.AuxiliaryPercussion;
import org.wysko.midis2jam2.util.Utils;
import org.wysko.midis2jam2.world.AssetLoaderKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001b"}, d2={"Lorg/wysko/midis2jam2/instrument/family/percussion/Metronome;", "Lorg/wysko/midis2jam2/instrument/family/percussion/AuxiliaryPercussion;", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "clickHits", "", "Lorg/wysko/kmidi/midi/event/NoteEvent$NoteOn;", "bellHits", "(Lorg/wysko/midis2jam2/Midis2jam2;Ljava/util/List;Ljava/util/List;)V", "bell", "Lcom/jme3/scene/Spatial;", "bellStriker", "Lorg/wysko/midis2jam2/instrument/algorithmic/Striker;", "bellSwingsRight", "", "click", "clickStriker", "clickSwingsRight", "previousBellTarget", "previousClickTarget", "tick", "", "time", "Lkotlin/time/Duration;", "delta", "tick-QTBD994", "(JJ)V", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMetronome.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Metronome.kt\norg/wysko/midis2jam2/instrument/family/percussion/Metronome\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1045#2:121\n*S KotlinDebug\n*F\n+ 1 Metronome.kt\norg/wysko/midis2jam2/instrument/family/percussion/Metronome\n*L\n35#1:121\n*E\n"})
public final class Metronome
extends AuxiliaryPercussion {
    @NotNull
    private final Striker bellStriker;
    @NotNull
    private final Striker clickStriker;
    @NotNull
    private final Spatial bell;
    @NotNull
    private final Spatial click;
    private boolean clickSwingsRight;
    private boolean bellSwingsRight;
    @Nullable
    private NoteEvent.NoteOn previousBellTarget;
    @Nullable
    private NoteEvent.NoteOn previousClickTarget;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public Metronome(@NotNull Midis2jam2 context2, @NotNull List<NoteEvent.NoteOn> clickHits, @NotNull List<NoteEvent.NoteOn> bellHits) {
        void $this$click_u24lambda_u242;
        Spatial $this$bell_u24lambda_u241;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(clickHits, "clickHits");
        Intrinsics.checkNotNullParameter(bellHits, "bellHits");
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)clickHits, (Iterable)bellHits);
        boolean $i$f$sortedBy22 = false;
        super(context2, CollectionsKt.toMutableList(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                NoteEvent.NoteOn it = (NoteEvent.NoteOn)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTick());
                it = (NoteEvent.NoteOn)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getTick());
            }
        })));
        Spatial spatial = new Node();
        this.bellStriker = new Striker(context2, bellHits, spatial, 2.4, 30.0, null, false, false, 224, null);
        spatial = new Node();
        this.clickStriker = new Striker(context2, clickHits, spatial, 2.4, 30.0, null, false, false, 224, null);
        spatial = AssetLoaderKt.modelD(context2, "MetronomePendjulum2.obj", "HornSkin.bmp");
        Spatial $i$f$sortedBy22 = spatial;
        Metronome metronome = this;
        boolean bl = false;
        this.getGeometry().attachChild($this$bell_u24lambda_u241);
        $this$bell_u24lambda_u241.setLocalTranslation(0.0f, 0.0f, 0.5f);
        metronome.bell = spatial;
        $this$bell_u24lambda_u241 = spatial = AssetLoaderKt.modelD(context2, "MetronomePendjulum1.obj", "ShinySilver.bmp");
        metronome = this;
        boolean bl2 = false;
        this.getGeometry().attachChild((Spatial)$this$click_u24lambda_u242);
        $this$click_u24lambda_u242.setLocalTranslation(0.0f, 0.0f, 1.0f);
        metronome.click = spatial;
        this.clickSwingsRight = true;
        this.bellSwingsRight = true;
        Spatial $this$_init__u24lambda_u243 = spatial = this.getGeometry();
        boolean bl3 = false;
        ((Node)$this$_init__u24lambda_u243).attachChild(AssetLoaderKt.modelD(context2, "MetronomeBox.obj", "Wood.bmp"));
        $this$_init__u24lambda_u243.setLocalTranslation(-20.0f, 0.0f, -46.0f);
        $this$_init__u24lambda_u243.setLocalRotation(new Quaternion().fromAngles(0.0f, Utils.INSTANCE.rad(20.0), 0.0f));
    }

    @Override
    public void tick-QTBD994(long time, long delta) {
        super.tick-QTBD994(time, delta);
        StickStatus bellResults = this.bellStriker.tick-QTBD994(time, delta);
        StickStatus clickResults = this.clickStriker.tick-QTBD994(time, delta);
        NoteEvent.NoteOn noteOn = bellResults.getStrikingFor();
        if (noteOn != null) {
            NoteEvent.NoteOn it = noteOn;
            boolean bl = false;
            if (!Intrinsics.areEqual(it, this.previousBellTarget)) {
                this.previousBellTarget = it;
                this.bellSwingsRight = !this.bellSwingsRight;
            }
        }
        float bellRotation = this.bellSwingsRight ? bellResults.getRotationAngle() - Utils.INSTANCE.rad(30.0) : -bellResults.getRotationAngle() + Utils.INSTANCE.rad(30.0);
        this.bell.setLocalRotation(new Quaternion().fromAngles(0.0f, 0.0f, bellRotation));
        NoteEvent.NoteOn noteOn2 = clickResults.getStrikingFor();
        if (noteOn2 != null) {
            NoteEvent.NoteOn it = noteOn2;
            boolean bl = false;
            if (!Intrinsics.areEqual(it, this.previousClickTarget)) {
                this.previousClickTarget = it;
                this.clickSwingsRight = !this.clickSwingsRight;
            }
        }
        float clickRotation = this.clickSwingsRight ? clickResults.getRotationAngle() - Utils.INSTANCE.rad(30.0) : -clickResults.getRotationAngle() + Utils.INSTANCE.rad(30.0);
        this.click.setLocalRotation(new Quaternion().fromAngles(0.0f, 0.0f, clickRotation));
    }
}

