/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.family.percussion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.math.Quaternion;
import com.jme3.scene.Node;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.algorithmic.EventCollector;
import org.wysko.midis2jam2.instrument.family.percussion.AuxiliaryPercussion;
import org.wysko.midis2jam2.instrument.family.percussion.GuiroKt;
import org.wysko.midis2jam2.instrument.family.percussion.GuiroStickSpeed;
import org.wysko.midis2jam2.world.AssetLoaderKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0015H\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0015H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006!"}, d2={"Lorg/wysko/midis2jam2/instrument/family/percussion/Guiro;", "Lorg/wysko/midis2jam2/instrument/family/percussion/AuxiliaryPercussion;", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "shortHits", "", "Lorg/wysko/kmidi/midi/event/NoteEvent$NoteOn;", "longHits", "(Lorg/wysko/midis2jam2/Midis2jam2;Ljava/util/List;Ljava/util/List;)V", "guiroNode", "Lcom/jme3/scene/Node;", "isMoving", "", "isMovingLeft", "longCollector", "Lorg/wysko/midis2jam2/instrument/algorithmic/EventCollector;", "movingSpeed", "Lorg/wysko/midis2jam2/instrument/family/percussion/GuiroStickSpeed;", "shortCollector", "stickNode", "stickPosition", "", "easedStickPosition", "tick", "", "time", "Lkotlin/time/Duration;", "delta", "tick-QTBD994", "(JJ)V", "toString", "", "verticalTransform", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGuiro.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Guiro.kt\norg/wysko/midis2jam2/instrument/family/percussion/Guiro\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1045#2:169\n*S KotlinDebug\n*F\n+ 1 Guiro.kt\norg/wysko/midis2jam2/instrument/family/percussion/Guiro\n*L\n68#1:169\n*E\n"})
public final class Guiro
extends AuxiliaryPercussion {
    @NotNull
    private final EventCollector<NoteEvent.NoteOn> shortCollector;
    @NotNull
    private final EventCollector<NoteEvent.NoteOn> longCollector;
    @NotNull
    private final Node guiroNode;
    @NotNull
    private final Node stickNode;
    private boolean isMoving;
    private boolean isMovingLeft;
    @NotNull
    private GuiroStickSpeed movingSpeed;
    private float stickPosition;
    public static final int $stable = 8;

    public Guiro(@NotNull Midis2jam2 context2, @NotNull List<NoteEvent.NoteOn> shortHits, @NotNull List<NoteEvent.NoteOn> longHits) {
        Node $this$stickNode_u24lambda_u243;
        Node it;
        Node $this$guiroNode_u24lambda_u241;
        Node node2;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(shortHits, "shortHits");
        Intrinsics.checkNotNullParameter(longHits, "longHits");
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)shortHits, (Iterable)longHits);
        boolean $i$f$sortedBy22 = false;
        super(context2, CollectionsKt.toMutableList(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                NoteEvent.NoteOn it = (NoteEvent.NoteOn)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTick());
                it = (NoteEvent.NoteOn)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getTick());
            }
        })));
        this.shortCollector = new EventCollector(context2, shortHits, null, null, 12, null);
        this.longCollector = new EventCollector(context2, longHits, null, null, 12, null);
        Node $i$f$sortedBy22 = node2 = new Node();
        Guiro guiro = this;
        boolean bl = false;
        $this$guiroNode_u24lambda_u241.attachChild(AssetLoaderKt.modelD(context2, "DrumSet_Guiro.obj", "GuiroSkin.png"));
        $this$guiroNode_u24lambda_u241 = node2;
        boolean bl2 = false;
        this.getGeometry().attachChild(it);
        guiro.guiroNode = node2;
        it = node2 = new Node();
        guiro = this;
        boolean bl3 = false;
        $this$stickNode_u24lambda_u243.attachChild(AssetLoaderKt.modelD(context2, "DrumSet_GuiroStick.obj", "Wood.bmp"));
        $this$stickNode_u24lambda_u243 = node2;
        boolean bl4 = false;
        this.getGeometry().attachChild(it);
        guiro.stickNode = node2;
        this.isMovingLeft = true;
        this.movingSpeed = GuiroStickSpeed.LONG;
        this.getGeometry().setLocalTranslation(GuiroKt.access$getBASE_POSITION$p());
        this.getGeometry().setLocalRotation(GuiroKt.access$getBASE_ROTATION$p());
    }

    @Override
    public void tick-QTBD994(long time, long delta) {
        NoteEvent.NoteOn it;
        super.tick-QTBD994(time, delta);
        NoteEvent.NoteOn noteOn = this.shortCollector.advanceCollectOne-LRDsOJo(time);
        if (noteOn != null) {
            it = noteOn;
            boolean bl = false;
            this.isMoving = true;
            this.movingSpeed = GuiroStickSpeed.SHORT;
            boolean bl2 = this.isMovingLeft = !this.isMovingLeft;
            if (this.isMovingLeft) {
                this.stickPosition = 1.0f;
            }
        }
        NoteEvent.NoteOn noteOn2 = this.longCollector.advanceCollectOne-LRDsOJo(time);
        if (noteOn2 != null) {
            it = noteOn2;
            boolean bl = false;
            this.isMoving = true;
            this.movingSpeed = GuiroStickSpeed.LONG;
            boolean bl3 = this.isMovingLeft = !this.isMovingLeft;
            if (this.isMovingLeft) {
                this.stickPosition = 1.0f;
            }
        }
        if (this.isMoving) {
            this.stickPosition += (float)((double)((this.isMovingLeft ? -1.0f : 1.0f) * (this.movingSpeed == GuiroStickSpeed.LONG ? 3.6f : 9.0f)) * Duration.toDouble-impl(delta, DurationUnit.SECONDS));
            if (!GuiroKt.access$getGUIRO_SLIDE_RANGE$p().contains((Comparable)Float.valueOf(this.stickPosition))) {
                this.isMoving = false;
            }
            this.stickPosition = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(this.stickPosition), GuiroKt.access$getGUIRO_SLIDE_RANGE$p()))).floatValue();
        }
        Node $this$tick_QTBD994_u24lambda_u247 = this.stickNode;
        boolean bl = false;
        $this$tick_QTBD994_u24lambda_u247.setLocalTranslation(GuiroKt.access$getSTICK_BASE_POSITION$p().add(this.easedStickPosition() * 5.0f, this.verticalTransform(), 0.0f));
        $this$tick_QTBD994_u24lambda_u247.setLocalRotation(new Quaternion().fromAngles(this.verticalTransform() / (float)4, 0.0f, 0.0f));
        this.guiroNode.setLocalTranslation(0.0f, this.verticalTransform() / (float)4, 0.0f);
    }

    private final float easedStickPosition() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.movingSpeed.ordinal()]) {
            case 1 -> {
                if (this.isMovingLeft) {
                    yield 1.0f - (float)Math.pow(1.0f - this.stickPosition, 2);
                }
                yield (float)Math.pow(this.stickPosition, 2);
            }
            case 2 -> {
                if (this.isMovingLeft) {
                    yield (float)Math.pow(this.stickPosition, 2);
                }
                yield 1.0f - (float)Math.pow(1.0f - this.stickPosition, 2);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final float verticalTransform() {
        return Math.abs((float)Math.pow((float)2 * this.stickPosition - 1.0f, 5));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toString() {
        void $this$toString_u24lambda_u248;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        String string = super.toString();
        boolean bl = false;
        StringBuilder stringBuilder3 = $this$toString_u24lambda_u248.append(this.formatProperty("stickPosition", Float.valueOf(this.stickPosition)));
        Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(...)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append(...)");
        StringBuilder stringBuilder4 = $this$toString_u24lambda_u248.append(this.formatProperty("isMovingLeft", String.valueOf(this.isMovingLeft)));
        Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(...)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append(...)");
        StringBuilder stringBuilder5 = $this$toString_u24lambda_u248.append(this.formatProperty("isMoving", String.valueOf(this.isMoving)));
        Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(...)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append(...)");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string + string2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GuiroStickSpeed.values().length];
            try {
                nArray[GuiroStickSpeed.LONG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GuiroStickSpeed.SHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

