/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.family.organ;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.math.Quaternion;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.midi.TimedArc;
import org.wysko.kmidi.midi.event.MidiEvent;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.family.organ.AccordionKey;
import org.wysko.midis2jam2.instrument.family.piano.Key;
import org.wysko.midis2jam2.instrument.family.piano.KeyConfiguration;
import org.wysko.midis2jam2.instrument.family.piano.KeyboardConfiguration;
import org.wysko.midis2jam2.instrument.family.piano.KeyedInstrument;
import org.wysko.midis2jam2.util.Utils;
import org.wysko.midis2jam2.world.AssetLoaderKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 -2\u00020\u0001:\u0002-.B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\b\u0010 \u001a\u00020\fH\u0002J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020&H\u0016J\"\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b)\u0010*J\b\u0010+\u001a\u00020,H\u0016R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006/"}, d2={"Lorg/wysko/midis2jam2/instrument/family/organ/Accordion;", "Lorg/wysko/midis2jam2/instrument/family/piano/KeyedInstrument;", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "eventList", "", "Lorg/wysko/kmidi/midi/event/MidiEvent;", "type", "Lorg/wysko/midis2jam2/instrument/family/organ/Accordion$Type;", "(Lorg/wysko/midis2jam2/Midis2jam2;Ljava/util/List;Lorg/wysko/midis2jam2/instrument/family/organ/Accordion$Type;)V", "accordionSections", "", "Lcom/jme3/scene/Node;", "[Lcom/jme3/scene/Node;", "angle", "", "expanding", "", "keys", "Lorg/wysko/midis2jam2/instrument/family/piano/Key;", "getKeys", "()[Lorg/wysko/midis2jam2/instrument/family/piano/Key;", "[Lorg/wysko/midis2jam2/instrument/family/piano/Key;", "squeezingSpeed", "", "adjustForMultipleInstances", "", "delta", "Lkotlin/time/Duration;", "adjustForMultipleInstances-LRDsOJo", "(J)V", "calculateAngle", "dummyWhiteKey", "getKeyByMidiNote", "midiNote", "", "keyStatus", "Lorg/wysko/midis2jam2/instrument/family/piano/Key$State;", "", "tick", "time", "tick-QTBD994", "(JJ)V", "toString", "", "Companion", "Type", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAccordion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Accordion.kt\norg/wysko/midis2jam2/instrument/family/organ/Accordion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n13309#2,2:252\n13309#2,2:254\n13309#2,2:256\n1#3:258\n1855#4,2:259\n288#4,2:261\n*S KotlinDebug\n*F\n+ 1 Accordion.kt\norg/wysko/midis2jam2/instrument/family/organ/Accordion\n*L\n227#1:252,2\n232#1:254,2\n240#1:256,2\n134#1:259,2\n195#1:261,2\n*E\n"})
public final class Accordion
extends KeyedInstrument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Key[] keys;
    @NotNull
    private final Node[] accordionSections;
    private float angle;
    private double squeezingSpeed;
    private boolean expanding;
    public static final int $stable = 8;
    @NotNull
    private static final ClosedFloatingPointRange<Float> SQUEEZE_RANGE = RangesKt.rangeTo(1.0f, 4.0f);
    public static final int SECTION_COUNT = 14;
    public static final int MAX_SQUEEZING_SPEED = 2;
    public static final float WHITE_KEY_COUNT = 12.0f;
    @NotNull
    private static final KeyboardConfiguration KEY_CONFIGURATION = new KeyboardConfiguration(new KeyConfiguration.SeparateTextures("AccordionKeyWhiteFront.obj", "AccordionKeyWhiteBack.obj", "AccordionKey.bmp", "AccordionKeyDown.bmp"), new KeyConfiguration.SeparateTextures("AccordionKeyBlack.obj", null, "AccordionKeyBlack.bmp", "AccordionKeyBlackDown.bmp"));

    public Accordion(@NotNull Midis2jam2 context2, @NotNull List<MidiEvent> eventList, @NotNull Type type2) {
        Object it;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(eventList, "eventList");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        super(context2, eventList, (byte)0, (byte)23);
        Accordion accordion = this;
        Accordion accordion2 = this;
        int n = 0;
        int whiteCount = 0;
        Key[] keyArray = new Key[24];
        for (int i = 0; i < 24; ++i) {
            int n2 = i;
            keyArray[n2] = switch (WhenMappings.$EnumSwitchMapping$0[Key.Color.Companion.fromNote((byte)n2).ordinal()]) {
                case 1 -> {
                    ++whiteCount;
                    yield new AccordionKey(this, (byte)n2, whiteCount, this);
                }
                case 2 -> new AccordionKey(this, (byte)n2, n2, this);
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        accordion2.keys = keyArray;
        int n3 = 0;
        Object it2 = new Node[14];
        accordion2 = this;
        while (n3 < 14) {
            n = n3++;
            it2[n] = new Node();
        }
        accordion2.accordionSections = it2;
        this.angle = ((Number)SQUEEZE_RANGE.getEndInclusive()).floatValue();
        it2 = AssetLoaderKt.modelD(context2, "AccordionLeftHand.obj", type2.getTextureCaseName());
        Object it3 = it2;
        boolean bl = false;
        this.accordionSections[0].attachChild((Spatial)it3);
        Object leftHandCase = it2;
        Intrinsics.checkNotNull(leftHandCase, "null cannot be cast to non-null type com.jme3.scene.Node");
        Object $this$_init__u24lambda_u247 = it2 = (Node)leftHandCase;
        boolean bl2 = false;
        ((Node)$this$_init__u24lambda_u247).getChild(1).setMaterial(context2.diffuseMaterial("LeatherStrap.bmp"));
        ((Node)$this$_init__u24lambda_u247).getChild(2).setMaterial(context2.diffuseMaterial("RubberFoot.bmp"));
        Node keysNode = new Node();
        this.accordionSections[13].attachChild(keysNode);
        Object it4 = $this$_init__u24lambda_u247 = this.dummyWhiteKey();
        boolean bl3 = false;
        keysNode.attachChild((Spatial)it4);
        ((Spatial)it4).setLocalTranslation(0.0f, 7.0f, 0.0f);
        Object it5 = $this$_init__u24lambda_u247 = this.dummyWhiteKey();
        int n4 = 0;
        keysNode.attachChild((Spatial)it5);
        ((Spatial)it5).setLocalTranslation(0.0f, -8.0f, 0.0f);
        Object[] $this$forEach$iv = this.getKeys();
        boolean $i$f$forEach = false;
        for (Key key : $this$forEach$iv) {
            it = key;
            boolean bl4 = false;
            keysNode.attachChild(((Key)it).getRoot());
        }
        keysNode.setLocalTranslation(-4.0f, 22.0f, -0.8f);
        $this$forEach$iv = this.accordionSections;
        $i$f$forEach = false;
        int n5 = $this$forEach$iv.length;
        for (n4 = 0; n4 < n5; ++n4) {
            Object object;
            Object section = object = $this$forEach$iv[n4];
            boolean bl5 = false;
            ((Node)section).attachChild(AssetLoaderKt.modelD(context2, "AccordionFold.obj", "AccordionFold.bmp"));
        }
        this.accordionSections[13].attachChild(AssetLoaderKt.modelD(context2, "AccordionRightHand.obj", type2.getTextureCaseFrontName()));
        $this$forEach$iv = this.accordionSections;
        $i$f$forEach = false;
        n5 = $this$forEach$iv.length;
        for (n4 = 0; n4 < n5; ++n4) {
            Object object;
            it = object = $this$forEach$iv[n4];
            boolean bl6 = false;
            this.getGeometry().attachChild((Spatial)it);
        }
        Node $this$_init__u24lambda_u2413 = this.getGeometry();
        boolean bl7 = false;
        $this$_init__u24lambda_u2413.setLocalTranslation(-70.0f, 10.0f, -60.0f);
        $this$_init__u24lambda_u2413.setLocalRotation(new Quaternion().fromAngles(Utils.INSTANCE.rad(0.0), Utils.INSTANCE.rad(45.0), Utils.INSTANCE.rad(-5.0)));
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        return this.keys;
    }

    private final Node dummyWhiteKey() {
        Node node2;
        Node $this$dummyWhiteKey_u24lambda_u241 = node2 = new Node();
        boolean bl = false;
        $this$dummyWhiteKey_u24lambda_u241.attachChild(AssetLoaderKt.modelD(this.getContext(), "AccordionKeyWhiteFront.obj", "AccordionKey.bmp"));
        $this$dummyWhiteKey_u24lambda_u241.attachChild(AssetLoaderKt.modelD(this.getContext(), "AccordionKeyWhiteBack.obj", "AccordionKey.bmp"));
        return node2;
    }

    private final void calculateAngle(float delta) {
        if (!((Collection)this.getCollector().getCurrentTimedArcs()).isEmpty()) {
            this.squeezingSpeed = 2.0;
        } else if (this.squeezingSpeed > 0.0) {
            double d;
            this.squeezingSpeed -= (double)(delta * (float)3);
            double it = d = RangesKt.coerceAtLeast(this.squeezingSpeed, 0.0);
            boolean bl = false;
            this.squeezingSpeed = it;
        }
        if (this.expanding) {
            this.angle += (float)((double)delta * this.squeezingSpeed);
            if (this.angle > ((Number)SQUEEZE_RANGE.getEndInclusive()).floatValue()) {
                this.expanding = false;
            }
        } else {
            this.angle -= (float)((double)delta * this.squeezingSpeed);
            if (this.angle < ((Number)SQUEEZE_RANGE.getStart()).floatValue()) {
                this.expanding = true;
            }
        }
    }

    @Override
    public void tick-QTBD994(long time, long delta) {
        super.tick-QTBD994(time, delta);
        this.calculateAngle((float)Duration.toDouble-impl(delta, DurationUnit.SECONDS));
        Iterable $this$forEach$iv = ArraysKt.getIndices(this.accordionSections);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            this.accordionSections[it].setLocalRotation(new Quaternion().fromAngles(0.0f, 0.0f, Utils.INSTANCE.rad((double)this.angle * ((double)it - 7.5))));
        }
    }

    @Override
    @NotNull
    protected Key getKeyByMidiNote(int midiNote) {
        return this.getKeys()[midiNote % 24];
    }

    @Override
    protected void adjustForMultipleInstances-LRDsOJo(long delta) {
        this.getRoot().setLocalTranslation(0.0f, (float)30 * this.updateInstrumentIndex-LRDsOJo(delta), 0.0f);
    }

    @Override
    @NotNull
    public Key.State keyStatus(byte midiNote) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.getCollector().getCurrentTimedArcs();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TimedArc it = (TimedArc)element$iv;
                boolean bl = false;
                if (!(it.getNote() % 24 == midiNote % 24)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        TimedArc timedArc = v0;
        if (timedArc != null) {
            TimedArc it = timedArc;
            boolean bl = false;
            return new Key.State.Down(it.getNoteOn().getVelocity());
        }
        return Key.State.Up.INSTANCE;
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + this.formatProperty("angle", Float.valueOf(this.angle));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/wysko/midis2jam2/instrument/family/organ/Accordion$Companion;", "", "()V", "KEY_CONFIGURATION", "Lorg/wysko/midis2jam2/instrument/family/piano/KeyboardConfiguration;", "getKEY_CONFIGURATION", "()Lorg/wysko/midis2jam2/instrument/family/piano/KeyboardConfiguration;", "MAX_SQUEEZING_SPEED", "", "SECTION_COUNT", "SQUEEZE_RANGE", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "getSQUEEZE_RANGE", "()Lkotlin/ranges/ClosedFloatingPointRange;", "WHITE_KEY_COUNT", "midis2jam2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClosedFloatingPointRange<Float> getSQUEEZE_RANGE() {
            return SQUEEZE_RANGE;
        }

        @NotNull
        public final KeyboardConfiguration getKEY_CONFIGURATION() {
            return KEY_CONFIGURATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/wysko/midis2jam2/instrument/family/organ/Accordion$Type;", "", "textureCaseName", "", "textureCaseFrontName", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getTextureCaseFrontName", "()Ljava/lang/String;", "getTextureCaseName", "ACCORDION", "BANDONEON", "midis2jam2"})
    public static final class Type
    extends Enum<Type> {
        @NotNull
        private final String textureCaseName;
        @NotNull
        private final String textureCaseFrontName;
        public static final /* enum */ Type ACCORDION = new Type("AccordionCase.bmp", "AccordionCaseFront.bmp");
        public static final /* enum */ Type BANDONEON = new Type("BandoneonCase.bmp", "BandoneonCaseFront.bmp");
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(String textureCaseName, String textureCaseFrontName) {
            this.textureCaseName = textureCaseName;
            this.textureCaseFrontName = textureCaseFrontName;
        }

        @NotNull
        public final String getTextureCaseName() {
            return this.textureCaseName;
        }

        @NotNull
        public final String getTextureCaseFrontName() {
            return this.textureCaseFrontName;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.ACCORDION, Type.BANDONEON};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Key.Color.values().length];
            try {
                nArray[Key.Color.White.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Key.Color.Black.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

