/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.family.guitar;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.midis2jam2.instrument.family.guitar.FretboardPosition;
import org.wysko.midis2jam2.instrument.family.guitar.FrettingEngine;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0002R\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/wysko/midis2jam2/instrument/family/guitar/StandardFrettingEngine;", "Lorg/wysko/midis2jam2/instrument/family/guitar/FrettingEngine;", "numberOfStrings", "", "numberOfFrets", "openStringMidiNotes", "", "(II[I)V", "frets", "getFrets", "()[I", "getNumberOfFrets", "()I", "getNumberOfStrings", "runningAverage", "", "Lorg/wysko/midis2jam2/instrument/family/guitar/FretboardPosition;", "allPossibleFretboardPositions", "midiNote", "", "applyFretboardPosition", "", "position", "bestFretboardPosition", "lowestFretboardPosition", "occupiedStrings", "", "lowestByFret", "", "releaseString", "string", "runningAveragePosition", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStandardFrettingEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardFrettingEngine.kt\norg/wysko/midis2jam2/instrument/family/guitar/StandardFrettingEngine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,131:1\n1#2:132\n766#3:133\n857#3,2:134\n2333#3,14:136\n11185#4:150\n11305#4,4:151\n*S KotlinDebug\n*F\n+ 1 StandardFrettingEngine.kt\norg/wysko/midis2jam2/instrument/family/guitar/StandardFrettingEngine\n*L\n106#1:133\n106#1:134,2\n107#1:136,14\n110#1:150\n110#1:151,4\n*E\n"})
public final class StandardFrettingEngine
implements FrettingEngine {
    private final int numberOfStrings;
    private final int numberOfFrets;
    @NotNull
    private final int[] openStringMidiNotes;
    @NotNull
    private final int[] frets;
    @NotNull
    private final List<FretboardPosition> runningAverage;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public StandardFrettingEngine(int numberOfStrings, int numberOfFrets, @NotNull int[] openStringMidiNotes) {
        void $this$frets_u24lambda_u241;
        int[] nArray;
        Intrinsics.checkNotNullParameter(openStringMidiNotes, "openStringMidiNotes");
        this.numberOfStrings = numberOfStrings;
        this.numberOfFrets = numberOfFrets;
        this.openStringMidiNotes = openStringMidiNotes;
        if (!(this.openStringMidiNotes.length == this.numberOfStrings)) {
            boolean $i$a$-require-StandardFrettingEngine$22 = false;
            String $i$a$-require-StandardFrettingEngine$22 = "The number of strings does not equal the number of data in the open string MIDI notes.";
            throw new IllegalArgumentException($i$a$-require-StandardFrettingEngine$22.toString());
        }
        int[] $i$a$-require-StandardFrettingEngine$22 = nArray = new int[this.numberOfStrings];
        StandardFrettingEngine standardFrettingEngine = this;
        boolean bl = false;
        ArraysKt.fill$default((int[])$this$frets_u24lambda_u241, -1, 0, 0, 6, null);
        standardFrettingEngine.frets = nArray;
        this.runningAverage = new ArrayList();
    }

    public final int getNumberOfStrings() {
        return this.numberOfStrings;
    }

    public final int getNumberOfFrets() {
        return this.numberOfFrets;
    }

    @Override
    @NotNull
    public int[] getFrets() {
        return this.frets;
    }

    @Override
    @Nullable
    public FretboardPosition bestFretboardPosition(byte midiNote) {
        List<FretboardPosition> possiblePositions = this.allPossibleFretboardPositions(midiNote);
        Comparator<Object> comparator = Comparator.comparingDouble(arg_0 -> StandardFrettingEngine.bestFretboardPosition$lambda$2(new Function1<FretboardPosition, Double>(this){
            final /* synthetic */ StandardFrettingEngine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull FretboardPosition o) {
                Intrinsics.checkNotNullParameter(o, "o");
                return o.distance(StandardFrettingEngine.access$runningAveragePosition(this.this$0));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, "comparingDouble(...)");
        CollectionsKt.sortWith(possiblePositions, comparator);
        return CollectionsKt.firstOrNull(possiblePositions);
    }

    @Override
    public void applyFretboardPosition(@NotNull FretboardPosition position) {
        Intrinsics.checkNotNullParameter(position, "position");
        FretboardPosition $this$applyFretboardPosition_u24lambda_u243 = position;
        boolean bl = false;
        this.getFrets()[$this$applyFretboardPosition_u24lambda_u243.getString()] = $this$applyFretboardPosition_u24lambda_u243.getFret();
        this.runningAverage.add($this$applyFretboardPosition_u24lambda_u243);
        if (this.runningAverage.size() > 10) {
            this.runningAverage.remove(0);
        }
    }

    @Override
    public void releaseString(int string) {
        if (!(0 <= string ? string < this.numberOfStrings : false)) {
            boolean bl = false;
            String string2 = "Can't release a string that does not exist.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.getFrets()[string] = -1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FretboardPosition lowestFretboardPosition(byte midiNote, @NotNull List<Integer> occupiedStrings, boolean lowestByFret) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(occupiedStrings, "occupiedStrings");
        Iterable iterable = this.allPossibleFretboardPositions(midiNote);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FretboardPosition it = (FretboardPosition)element$iv$iv;
            boolean bl = false;
            if (!(!occupiedStrings.contains(it.getString()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                FretboardPosition it = (FretboardPosition)minElem$iv;
                boolean bl = false;
                int minValue$iv = lowestByFret ? it.getFret() : it.getString();
                do {
                    int v$iv;
                    Object e$iv = iterator$iv.next();
                    FretboardPosition it2 = (FretboardPosition)e$iv;
                    $i$a$-minByOrNull-StandardFrettingEngine$lowestFretboardPosition$2 = false;
                    int n = v$iv = lowestByFret ? it2.getFret() : it2.getString();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public static /* synthetic */ FretboardPosition lowestFretboardPosition$default(StandardFrettingEngine standardFrettingEngine, byte by, List list2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return standardFrettingEngine.lowestFretboardPosition(by, list2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FretboardPosition> allPossibleFretboardPositions(byte midiNote) {
        void $this$mapIndexedTo$iv$iv;
        int[] $this$mapIndexed$iv = this.openStringMidiNotes;
        boolean $i$f$mapIndexed = false;
        int[] nArray = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void openStringNote;
            int n = index$iv$iv++;
            void var11_11 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int fret = midiNote - openStringNote;
            collection.add(!(0 <= fret ? fret <= this.numberOfFrets : false) || this.getFrets()[index2] != -1 ? null : new FretboardPosition((int)index2, fret));
        }
        return CollectionsKt.toMutableList(CollectionsKt.filterNotNull((List)destination$iv$iv));
    }

    private final FretboardPosition runningAveragePosition() {
        FretboardPosition fretboardPosition;
        if (this.runningAverage.isEmpty()) {
            fretboardPosition = new FretboardPosition(0, 0);
        } else {
            int n;
            Iterator iterator2 = ((Iterable)this.runningAverage).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            FretboardPosition it22 = (FretboardPosition)iterator2.next();
            boolean bl = false;
            int it22 = it22.getString();
            while (iterator2.hasNext()) {
                FretboardPosition it32 = (FretboardPosition)iterator2.next();
                $i$a$-minOf-StandardFrettingEngine$runningAveragePosition$1 = false;
                int it32 = it32.getString();
                if (it22 <= it32) continue;
                it22 = it32;
            }
            Iterable iterable = this.runningAverage;
            int n2 = it22;
            iterator2 = iterable.iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            FretboardPosition it = (FretboardPosition)iterator2.next();
            boolean bl2 = false;
            int n3 = it.getFret();
            while (iterator2.hasNext()) {
                FretboardPosition it3 = (FretboardPosition)iterator2.next();
                $i$a$-minOf-StandardFrettingEngine$runningAveragePosition$2 = false;
                int n4 = it3.getFret();
                if (n3 <= n4) continue;
                n3 = n4;
            }
            int n5 = n = n3;
            int n6 = n2;
            fretboardPosition = new FretboardPosition(n6, n5);
        }
        return fretboardPosition;
    }

    private static final double bestFretboardPosition$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return ((Number)$tmp0.invoke(p0)).doubleValue();
    }

    public static final /* synthetic */ FretboardPosition access$runningAveragePosition(StandardFrettingEngine $this) {
        return $this.runningAveragePosition();
    }
}

