/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.family.guitar;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.midi.TimedArc;
import org.wysko.kmidi.midi.event.MidiEvent;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.SustainedInstrument;
import org.wysko.midis2jam2.instrument.algorithmic.PitchBendModulationController;
import org.wysko.midis2jam2.instrument.algorithmic.StringVibrationController;
import org.wysko.midis2jam2.instrument.family.guitar.FretboardPosition;
import org.wysko.midis2jam2.instrument.family.guitar.FrettedInstrumentPositioning;
import org.wysko.midis2jam2.instrument.family.guitar.FrettingEngine;
import org.wysko.midis2jam2.instrument.family.guitar.StandardFrettingEngine;
import org.wysko.midis2jam2.util.JmeDslKt;
import org.wysko.midis2jam2.util.Utils;
import org.wysko.midis2jam2.util.UtilsKt;
import org.wysko.midis2jam2.world.AssetLoaderKt;
import org.wysko.midis2jam2.world.GlowControllerKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b'\u0018\u00002\u00020\u0001BI\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\u0010\u0011J2\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\f2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020'H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b9\u0010:J\u0017\u0010;\u001a\u0004\u0018\u00010\f2\u0006\u00104\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010<J\u0018\u0010=\u001a\u00020'2\u0006\u00105\u001a\u00020\f2\u0006\u00108\u001a\u00020'H\u0002J\"\u0010>\u001a\u0002032\u0006\u0010?\u001a\u0002072\u0006\u00106\u001a\u000207H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b@\u0010AJ\b\u0010B\u001a\u00020\u0010H\u0016R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00050\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001f0\u001eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b*\u0010\u001aR\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0.X\u0094\u0004\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b/\u00100\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006C"}, d2={"Lorg/wysko/midis2jam2/instrument/family/guitar/FrettedInstrument;", "Lorg/wysko/midis2jam2/instrument/SustainedInstrument;", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "events", "", "Lorg/wysko/kmidi/midi/event/MidiEvent;", "frettingEngine", "Lorg/wysko/midis2jam2/instrument/family/guitar/FrettingEngine;", "positioning", "Lorg/wysko/midis2jam2/instrument/family/guitar/FrettedInstrumentPositioning;", "numberOfStrings", "", "instrumentBody", "Lkotlin/Pair;", "Lcom/jme3/scene/Spatial;", "", "(Lorg/wysko/midis2jam2/Midis2jam2;Ljava/util/List;Lorg/wysko/midis2jam2/instrument/family/guitar/FrettingEngine;Lorg/wysko/midis2jam2/instrument/family/guitar/FrettedInstrumentPositioning;ILkotlin/Pair;)V", "animatedStartedMap", "", "Lorg/wysko/kmidi/midi/TimedArc;", "", "getFrettingEngine", "()Lorg/wysko/midis2jam2/instrument/family/guitar/FrettingEngine;", "lowerStrings", "getLowerStrings", "()Ljava/util/List;", "noteFingers", "getNoteFingers", "notePeriodFretboardPosition", "", "Lorg/wysko/midis2jam2/instrument/family/guitar/FretboardPosition;", "getNotePeriodFretboardPosition", "()Ljava/util/Map;", "pitchBendModulationController", "Lorg/wysko/midis2jam2/instrument/algorithmic/PitchBendModulationController;", "getPositioning", "()Lorg/wysko/midis2jam2/instrument/family/guitar/FrettedInstrumentPositioning;", "stringHeight", "", "stringVibrators", "Lorg/wysko/midis2jam2/instrument/algorithmic/StringVibrationController;", "getStringVibrators", "stringVibrators$delegate", "Lkotlin/Lazy;", "upperStrings", "", "getUpperStrings", "()[Lcom/jme3/scene/Spatial;", "[Lcom/jme3/scene/Spatial;", "animateString", "", "string", "fret", "delta", "Lkotlin/time/Duration;", "pitchBendAmount", "animateString-exY8QGI", "(IIJF)V", "fretPressedOnString", "(I)Ljava/lang/Integer;", "fretToDistance", "tick", "time", "tick-QTBD994", "(JJ)V", "toString", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFrettedInstrument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrettedInstrument.kt\norg/wysko/midis2jam2/instrument/family/guitar/FrettedInstrument\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n2634#2:270\n1855#2,2:272\n800#2,11:274\n1855#2:285\n1856#2:287\n1271#2,2:288\n1285#2,4:290\n288#2,2:294\n1855#2,2:296\n1855#2,2:298\n1747#2,3:300\n1#3:271\n1#3:286\n*S KotlinDebug\n*F\n+ 1 FrettedInstrument.kt\norg/wysko/midis2jam2/instrument/family/guitar/FrettedInstrument\n*L\n85#1:270\n94#1:272,2\n101#1:274,11\n101#1:285\n101#1:287\n131#1:288,2\n131#1:290,4\n155#1:294,2\n205#1:296,2\n220#1:298,2\n252#1:300,3\n85#1:271\n*E\n"})
public abstract class FrettedInstrument
extends SustainedInstrument {
    @NotNull
    private final FrettingEngine frettingEngine;
    @NotNull
    private final FrettedInstrumentPositioning positioning;
    private final int numberOfStrings;
    @NotNull
    private final List<List<Spatial>> lowerStrings;
    @NotNull
    private final Spatial[] upperStrings;
    @NotNull
    private final List<Spatial> noteFingers;
    @NotNull
    private final Map<TimedArc, FretboardPosition> notePeriodFretboardPosition;
    @NotNull
    private final PitchBendModulationController pitchBendModulationController;
    private final float stringHeight;
    @NotNull
    private final Lazy stringVibrators$delegate;
    @NotNull
    private final Map<TimedArc, Boolean> animatedStartedMap;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    protected FrettedInstrument(@NotNull Midis2jam2 context2, @NotNull List<? extends MidiEvent> events, @NotNull FrettingEngine frettingEngine, @NotNull FrettedInstrumentPositioning positioning, int numberOfStrings, @NotNull Pair<? extends Spatial, String> instrumentBody) {
        void $this$associateWith$iv;
        void $this$forEach$iv;
        Iterator $this$filterIsInstanceTo$iv$iv;
        Object it;
        void $this$notePeriodFretboardPosition_u24lambda_u248;
        Iterable $this$onEach$iv;
        void var9_15;
        Object object;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(events, "events");
        Intrinsics.checkNotNullParameter(frettingEngine, "frettingEngine");
        Intrinsics.checkNotNullParameter(positioning, "positioning");
        Intrinsics.checkNotNullParameter(instrumentBody, "instrumentBody");
        super(context2, events);
        this.frettingEngine = frettingEngine;
        this.positioning = positioning;
        this.numberOfStrings = numberOfStrings;
        this.lowerStrings = CollectionsKt.emptyList();
        this.upperStrings = new Spatial[0];
        int n = this.numberOfStrings;
        FrettedInstrument frettedInstrument = this;
        ArrayList<Spatial> arrayList = new ArrayList<Spatial>(n);
        int n2 = 0;
        while (n2 < n) {
            Spatial spatial;
            int n3;
            int n4 = n3 = n2++;
            object = arrayList;
            boolean bl = false;
            Spatial $this$noteFingers_u24lambda_u241_u24lambda_u240 = spatial = AssetLoaderKt.modelD(context2, "GuitarNoteFinger.obj", instrumentBody.getSecond());
            boolean bl2 = false;
            $this$noteFingers_u24lambda_u241_u24lambda_u240.setCullHint(UtilsKt.getCh(false));
            Intrinsics.checkNotNull($this$noteFingers_u24lambda_u241_u24lambda_u240, "null cannot be cast to non-null type com.jme3.scene.Geometry");
            ((Geometry)$this$noteFingers_u24lambda_u241_u24lambda_u240).getMaterial().setColor("GlowColor", GlowControllerKt.getSTRING_GLOW());
            ((ArrayList)object).add(spatial);
        }
        Iterable iterable = arrayList;
        boolean $i$f$onEach22 = false;
        void $this$onEach_u24lambda_u2416$iv = var9_15 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            Spatial it2 = (Spatial)element$iv;
            boolean bl3 = false;
            JmeDslKt.plusAssign(this.getGeometry(), it2);
        }
        frettedInstrument.noteFingers = (List)var9_15;
        FrettedInstrument $i$f$onEach22 = this;
        frettedInstrument = this;
        boolean bl4 = false;
        Map fretboardPositions = new LinkedHashMap();
        Map<NoteEvent, TimedArc> $this$notePeriodFretboardPosition_u24lambda_u248_u24lambda_u244 = bl = MapsKt.createMapBuilder();
        boolean bl5 = false;
        Iterable $this$forEach$iv2 = $this$notePeriodFretboardPosition_u24lambda_u248.getTimedArcs();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (TimedArc)element$iv;
            boolean bl6 = false;
            $this$notePeriodFretboardPosition_u24lambda_u248_u24lambda_u244.put(((TimedArc)it).getNoteOff(), (TimedArc)it);
            $this$notePeriodFretboardPosition_u24lambda_u248_u24lambda_u244.put(((TimedArc)it).getNoteOn(), (TimedArc)it);
        }
        Map periodByNoteEvent = MapsKt.build(bl);
        Set occupiedStrings = new LinkedHashSet();
        Map stringByNoteEvent = new LinkedHashMap();
        Iterable $this$filterIsInstance$iv = events;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$forEach22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        it = $this$filterIsInstanceTo$iv$iv.iterator();
        while (it.hasNext()) {
            Object element$iv$iv = it.next();
            if (!(element$iv$iv instanceof NoteEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            NoteEvent noteEvent = (NoteEvent)element$iv;
            boolean bl7 = false;
            NoteEvent noteEvent2 = noteEvent;
            if (noteEvent2 instanceof NoteEvent.NoteOn) {
                if ($this$notePeriodFretboardPosition_u24lambda_u248.frettingEngine.bestFretboardPosition(noteEvent.getNote()) != null) {
                    FretboardPosition it3;
                    boolean bl8 = false;
                    ((Collection)occupiedStrings).add(it3.getString());
                    Map map2 = fretboardPositions;
                    TimedArc timedArc = (TimedArc)periodByNoteEvent.get(noteEvent);
                    if (timedArc == null) continue;
                    map2.put(timedArc, it3);
                    stringByNoteEvent.put(noteEvent.getNote(), it3.getString());
                    $this$notePeriodFretboardPosition_u24lambda_u248.frettingEngine.applyFretboardPosition(it3);
                }
                continue;
            }
            if (!(noteEvent2 instanceof NoteEvent.NoteOff)) continue;
            Integer n5 = (Integer)stringByNoteEvent.remove(noteEvent.getNote());
            if (n5 == null) continue;
            int it4 = ((Number)n5).intValue();
            boolean bl9 = false;
            $this$notePeriodFretboardPosition_u24lambda_u248.frettingEngine.releaseString(it4);
        }
        frettedInstrument.notePeriodFretboardPosition = fretboardPositions;
        this.pitchBendModulationController = new PitchBendModulationController(context2, events, 0.0);
        this.stringHeight = this.positioning.getUpperY() - this.positioning.getLowerY();
        this.stringVibrators$delegate = LazyKt.lazy((Function0)new Function0<List<? extends StringVibrationController>>(this){
            final /* synthetic */ FrettedInstrument this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<StringVibrationController> invoke() {
                int n = FrettedInstrument.access$getNumberOfStrings$p(this.this$0);
                FrettedInstrument frettedInstrument = this.this$0;
                ArrayList<StringVibrationController> arrayList = new ArrayList<StringVibrationController>(n);
                int n2 = 0;
                while (n2 < n) {
                    void it;
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<StringVibrationController> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(new StringVibrationController((Collection<? extends Spatial>)frettedInstrument.getLowerStrings().get((int)it)));
                }
                return arrayList;
            }
        });
        $this$onEach$iv = this.getTimedArcs();
        frettedInstrument = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            TimedArc $i$f$forEach3 = (TimedArc)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl10 = false;
            Boolean bl11 = false;
            object.put(t, bl11);
        }
        frettedInstrument.animatedStartedMap = MapsKt.toMutableMap(result$iv);
        JmeDslKt.plusAssign(this.getGeometry(), instrumentBody.getFirst());
    }

    @NotNull
    protected final FrettingEngine getFrettingEngine() {
        return this.frettingEngine;
    }

    @NotNull
    protected final FrettedInstrumentPositioning getPositioning() {
        return this.positioning;
    }

    @NotNull
    protected List<List<Spatial>> getLowerStrings() {
        return this.lowerStrings;
    }

    @NotNull
    protected Spatial[] getUpperStrings() {
        return this.upperStrings;
    }

    @NotNull
    protected final List<Spatial> getNoteFingers() {
        return this.noteFingers;
    }

    @NotNull
    protected Map<TimedArc, FretboardPosition> getNotePeriodFretboardPosition() {
        return this.notePeriodFretboardPosition;
    }

    private final List<StringVibrationController> getStringVibrators() {
        Lazy lazy = this.stringVibrators$delegate;
        return (List)lazy.getValue();
    }

    @Override
    public void tick-QTBD994(long time, long delta) {
        super.tick-QTBD994(time, delta);
        int n = this.numberOfStrings;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            Integer n2 = this.fretPressedOnString(it);
            this.animateString-exY8QGI(it, n2 != null ? n2 : -1, delta, PitchBendModulationController.tick-ePrTys8$default(this.pitchBendModulationController, time, delta, false, false, new Function0<Boolean>(this.getCollector().getCurrentTimedArcs()){

                @NotNull
                public final Boolean invoke() {
                    return !((Collection)this.receiver).isEmpty();
                }
            }, 12, null));
        }
    }

    private final Integer fretPressedOnString(int string) {
        Object v2;
        block4: {
            Iterable $this$firstOrNull$iv = this.getCollector().getCurrentTimedArcs();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TimedArc it = (TimedArc)element$iv;
                boolean bl = false;
                FretboardPosition fretboardPosition = this.getNotePeriodFretboardPosition().get(it);
                boolean bl2 = fretboardPosition != null ? fretboardPosition.getString() == string : false;
                if (!bl2) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        TimedArc np = v2;
        if (np != null) {
            Integer n;
            TimedArc it = np;
            boolean bl = false;
            Boolean bl3 = this.animatedStartedMap.get(it);
            Intrinsics.checkNotNull(bl3);
            if (!bl3.booleanValue()) {
                this.animatedStartedMap.put(it, true);
                n = null;
            } else {
                FretboardPosition fretboardPosition = this.getNotePeriodFretboardPosition().get(np);
                n = fretboardPosition != null ? Integer.valueOf(fretboardPosition.getFret()) : null;
            }
            return n;
        }
        return null;
    }

    private final float fretToDistance(int fret, float pitchBendAmount) {
        FrettingEngine frettingEngine = this.frettingEngine;
        Intrinsics.checkNotNull(frettingEngine, "null cannot be cast to non-null type org.wysko.midis2jam2.instrument.family.guitar.StandardFrettingEngine");
        StandardFrettingEngine engine = (StandardFrettingEngine)frettingEngine;
        int semitoneOffset = pitchBendAmount > 0.0f ? (int)Math.floor(pitchBendAmount) : (int)Math.ceil(pitchBendAmount);
        float semitoneFraction = pitchBendAmount % 1.0f;
        int adjFret = RangesKt.coerceIn(fret + semitoneOffset, new IntRange(0, engine.getNumberOfFrets()));
        return semitoneFraction > 0.0f ? Utils.INSTANCE.lerp(this.positioning.getFretHeights().calculateScale(adjFret), this.positioning.getFretHeights().calculateScale(RangesKt.coerceAtMost(adjFret + 1, engine.getNumberOfFrets())), semitoneFraction) : Utils.INSTANCE.lerp(this.positioning.getFretHeights().calculateScale(adjFret), this.positioning.getFretHeights().calculateScale(RangesKt.coerceAtLeast(adjFret - 1, 0)), -semitoneFraction);
    }

    private final void animateString-exY8QGI(int string, int fret, long delta, float pitchBendAmount) {
        Vector3f $i$f$forEach2;
        if (fret == -1) {
            this.getUpperStrings()[string].setLocalScale(this.positioning.getRestingStrings()[string]);
            Iterable $this$forEach$iv = this.getLowerStrings().get(string);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Spatial it = (Spatial)element$iv;
                boolean bl = false;
                it.setCullHint(Spatial.CullHint.Always);
            }
            this.noteFingers.get(string).setCullHint(Spatial.CullHint.Always);
            return;
        }
        float fretDistance = this.fretToDistance(fret, pitchBendAmount);
        Vector3f vector3f = $i$f$forEach2 = new Vector3f(this.positioning.getRestingStrings()[string]);
        Spatial spatial = this.getUpperStrings()[string];
        boolean bl = false;
        $this$animateString_exY8QGI_u24lambda_u2414.y = fretDistance;
        spatial.setLocalScale($i$f$forEach2);
        this.getStringVibrators().get(string).tick-LRDsOJo(delta);
        Iterable $this$forEach$iv = this.getLowerStrings().get(string);
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            Spatial it = (Spatial)element$iv;
            boolean bl2 = false;
            it.setLocalScale(new Vector3f(this.positioning.getRestingStrings()[string]).setY(1.0f - fretDistance));
        }
        Spatial it = this.noteFingers.get(string);
        boolean bl3 = false;
        if (fret != 0 || !(pitchBendAmount == 0.0f)) {
            it.setCullHint(UtilsKt.getCh(true));
            FrettedInstrumentPositioning $this$animateString_exY8QGI_u24lambda_u2417_u24lambda_u2416 = this.positioning;
            boolean bl4 = false;
            it.setLocalTranslation(JmeDslKt.v3(Float.valueOf(($this$animateString_exY8QGI_u24lambda_u2417_u24lambda_u2416.getLowerX()[string] - $this$animateString_exY8QGI_u24lambda_u2417_u24lambda_u2416.getUpperX()[string]) * fretDistance + $this$animateString_exY8QGI_u24lambda_u2417_u24lambda_u2416.getUpperX()[string]), Float.valueOf($this$animateString_exY8QGI_u24lambda_u2417_u24lambda_u2416.getFingerVerticalOffset().y - this.stringHeight * fretDistance), $this$animateString_exY8QGI_u24lambda_u2417_u24lambda_u2416 instanceof FrettedInstrumentPositioning.FrettedInstrumentPositioningWithZ ? (Number)((double)((((FrettedInstrumentPositioning.FrettedInstrumentPositioningWithZ)$this$animateString_exY8QGI_u24lambda_u2417_u24lambda_u2416).getTopZ()[string] - ((FrettedInstrumentPositioning.FrettedInstrumentPositioningWithZ)$this$animateString_exY8QGI_u24lambda_u2417_u24lambda_u2416).getBottomZ()[string]) * fretDistance + ((FrettedInstrumentPositioning.FrettedInstrumentPositioningWithZ)$this$animateString_exY8QGI_u24lambda_u2417_u24lambda_u2416).getTopZ()[string]) * -1.3 - (double)2) : (Number)0));
        } else {
            it.setCullHint(UtilsKt.getCh(false));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toString() {
        void $this$toString_u24lambda_u2420;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        String string = "FRETBOARD";
        FrettedInstrument frettedInstrument = this;
        String string2 = super.toString();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue($this$toString_u24lambda_u2420.append('\n'), "append(...)");
        FrettingEngine frettingEngine = this.frettingEngine;
        Intrinsics.checkNotNull(frettingEngine, "null cannot be cast to non-null type org.wysko.midis2jam2.instrument.family.guitar.StandardFrettingEngine");
        StandardFrettingEngine cfr_ignored_0 = (StandardFrettingEngine)frettingEngine;
        for (int x2 = this.numberOfStrings - 1; -1 < x2; --x2) {
            int n = ((StandardFrettingEngine)this.frettingEngine).getNumberOfFrets();
            for (int y2 = 0; y2 < n; ++y2) {
                boolean bl2;
                void var8_11;
                block7: {
                    void $this$any$iv;
                    Iterable iterable = this.getCollector().getCurrentTimedArcs();
                    var8_11 = $this$toString_u24lambda_u2420;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl3;
                            TimedArc it = (TimedArc)element$iv;
                            boolean bl4 = false;
                            if (this.getNotePeriodFretboardPosition().get(it) != null) {
                                FretboardPosition it2;
                                boolean bl5 = false;
                                bl3 = it2.getString() == x2 && it2.getFret() == y2;
                            } else {
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                }
                boolean bl6 = bl2;
                var8_11.append(bl6 ? "x" : "-");
            }
            Intrinsics.checkNotNullExpressionValue($this$toString_u24lambda_u2420.append('\n'), "append(...)");
        }
        Unit unit = Unit.INSTANCE;
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string2 + frettedInstrument.formatProperty(string, string3);
    }

    public static final /* synthetic */ int access$getNumberOfStrings$p(FrettedInstrument $this) {
        return $this.numberOfStrings;
    }
}

