/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.family.guitar;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.kmidi.midi.TimedArc;
import org.wysko.kmidi.midi.event.MidiEvent;
import org.wysko.kmidi.midi.event.VirtualCompositePitchBendEvent;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.datastructure.RunningAverage;
import org.wysko.midis2jam2.instrument.family.guitar.BetterFretting;
import org.wysko.midis2jam2.instrument.family.guitar.ChordDefinition;
import org.wysko.midis2jam2.instrument.family.guitar.FretboardPosition;
import org.wysko.midis2jam2.midi.NotePeriodKt;
import org.wysko.midis2jam2.midi.TimedArcGroup;
import org.wysko.midis2jam2.util.UtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001:\u00011B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ8\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\n2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0010\b\u0002\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0002J\"\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005H\u0002J&\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0002J \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\nJ\u0016\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\nH\u0002J0\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\"\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u000e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020%0\nH\u0002J\u0016\u0010*\u001a\u00020\u00062\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J(\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u0010H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b/\u00100R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00062"}, d2={"Lorg/wysko/midis2jam2/instrument/family/guitar/BetterFretting;", "", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "chordDictionary", "", "Lorg/wysko/midis2jam2/instrument/family/guitar/ChordDefinition;", "openStringNoteValues", "", "events", "", "Lorg/wysko/kmidi/midi/event/MidiEvent;", "(Lorg/wysko/midis2jam2/Midis2jam2;Ljava/util/Set;[ILjava/util/List;)V", "absolutePitchBendEventsWithTime", "", "Lorg/wysko/kmidi/midi/event/VirtualCompositePitchBendEvent;", "Lkotlin/time/Duration;", "allPossibleFretboardPositions", "Lorg/wysko/midis2jam2/instrument/family/guitar/FretboardPosition;", "midiNote", "", "occupiedStrings", "", "pitchBendExtremes", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "buildChord", "Lorg/wysko/kmidi/midi/TimedArc;", "notePeriods", "buildDuet", "Lkotlin/Pair;", "arc1", "arc2", "calculate", "calculateChords", "Lorg/wysko/midis2jam2/instrument/family/guitar/BetterFretting$ChordCalculationResult;", "groups", "Lorg/wysko/midis2jam2/midi/TimedArcGroup;", "calculateIntervals", "chordDefinitionsUsed", "calculateMonophonic", "list", "evaluateChords", "chords", "findPitchBendExtremesDuringRange", "start", "end", "findPitchBendExtremesDuringRange-QTBD994", "(JJ)Lkotlin/ranges/ClosedFloatingPointRange;", "ChordCalculationResult", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBetterFretting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BetterFretting.kt\norg/wysko/midis2jam2/instrument/family/guitar/BetterFretting\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,310:1\n1045#2:311\n2624#2,3:312\n1271#2,2:315\n1285#2,4:317\n1360#2:321\n1446#2,5:322\n1271#2,2:327\n1285#2,2:329\n1549#2:331\n1620#2,3:332\n1549#2:335\n1620#2,3:336\n1288#2:339\n1549#2:340\n1620#2,2:341\n1549#2:343\n1620#2,3:344\n1622#2:347\n2310#2,5:348\n2316#2,8:354\n2310#2,14:362\n1940#2,14:376\n1549#2:390\n1620#2,3:391\n2310#2,14:394\n1940#2,14:408\n1549#2:422\n1620#2,3:423\n766#2:426\n857#2,2:427\n766#2:429\n857#2,2:430\n766#2:432\n857#2,2:433\n1940#2,14:435\n1045#2:449\n766#2:450\n857#2,2:451\n1549#2:453\n1620#2,3:454\n2333#2,14:457\n1271#2,2:471\n1285#2,4:473\n2333#2,14:477\n1549#2:491\n1620#2,3:492\n1045#2:495\n1271#2,2:496\n1285#2,4:498\n766#2:507\n857#2,2:508\n766#2:510\n857#2,2:511\n1045#2:513\n378#2,7:514\n1045#2:521\n350#2,7:522\n1045#2:529\n1549#2:530\n1620#2,3:531\n1#3:353\n11185#4:502\n11305#4,4:503\n*S KotlinDebug\n*F\n+ 1 BetterFretting.kt\norg/wysko/midis2jam2/instrument/family/guitar/BetterFretting\n*L\n36#1:311\n36#1:312,3\n43#1:315,2\n43#1:317,4\n67#1:321\n67#1:322,5\n88#1:327,2\n88#1:329,2\n89#1:331\n89#1:332,3\n90#1:335\n90#1:336,3\n88#1:339\n97#1:340\n97#1:341,2\n98#1:343\n98#1:344,3\n97#1:347\n102#1:348,5\n102#1:354,8\n104#1:362,14\n105#1:376,14\n111#1:390\n111#1:391,3\n125#1:394,14\n128#1:408,14\n157#1:422\n157#1:423,3\n160#1:426\n160#1:427,2\n167#1:429\n167#1:430,2\n174#1:432\n174#1:433,2\n176#1:435,14\n190#1:449\n193#1:450\n193#1:451,2\n193#1:453\n193#1:454,3\n195#1:457,14\n204#1:471,2\n204#1:473,4\n225#1:477,14\n234#1:491\n234#1:492,3\n234#1:495\n255#1:496,2\n255#1:498,4\n281#1:507\n281#1:508,2\n282#1:510\n282#1:511,2\n297#1:513\n297#1:514,7\n300#1:521\n300#1:522,7\n305#1:529\n307#1:530\n307#1:531,3\n269#1:502\n269#1:503,4\n*E\n"})
public final class BetterFretting {
    @NotNull
    private final Midis2jam2 context;
    @NotNull
    private final Set<ChordDefinition> chordDictionary;
    @NotNull
    private final int[] openStringNoteValues;
    @NotNull
    private final List<MidiEvent> events;
    @NotNull
    private final Map<VirtualCompositePitchBendEvent, Duration> absolutePitchBendEventsWithTime;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public BetterFretting(@NotNull Midis2jam2 context2, @NotNull Set<ChordDefinition> chordDictionary, @NotNull int[] openStringNoteValues, @NotNull List<? extends MidiEvent> events) {
        void $this$associateWith$iv;
        VirtualCompositePitchBendEvent it;
        Object object;
        void absolutePitchBendEvents;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(chordDictionary, "chordDictionary");
        Intrinsics.checkNotNullParameter(openStringNoteValues, "openStringNoteValues");
        Intrinsics.checkNotNullParameter(events, "events");
        this.context = context2;
        this.chordDictionary = chordDictionary;
        this.openStringNoteValues = openStringNoteValues;
        this.events = events;
        List<VirtualCompositePitchBendEvent> list2 = VirtualCompositePitchBendEvent.Companion.fromEvents(this.events);
        BetterFretting betterFretting = this;
        boolean bl = false;
        if (absolutePitchBendEvents.isEmpty()) {
            object = CollectionsKt.listOf(new VirtualCompositePitchBendEvent(0, 0.0));
        } else {
            boolean bl2;
            block6: {
                Iterable $this$sortedBy$iv = (Iterable)absolutePitchBendEvents;
                boolean $i$f$sortedBy = false;
                Iterable $this$none$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        VirtualCompositePitchBendEvent it = (VirtualCompositePitchBendEvent)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getTick());
                        it = (VirtualCompositePitchBendEvent)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getTick());
                    }
                });
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (VirtualCompositePitchBendEvent)element$iv;
                        boolean bl3 = false;
                        if (!(it.getTick() == 0)) continue;
                        bl2 = false;
                        break block6;
                    }
                    bl2 = true;
                }
            }
            object = bl2 ? CollectionsKt.plus((Collection)CollectionsKt.listOf(new VirtualCompositePitchBendEvent(0, 0.0)), (Iterable)absolutePitchBendEvents) : absolutePitchBendEvents;
        }
        Iterable iterable = object;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (VirtualCompositePitchBendEvent)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl4 = false;
            Duration duration = Duration.box-impl(this.context.getSequence().getTimeAtTick-5sfh64U(it.getTick()));
            map2.put(t, duration);
        }
        betterFretting.absolutePitchBendEventsWithTime = result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<TimedArc, FretboardPosition> calculate(@NotNull List<TimedArc> notePeriods) {
        Intrinsics.checkNotNullParameter(notePeriods, "notePeriods");
        Map map2 = new LinkedHashMap();
        List<TimedArcGroup> groups2 = NotePeriodKt.improvedContiguousGroupDetection(notePeriods);
        List groupsChunkedByPolyphony2 = SequencesKt.toList(UtilsKt.chunked(CollectionsKt.asSequence((Iterable)groups2), calculate.groupsChunkedByPolyphony.1.INSTANCE));
        List chordCalculationResults = new ArrayList();
        for (List<TimedArcGroup> list2 : groupsChunkedByPolyphony2) {
            int size2 = ((TimedArcGroup)CollectionsKt.first(list2)).getArcs().size();
            boolean bl = false;
            switch (size2) {
                case 1: {
                    map2.putAll(this.calculateMonophonic(list2));
                    break;
                }
                case 2: {
                    void $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    Iterable iterable = chordCalculationResults;
                    List<TimedArcGroup> list22 = list2;
                    BetterFretting betterFretting = this;
                    Map map3 = map2;
                    boolean $i$f$flatMap = false;
                    void var15_15 = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        ChordCalculationResult it = (ChordCalculationResult)element$iv$iv;
                        boolean bl2 = false;
                        Iterable list$iv$iv = it.getChordDefinitionsUsed();
                        CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                    }
                    List list3 = (List)destination$iv$iv;
                    map3.putAll(betterFretting.calculateIntervals(list22, CollectionsKt.toSet(list3)));
                    break;
                }
                default: {
                    ChordCalculationResult chordCalculationResult = this.calculateChords(list2);
                    map2.putAll(chordCalculationResult.getFretboardPositions());
                    ((Collection)chordCalculationResults).add(chordCalculationResult);
                }
            }
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<TimedArc, FretboardPosition> calculateIntervals(List<TimedArcGroup> groups2, Set<ChordDefinition> chordDefinitionsUsed) {
        void $this$mapTo$iv$iv;
        List<Object> list2;
        Iterable $this$map$iv;
        List<Object> $this$calculateIntervals_u24lambda_u249_u24lambda_u2482;
        Object object;
        Iterable $this$map$iv2;
        Object object2;
        Map map2 = new LinkedHashMap();
        Iterable $this$associateWith$iv = groups2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$mapTo$iv$iv3;
            TimedArcGroup timedArcGroup = (TimedArcGroup)element$iv$iv;
            Object t = element$iv$iv;
            object2 = result$iv;
            boolean bl = false;
            Set<TimedArc> notePeriods = timedArcGroup.component1();
            $this$map$iv2 = notePeriods;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                TimedArc timedArc = (TimedArc)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(it.getNote());
            }
            $this$calculateIntervals_u24lambda_u249_u24lambda_u2482 = CollectionsKt.sorted((List)destination$iv$iv);
            boolean bl3 = false;
            $this$map$iv = $this$calculateIntervals_u24lambda_u249_u24lambda_u2482;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                byte by = ((Number)item$iv$iv).byteValue();
                Object object3 = destination$iv$iv2;
                boolean bl4 = false;
                object3.add((int)(it - ((Number)CollectionsKt.minOrThrow((Iterable)$this$calculateIntervals_u24lambda_u249_u24lambda_u2482)).intValue()));
            }
            list2 = (List)destination$iv$iv2;
            object2.put(t, list2);
        }
        Map shapes = result$iv;
        Iterable $this$map$iv3 = SequencesKt.toList(UtilsKt.chunked(MapsKt.asSequence(shapes), calculateIntervals.groupsChunkedByShape.1.INSTANCE));
        boolean $i$f$map = false;
        $this$associateWithTo$iv$iv = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv4;
            void entries2;
            List bl = (List)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl5 = false;
            $this$map$iv2 = (Iterable)entries2;
            $this$calculateIntervals_u24lambda_u249_u24lambda_u2482 = ((Map.Entry)CollectionsKt.first(entries2)).getValue();
            boolean $i$f$map3 = false;
            $this$map$iv = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                void it;
                object = (Map.Entry)item$iv$iv2;
                Collection bl2 = destination$iv$iv3;
                boolean bl6 = false;
                bl2.add((TimedArcGroup)it.getKey());
            }
            object2.add(TuplesKt.to($this$calculateIntervals_u24lambda_u249_u24lambda_u2482, (List)destination$iv$iv3));
        }
        List groupsChunkedByShape2 = (List)destination$iv$iv;
        for (Pair chunk : groupsChunkedByShape2) {
            Object t;
            void $this$maxBy$iv;
            Object t2;
            Iterable $this$minBy$iv;
            Object t3;
            Iterable $this$minBy$iv2 = (Iterable)chunk.getSecond();
            boolean $i$f$minByOrThrow22 = false;
            Iterator iterator$iv = $this$minBy$iv2.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t3 = minElem$iv;
            } else {
                TimedArcGroup entries2 = (TimedArcGroup)minElem$iv;
                boolean bl = false;
                Set<TimedArc> notePeriods2 = entries2.component1();
                Iterator $this$calculateIntervals_u24lambda_u249_u24lambda_u2482 = ((Iterable)notePeriods2).iterator();
                if (!$this$calculateIntervals_u24lambda_u249_u24lambda_u2482.hasNext()) {
                    throw new NoSuchElementException();
                }
                TimedArc it22 = (TimedArc)$this$calculateIntervals_u24lambda_u249_u24lambda_u2482.next();
                boolean bl7 = false;
                byte it22 = it22.getNote();
                while ($this$calculateIntervals_u24lambda_u249_u24lambda_u2482.hasNext()) {
                    TimedArc it32 = (TimedArc)$this$calculateIntervals_u24lambda_u249_u24lambda_u2482.next();
                    $i$a$-minOf-BetterFretting$calculateIntervals$groupWithLowestOverallNote$1$1 = false;
                    byte it32 = it32.getNote();
                    if (it22 <= it32) continue;
                    it22 = it32;
                }
                byte minValue$iv = it22;
                do {
                    Object e$iv = iterator$iv.next();
                    TimedArcGroup notePeriods2 = (TimedArcGroup)e$iv;
                    $i$a$-minByOrThrow-BetterFretting$calculateIntervals$groupWithLowestOverallNote$1 = false;
                    Set<TimedArc> notePeriods3 = notePeriods2.component1();
                    Iterator it32 = ((Iterable)notePeriods3).iterator();
                    if (!it32.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    TimedArc it42 = (TimedArc)it32.next();
                    $i$a$-minOf-BetterFretting$calculateIntervals$groupWithLowestOverallNote$1$1 = false;
                    byte it42 = it42.getNote();
                    while (it32.hasNext()) {
                        TimedArc it52 = (TimedArc)it32.next();
                        $i$a$-minOf-BetterFretting$calculateIntervals$groupWithLowestOverallNote$1$1 = false;
                        byte it52 = it52.getNote();
                        if (it42 <= it52) continue;
                        it42 = it52;
                    }
                    byte v$iv = it42;
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t3 = minElem$iv;
            }
            TimedArcGroup groupWithLowestOverallNote = (TimedArcGroup)t3;
            Iterable $i$f$minByOrThrow22 = groupWithLowestOverallNote.getArcs();
            BetterFretting betterFretting = this;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv2 = $this$minBy$iv.iterator();
            if (!iterator$iv2.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv2 = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                t2 = minElem$iv2;
            } else {
                TimedArc it = (TimedArc)minElem$iv2;
                boolean bl = false;
                byte minValue$iv = it.getNote();
                do {
                    Object e$iv = iterator$iv2.next();
                    TimedArc it2 = (TimedArc)e$iv;
                    $i$a$-minByOrThrow-BetterFretting$calculateIntervals$lowestGroupPosition$1 = false;
                    byte v$iv = it2.getNote();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv2 = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                t2 = minElem$iv2;
            }
            $this$minBy$iv = groupWithLowestOverallNote.getArcs();
            TimedArc timedArc = (TimedArc)t2;
            boolean $i$f$maxByOrThrow = false;
            iterator$iv2 = $this$maxBy$iv.iterator();
            if (!iterator$iv2.hasNext()) {
                throw new NoSuchElementException();
            }
            Object maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                t = maxElem$iv;
            } else {
                TimedArc it = (TimedArc)maxElem$iv;
                boolean bl = false;
                byte maxValue$iv = it.getNote();
                do {
                    Object e$iv2 = iterator$iv2.next();
                    TimedArc it3 = (TimedArc)e$iv2;
                    t6 = false;
                    byte v$iv = it3.getNote();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv2;
                    maxValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                t = maxElem$iv;
            }
            list2 = t;
            Pair<FretboardPosition, FretboardPosition> lowestGroupPosition = betterFretting.buildDuet(timedArc, (TimedArc)((Object)list2));
            Iterator iterator2 = ((List)chunk.getSecond()).iterator();
            while (iterator2.hasNext()) {
                Object t4;
                Object e$iv;
                Object t5;
                Object v3;
                Object object4;
                Set<TimedArc> notePeriods;
                block39: {
                    notePeriods = ((TimedArcGroup)iterator2.next()).component1();
                    Iterable e$iv2 = chordDefinitionsUsed;
                    for (Object t6 : e$iv2) {
                        void $this$mapTo$iv$iv5;
                        void $this$map$iv4;
                        ChordDefinition definition = (ChordDefinition)t6;
                        boolean bl = false;
                        Iterable it52 = notePeriods;
                        object4 = definition.getDefinedNotes();
                        boolean $i$f$map4 = false;
                        void it = $this$map$iv4;
                        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv4, 10));
                        boolean $i$f$mapTo4 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
                            void it4;
                            TimedArc bl4 = (TimedArc)item$iv$iv;
                            Collection collection = destination$iv$iv4;
                            boolean bl8 = false;
                            collection.add(it4.getNote());
                        }
                        if (!object4.containsAll((List)destination$iv$iv4)) continue;
                        v3 = t6;
                        break block39;
                    }
                    v3 = null;
                }
                ChordDefinition matchingDefinition = v3;
                if (matchingDefinition != null) {
                    for (TimedArc np : notePeriods) {
                        FretboardPosition pos;
                        if (matchingDefinition.calculateFretboardPosition(np.getNote()) == null) continue;
                        boolean bl = false;
                        Map $this$map$iv4 = map2;
                        object4 = TuplesKt.to(np, pos);
                        $this$map$iv4.put(((Pair)object4).getFirst(), ((Pair)object4).getSecond());
                    }
                    continue;
                }
                Iterator iterator3 = ((Iterable)notePeriods).iterator();
                if (!iterator3.hasNext()) {
                    throw new NoSuchElementException();
                }
                TimedArc it = (TimedArc)iterator3.next();
                boolean bl = false;
                byte by = it.getNote();
                while (iterator3.hasNext()) {
                    TimedArc it62 = (TimedArc)iterator3.next();
                    $i$a$-minOf-BetterFretting$calculateIntervals$lowNoteOfGroup$1 = false;
                    byte it62 = it62.getNote();
                    if (by <= it62) continue;
                    by = it62;
                }
                byte lowNoteOfGroup = by;
                iterator3 = groupWithLowestOverallNote.getArcs();
                byte by2 = lowNoteOfGroup;
                Iterator iterator4 = iterator3.iterator();
                if (!iterator4.hasNext()) {
                    throw new NoSuchElementException();
                }
                TimedArc it72 = (TimedArc)iterator4.next();
                boolean bl9 = false;
                byte it72 = it72.getNote();
                while (iterator4.hasNext()) {
                    TimedArc it82 = (TimedArc)iterator4.next();
                    $i$a$-minOf-BetterFretting$calculateIntervals$difference$1 = false;
                    byte it82 = it82.getNote();
                    if (it72 <= it82) continue;
                    it72 = it82;
                }
                byte by3 = it72;
                int difference = by2 - by3;
                Pair<FretboardPosition, FretboardPosition> pair = lowestGroupPosition;
                if (pair == null) continue;
                iterator4 = pair;
                boolean bl10 = false;
                FretboardPosition first2 = (FretboardPosition)((Pair)((Object)iterator4)).component1();
                FretboardPosition second2 = (FretboardPosition)((Pair)((Object)iterator4)).component2();
                object4 = map2;
                Object $this$minBy$iv3 = notePeriods;
                boolean $i$f$minByOrThrow3 = false;
                Iterator iterator$iv3 = $this$minBy$iv3.iterator();
                if (!iterator$iv3.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object minElem$iv3 = iterator$iv3.next();
                if (!iterator$iv3.hasNext()) {
                    t5 = minElem$iv3;
                } else {
                    TimedArc it5 = (TimedArc)minElem$iv3;
                    boolean bl11 = false;
                    byte minValue$iv = it5.getNote();
                    do {
                        e$iv = iterator$iv3.next();
                        TimedArc it6 = (TimedArc)e$iv;
                        $i$a$-minByOrThrow-BetterFretting$calculateIntervals$2$1 = false;
                        byte v$iv = it6.getNote();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv3 = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv3.hasNext());
                    t5 = minElem$iv3;
                }
                $this$minBy$iv3 = TuplesKt.to(t5, new FretboardPosition(first2.getString(), first2.getFret() + difference));
                object4.put(((Pair)$this$minBy$iv3).getFirst(), ((Pair)$this$minBy$iv3).getSecond());
                object4 = map2;
                Iterable $this$maxBy$iv2 = notePeriods;
                boolean $i$f$maxByOrThrow2 = false;
                iterator$iv3 = $this$maxBy$iv2.iterator();
                if (!iterator$iv3.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object maxElem$iv2 = iterator$iv3.next();
                if (!iterator$iv3.hasNext()) {
                    t4 = maxElem$iv2;
                } else {
                    TimedArc it8 = (TimedArc)maxElem$iv2;
                    boolean bl12 = false;
                    byte maxValue$iv = it8.getNote();
                    do {
                        e$iv = iterator$iv3.next();
                        TimedArc it9 = (TimedArc)e$iv;
                        $i$a$-maxByOrThrow-BetterFretting$calculateIntervals$2$2 = false;
                        byte v$iv = it9.getNote();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv2 = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv3.hasNext());
                    t4 = maxElem$iv2;
                }
                Pair pair2 = TuplesKt.to(t4, new FretboardPosition(second2.getString(), second2.getFret() + difference));
                object4.put(pair2.getFirst(), pair2.getSecond());
            }
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final ChordCalculationResult calculateChords(List<TimedArcGroup> groups2) {
        Map map2 = new LinkedHashMap();
        Set definitionsUsed = new LinkedHashSet();
        Iterator<TimedArcGroup> iterator2 = groups2.iterator();
        while (iterator2.hasNext()) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            void $this$filterTo$iv$iv3;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            Set<TimedArc> notePeriods = iterator2.next().component1();
            Iterable $this$map$iv = notePeriods;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                TimedArc timedArc = (TimedArc)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getNote());
            }
            Set notes = CollectionsKt.toSet((List)destination$iv$iv);
            Iterable $this$filter$iv = this.chordDictionary;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            item$iv$iv2 = $this$filterTo$iv$iv3.iterator();
            while (item$iv$iv2.hasNext()) {
                Object element$iv$iv = item$iv$iv2.next();
                ChordDefinition it = (ChordDefinition)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getDefinedNotes(), notes)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Set<ChordDefinition> exactMatches = CollectionsKt.toSet((List)destination$iv$iv2);
            if (!((Collection)exactMatches).isEmpty()) {
                BetterFretting.calculateChords$applyDefinition(definitionsUsed, map2, this.evaluateChords(exactMatches), notePeriods);
                continue;
            }
            Iterable $this$filter$iv2 = this.chordDictionary;
            boolean $i$f$filter2 = false;
            destination$iv$iv2 = $this$filter$iv2;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                ChordDefinition it = (ChordDefinition)element$iv$iv;
                boolean bl = false;
                if (!it.getDefinedNotes().containsAll(notes)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            Set<ChordDefinition> comprehensiveMatches = CollectionsKt.toSet((List)destination$iv$iv3);
            if (!((Collection)comprehensiveMatches).isEmpty()) {
                BetterFretting.calculateChords$applyDefinition(definitionsUsed, map2, this.evaluateChords(comprehensiveMatches), notePeriods);
                continue;
            }
            Iterable $this$filter$iv3 = this.chordDictionary;
            boolean $i$f$filter3 = false;
            destination$iv$iv3 = $this$filter$iv3;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ChordDefinition it = (ChordDefinition)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !((Collection)CollectionsKt.intersect((Iterable)it.getDefinedNotes(), notes)).isEmpty();
                if (!bl2) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            Set partialMatches = CollectionsKt.toSet((List)destination$iv$iv4);
            if (!((Collection)partialMatches).isEmpty()) {
                Object t;
                Iterable $this$maxBy$iv = partialMatches;
                boolean $i$f$maxByOrThrow = false;
                Iterator iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t = maxElem$iv;
                } else {
                    ChordDefinition it = (ChordDefinition)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = CollectionsKt.intersect((Iterable)it.getDefinedNotes(), notes).size();
                    do {
                        Object e$iv = iterator$iv.next();
                        ChordDefinition it2 = (ChordDefinition)e$iv;
                        $i$a$-maxByOrThrow-BetterFretting$calculateChords$best$1 = false;
                        int v$iv = CollectionsKt.intersect((Iterable)it2.getDefinedNotes(), notes).size();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t = maxElem$iv;
                }
                ChordDefinition best = (ChordDefinition)t;
                BetterFretting.calculateChords$applyDefinition(definitionsUsed, map2, best, notePeriods);
            }
            map2.putAll(this.buildChord(notePeriods));
        }
        return new ChordCalculationResult(map2, definitionsUsed);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<TimedArc, FretboardPosition> buildChord(Set<TimedArc> notePeriods) {
        int n = 0;
        Integer[] integerArray = new Integer[6];
        while (n < 6) {
            int n2 = n++;
            integerArray[n2] = -1;
        }
        Integer[] frets = integerArray;
        Map map2 = new LinkedHashMap();
        Iterable $this$sortedBy$iv = notePeriods;
        boolean $i$f$sortedBy = false;
        for (TimedArc np : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                TimedArc it = (TimedArc)a;
                boolean bl = false;
                Comparable comparable = Byte.valueOf(it.getNote());
                it = (TimedArc)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getNote());
            }
        })) {
            FretboardPosition it;
            Object v0;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            IndexedValue it2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable<IndexedValue<Integer>> iterable = ArraysKt.withIndex(frets);
            byte by = np.getNote();
            BetterFretting betterFretting = this;
            boolean $i$f$filter = false;
            void var9_13 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (IndexedValue)element$iv$iv;
                bl = false;
                if (!(((Number)it2.getValue()).intValue() != -1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<Integer> collection = (List)destination$iv$iv;
            $this$filter$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                it2 = (IndexedValue)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                collection.add(it3.getIndex());
            }
            collection = (List)destination$iv$iv;
            List allPossibleFretboardPositions = BetterFretting.allPossibleFretboardPositions$default(betterFretting, by, CollectionsKt.toSet((Iterable)collection), null, 4, null);
            Iterable $this$minByOrNull$iv = allPossibleFretboardPositions;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    FretboardPosition it3 = (FretboardPosition)minElem$iv;
                    boolean bl2 = false;
                    int minValue$iv = it3.getString();
                    do {
                        Object e$iv = iterator$iv.next();
                        FretboardPosition it4 = (FretboardPosition)e$iv;
                        boolean bl3 = false;
                        int v$iv = it4.getString();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            if ((FretboardPosition)v0 == null) continue;
            boolean bl4 = false;
            frets[it.getString()] = it.getFret();
            Map map3 = map2;
            Pair<TimedArc, FretboardPosition> pair = TuplesKt.to(np, it);
            map3.put(pair.getFirst(), pair.getSecond());
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final ChordDefinition evaluateChords(Set<ChordDefinition> chords) {
        Object t;
        Iterable $this$associateWith$iv = chords;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ChordDefinition chordDefinition = (ChordDefinition)element$iv$iv;
            Object t2 = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Double d = UtilsKt.stdDev((Collection<? extends Number>)it.getFrets()) + CollectionsKt.averageOfInt((Iterable<Integer>)it.getFrets());
            map2.put(t2, d);
        }
        Map losses = result$iv;
        Iterable iterable = losses.entrySet();
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Object t3 = iterator2.next();
        if (!iterator2.hasNext()) {
            t = t3;
        } else {
            Map.Entry it = (Map.Entry)t3;
            boolean bl = false;
            double d = ((Number)it.getValue()).doubleValue();
            do {
                Object t4 = iterator2.next();
                Map.Entry it2 = (Map.Entry)t4;
                $i$a$-minByOrThrow-BetterFretting$evaluateChords$1 = false;
                double d2 = ((Number)it2.getValue()).doubleValue();
                if (Double.compare(d, d2) <= 0) continue;
                t3 = t4;
                d = d2;
            } while (iterator2.hasNext());
            t = t3;
        }
        return (ChordDefinition)((Map.Entry)t).getKey();
    }

    private final Pair<FretboardPosition, FretboardPosition> buildDuet(TimedArc arc1, TimedArc arc2) {
        Object v0;
        List possibleFretboardPositions = new ArrayList();
        for (int x2 = 0; x2 < 6; ++x2) {
            for (int y2 = 0; y2 < 6; ++y2) {
                if (x2 >= y2) continue;
                int fret1 = arc1.getNote() - this.openStringNoteValues[x2];
                int fret2 = arc2.getNote() - this.openStringNoteValues[y2];
                if (fret1 < 0 || fret2 < 0 || fret1 > 22 || fret2 > 22) continue;
                ((Collection)possibleFretboardPositions).add(TuplesKt.to(new FretboardPosition(x2, fret1), new FretboardPosition(y2, fret2)));
            }
        }
        Iterable $this$minByOrNull$iv = possibleFretboardPositions;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Pair pair = (Pair)minElem$iv;
                boolean bl = false;
                Object fp1 = (FretboardPosition)pair.component1();
                FretboardPosition fp2 = (FretboardPosition)pair.component2();
                int minValue$iv = Math.abs(((FretboardPosition)fp1).getFret() - fp2.getFret()) + (((FretboardPosition)fp1).getFret() + fp2.getFret());
                do {
                    Object e$iv = iterator$iv.next();
                    fp1 = (Pair)e$iv;
                    $i$a$-minByOrNull-BetterFretting$buildDuet$1 = false;
                    FretboardPosition fp12 = (FretboardPosition)((Pair)fp1).component1();
                    FretboardPosition fp22 = (FretboardPosition)((Pair)fp1).component2();
                    int v$iv = Math.abs(fp12.getFret() - fp22.getFret()) + (fp12.getFret() + fp22.getFret());
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Pair pair = v0;
        if (pair != null) {
            Pair pair2 = pair;
            boolean bl = false;
            FretboardPosition fp1 = (FretboardPosition)pair2.component1();
            FretboardPosition fp2 = (FretboardPosition)pair2.component2();
            return TuplesKt.to(fp1, fp2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<TimedArc, FretboardPosition> calculateMonophonic(List<TimedArcGroup> list2) {
        Iterable it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TimedArcGroup timedArcGroup = (TimedArcGroup)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add((TimedArc)CollectionsKt.first((Iterable)((TimedArcGroup)((Object)it)).getArcs()));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List notePeriods = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                TimedArc it = (TimedArc)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStart());
                it = (TimedArc)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getStart());
            }
        });
        RunningAverage runningAverage = new RunningAverage(3, 0);
        Map map2 = new LinkedHashMap();
        object2 = notePeriods.iterator();
        int n = 0;
        while (object2.hasNext()) {
            Object object3;
            Object v0;
            void $this$associateWith$iv;
            int index2 = n++;
            TimedArc notePeriod = (TimedArc)object2.next();
            if (index2 > 0 && notePeriod.getNote() == ((TimedArc)notePeriods.get(index2 - 1)).getNote()) {
                if ((FretboardPosition)map2.get(notePeriods.get(index2 - 1)) != null) {
                    FretboardPosition it2;
                    boolean bl = false;
                    Map map3 = map2;
                    Pair<TimedArc, FretboardPosition> pair = TuplesKt.to(notePeriod, it2);
                    map3.put(pair.getFirst(), pair.getSecond());
                }
                continue;
            }
            it = BetterFretting.allPossibleFretboardPositions$default(this, notePeriod.getNote(), null, this.findPitchBendExtremesDuringRange-QTBD994(notePeriod.getStartTime-UwyO8pc(), notePeriod.getEndTime-UwyO8pc()), 2, null);
            boolean $i$f$associateWith = false;
            Object result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it3;
                FretboardPosition fretboardPosition = (FretboardPosition)element$iv$iv;
                Object t = element$iv$iv;
                object = (Map)result$iv;
                boolean bl = false;
                Double d = Math.abs(runningAverage.invoke() - (double)it3.getFret());
                object.put(t, d);
            }
            Object object4 = ((Map)result$iv).entrySet();
            if (!(result$iv = object4.iterator()).hasNext()) {
                v0 = null;
            } else {
                $this$associateWithTo$iv$iv = result$iv.next();
                if (!result$iv.hasNext()) {
                    v0 = $this$associateWithTo$iv$iv;
                } else {
                    Map.Entry it4 = (Map.Entry)$this$associateWithTo$iv$iv;
                    boolean bl = false;
                    double d = ((Number)it4.getValue()).doubleValue();
                    do {
                        object3 = result$iv.next();
                        Map.Entry it5 = (Map.Entry)object3;
                        $i$a$-minByOrNull-BetterFretting$calculateMonophonic$3 = false;
                        double d2 = ((Number)it5.getValue()).doubleValue();
                        if (Double.compare(d, d2) <= 0) continue;
                        $this$associateWithTo$iv$iv = object3;
                        d = d2;
                    } while (result$iv.hasNext());
                    v0 = $this$associateWithTo$iv$iv;
                }
            }
            Map.Entry entry = v0;
            if (entry == null) continue;
            object4 = entry;
            boolean bl = false;
            FretboardPosition key = (FretboardPosition)object4.getKey();
            Map map4 = map2;
            object3 = TuplesKt.to(notePeriod, key);
            map4.put(((Pair)object3).getFirst(), ((Pair)object3).getSecond());
            runningAverage.plusAssign(key.getFret());
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FretboardPosition> allPossibleFretboardPositions(byte midiNote, Set<Integer> occupiedStrings, ClosedFloatingPointRange<Double> pitchBendExtremes) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        void $this$mapIndexedTo$iv$iv;
        Object $this$mapIndexed$iv = this.openStringNoteValues;
        boolean $i$f$mapIndexed = false;
        int[] nArray = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(((int[])$this$mapIndexed$iv).length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv22 = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void string;
            void openStringNoteValue;
            int n = index$iv$iv22++;
            void var13_20 = item$iv$iv;
            int n2 = n;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            int $this$allPossibleFretboardPositions_u24lambda_u2446_u24lambda_u2445 = midiNote - openStringNoteValue;
            boolean bl2 = false;
            collection2.add($this$allPossibleFretboardPositions_u24lambda_u2446_u24lambda_u2445 < 0 ? null : new FretboardPosition((int)string, $this$allPossibleFretboardPositions_u24lambda_u2446_u24lambda_u2445));
        }
        $this$mapIndexed$iv = CollectionsKt.filterNotNull((List)destination$iv$iv);
        boolean $i$f$filter = false;
        $this$mapIndexedTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            FretboardPosition it = (FretboardPosition)element$iv$iv;
            boolean bl = false;
            if (!(!occupiedStrings.contains(it.getString()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List positions = (List)destination$iv$iv;
        boolean bl = false;
        Iterable $this$filter$iv2 = positions;
        boolean $i$f$filter2 = false;
        Iterable index$iv$iv22 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FretboardPosition it = (FretboardPosition)element$iv$iv;
            boolean bl3 = false;
            boolean bl4 = pitchBendExtremes == null ? true : ((double)it.getFret() + ((Number)pitchBendExtremes.getStart()).doubleValue() < 0.0 ? false : !((double)it.getFret() + ((Number)pitchBendExtremes.getEndInclusive()).doubleValue() > 22.0));
            if (!bl4) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Collection collection3 = (List)destination$iv$iv2;
        if (collection3.isEmpty()) {
            boolean bl5 = false;
            collection = positions;
        } else {
            collection = collection3;
        }
        return (List)collection;
    }

    static /* synthetic */ List allPossibleFretboardPositions$default(BetterFretting betterFretting, byte by, Set set, ClosedFloatingPointRange closedFloatingPointRange, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 4) != 0) {
            closedFloatingPointRange = null;
        }
        return betterFretting.allPossibleFretboardPositions(by, set, closedFloatingPointRange);
    }

    /*
     * WARNING - void declaration
     */
    private final ClosedFloatingPointRange<Double> findPitchBendExtremesDuringRange-QTBD994(long start2, long end2) {
        void $this$mapTo$iv$iv;
        int endEventIndex;
        int startEventIndex;
        block6: {
            int n;
            void $this$indexOfFirst$iv;
            int n2;
            block5: {
                void $this$indexOfLast$iv;
                List $this$sortedBy$iv = (List)((Object)this.absolutePitchBendEventsWithTime.entrySet());
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(((VirtualCompositePitchBendEvent)it.getKey()).getTick());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, ((VirtualCompositePitchBendEvent)it.getKey()).getTick());
                    }
                });
                boolean $i$f$indexOfLast = false;
                ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Map.Entry it = (Map.Entry)iterator$iv.previous();
                    boolean bl = false;
                    if (!(Duration.compareTo-LRDsOJo(((Duration)it.getValue()).unbox-impl(), start2) <= 0)) continue;
                    n2 = iterator$iv.nextIndex();
                    break block5;
                }
                n2 = -1;
            }
            startEventIndex = n2;
            List $this$sortedBy$iv = (List)((Object)this.absolutePitchBendEventsWithTime.entrySet());
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((VirtualCompositePitchBendEvent)it.getKey()).getTick());
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, ((VirtualCompositePitchBendEvent)it.getKey()).getTick());
                }
            });
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                Map.Entry it = (Map.Entry)item$iv;
                boolean bl = false;
                if (Duration.compareTo-LRDsOJo(((Duration)it.getValue()).unbox-impl(), end2) >= 0) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = endEventIndex = -1;
        }
        if (endEventIndex == -1) {
            endEventIndex = startEventIndex;
        }
        Iterable $this$sortedBy$iv = this.absolutePitchBendEventsWithTime.entrySet();
        boolean $i$f$sortedBy = false;
        List eventsInRange = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((VirtualCompositePitchBendEvent)it.getKey()).getTick());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, ((VirtualCompositePitchBendEvent)it.getKey()).getTick());
            }
        }).subList(startEventIndex, endEventIndex + 1);
        Iterable $this$map$iv = eventsInRange;
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(((VirtualCompositePitchBendEvent)it.getKey()).getBend());
        }
        List it = (List)destination$iv$iv;
        boolean bl3 = false;
        Object t = CollectionsKt.minOrNull(it);
        Intrinsics.checkNotNull(t);
        double d = (Double)t;
        Object t2 = CollectionsKt.maxOrNull(it);
        Intrinsics.checkNotNull(t2);
        return RangesKt.rangeTo(d, (Double)t2);
    }

    private static final void calculateChords$applyDefinition(Set<ChordDefinition> definitionsUsed, Map<TimedArc, FretboardPosition> map2, ChordDefinition definition, Set<TimedArc> notePeriods) {
        for (TimedArc np : notePeriods) {
            FretboardPosition pos;
            if (definition.calculateFretboardPosition(np.getNote()) == null) continue;
            boolean bl = false;
            Map<TimedArc, FretboardPosition> map3 = map2;
            Pair<TimedArc, FretboardPosition> pair = TuplesKt.to(np, pos);
            map3.put(pair.getFirst(), pair.getSecond());
        }
        ((Collection)definitionsUsed).add(definition);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J/\u0010\u0010\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/wysko/midis2jam2/instrument/family/guitar/BetterFretting$ChordCalculationResult;", "", "fretboardPositions", "", "Lorg/wysko/kmidi/midi/TimedArc;", "Lorg/wysko/midis2jam2/instrument/family/guitar/FretboardPosition;", "chordDefinitionsUsed", "", "Lorg/wysko/midis2jam2/instrument/family/guitar/ChordDefinition;", "(Ljava/util/Map;Ljava/util/Set;)V", "getChordDefinitionsUsed", "()Ljava/util/Set;", "getFretboardPositions", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "midis2jam2"})
    private static final class ChordCalculationResult {
        @NotNull
        private final Map<TimedArc, FretboardPosition> fretboardPositions;
        @NotNull
        private final Set<ChordDefinition> chordDefinitionsUsed;

        public ChordCalculationResult(@NotNull Map<TimedArc, FretboardPosition> fretboardPositions, @NotNull Set<ChordDefinition> chordDefinitionsUsed) {
            Intrinsics.checkNotNullParameter(fretboardPositions, "fretboardPositions");
            Intrinsics.checkNotNullParameter(chordDefinitionsUsed, "chordDefinitionsUsed");
            this.fretboardPositions = fretboardPositions;
            this.chordDefinitionsUsed = chordDefinitionsUsed;
        }

        @NotNull
        public final Map<TimedArc, FretboardPosition> getFretboardPositions() {
            return this.fretboardPositions;
        }

        @NotNull
        public final Set<ChordDefinition> getChordDefinitionsUsed() {
            return this.chordDefinitionsUsed;
        }

        @NotNull
        public final Map<TimedArc, FretboardPosition> component1() {
            return this.fretboardPositions;
        }

        @NotNull
        public final Set<ChordDefinition> component2() {
            return this.chordDefinitionsUsed;
        }

        @NotNull
        public final ChordCalculationResult copy(@NotNull Map<TimedArc, FretboardPosition> fretboardPositions, @NotNull Set<ChordDefinition> chordDefinitionsUsed) {
            Intrinsics.checkNotNullParameter(fretboardPositions, "fretboardPositions");
            Intrinsics.checkNotNullParameter(chordDefinitionsUsed, "chordDefinitionsUsed");
            return new ChordCalculationResult(fretboardPositions, chordDefinitionsUsed);
        }

        public static /* synthetic */ ChordCalculationResult copy$default(ChordCalculationResult chordCalculationResult, Map map2, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = chordCalculationResult.fretboardPositions;
            }
            if ((n & 2) != 0) {
                set = chordCalculationResult.chordDefinitionsUsed;
            }
            return chordCalculationResult.copy(map2, set);
        }

        @NotNull
        public String toString() {
            return "ChordCalculationResult(fretboardPositions=" + this.fretboardPositions + ", chordDefinitionsUsed=" + this.chordDefinitionsUsed + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.fretboardPositions).hashCode();
            result2 = result2 * 31 + ((Object)this.chordDefinitionsUsed).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChordCalculationResult)) {
                return false;
            }
            ChordCalculationResult chordCalculationResult = (ChordCalculationResult)other;
            if (!Intrinsics.areEqual(this.fretboardPositions, chordCalculationResult.fretboardPositions)) {
                return false;
            }
            return Intrinsics.areEqual(this.chordDefinitionsUsed, chordCalculationResult.chordDefinitionsUsed);
        }
    }
}

