/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.family.chromaticpercussion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.midi.event.Event;
import org.wysko.kmidi.midi.event.MidiEvent;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.DecayedInstrument;
import org.wysko.midis2jam2.instrument.MultipleInstancesLinearAdjustment;
import org.wysko.midis2jam2.instrument.algorithmic.EventCollector;
import org.wysko.midis2jam2.instrument.family.percussion.CymbalAnimator;
import org.wysko.midis2jam2.instrument.family.percussive.TwelveDrumOctave;
import org.wysko.midis2jam2.util.JmeDslKt;
import org.wysko.midis2jam2.world.AssetLoaderKt;
import org.wysko.midis2jam2.world.GlowController;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001'B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001d\u001a\u00020\u000bH\u0002J\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b#\u0010$J\"\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010$R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006("}, d2={"Lorg/wysko/midis2jam2/instrument/family/chromaticpercussion/MusicBox;", "Lorg/wysko/midis2jam2/instrument/DecayedInstrument;", "Lorg/wysko/midis2jam2/instrument/MultipleInstancesLinearAdjustment;", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "eventList", "", "Lorg/wysko/kmidi/midi/event/MidiEvent;", "(Lorg/wysko/midis2jam2/Midis2jam2;Ljava/util/List;)V", "activePins", "", "Lcom/jme3/scene/Spatial;", "collectorForLamellae", "Lorg/wysko/midis2jam2/instrument/algorithmic/EventCollector;", "Lorg/wysko/kmidi/midi/event/NoteEvent$NoteOn;", "collectorForPins", "cylinder", "Lcom/jme3/scene/Node;", "lamellae", "Lorg/wysko/midis2jam2/instrument/family/chromaticpercussion/MusicBox$Lamella;", "multipleInstancesDirection", "Lcom/jme3/math/Vector3f;", "getMultipleInstancesDirection", "()Lcom/jme3/math/Vector3f;", "pinModel", "pinPool", "pinRotations", "", "", "getPin", "rotateCylinder", "", "time", "Lkotlin/time/Duration;", "delta", "rotateCylinder-QTBD994", "(JJ)V", "tick", "tick-QTBD994", "Lamella", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMusicBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MusicBox.kt\norg/wysko/midis2jam2/instrument/family/chromaticpercussion/MusicBox\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1#2:154\n1#2:156\n1#2:165\n2634#3:155\n1855#3,2:157\n1855#3,2:159\n766#3:161\n857#3,2:162\n2634#3:164\n1855#3,2:166\n1855#3,2:168\n*S KotlinDebug\n*F\n+ 1 MusicBox.kt\norg/wysko/midis2jam2/instrument/family/chromaticpercussion/MusicBox\n*L\n61#1:156\n101#1:165\n61#1:155\n87#1:157,2\n98#1:159,2\n100#1:161\n100#1:162,2\n101#1:164\n105#1:166,2\n117#1:168,2\n*E\n"})
public final class MusicBox
extends DecayedInstrument
implements MultipleInstancesLinearAdjustment {
    @NotNull
    private final Vector3f multipleInstancesDirection;
    @NotNull
    private final List<Lamella> lamellae;
    @NotNull
    private final Node cylinder;
    @NotNull
    private final List<Spatial> activePins;
    @NotNull
    private final Map<Spatial, Float> pinRotations;
    @NotNull
    private final Spatial pinModel;
    @NotNull
    private final List<Spatial> pinPool;
    @NotNull
    private final EventCollector<NoteEvent.NoteOn> collectorForPins;
    @NotNull
    private final EventCollector<NoteEvent.NoteOn> collectorForLamellae;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public MusicBox(@NotNull Midis2jam2 context2, @NotNull List<? extends MidiEvent> eventList) {
        void $this$lambda_u243_u24lambda_u242;
        Node node2;
        void $this$onEach$iv;
        void var5_10;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(eventList, "eventList");
        super(context2, eventList);
        this.multipleInstancesDirection = JmeDslKt.v3(0, 0, -18);
        int n = 12;
        MusicBox musicBox = this;
        ArrayList<Lamella> arrayList = new ArrayList<Lamella>(n);
        int n2 = 0;
        while (n2 < n) {
            void i;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Lamella> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new Lamella((int)i));
        }
        Iterable iterable = arrayList;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = var5_10 = $this$onEach$iv;
        boolean $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv22 = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            Lamella it = (Lamella)element$iv;
            boolean bl = false;
            JmeDslKt.plusAssign(this.getGeometry(), it.getHighestLevel());
        }
        musicBox.lamellae = (List)var5_10;
        this.cylinder = JmeDslKt.node$default(null, 1, null);
        this.activePins = new ArrayList();
        this.pinRotations = new LinkedHashMap();
        this.pinModel = AssetLoaderKt.modelR(context2, "MusicBoxPoint.obj", "ShinySilver.bmp");
        this.pinPool = new ArrayList();
        this.collectorForPins = new EventCollector(context2, this.getHits(), new Function2<Event, Duration, Boolean>(context2){
            final /* synthetic */ Midis2jam2 $context;
            {
                this.$context = $context;
                super(2);
            }

            @NotNull
            public final Boolean invoke-HG0u8IE(@NotNull Event event, long time) {
                Intrinsics.checkNotNullParameter(event, "event");
                return Duration.compareTo-LRDsOJo(this.$context.getSequence().getTimeAtTick-5sfh64U(event.getTick() - this.$context.getSequence().getSmf().getTpq()), time) <= 0;
            }
        }, null, 8, null);
        this.collectorForLamellae = new EventCollector(context2, this.getHits(), null, null, 12, null);
        Node $this$_init__u24lambda_u243 = this.getGeometry();
        boolean bl = false;
        JmeDslKt.unaryPlus($this$_init__u24lambda_u243, AssetLoaderKt.modelD(context2, "MusicBoxCase.obj", "Wood.bmp"));
        JmeDslKt.unaryPlus($this$_init__u24lambda_u243, AssetLoaderKt.modelR(context2, "MusicBoxTopBlade.obj", "ShinySilver.bmp"));
        Node $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv22 = node2 = this.cylinder;
        Node node3 = $this$_init__u24lambda_u243;
        boolean bl2 = false;
        JmeDslKt.unaryPlus((Node)$this$lambda_u243_u24lambda_u242, AssetLoaderKt.modelR(context2, "MusicBoxSpindle.obj", "ShinySilver.bmp"));
        Node cfr_ignored_0 = (Node)JmeDslKt.unaryPlus(node3, (Spatial)node2);
        JmeDslKt.setLoc(this.getPlacement(), JmeDslKt.v3(37, 5, -5));
    }

    @Override
    @NotNull
    public Vector3f getMultipleInstancesDirection() {
        return this.multipleInstancesDirection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick-QTBD994(long time, long delta) {
        void $this$onEach$iv;
        void $this$filterTo$iv$iv;
        NoteEvent.NoteOn it;
        super.tick-QTBD994(time, delta);
        this.rotateCylinder-QTBD994(time, delta);
        Iterable $this$forEach$iv = this.collectorForPins.advanceCollectAll-LRDsOJo(time);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (NoteEvent.NoteOn)element$iv;
            boolean bl = false;
            Spatial $this$tick_QTBD994_u24lambda_u245_u24lambda_u244 = this.getPin();
            boolean bl2 = false;
            JmeDslKt.plusAssign(this.getGeometry(), $this$tick_QTBD994_u24lambda_u245_u24lambda_u244);
            ((Collection)this.activePins).add($this$tick_QTBD994_u24lambda_u245_u24lambda_u244);
            this.pinRotations.put($this$tick_QTBD994_u24lambda_u245_u24lambda_u244, Float.valueOf(0.0f));
            JmeDslKt.setLoc($this$tick_QTBD994_u24lambda_u245_u24lambda_u244, JmeDslKt.v3((double)((it.getNote() + 3) % 12) - 5.5, 0, 0));
            JmeDslKt.setRot($this$tick_QTBD994_u24lambda_u245_u24lambda_u244, JmeDslKt.v3(-90, 0, 0));
        }
        $this$forEach$iv = this.collectorForLamellae.advanceCollectAll-LRDsOJo(time);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (NoteEvent.NoteOn)element$iv;
            boolean bl = false;
            this.lamellae.get((it.getNote() + 3) % 12).play$midis2jam2();
        }
        Iterable $this$filter$iv = this.activePins;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Spatial it2 = (Spatial)element$iv$iv;
            boolean bl = false;
            Float f = this.pinRotations.get(it2);
            Intrinsics.checkNotNull(f);
            if (!((double)((Number)f).floatValue() > 4.71238911151886)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = $this$filterTo$iv$iv = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            Spatial it3 = (Spatial)element$iv;
            boolean bl3 = false;
            JmeDslKt.minusAssign(this.getGeometry(), it3);
        }
        $this$onEach$iv = $this$filterTo$iv$iv;
        List it4 = (List)$this$onEach$iv;
        boolean bl4 = false;
        this.activePins.removeAll(it4);
        it4 = (List)$this$onEach$iv;
        boolean bl5 = false;
        this.pinPool.addAll(it4);
        $this$forEach$iv = this.lamellae;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Lamella it5 = (Lamella)element$iv;
            boolean bl6 = false;
            it5.tick-LRDsOJo(delta);
        }
    }

    private final Spatial getPin() {
        Spatial spatial;
        if (!((Collection)this.pinPool).isEmpty()) {
            spatial = this.pinPool.remove(0);
        } else {
            Spatial spatial2 = this.pinModel.clone();
            spatial = spatial2;
            Intrinsics.checkNotNullExpressionValue(spatial2, "clone(...)");
        }
        return spatial;
    }

    private final void rotateCylinder-QTBD994(long time, long delta) {
        double tempo = this.getContext().getSequence().getTempoAtTime-LRDsOJo(time).getBeatsPerMinute();
        float dRotation = (float)(1.5707963705062866 * Duration.toDouble-impl(delta, DurationUnit.SECONDS) * tempo / 60.0);
        Iterable $this$forEach$iv = this.pinRotations.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            ((Spatial)it.getKey()).rotate(dRotation, 0.0f, 0.0f);
            this.pinRotations.put((Spatial)it.getKey(), Float.valueOf(((Number)it.getValue()).floatValue() + dRotation));
        }
        this.cylinder.rotate(dRotation, 0.0f, 0.0f);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u001a\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0013"}, d2={"Lorg/wysko/midis2jam2/instrument/family/chromaticpercussion/MusicBox$Lamella;", "Lorg/wysko/midis2jam2/instrument/family/percussive/TwelveDrumOctave$TwelfthOfOctaveDecayed;", "i", "", "(Lorg/wysko/midis2jam2/instrument/family/chromaticpercussion/MusicBox;I)V", "animator", "Lorg/wysko/midis2jam2/instrument/family/percussion/CymbalAnimator;", "glowController", "Lorg/wysko/midis2jam2/world/GlowController;", "model", "Lcom/jme3/scene/Geometry;", "play", "", "play$midis2jam2", "tick", "delta", "Lkotlin/time/Duration;", "tick-LRDsOJo", "(J)V", "midis2jam2"})
    public final class Lamella
    extends TwelveDrumOctave.TwelfthOfOctaveDecayed {
        @NotNull
        private final Geometry model;
        @NotNull
        private final GlowController glowController;
        @NotNull
        private final CymbalAnimator animator;

        /*
         * WARNING - void declaration
         */
        public Lamella(int i) {
            void $this$model_u24lambda_u240;
            Spatial spatial;
            Spatial spatial2 = spatial = AssetLoaderKt.modelR(MusicBox.this.getContext(), "MusicBoxKey.obj", "ShinySilver.bmp");
            Lamella lamella = this;
            boolean bl = false;
            $this$model_u24lambda_u240.setLocalScale(JmeDslKt.v3(Float.valueOf(-0.0454f * (float)i + 1.0f), 1, 1));
            Spatial spatial3 = spatial;
            Intrinsics.checkNotNull(spatial3, "null cannot be cast to non-null type com.jme3.scene.Geometry");
            lamella.model = (Geometry)spatial3;
            this.glowController = new GlowController(null, 1, null);
            this.animator = new CymbalAnimator(this.model, 1.0, 3.0, 2.5, 1.5707964f);
            Node $this$_init__u24lambda_u241 = this.getHighestLevel();
            boolean bl2 = false;
            JmeDslKt.unaryPlus($this$_init__u24lambda_u241, (Spatial)this.model);
            JmeDslKt.setLoc($this$_init__u24lambda_u241, JmeDslKt.v3((double)i - 5.5, 7, 0));
        }

        public final void play$midis2jam2() {
            this.animator.strike();
        }

        @Override
        public void tick-LRDsOJo(long delta) {
            this.model.getMaterial().setColor("GlowColor", this.glowController.calculate(this.animator.getAnimTime() * (double)2));
            this.animator.tick-LRDsOJo(delta);
        }
    }
}

