/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.family.brass;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.midi.TimedArc;
import org.wysko.kmidi.midi.event.MidiEvent;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.MonophonicInstrument;
import org.wysko.midis2jam2.instrument.algorithmic.PitchBendModulationController;
import org.wysko.midis2jam2.instrument.clone.Clone;
import org.wysko.midis2jam2.instrument.clone.CloneWithBell;
import org.wysko.midis2jam2.instrument.family.brass.TromboneKt;
import org.wysko.midis2jam2.util.JmeDslKt;
import org.wysko.midis2jam2.world.AssetLoaderKt;
import org.wysko.midis2jam2.world.Axis;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0016B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ*\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0017"}, d2={"Lorg/wysko/midis2jam2/instrument/family/brass/Trombone;", "Lorg/wysko/midis2jam2/instrument/MonophonicInstrument;", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "eventList", "", "Lorg/wysko/kmidi/midi/event/MidiEvent;", "(Lorg/wysko/midis2jam2/Midis2jam2;Ljava/util/List;)V", "bend", "", "adjustForMultipleInstances", "", "delta", "Lkotlin/time/Duration;", "adjustForMultipleInstances-LRDsOJo", "(J)V", "handlePitchBend", "time", "isNewNote", "", "handlePitchBend-NqJ4yvY", "(JJZ)V", "TromboneClone", "midis2jam2"})
@StabilityInferred(parameters=0)
public final class Trombone
extends MonophonicInstrument {
    private float bend;
    public static final int $stable = 8;

    public Trombone(@NotNull Midis2jam2 context2, @NotNull List<? extends MidiEvent> eventList) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(eventList, "eventList");
        super(context2, eventList, Reflection.getOrCreateKotlinClass(TromboneClone.class), TromboneKt.access$getSLIDE_MANAGER$p());
    }

    @Override
    protected void adjustForMultipleInstances-LRDsOJo(long delta) {
        JmeDslKt.setLoc(this.getRoot(), JmeDslKt.v3(0, Float.valueOf((float)10 * this.updateInstrumentIndex-LRDsOJo(delta)), 0));
    }

    @Override
    public void handlePitchBend-NqJ4yvY(long time, long delta, boolean isNewNote) {
        this.bend = PitchBendModulationController.tick-ePrTys8$default(this.getPitchBendModulationController(), time, delta, false, false, new Function0<Boolean>(this){
            final /* synthetic */ Trombone this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = this.this$0.getClones();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Clone it = (Clone)element$iv;
                            boolean bl2 = false;
                            if (!it.isPlaying()) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }, 8, null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\"\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001e\u0010\u0012J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006!"}, d2={"Lorg/wysko/midis2jam2/instrument/family/brass/Trombone$TromboneClone;", "Lorg/wysko/midis2jam2/instrument/clone/CloneWithBell;", "(Lorg/wysko/midis2jam2/instrument/family/brass/Trombone;)V", "slide", "Lcom/jme3/scene/Spatial;", "slidePosition", "", "getSlidePosition", "()D", "adjustForPolyphony", "", "delta", "Lkotlin/time/Duration;", "adjustForPolyphony-LRDsOJo", "(J)V", "advanceSlide", "time", "advanceSlide-QTBD994", "(JJ)V", "getSlidePositionFromNote", "", "period", "Lorg/wysko/kmidi/midi/TimedArc;", "moveToPosition", "position", "slideLocation", "Lcom/jme3/math/Vector3f;", "snapSlide", "", "tick", "tick-QTBD994", "toString", "", "midis2jam2"})
    @SourceDebugExtension(value={"SMAP\nTrombone.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Trombone.kt\norg/wysko/midis2jam2/instrument/family/brass/Trombone$TromboneClone\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1855#2,2:164\n*S KotlinDebug\n*F\n+ 1 Trombone.kt\norg/wysko/midis2jam2/instrument/family/brass/Trombone$TromboneClone\n*L\n149#1:164,2\n*E\n"})
    public final class TromboneClone
    extends CloneWithBell {
        @NotNull
        private final Spatial slide;

        /*
         * WARNING - void declaration
         */
        public TromboneClone() {
            void $this$lambda_u241_u24lambda_u240;
            Spatial spatial;
            super(Trombone.this, 0.1f, 1.0f, Axis.Z, Axis.X);
            this.slide = AssetLoaderKt.modelR(Trombone.this.getContext(), "TromboneSlide.obj", "HornSkin.bmp");
            Node node2 = this.getGeometry();
            Trombone trombone = Trombone.this;
            Node $this$_init__u24lambda_u241 = node2;
            boolean bl = false;
            JmeDslKt.unaryPlus($this$_init__u24lambda_u241, this.slide);
            Spatial spatial2 = spatial = AssetLoaderKt.modelR(trombone.getContext(), "TromboneBody.obj", "HornSkin.bmp");
            Node node3 = $this$_init__u24lambda_u241;
            boolean bl2 = false;
            Intrinsics.checkNotNull($this$lambda_u241_u24lambda_u240, "null cannot be cast to non-null type com.jme3.scene.Node");
            Node cfr_ignored_0 = (Node)$this$lambda_u241_u24lambda_u240;
            ((Node)$this$lambda_u241_u24lambda_u240).getChild(1).setMaterial(trombone.getContext().reflectiveMaterial("Assets/HornSkinGrey.bmp"));
            JmeDslKt.unaryPlus(node3, spatial);
            JmeDslKt.setRot($this$_init__u24lambda_u241, JmeDslKt.v3(-10.0, 0, 0));
            $this$_init__u24lambda_u241.setLocalScale(JmeDslKt.v3(Float.valueOf(0.8f), Float.valueOf(0.8f), Float.valueOf(0.8f)));
            node2 = this.getBell();
            trombone = Trombone.this;
            Node $this$_init__u24lambda_u242 = node2;
            boolean bl3 = false;
            JmeDslKt.unaryPlus($this$_init__u24lambda_u242, AssetLoaderKt.modelR(trombone.getContext(), "TromboneHorn.obj", "HornSkin.bmp"));
            JmeDslKt.setLoc($this$_init__u24lambda_u242, JmeDslKt.v3(0.5522, 4.291, 1.207));
            JmeDslKt.setRot($this$_init__u24lambda_u242, JmeDslKt.v3(-4.0, 0, 0));
            JmeDslKt.setLoc(this.getHighestLevel(), JmeDslKt.v3(0, 65, -55.4));
        }

        private final double getSlidePosition() {
            return 0.3 * (double)(this.slide.getLocalTranslation().z + 1.0f);
        }

        private final void moveToPosition(double position) {
            JmeDslKt.setLoc(this.slide, this.slideLocation(((Number)RangesKt.coerceIn((Comparable)Double.valueOf(position - (double)Trombone.this.bend), RangesKt.rangeTo(0.5, 7.0))).doubleValue()));
        }

        private final Vector3f slideLocation(double position) {
            return new Vector3f(0.0f, 0.0f, (float)(3.333333 * position - 1.0));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void tick-QTBD994(long time, long delta) {
            super.tick-QTBD994(time, delta);
            if (!this.isPlaying()) {
                this.advanceSlide-QTBD994(time, delta);
                return;
            }
            TimedArc timedArc = this.getTimedArcCollector().peek();
            if (timedArc == null) return;
            TimedArc it = timedArc;
            boolean bl = false;
            if (Duration.compareTo-LRDsOJo(Duration.minus-LRDsOJo(it.getStartTime-UwyO8pc(), time), DurationKt.toDuration(0.1, DurationUnit.SECONDS)) < 0) {
                TimedArc timedArc2 = this.getCurrentNotePeriod();
                Duration duration = timedArc2 != null ? Duration.box-impl(timedArc2.getDuration-UwyO8pc()) : null;
                Intrinsics.checkNotNull(duration);
                if (Duration.compareTo-LRDsOJo(duration.unbox-impl(), DurationKt.toDuration(0.15, DurationUnit.SECONDS)) >= 0) {
                    this.advanceSlide-QTBD994(time, delta);
                    return;
                }
            }
            this.snapSlide();
        }

        private final boolean snapSlide() {
            TimedArc timedArc = this.getCurrentNotePeriod();
            if (timedArc == null) {
                return true;
            }
            this.moveToPosition(this.getSlidePositionFromNote(timedArc));
            return false;
        }

        private final void advanceSlide-QTBD994(long time, long delta) {
            block2: {
                TimedArc timedArc = this.getTimedArcCollector().peek();
                if (timedArc == null) break block2;
                TimedArc it = timedArc;
                boolean bl = false;
                byte by = it.getNote();
                if (!(21 <= by ? by < 81 : false)) {
                    return;
                }
                long l = DurationKt.toDuration(1.0, DurationUnit.SECONDS);
                long l2 = Duration.minus-LRDsOJo(it.getStartTime-UwyO8pc(), time);
                boolean bl2 = 0 <= Duration.box-impl(l2).compareTo(Duration.box-impl(delta)) ? Duration.box-impl(l2).compareTo(Duration.box-impl(l)) <= 0 : false;
                if (bl2) {
                    int target = this.getSlidePositionFromNote(it);
                    this.moveToPosition(this.getSlidePosition() + ((double)target - this.getSlidePosition()) / Duration.toDouble-impl(Duration.minus-LRDsOJo(it.getStartTime-UwyO8pc(), time), DurationUnit.SECONDS) * Duration.toDouble-impl(delta, DurationUnit.SECONDS));
                }
            }
        }

        private final int getSlidePositionFromNote(TimedArc period) {
            Object object = TromboneKt.access$getSLIDE_MANAGER$p().fingering(period.getNote());
            if (object == null) {
                return MathKt.roundToInt(this.getSlidePosition());
            }
            Object positionList = object;
            if (positionList.size() == 1) {
                return ((Number)positionList.get(0)).intValue();
            }
            TreeMap positionScoreMap = new TreeMap();
            Iterable $this$forEach$iv = (Iterable)positionList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int pos = ((Number)element$iv).intValue();
                boolean bl = false;
                Integer n = pos;
                ((Map)positionScoreMap).put(Math.abs(this.getSlidePosition() - (double)pos), n);
            }
            Object v = positionScoreMap.firstEntry().getValue();
            Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
            return ((Number)v).intValue();
        }

        @Override
        protected void adjustForPolyphony-LRDsOJo(long delta) {
            JmeDslKt.setLoc(this.getRoot(), JmeDslKt.v3(0, Float.valueOf(this.indexForMoving()), 0));
            JmeDslKt.setRot(this.getRoot(), JmeDslKt.v3(0, Float.valueOf((float)-70 + this.indexForMoving() * (float)15), 0));
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString() + this.debugProperty("slide", this.getSlidePosition());
        }
    }
}

