/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.clone;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.kmidi.midi.TimedArc;
import org.wysko.midis2jam2.instrument.MonophonicInstrument;
import org.wysko.midis2jam2.instrument.algorithmic.TimedArcCollector;
import org.wysko.midis2jam2.util.JmeDslKt;
import org.wysko.midis2jam2.util.UtilsKt;
import org.wysko.midis2jam2.world.Axis;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\b'\u0018\u00002\u00020\u0001B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H$\u00f8\u0001\u0000\u00a2\u0006\u0004\b1\u00102J\b\u00103\u001a\u00020\u001eH\u0002J\b\u00104\u001a\u00020.H\u0016J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u00108\u001a\u00020\u0001H\u0004J\u0010\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020\u0005H\u0014J\"\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u0002002\u0006\u0010/\u001a\u000200H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b?\u0010@J\b\u0010A\u001a\u000206H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u001b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u001a\u0010 \u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001f\"\u0004\b!\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020(X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006B"}, d2={"Lorg/wysko/midis2jam2/instrument/clone/Clone;", "", "parent", "Lorg/wysko/midis2jam2/instrument/MonophonicInstrument;", "rotationFactor", "", "rotationAxis", "Lorg/wysko/midis2jam2/world/Axis;", "(Lorg/wysko/midis2jam2/instrument/MonophonicInstrument;FLorg/wysko/midis2jam2/world/Axis;)V", "animNode", "Lcom/jme3/scene/Node;", "getAnimNode", "()Lcom/jme3/scene/Node;", "arcs", "", "Lorg/wysko/kmidi/midi/TimedArc;", "getArcs", "()Ljava/util/List;", "bendNode", "getBendNode", "currentNotePeriod", "getCurrentNotePeriod", "()Lorg/wysko/kmidi/midi/TimedArc;", "setCurrentNotePeriod", "(Lorg/wysko/kmidi/midi/TimedArc;)V", "geometry", "getGeometry", "highestLevel", "getHighestLevel", "isPlaying", "", "()Z", "isVisible", "setVisible", "(Z)V", "getParent", "()Lorg/wysko/midis2jam2/instrument/MonophonicInstrument;", "root", "getRoot", "timedArcCollector", "Lorg/wysko/midis2jam2/instrument/algorithmic/TimedArcCollector;", "getTimedArcCollector", "()Lorg/wysko/midis2jam2/instrument/algorithmic/TimedArcCollector;", "setTimedArcCollector", "(Lorg/wysko/midis2jam2/instrument/algorithmic/TimedArcCollector;)V", "adjustForPolyphony", "", "delta", "Lkotlin/time/Duration;", "adjustForPolyphony-LRDsOJo", "(J)V", "calcVisibility", "createCollector", "debugProperty", "", "name", "value", "hideOrShowOnPolyphony", "index", "", "indexForMoving", "tick", "time", "tick-QTBD994", "(JJ)V", "toString", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nClone.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Clone.kt\norg/wysko/midis2jam2/instrument/clone/Clone\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n766#2:198\n857#2,2:199\n*S KotlinDebug\n*F\n+ 1 Clone.kt\norg/wysko/midis2jam2/instrument/clone/Clone\n*L\n129#1:198\n129#1:199,2\n*E\n"})
public abstract class Clone {
    @NotNull
    private final MonophonicInstrument parent;
    private final float rotationFactor;
    @NotNull
    private final Axis rotationAxis;
    private boolean isVisible;
    @NotNull
    private final List<TimedArc> arcs;
    @NotNull
    private final Node root;
    @NotNull
    private final Node geometry;
    @NotNull
    private final Node animNode;
    @NotNull
    private final Node highestLevel;
    @NotNull
    private final Node bendNode;
    @Nullable
    private TimedArc currentNotePeriod;
    protected TimedArcCollector timedArcCollector;
    public static final int $stable = 8;

    protected Clone(@NotNull MonophonicInstrument parent2, float rotationFactor, @NotNull Axis rotationAxis) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter((Object)rotationAxis, "rotationAxis");
        this.parent = parent2;
        this.rotationFactor = rotationFactor;
        this.rotationAxis = rotationAxis;
        this.arcs = new ArrayList();
        this.root = new Node();
        this.geometry = new Node();
        this.animNode = new Node();
        this.highestLevel = new Node();
        this.bendNode = new Node();
        JmeDslKt.plusAssign(this.parent.getGeometry(), this.root);
        JmeDslKt.plusAssign(this.root, this.highestLevel);
        JmeDslKt.plusAssign(this.highestLevel, this.bendNode);
        JmeDslKt.plusAssign(this.bendNode, this.animNode);
        JmeDslKt.plusAssign(this.animNode, this.geometry);
    }

    @NotNull
    public final MonophonicInstrument getParent() {
        return this.parent;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    @NotNull
    public final List<TimedArc> getArcs() {
        return this.arcs;
    }

    @NotNull
    public final Node getRoot() {
        return this.root;
    }

    @NotNull
    public final Node getGeometry() {
        return this.geometry;
    }

    @NotNull
    public final Node getAnimNode() {
        return this.animNode;
    }

    @NotNull
    public final Node getHighestLevel() {
        return this.highestLevel;
    }

    @NotNull
    public final Node getBendNode() {
        return this.bendNode;
    }

    @Nullable
    public final TimedArc getCurrentNotePeriod() {
        return this.currentNotePeriod;
    }

    public final void setCurrentNotePeriod(@Nullable TimedArc timedArc) {
        this.currentNotePeriod = timedArc;
    }

    @NotNull
    protected final TimedArcCollector getTimedArcCollector() {
        TimedArcCollector timedArcCollector = this.timedArcCollector;
        if (timedArcCollector != null) {
            return timedArcCollector;
        }
        Intrinsics.throwUninitializedPropertyAccessException("timedArcCollector");
        return null;
    }

    protected final void setTimedArcCollector(@NotNull TimedArcCollector timedArcCollector) {
        Intrinsics.checkNotNullParameter(timedArcCollector, "<set-?>");
        this.timedArcCollector = timedArcCollector;
    }

    public final boolean isPlaying() {
        return this.currentNotePeriod != null;
    }

    public void tick-QTBD994(long time, long delta) {
        Unit unit;
        TimedArc timedArc = this.currentNotePeriod = (TimedArc)CollectionsKt.firstOrNull((Iterable)this.getTimedArcCollector().advance-LRDsOJo(time).getCurrentTimedArcs());
        if (timedArc != null) {
            TimedArc it = timedArc;
            boolean bl = false;
            float rotate = -((float)Duration.div-LRDsOJo(Duration.minus-LRDsOJo(it.getEndTime-UwyO8pc(), time), it.getDuration-UwyO8pc())) * this.rotationFactor;
            this.animNode.setLocalRotation(new Quaternion().fromAngles(Matrix3f.IDENTITY.getRow(this.rotationAxis.getComponentIndex()).mult(rotate).toArray(null)));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            Clone $this$tick_QTBD994_u24lambda_u241 = this;
            boolean bl = false;
            $this$tick_QTBD994_u24lambda_u241.animNode.setLocalRotation(new Quaternion());
        }
        this.hideOrShowOnPolyphony(this.parent.getClones().indexOf(this));
        this.adjustForPolyphony-LRDsOJo(delta);
    }

    public void createCollector() {
        this.setTimedArcCollector(new TimedArcCollector(this.parent.getContext(), this.arcs, null, 4, null));
    }

    /*
     * WARNING - void declaration
     */
    protected float indexForMoving() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.parent.getClones();
        float f = 0.0f;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Clone it = (Clone)element$iv$iv;
            boolean bl = false;
            if (!it.isVisible) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return RangesKt.coerceAtLeast(f, (float)list2.indexOf(this));
    }

    protected abstract void adjustForPolyphony-LRDsOJo(long var1);

    private final boolean calcVisibility() {
        if (this.currentNotePeriod != null) {
            return true;
        }
        TimedArc timedArc = this.getTimedArcCollector().prev();
        if (timedArc != null) {
            int timeGap;
            TimedArc prev = timedArc;
            boolean bl = false;
            TimedArc timedArc2 = this.getTimedArcCollector().peek();
            int n = timeGap = timedArc2 != null ? timedArc2.getStart() - prev.getEnd() : Integer.MAX_VALUE;
            if (timeGap <= this.parent.getContext().getSequence().getSmf().getTpq() * 2) {
                return true;
            }
        }
        return false;
    }

    private final void hideOrShowOnPolyphony(int index2) {
        if (index2 == 0) {
            this.highestLevel.setCullHint(Spatial.CullHint.Dynamic);
            this.isVisible = true;
        } else {
            if (this.indexForMoving() == 0.0f) {
                this.isVisible = false;
                this.highestLevel.setCullHint(Spatial.CullHint.Always);
            }
            this.highestLevel.setCullHint(UtilsKt.getCh(this.calcVisibility()));
            this.isVisible = this.calcVisibility();
        }
    }

    @NotNull
    protected final String debugProperty(@NotNull String name, @NotNull Object value) {
        String string;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        if (value instanceof Float) {
            String string2 = "%.3f";
            Object[] objectArray = new Object[]{value};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            string = "\t\t- " + name + ": " + string3 + "\n";
        } else {
            string = "\t\t- " + name + ": " + value + "\n";
        }
        return string;
    }

    @NotNull
    public String toString() {
        return "\t- " + this.getClass().getSimpleName() + "\n";
    }
}

