/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.algorithmic;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.kmidi.midi.TimedArc;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.datastructure.HeapAPQ;
import org.wysko.midis2jam2.instrument.algorithmic.Collector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00128\b\u0002\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\n\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\tH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0013j\b\u0012\u0004\u0012\u00020\u0002`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R>\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006&"}, d2={"Lorg/wysko/midis2jam2/instrument/algorithmic/TimedArcCollector;", "Lorg/wysko/midis2jam2/instrument/algorithmic/Collector;", "Lorg/wysko/kmidi/midi/TimedArc;", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "arcs", "", "releaseCondition", "Lkotlin/Function2;", "Lkotlin/time/Duration;", "Lkotlin/ParameterName;", "name", "time", "np", "", "(Lorg/wysko/midis2jam2/Midis2jam2;Ljava/util/List;Lkotlin/jvm/functions/Function2;)V", "currentIndex", "", "currentTimedArcs", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getCurrentTimedArcs", "()Ljava/util/HashSet;", "heap", "Lorg/wysko/midis2jam2/datastructure/HeapAPQ;", "", "lastRemoved", "advance", "Lorg/wysko/midis2jam2/instrument/algorithmic/TimedArcCollector$AdvanceResult;", "advance-LRDsOJo", "(J)Lorg/wysko/midis2jam2/instrument/algorithmic/TimedArcCollector$AdvanceResult;", "peek", "prev", "seek", "", "seek-LRDsOJo", "(J)V", "AdvanceResult", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTimedArcCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimedArcCollector.kt\norg/wysko/midis2jam2/instrument/algorithmic/TimedArcCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1045#2:97\n1#3:98\n*S KotlinDebug\n*F\n+ 1 TimedArcCollector.kt\norg/wysko/midis2jam2/instrument/algorithmic/TimedArcCollector\n*L\n39#1:97\n*E\n"})
public final class TimedArcCollector
implements Collector<TimedArc> {
    @NotNull
    private List<TimedArc> arcs;
    @NotNull
    private final Function2<Duration, TimedArc, Boolean> releaseCondition;
    @NotNull
    private final HashSet<TimedArc> currentTimedArcs;
    @NotNull
    private final HeapAPQ<Double, TimedArc> heap;
    private int currentIndex;
    @Nullable
    private TimedArc lastRemoved;
    public static final int $stable = 8;

    public TimedArcCollector(@NotNull Midis2jam2 context2, @NotNull List<TimedArc> arcs, @NotNull Function2<? super Duration, ? super TimedArc, Boolean> releaseCondition) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(arcs, "arcs");
        Intrinsics.checkNotNullParameter(releaseCondition, "releaseCondition");
        this.arcs = arcs;
        this.releaseCondition = releaseCondition;
        context2.registerCollector(this);
        Iterable $this$sortedBy$iv = this.arcs;
        boolean $i$f$sortedBy = false;
        this.arcs = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                TimedArc it = (TimedArc)a;
                boolean bl = false;
                Comparable comparable = Duration.box-impl(it.getStartTime-UwyO8pc());
                it = (TimedArc)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)Duration.box-impl(it.getStartTime-UwyO8pc()));
            }
        });
        this.currentTimedArcs = new HashSet();
        this.heap = new HeapAPQ(TimedArcCollector::heap$lambda$1);
    }

    public /* synthetic */ TimedArcCollector(Midis2jam2 midis2jam2, List list2, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function2 = 1.INSTANCE;
        }
        this(midis2jam2, list2, function2);
    }

    @NotNull
    public final HashSet<TimedArc> getCurrentTimedArcs() {
        return this.currentTimedArcs;
    }

    @NotNull
    public final AdvanceResult advance-LRDsOJo(long time) {
        boolean hasChanged = false;
        Set newlyRemovedTimedArcs = new LinkedHashSet();
        while (this.currentIndex < this.arcs.size() && Duration.compareTo-LRDsOJo(this.arcs.get(this.currentIndex).getStartTime-UwyO8pc(), time) <= 0) {
            TimedArc np = this.arcs.get(this.currentIndex);
            this.heap.insert(Duration.toDouble-impl(np.getEndTime-UwyO8pc(), DurationUnit.SECONDS), np);
            ((Collection)newlyRemovedTimedArcs).add(np);
            this.currentTimedArcs.add(np);
            int n = this.currentIndex;
            this.currentIndex = n + 1;
            hasChanged = true;
        }
        while (true) {
            boolean bl;
            HeapAPQ.PQEntry it;
            if (this.heap.min() != null) {
                boolean bl2 = false;
                bl = this.releaseCondition.invoke(Duration.box-impl(time), (TimedArc)it.getValue()).booleanValue();
            } else {
                bl = false;
            }
            if (!bl) break;
            if (this.heap.removeMin() == null) continue;
            boolean bl3 = false;
            this.currentTimedArcs.remove(it.getValue());
            this.lastRemoved = (TimedArc)it.getValue();
            hasChanged = true;
        }
        return new AdvanceResult((Set<TimedArc>)this.currentTimedArcs, newlyRemovedTimedArcs, hasChanged);
    }

    @Override
    public void seek-LRDsOJo(long time) {
        this.currentTimedArcs.clear();
        this.heap.clear();
        this.currentIndex = 0;
        this.lastRemoved = null;
        this.advance-LRDsOJo(time);
    }

    @Override
    @Nullable
    public TimedArc peek() {
        return CollectionsKt.getOrNull(this.arcs, this.currentIndex);
    }

    @Override
    @Nullable
    public TimedArc prev() {
        return this.lastRemoved;
    }

    private static final int heap$lambda$1(Double p0, Double p1) {
        double d = p0;
        Intrinsics.checkNotNull(p1);
        return Double.compare(d, p1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/wysko/midis2jam2/instrument/algorithmic/TimedArcCollector$AdvanceResult;", "", "currentTimedArcs", "", "Lorg/wysko/kmidi/midi/TimedArc;", "newlyRemovedTimedArcs", "hasChanged", "", "(Ljava/util/Set;Ljava/util/Set;Z)V", "getCurrentTimedArcs", "()Ljava/util/Set;", "getHasChanged", "()Z", "getNewlyRemovedTimedArcs", "midis2jam2"})
    @StabilityInferred(parameters=0)
    public static final class AdvanceResult {
        @NotNull
        private final Set<TimedArc> currentTimedArcs;
        @NotNull
        private final Set<TimedArc> newlyRemovedTimedArcs;
        private final boolean hasChanged;
        public static final int $stable = 8;

        public AdvanceResult(@NotNull Set<TimedArc> currentTimedArcs, @NotNull Set<TimedArc> newlyRemovedTimedArcs, boolean hasChanged) {
            Intrinsics.checkNotNullParameter(currentTimedArcs, "currentTimedArcs");
            Intrinsics.checkNotNullParameter(newlyRemovedTimedArcs, "newlyRemovedTimedArcs");
            this.currentTimedArcs = currentTimedArcs;
            this.newlyRemovedTimedArcs = newlyRemovedTimedArcs;
            this.hasChanged = hasChanged;
        }

        @NotNull
        public final Set<TimedArc> getCurrentTimedArcs() {
            return this.currentTimedArcs;
        }

        @NotNull
        public final Set<TimedArc> getNewlyRemovedTimedArcs() {
            return this.newlyRemovedTimedArcs;
        }

        public final boolean getHasChanged() {
            return this.hasChanged;
        }
    }
}

