/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument.algorithmic;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.TimeBasedSequence;
import org.wysko.kmidi.midi.analysis.Polyphony;
import org.wysko.kmidi.midi.event.ControlChangeEvent;
import org.wysko.kmidi.midi.event.Event;
import org.wysko.kmidi.midi.event.MidiEvent;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.kmidi.midi.event.ProgramEvent;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.Instrument;
import org.wysko.midis2jam2.instrument.SustainedInstrument;
import org.wysko.midis2jam2.instrument.family.animusic.SpaceLaser;
import org.wysko.midis2jam2.instrument.family.animusic.SpaceLaserType;
import org.wysko.midis2jam2.instrument.family.brass.FrenchHorn;
import org.wysko.midis2jam2.instrument.family.brass.StageHorns;
import org.wysko.midis2jam2.instrument.family.brass.StageHornsType;
import org.wysko.midis2jam2.instrument.family.brass.Trombone;
import org.wysko.midis2jam2.instrument.family.brass.Trumpet;
import org.wysko.midis2jam2.instrument.family.brass.TrumpetType;
import org.wysko.midis2jam2.instrument.family.brass.Tuba;
import org.wysko.midis2jam2.instrument.family.chromaticpercussion.Kalimba;
import org.wysko.midis2jam2.instrument.family.chromaticpercussion.Mallets;
import org.wysko.midis2jam2.instrument.family.chromaticpercussion.MusicBox;
import org.wysko.midis2jam2.instrument.family.chromaticpercussion.TinkleBell;
import org.wysko.midis2jam2.instrument.family.chromaticpercussion.TubularBells;
import org.wysko.midis2jam2.instrument.family.ensemble.ApplauseChoir;
import org.wysko.midis2jam2.instrument.family.ensemble.PizzicatoStrings;
import org.wysko.midis2jam2.instrument.family.ensemble.StageChoir;
import org.wysko.midis2jam2.instrument.family.ensemble.StageStrings;
import org.wysko.midis2jam2.instrument.family.ensemble.Timpani;
import org.wysko.midis2jam2.instrument.family.ethnic.BagPipe;
import org.wysko.midis2jam2.instrument.family.guitar.Banjo;
import org.wysko.midis2jam2.instrument.family.guitar.BassGuitar;
import org.wysko.midis2jam2.instrument.family.guitar.Guitar;
import org.wysko.midis2jam2.instrument.family.guitar.Shamisen;
import org.wysko.midis2jam2.instrument.family.organ.Accordion;
import org.wysko.midis2jam2.instrument.family.organ.Harmonica;
import org.wysko.midis2jam2.instrument.family.percussion.Agogo;
import org.wysko.midis2jam2.instrument.family.percussion.AuxiliaryPercussion;
import org.wysko.midis2jam2.instrument.family.percussion.Bongos;
import org.wysko.midis2jam2.instrument.family.percussion.Cabasa;
import org.wysko.midis2jam2.instrument.family.percussion.Castanets;
import org.wysko.midis2jam2.instrument.family.percussion.Claves;
import org.wysko.midis2jam2.instrument.family.percussion.Congas;
import org.wysko.midis2jam2.instrument.family.percussion.Cowbell;
import org.wysko.midis2jam2.instrument.family.percussion.Cuica;
import org.wysko.midis2jam2.instrument.family.percussion.Guiro;
import org.wysko.midis2jam2.instrument.family.percussion.HandClap;
import org.wysko.midis2jam2.instrument.family.percussion.HighQ;
import org.wysko.midis2jam2.instrument.family.percussion.JingleBell;
import org.wysko.midis2jam2.instrument.family.percussion.Maracas;
import org.wysko.midis2jam2.instrument.family.percussion.Metronome;
import org.wysko.midis2jam2.instrument.family.percussion.Shaker;
import org.wysko.midis2jam2.instrument.family.percussion.Slap;
import org.wysko.midis2jam2.instrument.family.percussion.SquareClick;
import org.wysko.midis2jam2.instrument.family.percussion.Sticks;
import org.wysko.midis2jam2.instrument.family.percussion.Surdo;
import org.wysko.midis2jam2.instrument.family.percussion.Tambourine;
import org.wysko.midis2jam2.instrument.family.percussion.Timbales;
import org.wysko.midis2jam2.instrument.family.percussion.Triangle;
import org.wysko.midis2jam2.instrument.family.percussion.Whistle;
import org.wysko.midis2jam2.instrument.family.percussion.Woodblock;
import org.wysko.midis2jam2.instrument.family.percussion.drumset.BrushDrumSet;
import org.wysko.midis2jam2.instrument.family.percussion.drumset.DrumSet;
import org.wysko.midis2jam2.instrument.family.percussion.drumset.ElectronicDrumSet;
import org.wysko.midis2jam2.instrument.family.percussion.drumset.OrchestraDrumSet;
import org.wysko.midis2jam2.instrument.family.percussion.drumset.TypicalDrumSet;
import org.wysko.midis2jam2.instrument.family.percussion.drumset.kit.ShellStyle;
import org.wysko.midis2jam2.instrument.family.percussive.Agogos;
import org.wysko.midis2jam2.instrument.family.percussive.MelodicTom;
import org.wysko.midis2jam2.instrument.family.percussive.SteelDrums;
import org.wysko.midis2jam2.instrument.family.percussive.SynthDrum;
import org.wysko.midis2jam2.instrument.family.percussive.TaikoDrum;
import org.wysko.midis2jam2.instrument.family.percussive.Woodblocks;
import org.wysko.midis2jam2.instrument.family.piano.FifthsKeyboard;
import org.wysko.midis2jam2.instrument.family.piano.Keyboard;
import org.wysko.midis2jam2.instrument.family.piano.KeyboardSkin;
import org.wysko.midis2jam2.instrument.family.pipe.BlownBottle;
import org.wysko.midis2jam2.instrument.family.pipe.Flute;
import org.wysko.midis2jam2.instrument.family.pipe.Ocarina;
import org.wysko.midis2jam2.instrument.family.pipe.PanFlute;
import org.wysko.midis2jam2.instrument.family.pipe.Piccolo;
import org.wysko.midis2jam2.instrument.family.pipe.Recorder;
import org.wysko.midis2jam2.instrument.family.pipe.Whistles;
import org.wysko.midis2jam2.instrument.family.reed.Clarinet;
import org.wysko.midis2jam2.instrument.family.reed.Oboe;
import org.wysko.midis2jam2.instrument.family.reed.sax.AltoSax;
import org.wysko.midis2jam2.instrument.family.reed.sax.BaritoneSax;
import org.wysko.midis2jam2.instrument.family.reed.sax.SopranoSax;
import org.wysko.midis2jam2.instrument.family.reed.sax.TenorSax;
import org.wysko.midis2jam2.instrument.family.soundeffects.BirdTweet;
import org.wysko.midis2jam2.instrument.family.soundeffects.Helicopter;
import org.wysko.midis2jam2.instrument.family.soundeffects.ReverseCymbal;
import org.wysko.midis2jam2.instrument.family.soundeffects.TelephoneRing;
import org.wysko.midis2jam2.instrument.family.strings.AcousticBass;
import org.wysko.midis2jam2.instrument.family.strings.Cello;
import org.wysko.midis2jam2.instrument.family.strings.Fiddle;
import org.wysko.midis2jam2.instrument.family.strings.Harp;
import org.wysko.midis2jam2.instrument.family.strings.Viola;
import org.wysko.midis2jam2.instrument.family.strings.Violin;
import org.wysko.midis2jam2.util.LoggingKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ(\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J6\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004H\u0002J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J>\u0010\u0015\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00040\u00040\u00162\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J*\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00040\u0004*\b\u0012\u0004\u0012\u00020\u001a0\u00042\n\u0010\u001b\u001a\u00020\u001c\"\u00020\rH\u0002J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0004*\b\u0012\u0004\u0012\u00020\u00100\u0004H\u0002J&\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00100\u00042\n\u0010\u001e\u001a\u00020\u001c\"\u00020\rH\u0002J&\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00100\u00042\n\u0010\u001e\u001a\u00020\u001c\"\u00020\rH\u0002J\u0010\u0010 \u001a\u00020!*\b\u0012\u0004\u0012\u00020\"0\u000f\u00a8\u0006#"}, d2={"Lorg/wysko/midis2jam2/instrument/algorithmic/InstrumentAssignment;", "", "()V", "assign", "", "Lorg/wysko/midis2jam2/instrument/Instrument;", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "midiFile", "Lorg/wysko/kmidi/midi/TimeBasedSequence;", "buildDrumSet", "Lorg/wysko/midis2jam2/instrument/family/percussion/drumset/DrumSet;", "program", "", "events", "", "Lorg/wysko/kmidi/midi/event/MidiEvent;", "buildInstrument", "", "allChannelEvents", "buildSpecialCases", "collectAuxiliary", "", "Lkotlin/reflect/KClass;", "Lorg/wysko/midis2jam2/instrument/family/percussion/AuxiliaryPercussion;", "groupNotes", "Lorg/wysko/kmidi/midi/event/NoteEvent$NoteOn;", "programNums", "", "hits", "notes", "Lorg/wysko/kmidi/midi/event/NoteEvent;", "removeDuplicateProgramEvents", "", "Lorg/wysko/kmidi/midi/event/ProgramEvent;", "midis2jam2"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nInstrumentAssignment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstrumentAssignment.kt\norg/wysko/midis2jam2/instrument/algorithmic/InstrumentAssignment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,576:1\n1360#2:577\n1446#2,5:578\n800#2,11:583\n766#2:594\n857#2,2:595\n1002#2,2:598\n800#2,11:602\n1655#2,8:613\n1855#2,2:621\n1855#2:623\n533#2,6:624\n1856#2:630\n1855#2:631\n1549#2:633\n1620#2,3:634\n1864#2,2:637\n1045#2:639\n1866#2:640\n1856#2:642\n1855#2,2:643\n800#2,11:652\n800#2,11:663\n1045#2:674\n766#2:678\n857#2,2:679\n1549#2:682\n1620#2,3:683\n1549#2:686\n1620#2,3:687\n800#2,11:690\n766#2:701\n857#2,2:702\n800#2,11:704\n766#2:715\n857#2,2:716\n800#2,11:718\n1#3:597\n13374#4,2:600\n13376#4:645\n11095#4:675\n11430#4,2:676\n11432#4:681\n215#5:632\n216#5:641\n125#5:646\n152#5,2:647\n154#5:651\n37#6,2:649\n*S KotlinDebug\n*F\n+ 1 InstrumentAssignment.kt\norg/wysko/midis2jam2/instrument/algorithmic/InstrumentAssignment\n*L\n142#1:577\n142#1:578,5\n142#1:583,11\n143#1:594\n143#1:595,2\n147#1:598,2\n159#1:602,11\n167#1:613,8\n167#1:621,2\n175#1:623\n178#1:624,6\n175#1:630\n193#1:631\n199#1:633\n199#1:634,3\n201#1:637,2\n203#1:639\n201#1:640\n193#1:642\n211#1:643,2\n233#1:652,11\n241#1:663,11\n241#1:674\n373#1:678\n373#1:679,2\n457#1:682\n457#1:683,3\n474#1:686\n474#1:687,3\n538#1:690,11\n538#1:701\n538#1:702,2\n541#1:704,11\n541#1:715\n541#1:716,2\n543#1:718,11\n157#1:600,2\n157#1:645\n373#1:675\n373#1:676,2\n373#1:681\n197#1:632\n197#1:641\n219#1:646\n219#1:647,2\n219#1:651\n220#1:649,2\n*E\n"})
public final class InstrumentAssignment {
    @NotNull
    public static final InstrumentAssignment INSTANCE = new InstrumentAssignment();
    public static final int $stable;

    private InstrumentAssignment() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Instrument> assign(@NotNull Midis2jam2 context2, @NotNull TimeBasedSequence midiFile) {
        void $this$mapTo$iv$iv;
        List[] channels;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(midiFile, "midiFile");
        Iterable $this$flatMap$iv = midiFile.getSmf().getTracks();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            StandardMidiFile.Track it = (StandardMidiFile.Track)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.getEvents();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo22 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MidiEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List[] $this$assign_u24lambda_u242 = (List[])destination$iv$iv;
        boolean bl = false;
        List[] $i$f$filterIsInstanceTo22 = new List[16];
        for (int destination$iv$iv2 = 0; destination$iv$iv2 < 16; ++destination$iv$iv2) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object element$iv$iv;
            int n = destination$iv$iv2;
            element$iv$iv = (Iterable)$this$assign_u24lambda_u242;
            int list$iv$iv = n;
            List[] bl2 = $i$f$filterIsInstanceTo22;
            boolean $i$f$filter = false;
            void var14_36 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                MidiEvent it = (MidiEvent)element$iv$iv2;
                boolean bl3 = false;
                if (!(it.getChannel() == n)) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            List list2 = (List)destination$iv$iv3;
            bl2[list$iv$iv] = CollectionsKt.toMutableList(list2);
        }
        for (List channel : $this$assign_u24lambda_u242 = (channels = $i$f$filterIsInstanceTo22)) {
            boolean bl4 = false;
            List $this$sortBy$iv = channel;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() <= 1) continue;
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    MidiEvent it = (MidiEvent)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getTick());
                    it = (MidiEvent)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getTick());
                }
            });
        }
        List instruments = new ArrayList();
        Map auxiliary = new LinkedHashMap();
        List[] $this$forEachIndexed$iv = channels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (List item$iv : $this$forEachIndexed$iv) {
            Map<KClass<? extends AuxiliaryPercussion>, List<List<MidiEvent>>> it;
            Object event;
            Iterator $this$forEach$iv;
            Object key$iv;
            ProgramEvent it2;
            void $this$filterIsInstanceTo$iv$iv2;
            void channelSpecificEvents;
            int n = index$iv++;
            List $i$f$sortBy = item$iv;
            int channel = n;
            boolean bl5 = false;
            Iterable $this$filterIsInstance$iv2 = (Iterable)channelSpecificEvents;
            boolean $i$f$filterIsInstance2 = false;
            Iterable iterable2 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof ProgramEvent)) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List<ProgramEvent> programEvents = CollectionsKt.toMutableList((List)destination$iv$iv4);
            if (programEvents.isEmpty()) {
                ((Collection)programEvents).add(new ProgramEvent(0, (byte)channel, 0));
            }
            INSTANCE.removeDuplicateProgramEvents(programEvents);
            Map $this$assign_u24lambda_u2421_u24lambda_u247 = $i$f$filterIsInstance2 = MapsKt.createMapBuilder();
            boolean bl6 = false;
            Iterable $this$distinctBy$iv = programEvents;
            boolean $i$f$distinctBy = false;
            Object set$iv = new HashSet();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                it2 = (ProgramEvent)e$iv;
                boolean bl7 = false;
                key$iv = it2.getProgram();
                if (!((HashSet)set$iv).add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            $this$distinctBy$iv = list$iv;
            boolean $i$f$forEach = false;
            set$iv = $this$forEach$iv.iterator();
            while (set$iv.hasNext()) {
                Object element$iv = set$iv.next();
                ProgramEvent it3 = (ProgramEvent)element$iv;
                boolean bl8 = false;
                key$iv = $this$assign_u24lambda_u2421_u24lambda_u247;
                Pair<Byte, List> bl7 = TuplesKt.to(it3.getProgram(), (List)new ArrayList());
                key$iv.put(bl7.getFirst(), bl7.getSecond());
            }
            Map programBins = MapsKt.build($i$f$filterIsInstance2);
            Map programPerNote = new LinkedHashMap();
            Iterable $this$forEach$iv2 = (Iterable)channelSpecificEvents;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Unit unit;
                event = (MidiEvent)element$iv;
                boolean bl9 = false;
                if (!(event instanceof NoteEvent.NoteOff)) {
                    ProgramEvent programEvent;
                    block33: {
                        List<ProgramEvent> $this$lastOrNull$iv = programEvents;
                        boolean $i$f$lastOrNull = false;
                        ListIterator<ProgramEvent> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            ProgramEvent element$iv2 = iterator$iv.previous();
                            it = element$iv2;
                            boolean bl10 = false;
                            if (!(((ProgramEvent)((Object)it)).getTick() <= ((MidiEvent)event).getTick())) continue;
                            programEvent = element$iv2;
                            break block33;
                        }
                        programEvent = null;
                    }
                    ProgramEvent programEvent2 = programEvent;
                    byte currentProgram = programEvent2 != null ? programEvent2.getProgram() : (byte)0;
                    List list3 = (List)programBins.get(currentProgram);
                    if (list3 != null) {
                        ((Collection)list3).add(event);
                        v4 = Unit.INSTANCE;
                    } else {
                        v4 = null;
                    }
                    if (!(event instanceof NoteEvent.NoteOn)) continue;
                    Byte $i$f$lastOrNull = currentProgram;
                    programPerNote.put(((NoteEvent.NoteOn)event).getNote(), $i$f$lastOrNull);
                    continue;
                }
                List list4 = (List)programBins.get(programPerNote.get(((NoteEvent.NoteOff)event).getNote()));
                if (list4 != null) {
                    ((Collection)list4).add(event);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) continue;
                boolean bl11 = false;
                LoggingKt.logger(INSTANCE).warn("Unbalanced MIDI note events.");
            }
            if (channel == 9) {
                $this$forEach$iv2 = programBins.entrySet();
                $i$f$forEach2 = false;
                $this$forEach$iv = $this$forEach$iv2.iterator();
                while ($this$forEach$iv.hasNext()) {
                    List value;
                    Object element$iv = $this$forEach$iv.next();
                    event = (Map.Entry)element$iv;
                    boolean bl12 = false;
                    byte key = ((Number)event.getKey()).byteValue();
                    if (INSTANCE.buildDrumSet(context2, key, value = (List)event.getValue()) != null) {
                        DrumSet it4;
                        boolean bl13 = false;
                        ((Collection)instruments).add(it4);
                        v7 = Unit.INSTANCE;
                    } else {
                        v7 = null;
                    }
                    it = INSTANCE.buildSpecialCases(context2, key, value);
                    boolean bl14 = false;
                    CollectionsKt.addAll((Collection)instruments, (Iterable)((Object)it));
                    it = INSTANCE.collectAuxiliary(key, value);
                    boolean bl15 = false;
                    Map<KClass<? extends AuxiliaryPercussion>, List<List<MidiEvent>>> $this$forEach$iv3 = it;
                    boolean $i$f$forEach3 = false;
                    Iterator<Map.Entry<KClass<? extends AuxiliaryPercussion>, List<List<MidiEvent>>>> iterator2 = $this$forEach$iv3.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<KClass<? extends AuxiliaryPercussion>, List<List<MidiEvent>>> element$iv3;
                        Map.Entry<KClass<? extends AuxiliaryPercussion>, List<List<MidiEvent>>> entry = element$iv3 = iterator2.next();
                        boolean bl16 = false;
                        KClass<? extends AuxiliaryPercussion> t = entry.getKey();
                        List<List<MidiEvent>> u = entry.getValue();
                        if (auxiliary.get(t) == null) {
                            void $this$mapTo$iv$iv2;
                            Map map2 = auxiliary;
                            List $this$map$iv = u;
                            boolean $i$f$map = false;
                            List list5 = $this$map$iv;
                            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                void it5;
                                List list6 = (List)item$iv$iv;
                                Collection collection = destination$iv$iv5;
                                boolean bl17 = false;
                                collection.add(CollectionsKt.toMutableList((Collection)it5));
                            }
                            $this$map$iv = CollectionsKt.toMutableList((List)destination$iv$iv5);
                            map2.put(t, $this$map$iv);
                            continue;
                        }
                        Iterable $this$forEachIndexed$iv2 = u;
                        boolean $i$f$forEachIndexed2 = false;
                        int index$iv2 = 0;
                        for (Object item$iv2 : $this$forEachIndexed$iv2) {
                            void list7;
                            int n2;
                            if ((n2 = index$iv2++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            List list8 = (List)item$iv2;
                            int index2 = n2;
                            boolean bl18 = false;
                            Object v = auxiliary.get(t);
                            Intrinsics.checkNotNull(v);
                            ((List)((List)v).get(index2)).addAll((Collection)list7);
                            Object v2 = auxiliary.get(t);
                            Intrinsics.checkNotNull(v2);
                            List list9 = (List)v2;
                            Object v3 = auxiliary.get(t);
                            Intrinsics.checkNotNull(v3);
                            Iterable $this$sortedBy$iv = (Iterable)((List)v3).get(index2);
                            boolean $i$f$sortedBy = false;
                            list9.set(index2, CollectionsKt.toMutableList(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                                public final int compare(T a, T b) {
                                    MidiEvent it = (MidiEvent)a;
                                    boolean bl = false;
                                    Comparable comparable = Integer.valueOf(it.getTick());
                                    it = (MidiEvent)b;
                                    Comparable comparable2 = comparable;
                                    bl = false;
                                    return ComparisonsKt.compareValues(comparable2, it.getTick());
                                }
                            })));
                        }
                    }
                }
                continue;
            }
            $this$forEach$iv2 = programBins.entrySet();
            $i$f$forEach2 = false;
            $this$forEach$iv = $this$forEach$iv2.iterator();
            while ($this$forEach$iv.hasNext()) {
                Unit unit;
                List value;
                Object element$iv = $this$forEach$iv.next();
                event = (Map.Entry)element$iv;
                boolean bl19 = false;
                byte key = ((Number)event.getKey()).byteValue();
                if (INSTANCE.buildInstrument(context2, key, value = (List)event.getValue(), (List<? extends MidiEvent>)channelSpecificEvents) != null) {
                    boolean bl20 = false;
                    ((Collection)instruments).add(it2);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
        }
        Collection collection = instruments;
        Map $this$map$iv = auxiliary;
        boolean $i$f$map = false;
        Map channel = $this$map$iv;
        Collection destination$iv$iv6 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            KFunction kFunction;
            Collection collection2;
            block35: {
                block34: {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator3.next();
                    collection2 = destination$iv$iv6;
                    boolean bl21 = false;
                    KClass k = (KClass)entry.getKey();
                    List v = (List)entry.getValue();
                    kFunction = KClasses.getPrimaryConstructor(k);
                    if (kFunction == null) break block34;
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    spreadBuilder.add(context2);
                    Collection $this$toTypedArray$iv = v;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    spreadBuilder.addSpread(thisCollection$iv.toArray(new List[0]));
                    if ((kFunction = (AuxiliaryPercussion)kFunction.call(spreadBuilder.toArray(new Object[spreadBuilder.size()]))) != null) break block35;
                }
                throw new IllegalStateException("Invalid auxiliary percussion".toString());
            }
            collection2.add(kFunction);
        }
        Iterable iterable3 = (List)destination$iv$iv6;
        CollectionsKt.addAll(collection, iterable3);
        return instruments;
    }

    /*
     * WARNING - void declaration
     */
    private final Instrument buildInstrument(Midis2jam2 context2, byte program, List<MidiEvent> events, List<? extends MidiEvent> allChannelEvents) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv2 = events;
        boolean $i$f$filterIsInstance22 = false;
        Iterable iterable = $this$filterIsInstance$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof NoteEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List midiNoteEvents = (List)destination$iv$iv;
        Iterable $i$f$filterIsInstance22 = allChannelEvents;
        Collection collection = events;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ControlChangeEvent)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = CollectionsKt.distinct(CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv2)));
        boolean $i$f$sortedBy = false;
        List<MidiEvent> events2 = CollectionsKt.toMutableList(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                MidiEvent it = (MidiEvent)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTick());
                it = (MidiEvent)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getTick());
            }
        }));
        if (midiNoteEvents.isEmpty()) {
            return null;
        }
        return switch (program) {
            case 0 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("piano"));
            case 1 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("bright"));
            case 2 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("electric_grand"));
            case 3 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("honky_tonk"));
            case 4 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("electric_1"));
            case 5 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("electric_2"));
            case 6 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("harpsichord"));
            case 7 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("clavichord"));
            case 8 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("celesta"));
            case 9 -> new Mallets(context2, events2, Mallets.MalletType.Glockenspiel);
            case 10 -> new MusicBox(context2, events2);
            case 11 -> new Mallets(context2, events2, Mallets.MalletType.Vibraphone);
            case 12 -> new Mallets(context2, events2, Mallets.MalletType.Marimba);
            case 13 -> new Mallets(context2, events2, Mallets.MalletType.Xylophone);
            case 14, 98 -> new TubularBells(context2, events2);
            case 15, 16, 17, 18, 19, 20, 55 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("wood"));
            case 21 -> new Accordion(context2, events2, Accordion.Type.ACCORDION);
            case 22 -> new Harmonica(context2, events2);
            case 23 -> new Accordion(context2, events2, Accordion.Type.BANDONEON);
            case 24, 25, 120 -> new Guitar(context2, events2, Guitar.GuitarType.Acoustic.INSTANCE);
            case 26 -> new Guitar(context2, events2, Guitar.GuitarType.Jazz.INSTANCE);
            case 27 -> new Guitar(context2, events2, Guitar.GuitarType.Clean.INSTANCE);
            case 28 -> new Guitar(context2, events2, Guitar.GuitarType.Muted.INSTANCE);
            case 29 -> new Guitar(context2, events2, Guitar.GuitarType.Overdriven.INSTANCE);
            case 30 -> new Guitar(context2, events2, Guitar.GuitarType.Distortion.INSTANCE);
            case 31 -> new Guitar(context2, events2, Guitar.GuitarType.Harmonics.INSTANCE);
            case 32 -> new AcousticBass(context2, events2, AcousticBass.PlayingStyle.PIZZICATO);
            case 33, 34, 36, 37 -> new BassGuitar(context2, events2, BassGuitar.BassGuitarType.Standard.INSTANCE);
            case 35 -> new BassGuitar(context2, events2, BassGuitar.BassGuitarType.Fretless.INSTANCE);
            case 38 -> new BassGuitar(context2, events2, BassGuitar.BassGuitarType.Synth1.INSTANCE);
            case 39 -> new BassGuitar(context2, events2, BassGuitar.BassGuitarType.Synth2.INSTANCE);
            case 40 -> new Violin(context2, events2);
            case 41 -> new Viola(context2, events2);
            case 42 -> new Cello(context2, events2);
            case 43 -> new AcousticBass(context2, events2, AcousticBass.PlayingStyle.ARCO);
            case 44 -> new StageStrings(context2, events2, StageStrings.StageStringsType.StringEnsemble1, StageStrings.StageStringBehavior.Tremolo);
            case 45 -> new PizzicatoStrings(context2, events2);
            case 46 -> new Harp(context2, events2);
            case 47 -> new Timpani(context2, events2);
            case 48 -> new StageStrings(context2, events2, StageStrings.StageStringsType.StringEnsemble1, StageStrings.StageStringBehavior.Normal);
            case 49 -> new StageStrings(context2, events2, StageStrings.StageStringsType.StringEnsemble2, StageStrings.StageStringBehavior.Normal);
            case 50 -> new StageStrings(context2, events2, StageStrings.StageStringsType.SynthStrings1, StageStrings.StageStringBehavior.Normal);
            case 51 -> new StageStrings(context2, events2, StageStrings.StageStringsType.SynthStrings2, StageStrings.StageStringBehavior.Normal);
            case 52 -> new StageChoir(context2, events2, StageChoir.ChoirType.ChoirAahs);
            case 53 -> new StageChoir(context2, events2, StageChoir.ChoirType.VoiceOohs);
            case 54 -> new StageChoir(context2, events2, StageChoir.ChoirType.SynthVoice);
            case 56 -> new Trumpet(context2, events2, TrumpetType.Normal);
            case 57 -> new Trombone(context2, events2);
            case 58 -> new Tuba(context2, events2);
            case 59 -> new Trumpet(context2, events2, TrumpetType.Muted);
            case 60 -> new FrenchHorn(context2, events2);
            case 61 -> new StageHorns(context2, events2, StageHornsType.BrassSection.INSTANCE);
            case 62 -> new StageHorns(context2, events2, StageHornsType.SynthBrass1.INSTANCE);
            case 63 -> new StageHorns(context2, events2, StageHornsType.SynthBrass2.INSTANCE);
            case 64 -> new SopranoSax(context2, events2);
            case 65 -> new AltoSax(context2, events2);
            case 66 -> new TenorSax(context2, events2);
            case 67 -> new BaritoneSax(context2, events2);
            case 68 -> new Oboe(context2, events2);
            case 71 -> new Clarinet(context2, events2);
            case 72 -> new Piccolo(context2, events2);
            case 73 -> new Flute(context2, events2);
            case 74 -> new Recorder(context2, events2);
            case 75 -> new PanFlute(context2, events2, PanFlute.PipeSkin.WOOD);
            case 76 -> new BlownBottle(context2, events2);
            case 78 -> new Whistles(context2, events2);
            case 79 -> new Ocarina(context2, events2);
            case 80 -> Polyphony.INSTANCE.calculateMaximumPolyphony(midiNoteEvents) > 4 ? (SustainedInstrument)new Keyboard(context2, events2, KeyboardSkin.Companion.get("square_wave")) : (SustainedInstrument)new SpaceLaser(context2, events2, SpaceLaserType.Square.INSTANCE);
            case 81 -> Polyphony.INSTANCE.calculateMaximumPolyphony(midiNoteEvents) > 4 ? (SustainedInstrument)new Keyboard(context2, events2, KeyboardSkin.Companion.get("saw_wave")) : (SustainedInstrument)new SpaceLaser(context2, events2, SpaceLaserType.Saw.INSTANCE);
            case 82 -> new PanFlute(context2, events2, PanFlute.PipeSkin.GOLD);
            case 83 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("chiff"));
            case 84 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("charang"));
            case 85 -> new StageChoir(context2, events2, StageChoir.ChoirType.VoiceSynth);
            case 86 -> new FifthsKeyboard(context2, events2, KeyboardSkin.Companion.get("synth"));
            case 87 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("bass_and_lead"));
            case 88 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("new_age"));
            case 89 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("warm"));
            case 90 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("polysynth"));
            case 91 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("choir"));
            case 92 -> new StageStrings(context2, events2, StageStrings.StageStringsType.BowedSynth, StageStrings.StageStringBehavior.Normal);
            case 93 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("metallic"));
            case 94 -> new StageChoir(context2, events2, StageChoir.ChoirType.HaloSynth);
            case 95 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("sweep"));
            case 96 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("synth"));
            case 97 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("synth"));
            case 99 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("atmosphere"));
            case 100 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("synth"));
            case 101 -> new StageChoir(context2, events2, StageChoir.ChoirType.GoblinSynth);
            case 102 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("echoes"));
            case 103 -> new Keyboard(context2, events2, KeyboardSkin.Companion.get("synth"));
            case 105 -> new Banjo(context2, events2);
            case 106 -> new Shamisen(context2, events2);
            case 108 -> new Kalimba(context2, events2);
            case 109 -> new BagPipe(context2, events2);
            case 110 -> new Fiddle(context2, events2);
            case 112 -> new TinkleBell(context2, events2);
            case 113 -> new Agogos(context2, events2);
            case 114 -> new SteelDrums(context2, events2);
            case 115 -> new Woodblocks(context2, events2);
            case 116 -> new TaikoDrum(context2, events2);
            case 117 -> new MelodicTom(context2, events2);
            case 118 -> new SynthDrum(context2, events2);
            case 119 -> new ReverseCymbal(context2, events2);
            case 121 -> new StageChoir(context2, events2, StageChoir.ChoirType.SynthVoice);
            case 123 -> new BirdTweet(context2, events2);
            case 124 -> new TelephoneRing(context2, events2);
            case 125 -> new Helicopter(context2, events2);
            case 126 -> new ApplauseChoir(context2, events2);
            default -> null;
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<NoteEvent.NoteOn>> groupNotes(List<NoteEvent.NoteOn> $this$groupNotes, int ... programNums) {
        void $this$mapTo$iv$iv;
        int[] $this$map$iv = programNums;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void $this$filterTo$iv$iv;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = $this$groupNotes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                void program;
                NoteEvent.NoteOn it = (NoteEvent.NoteOn)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getNote() == program)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            collection.add((List)destination$iv$iv2);
        }
        return (List)destination$iv$iv;
    }

    private final Map<KClass<? extends AuxiliaryPercussion>, List<List<MidiEvent>>> collectAuxiliary(int program, List<MidiEvent> events) {
        Map eventMap = new LinkedHashMap();
        int n = program;
        switch (n) {
            case 0: 
            case 8: 
            case 16: 
            case 24: 
            case 25: 
            case 32: 
            case 40: {
                List<List<NoteEvent.NoteOn>> list2;
                int[] nArray;
                Object it;
                List<NoteEvent.NoteOn> list3;
                Object object = new int[]{27};
                List<NoteEvent.NoteOn> list4 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list4 != null) {
                    it = object = (Object)list4;
                    boolean bl = false;
                    nArray = new int[]{27};
                    v1 = eventMap.put(Reflection.getOrCreateKotlinClass(HighQ.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v1 = null;
                }
                object = new int[]{28};
                List<NoteEvent.NoteOn> list5 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list5 != null) {
                    it = object = (Object)list5;
                    boolean bl = false;
                    nArray = new int[]{28};
                    v3 = eventMap.put(Reflection.getOrCreateKotlinClass(Slap.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v3 = null;
                }
                object = new int[]{31};
                List<NoteEvent.NoteOn> list6 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list6 != null) {
                    it = object = (Object)list6;
                    boolean bl = false;
                    nArray = new int[]{31};
                    v5 = eventMap.put(Reflection.getOrCreateKotlinClass(Sticks.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v5 = null;
                }
                object = new int[]{32};
                List<NoteEvent.NoteOn> list7 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list7 != null) {
                    it = object = (Object)list7;
                    boolean bl = false;
                    nArray = new int[]{32};
                    v7 = eventMap.put(Reflection.getOrCreateKotlinClass(SquareClick.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v7 = null;
                }
                object = new int[]{33, 34};
                List<NoteEvent.NoteOn> list8 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list8 != null) {
                    it = object = (Object)list8;
                    boolean bl = false;
                    nArray = new int[]{33, 34};
                    v9 = eventMap.put(Reflection.getOrCreateKotlinClass(Metronome.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v9 = null;
                }
                object = new int[]{39};
                List<NoteEvent.NoteOn> list9 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list9 != null) {
                    it = object = (Object)list9;
                    boolean bl = false;
                    nArray = new int[]{39};
                    v11 = eventMap.put(Reflection.getOrCreateKotlinClass(HandClap.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v11 = null;
                }
                object = new int[]{54};
                List<NoteEvent.NoteOn> list10 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list10 != null) {
                    it = object = (Object)list10;
                    boolean bl = false;
                    nArray = new int[]{54};
                    v13 = eventMap.put(Reflection.getOrCreateKotlinClass(Tambourine.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v13 = null;
                }
                object = new int[]{56};
                List<NoteEvent.NoteOn> list11 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list11 != null) {
                    it = object = (Object)list11;
                    boolean bl = false;
                    nArray = new int[]{56};
                    v15 = eventMap.put(Reflection.getOrCreateKotlinClass(Cowbell.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v15 = null;
                }
                object = new int[]{60, 61};
                List<NoteEvent.NoteOn> list12 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list12 != null) {
                    it = object = (Object)list12;
                    boolean bl = false;
                    nArray = new int[]{60, 61};
                    v17 = eventMap.put(Reflection.getOrCreateKotlinClass(Bongos.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v17 = null;
                }
                object = new int[]{62, 63, 64};
                List<NoteEvent.NoteOn> list13 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list13 != null) {
                    it = object = (Object)list13;
                    boolean bl = false;
                    nArray = new int[]{62, 63, 64};
                    v19 = eventMap.put(Reflection.getOrCreateKotlinClass(Congas.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v19 = null;
                }
                object = new int[]{65, 66};
                List<NoteEvent.NoteOn> list14 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list14 != null) {
                    it = object = (Object)list14;
                    boolean bl = false;
                    nArray = new int[]{65, 66};
                    v21 = eventMap.put(Reflection.getOrCreateKotlinClass(Timbales.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v21 = null;
                }
                object = new int[]{67, 68};
                List<NoteEvent.NoteOn> list15 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list15 != null) {
                    it = object = (Object)list15;
                    boolean bl = false;
                    nArray = new int[]{67, 68};
                    v23 = eventMap.put(Reflection.getOrCreateKotlinClass(Agogo.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v23 = null;
                }
                object = new int[]{69};
                List<NoteEvent.NoteOn> list16 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list16 != null) {
                    it = object = (Object)list16;
                    boolean bl = false;
                    nArray = new int[]{69};
                    v25 = eventMap.put(Reflection.getOrCreateKotlinClass(Cabasa.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v25 = null;
                }
                object = new int[]{70};
                List<NoteEvent.NoteOn> list17 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list17 != null) {
                    it = object = (Object)list17;
                    boolean bl = false;
                    nArray = new int[]{70};
                    v27 = eventMap.put(Reflection.getOrCreateKotlinClass(Maracas.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v27 = null;
                }
                object = new int[]{71, 72};
                List<NoteEvent.NoteOn> list18 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list18 != null) {
                    it = object = (Object)list18;
                    boolean bl = false;
                    nArray = new int[]{71, 72};
                    v29 = eventMap.put(Reflection.getOrCreateKotlinClass(Whistle.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v29 = null;
                }
                object = new int[]{73, 74};
                List<NoteEvent.NoteOn> list19 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list19 != null) {
                    it = object = (Object)list19;
                    boolean bl = false;
                    nArray = new int[]{73, 74};
                    v31 = eventMap.put(Reflection.getOrCreateKotlinClass(Guiro.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v31 = null;
                }
                object = new int[]{75};
                List<NoteEvent.NoteOn> list20 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list20 != null) {
                    it = object = (Object)list20;
                    boolean bl = false;
                    nArray = new int[]{75};
                    v33 = eventMap.put(Reflection.getOrCreateKotlinClass(Claves.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v33 = null;
                }
                object = new int[]{76, 77};
                List<NoteEvent.NoteOn> list21 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list21 != null) {
                    it = object = (Object)list21;
                    boolean bl = false;
                    nArray = new int[]{76, 77};
                    v35 = eventMap.put(Reflection.getOrCreateKotlinClass(Woodblock.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v35 = null;
                }
                object = new int[]{78, 79};
                List<NoteEvent.NoteOn> list22 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list22 != null) {
                    it = object = (Object)list22;
                    boolean bl = false;
                    nArray = new int[]{78, 79};
                    v37 = eventMap.put(Reflection.getOrCreateKotlinClass(Cuica.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v37 = null;
                }
                object = new int[]{80, 81};
                List<NoteEvent.NoteOn> list23 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list23 != null) {
                    it = object = (Object)list23;
                    boolean bl = false;
                    nArray = new int[]{80, 81};
                    v39 = eventMap.put(Reflection.getOrCreateKotlinClass(Triangle.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v39 = null;
                }
                object = new int[]{82};
                List<NoteEvent.NoteOn> list24 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list24 != null) {
                    it = object = (Object)list24;
                    boolean bl = false;
                    nArray = new int[]{82};
                    v41 = eventMap.put(Reflection.getOrCreateKotlinClass(Shaker.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v41 = null;
                }
                object = new int[]{83};
                List<NoteEvent.NoteOn> list25 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list25 != null) {
                    it = object = (Object)list25;
                    boolean bl = false;
                    nArray = new int[]{83};
                    v43 = eventMap.put(Reflection.getOrCreateKotlinClass(JingleBell.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v43 = null;
                }
                object = new int[]{85};
                List<NoteEvent.NoteOn> list26 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list26 != null) {
                    it = object = (Object)list26;
                    boolean bl = false;
                    nArray = new int[]{85};
                    v45 = eventMap.put(Reflection.getOrCreateKotlinClass(Castanets.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v45 = null;
                }
                object = new int[]{86, 87};
                List<NoteEvent.NoteOn> list27 = list3 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list27 != null) {
                    it = object = (Object)list27;
                    boolean bl = false;
                    nArray = new int[]{86, 87};
                    list2 = eventMap.put(Reflection.getOrCreateKotlinClass(Surdo.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                    break;
                }
                list2 = null;
                break;
            }
            case 48: {
                List<List<NoteEvent.NoteOn>> list28;
                int[] nArray;
                Object it;
                List<NoteEvent.NoteOn> list29;
                Object object = new int[]{31};
                List<NoteEvent.NoteOn> list30 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list30 != null) {
                    it = object = (Object)list30;
                    boolean bl = false;
                    nArray = new int[]{31};
                    v49 = eventMap.put(Reflection.getOrCreateKotlinClass(Sticks.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v49 = null;
                }
                object = new int[]{32};
                List<NoteEvent.NoteOn> list31 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list31 != null) {
                    it = object = (Object)list31;
                    boolean bl = false;
                    nArray = new int[]{32};
                    v51 = eventMap.put(Reflection.getOrCreateKotlinClass(SquareClick.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v51 = null;
                }
                object = new int[]{33, 34};
                List<NoteEvent.NoteOn> list32 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list32 != null) {
                    it = object = (Object)list32;
                    boolean bl = false;
                    nArray = new int[]{33, 34};
                    v53 = eventMap.put(Reflection.getOrCreateKotlinClass(Metronome.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v53 = null;
                }
                object = new int[]{39, 85};
                List<NoteEvent.NoteOn> list33 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list33 != null) {
                    it = object = (Object)list33;
                    boolean bl = false;
                    v55 = eventMap.put(Reflection.getOrCreateKotlinClass(Castanets.class), CollectionsKt.listOf(it));
                } else {
                    v55 = null;
                }
                object = new int[]{54};
                List<NoteEvent.NoteOn> list34 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list34 != null) {
                    it = object = (Object)list34;
                    boolean bl = false;
                    nArray = new int[]{54};
                    v57 = eventMap.put(Reflection.getOrCreateKotlinClass(Tambourine.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v57 = null;
                }
                object = new int[]{56};
                List<NoteEvent.NoteOn> list35 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list35 != null) {
                    it = object = (Object)list35;
                    boolean bl = false;
                    nArray = new int[]{56};
                    v59 = eventMap.put(Reflection.getOrCreateKotlinClass(Cowbell.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v59 = null;
                }
                object = new int[]{60, 61};
                List<NoteEvent.NoteOn> list36 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list36 != null) {
                    it = object = (Object)list36;
                    boolean bl = false;
                    nArray = new int[]{60, 61};
                    v61 = eventMap.put(Reflection.getOrCreateKotlinClass(Bongos.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v61 = null;
                }
                object = new int[]{62, 63, 64};
                List<NoteEvent.NoteOn> list37 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list37 != null) {
                    it = object = (Object)list37;
                    boolean bl = false;
                    nArray = new int[]{62, 63, 64};
                    v63 = eventMap.put(Reflection.getOrCreateKotlinClass(Congas.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v63 = null;
                }
                object = new int[]{65, 66};
                List<NoteEvent.NoteOn> list38 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list38 != null) {
                    it = object = (Object)list38;
                    boolean bl = false;
                    nArray = new int[]{65, 66};
                    v65 = eventMap.put(Reflection.getOrCreateKotlinClass(Timbales.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v65 = null;
                }
                object = new int[]{67, 68};
                List<NoteEvent.NoteOn> list39 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list39 != null) {
                    it = object = (Object)list39;
                    boolean bl = false;
                    nArray = new int[]{67, 68};
                    v67 = eventMap.put(Reflection.getOrCreateKotlinClass(Agogo.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v67 = null;
                }
                object = new int[]{69};
                List<NoteEvent.NoteOn> list40 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list40 != null) {
                    it = object = (Object)list40;
                    boolean bl = false;
                    nArray = new int[]{69};
                    v69 = eventMap.put(Reflection.getOrCreateKotlinClass(Cabasa.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v69 = null;
                }
                object = new int[]{70};
                List<NoteEvent.NoteOn> list41 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list41 != null) {
                    it = object = (Object)list41;
                    boolean bl = false;
                    nArray = new int[]{70};
                    v71 = eventMap.put(Reflection.getOrCreateKotlinClass(Maracas.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v71 = null;
                }
                object = new int[]{71, 72};
                List<NoteEvent.NoteOn> list42 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list42 != null) {
                    it = object = (Object)list42;
                    boolean bl = false;
                    nArray = new int[]{71, 72};
                    v73 = eventMap.put(Reflection.getOrCreateKotlinClass(Whistle.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v73 = null;
                }
                object = new int[]{73, 74};
                List<NoteEvent.NoteOn> list43 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list43 != null) {
                    it = object = (Object)list43;
                    boolean bl = false;
                    nArray = new int[]{73, 74};
                    v75 = eventMap.put(Reflection.getOrCreateKotlinClass(Guiro.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v75 = null;
                }
                object = new int[]{75};
                List<NoteEvent.NoteOn> list44 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list44 != null) {
                    it = object = (Object)list44;
                    boolean bl = false;
                    nArray = new int[]{75};
                    v77 = eventMap.put(Reflection.getOrCreateKotlinClass(Claves.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v77 = null;
                }
                object = new int[]{76, 77};
                List<NoteEvent.NoteOn> list45 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list45 != null) {
                    it = object = (Object)list45;
                    boolean bl = false;
                    nArray = new int[]{76, 77};
                    v79 = eventMap.put(Reflection.getOrCreateKotlinClass(Woodblock.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v79 = null;
                }
                object = new int[]{78, 79};
                List<NoteEvent.NoteOn> list46 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list46 != null) {
                    it = object = (Object)list46;
                    boolean bl = false;
                    nArray = new int[]{78, 79};
                    v81 = eventMap.put(Reflection.getOrCreateKotlinClass(Cuica.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v81 = null;
                }
                object = new int[]{80, 81};
                List<NoteEvent.NoteOn> list47 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list47 != null) {
                    it = object = (Object)list47;
                    boolean bl = false;
                    nArray = new int[]{80, 81};
                    v83 = eventMap.put(Reflection.getOrCreateKotlinClass(Triangle.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v83 = null;
                }
                object = new int[]{82};
                List<NoteEvent.NoteOn> list48 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list48 != null) {
                    it = object = (Object)list48;
                    boolean bl = false;
                    nArray = new int[]{82};
                    v85 = eventMap.put(Reflection.getOrCreateKotlinClass(Shaker.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v85 = null;
                }
                object = new int[]{83};
                List<NoteEvent.NoteOn> list49 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list49 != null) {
                    it = object = (Object)list49;
                    boolean bl = false;
                    nArray = new int[]{83};
                    v87 = eventMap.put(Reflection.getOrCreateKotlinClass(JingleBell.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v87 = null;
                }
                object = new int[]{86, 87};
                List<NoteEvent.NoteOn> list50 = list29 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list50 != null) {
                    it = object = (Object)list50;
                    boolean bl = false;
                    nArray = new int[]{86, 87};
                    list28 = eventMap.put(Reflection.getOrCreateKotlinClass(Surdo.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                    break;
                }
                list28 = null;
                break;
            }
            case 56: {
                List<List<NoteEvent.NoteOn>> list51;
                int[] nArray;
                Object it;
                List<NoteEvent.NoteOn> list52;
                Object object = new int[]{39};
                List<NoteEvent.NoteOn> list53 = list52 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list53 != null) {
                    it = object = (Object)list53;
                    boolean bl = false;
                    nArray = new int[]{39};
                    v91 = eventMap.put(Reflection.getOrCreateKotlinClass(HighQ.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v91 = null;
                }
                object = new int[]{40};
                List<NoteEvent.NoteOn> list54 = list52 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list54 != null) {
                    it = object = (Object)list54;
                    boolean bl = false;
                    nArray = new int[]{40};
                    v93 = eventMap.put(Reflection.getOrCreateKotlinClass(Slap.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v93 = null;
                }
                object = new int[]{43};
                List<NoteEvent.NoteOn> list55 = list52 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list55 != null) {
                    it = object = (Object)list55;
                    boolean bl = false;
                    nArray = new int[]{43};
                    v95 = eventMap.put(Reflection.getOrCreateKotlinClass(Sticks.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v95 = null;
                }
                object = new int[]{44};
                List<NoteEvent.NoteOn> list56 = list52 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list56 != null) {
                    it = object = (Object)list56;
                    boolean bl = false;
                    nArray = new int[]{44};
                    v97 = eventMap.put(Reflection.getOrCreateKotlinClass(SquareClick.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                } else {
                    v97 = null;
                }
                object = new int[]{45, 46};
                List<NoteEvent.NoteOn> list57 = list52 = this.hits((List<? extends MidiEvent>)events, (int)object);
                if (list57 != null) {
                    it = object = (Object)list57;
                    boolean bl = false;
                    nArray = new int[]{45, 46};
                    list51 = eventMap.put(Reflection.getOrCreateKotlinClass(Metronome.class), INSTANCE.groupNotes((List<NoteEvent.NoteOn>)it, nArray));
                    break;
                }
                list51 = null;
            }
        }
        return eventMap;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Instrument> buildSpecialCases(Midis2jam2 context2, int program, List<MidiEvent> events) {
        List<Object> list2;
        switch (program) {
            case 24: {
                int[] nArray = new int[]{52};
                list2 = this.notes(events, nArray);
                if (list2 != null) {
                    void it;
                    Object object;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List notes = list2;
                    boolean bl = false;
                    ReverseCymbal[] reverseCymbalArray = new ReverseCymbal[1];
                    Iterable iterable = notes;
                    Midis2jam2 midis2jam2 = context2;
                    int n = 0;
                    ReverseCymbal[] reverseCymbalArray2 = reverseCymbalArray;
                    boolean $i$f$map22 = false;
                    void var16_24 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        NoteEvent noteEvent;
                        void it2;
                        NoteEvent noteEvent2 = (NoteEvent)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl2 = false;
                        void var24_39 = it2;
                        if (var24_39 instanceof NoteEvent.NoteOn) {
                            noteEvent = NoteEvent.NoteOn.copy$default((NoteEvent.NoteOn)it2, 0, (byte)0, (byte)60, (byte)0, 11, null);
                        } else if (var24_39 instanceof NoteEvent.NoteOff) {
                            noteEvent = NoteEvent.NoteOff.copy$default((NoteEvent.NoteOff)it2, 0, (byte)0, (byte)60, 3, null);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        object.add(noteEvent);
                    }
                    object = (List)destination$iv$iv;
                    Iterable $i$f$map22 = iterable = object;
                    boolean bl3 = false;
                    context2.getSequence().registerEvents((List<? extends Event>)it);
                    object = Unit.INSTANCE;
                    Iterable iterable2 = iterable;
                    Midis2jam2 midis2jam22 = midis2jam2;
                    reverseCymbalArray2[n] = new ReverseCymbal(midis2jam22, (List<? extends MidiEvent>)iterable2);
                    List<ReverseCymbal> list3 = CollectionsKt.mutableListOf(reverseCymbalArray);
                    list2 = list3;
                    if (list3 != null) break;
                }
                list2 = new ArrayList();
                break;
            }
            case 48: {
                Instrument instrument;
                Timpani timpani;
                Instrument instrument2;
                List<NoteEvent> it;
                Instrument[] instrumentArray;
                int n;
                List<NoteEvent> notes;
                Instrument[] instrumentArray2;
                Instrument[] instrumentArray3 = instrumentArray2 = new Instrument[2];
                int n2 = 0;
                int[] nArray = new int[]{41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
                List<NoteEvent> list4 = this.notes(events, nArray);
                if (list4 != null) {
                    notes = list4;
                    n = n2;
                    instrumentArray = instrumentArray3;
                    boolean bl = false;
                    instrument2 = new Timpani(context2, (List<? extends MidiEvent>)it);
                    instrumentArray3 = instrumentArray;
                    n2 = n;
                    timpani = instrument2;
                } else {
                    timpani = null;
                }
                instrumentArray3[n2] = timpani;
                Instrument[] instrumentArray4 = instrumentArray2;
                int n3 = 1;
                nArray = new int[]{88};
                List<NoteEvent> list5 = this.notes(events, nArray);
                if (list5 != null) {
                    void it3;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    it = list5;
                    n = n3;
                    instrumentArray = instrumentArray4;
                    boolean bl = false;
                    Iterable iterable = notes;
                    Midis2jam2 midis2jam2 = context2;
                    boolean $i$f$map32 = false;
                    void var13_17 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        NoteEvent noteEvent;
                        void it4;
                        NoteEvent $i$f$mapTo2 = (NoteEvent)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        void var21_36 = it4;
                        if (var21_36 instanceof NoteEvent.NoteOn) {
                            noteEvent = NoteEvent.NoteOn.copy$default((NoteEvent.NoteOn)it4, 0, (byte)0, (byte)60, (byte)0, 11, null);
                        } else if (var21_36 instanceof NoteEvent.NoteOff) {
                            noteEvent = NoteEvent.NoteOff.copy$default((NoteEvent.NoteOff)it4, 0, (byte)0, (byte)60, 3, null);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        collection.add(noteEvent);
                    }
                    Iterable $i$f$map32 = iterable = (List)destination$iv$iv;
                    boolean bl5 = false;
                    context2.getSequence().registerEvents((List<? extends Event>)it3);
                    StageChoir.ChoirType choirType = StageChoir.ChoirType.SynthVoice;
                    Iterable iterable3 = iterable;
                    Midis2jam2 midis2jam23 = midis2jam2;
                    instrument2 = new StageChoir(midis2jam23, (List<? extends MidiEvent>)iterable3, choirType);
                    instrumentArray4 = instrumentArray;
                    n3 = n;
                    instrument = instrument2;
                } else {
                    instrument = null;
                }
                instrumentArray4[n3] = instrument;
                list2 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.mutableListOf(instrumentArray2));
                break;
            }
            case 56: {
                SustainedInstrument sustainedInstrument;
                ApplauseChoir applauseChoir;
                SustainedInstrument sustainedInstrument2;
                List<NoteEvent> it;
                SustainedInstrument[] sustainedInstrumentArray;
                int n;
                SustainedInstrument[] sustainedInstrumentArray2;
                SustainedInstrument[] sustainedInstrumentArray3 = sustainedInstrumentArray2 = new SustainedInstrument[2];
                int n4 = 0;
                int[] nArray = new int[]{58};
                List<NoteEvent> list6 = this.notes(events, nArray);
                if (list6 != null) {
                    List<NoteEvent> notes = list6;
                    n = n4;
                    sustainedInstrumentArray = sustainedInstrumentArray3;
                    boolean bl = false;
                    sustainedInstrument2 = new ApplauseChoir(context2, (List<? extends MidiEvent>)it);
                    sustainedInstrumentArray3 = sustainedInstrumentArray;
                    n4 = n;
                    applauseChoir = sustainedInstrument2;
                } else {
                    applauseChoir = null;
                }
                sustainedInstrumentArray3[n4] = applauseChoir;
                SustainedInstrument[] sustainedInstrumentArray4 = sustainedInstrumentArray2;
                int n5 = 1;
                nArray = new int[]{70};
                List<NoteEvent> list7 = this.notes(events, nArray);
                if (list7 != null) {
                    it = list7;
                    n = n5;
                    sustainedInstrumentArray = sustainedInstrumentArray4;
                    boolean bl = false;
                    sustainedInstrument2 = new Helicopter(context2, it);
                    sustainedInstrumentArray4 = sustainedInstrumentArray;
                    n5 = n;
                    sustainedInstrument = sustainedInstrument2;
                } else {
                    sustainedInstrument = null;
                }
                sustainedInstrumentArray4[n5] = sustainedInstrument;
                list2 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.mutableListOf(sustainedInstrumentArray2));
                break;
            }
            default: {
                list2 = new ArrayList();
            }
        }
        return list2;
    }

    private final DrumSet buildDrumSet(Midis2jam2 context2, int program, List<MidiEvent> events) {
        if (this.hits(events).isEmpty()) {
            return null;
        }
        return switch (program) {
            case 24 -> new ElectronicDrumSet(context2, this.hits(events));
            case 25 -> new TypicalDrumSet(context2, ShellStyle.AlternativeDrumShell.Analog.INSTANCE, this.hits(events));
            case 40 -> new BrushDrumSet(context2, this.hits(events));
            case 48 -> new OrchestraDrumSet(context2, this.hits(events));
            default -> {
                ShellStyle.TypicalDrumShell v1 = ShellStyle.TypicalDrumShell.Companion.fromProgramNumber((byte)program);
                if (v1 == null) {
                    v1 = ShellStyle.TypicalDrumShell.Standard.INSTANCE;
                }
                yield new TypicalDrumSet(context2, v1, this.hits(events));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<NoteEvent> notes(List<? extends MidiEvent> $this$notes, int ... notes) {
        Collection collection;
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$notes;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof NoteEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NoteEvent it = (NoteEvent)element$iv$iv;
            boolean bl = false;
            if (!ArraysKt.contains(notes, (int)it.getNote())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection2 = (List)destination$iv$iv;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = null;
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    private final List<NoteEvent.NoteOn> hits(List<? extends MidiEvent> $this$hits, int ... notes) {
        Collection collection;
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$hits;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof NoteEvent.NoteOn)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NoteEvent.NoteOn it = (NoteEvent.NoteOn)element$iv$iv;
            boolean bl = false;
            if (!ArraysKt.contains(notes, (int)it.getNote())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection2 = (List)destination$iv$iv;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = null;
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    private final List<NoteEvent.NoteOn> hits(List<? extends MidiEvent> $this$hits) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$hits;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof NoteEvent.NoteOn)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void removeDuplicateProgramEvents(@NotNull List<ProgramEvent> $this$removeDuplicateProgramEvents) {
        int i;
        Intrinsics.checkNotNullParameter($this$removeDuplicateProgramEvents, "<this>");
        for (i = $this$removeDuplicateProgramEvents.size() - 2; -1 < i; --i) {
            while (i < $this$removeDuplicateProgramEvents.size() - 1 && $this$removeDuplicateProgramEvents.get(i).getTick() == $this$removeDuplicateProgramEvents.get(i + 1).getTick()) {
                $this$removeDuplicateProgramEvents.remove(i);
            }
        }
        for (i = $this$removeDuplicateProgramEvents.size() - 2; -1 < i; --i) {
            while (i != $this$removeDuplicateProgramEvents.size() - 1 && $this$removeDuplicateProgramEvents.get(i).getProgram() == $this$removeDuplicateProgramEvents.get(i + 1).getProgram()) {
                $this$removeDuplicateProgramEvents.remove(i + 1);
            }
        }
    }
}

