/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.instrument;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.MultipleInstancesLinearAdjustment;
import org.wysko.midis2jam2.instrument.MultipleInstancesRadialAdjustment;
import org.wysko.midis2jam2.instrument.family.percussion.drumset.DrumSet;
import org.wysko.midis2jam2.starter.configuration.ConfigurationKt;
import org.wysko.midis2jam2.starter.configuration.SettingsConfiguration;
import org.wysko.midis2jam2.util.JmeDslKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\b\u0010!\u001a\u00020\u0012H\u0002J$\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u001e2\b\b\u0002\u0010$\u001a\u00020\u0012H&\u00f8\u0001\u0000\u00a2\u0006\u0004\b%\u0010&J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000(H\u0014J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00000(H\u0014J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u0001H\u0004J\b\u0010-\u001a\u00020\u001cH\u0014J\b\u0010.\u001a\u00020\u001cH\u0014J\"\u0010/\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001eH&\u00f8\u0001\u0000\u00a2\u0006\u0004\b0\u00101J\b\u00102\u001a\u00020+H\u0016J\u001a\u00103\u001a\u0002042\u0006\u0010\u001d\u001a\u00020\u001eH\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b5\u00106R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R&\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u0011\u0010\u0019\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\n\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00067"}, d2={"Lorg/wysko/midis2jam2/instrument/Instrument;", "", "context", "Lorg/wysko/midis2jam2/Midis2jam2;", "(Lorg/wysko/midis2jam2/Midis2jam2;)V", "getContext", "()Lorg/wysko/midis2jam2/Midis2jam2;", "geometry", "Lcom/jme3/scene/Node;", "getGeometry", "()Lcom/jme3/scene/Node;", "index", "", "getIndex", "()D", "setIndex", "(D)V", "value", "", "isVisible", "()Z", "setVisible", "(Z)V", "placement", "getPlacement", "root", "getRoot", "adjustForMultipleInstances", "", "delta", "Lkotlin/time/Duration;", "adjustForMultipleInstances-LRDsOJo", "(J)V", "alwaysVisible", "calculateVisibility", "time", "future", "calculateVisibility-VtjQ1oo", "(JZ)Z", "findSimilar", "", "findSimilarAndVisible", "formatProperty", "", "name", "onEntry", "onExit", "tick", "tick-QTBD994", "(JJ)V", "toString", "updateInstrumentIndex", "", "updateInstrumentIndex-LRDsOJo", "(J)F", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nInstrument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instrument.kt\norg/wysko/midis2jam2/instrument/Instrument\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n766#2:212\n857#2,2:213\n766#2:215\n857#2,2:216\n*S KotlinDebug\n*F\n+ 1 Instrument.kt\norg/wysko/midis2jam2/instrument/Instrument\n*L\n187#1:212\n187#1:213,2\n192#1:215\n192#1:216,2\n*E\n"})
public abstract class Instrument {
    @NotNull
    private final Midis2jam2 context;
    @NotNull
    private final Node root;
    @NotNull
    private final Node placement;
    @NotNull
    private final Node geometry;
    private double index;
    private boolean isVisible;
    public static final int $stable = 8;

    public Instrument(@NotNull Midis2jam2 context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.root = JmeDslKt.node$default(null, 1, null);
        this.placement = JmeDslKt.node$default(null, 1, null);
        this.geometry = JmeDslKt.node$default(null, 1, null);
        this.isVisible = true;
        JmeDslKt.plusAssign(this.placement, this.geometry);
        JmeDslKt.plusAssign(this.root, this.placement);
        JmeDslKt.plusAssign(this.context.getRoot(), this.root);
    }

    @NotNull
    public final Midis2jam2 getContext() {
        return this.context;
    }

    @NotNull
    public final Node getRoot() {
        return this.root;
    }

    @NotNull
    public final Node getPlacement() {
        return this.placement;
    }

    @NotNull
    public final Node getGeometry() {
        return this.geometry;
    }

    public final double getIndex() {
        return this.index;
    }

    public final void setIndex(double d) {
        this.index = d;
    }

    public boolean isVisible() {
        return this.alwaysVisible() || this.isVisible;
    }

    public void setVisible(boolean value) {
        this.isVisible = value;
        Node $this$_set_isVisible__u24lambda_u240 = this.context.getRoot();
        boolean bl = false;
        if (this.alwaysVisible() || this.isVisible) {
            JmeDslKt.plusAssign($this$_set_isVisible__u24lambda_u240, this.root);
        } else {
            JmeDslKt.minusAssign($this$_set_isVisible__u24lambda_u240, this.root);
        }
    }

    private final boolean alwaysVisible() {
        return this instanceof DrumSet ? ((SettingsConfiguration)ConfigurationKt.getType(this.context.getConfigs(), Reflection.getOrCreateKotlinClass(SettingsConfiguration.class))).getInstrumentsAlwaysVisible() && Intrinsics.areEqual(this.context.getDrumSetVisibilityManager().getCurrentlyVisibleDrumSet(), this) : ((SettingsConfiguration)ConfigurationKt.getType(this.context.getConfigs(), Reflection.getOrCreateKotlinClass(SettingsConfiguration.class))).getInstrumentsAlwaysVisible();
    }

    public abstract void tick-QTBD994(long var1, long var3);

    public abstract boolean calculateVisibility-VtjQ1oo(long var1, boolean var3);

    public static /* synthetic */ boolean calculateVisibility-VtjQ1oo$default(Instrument instrument, long l, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: calculateVisibility-VtjQ1oo");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return instrument.calculateVisibility-VtjQ1oo(l, bl);
    }

    protected void onEntry() {
    }

    protected void onExit() {
    }

    protected void adjustForMultipleInstances-LRDsOJo(long delta) {
        Instrument instrument = this;
        if (instrument instanceof MultipleInstancesLinearAdjustment) {
            JmeDslKt.setLoc(this.root, JmeDslKt.times(((MultipleInstancesLinearAdjustment)((Object)this)).getMultipleInstancesDirection(), Float.valueOf(this.updateInstrumentIndex-LRDsOJo(delta))));
        } else if (instrument instanceof MultipleInstancesRadialAdjustment) {
            Spatial spatial = this.root;
            Vector3f vector3f = ((MultipleInstancesRadialAdjustment)((Object)this)).getRotationAxis().getIdentity().clone().mult(((MultipleInstancesRadialAdjustment)((Object)this)).getBaseAngle() + ((MultipleInstancesRadialAdjustment)((Object)this)).getRotationAngle() * this.updateInstrumentIndex-LRDsOJo(delta));
            Intrinsics.checkNotNullExpressionValue(vector3f, "mult(...)");
            JmeDslKt.setRot(spatial, vector3f);
        }
    }

    protected final float updateInstrumentIndex-LRDsOJo(long delta) {
        int targetIndex = this.isVisible() ? RangesKt.coerceAtLeast(this.findSimilarAndVisible().indexOf(this), 0) : this.findSimilarAndVisible().size() - 1;
        this.index += Duration.toDouble-impl(delta, DurationUnit.SECONDS) * (double)2500 * ((double)targetIndex - this.index) / 500.0;
        this.index = RangesKt.coerceAtMost(this.index, (double)this.findSimilar().size());
        return (float)this.index;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<Instrument> findSimilar() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.context.getInstruments();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Instrument it = (Instrument)element$iv$iv;
            boolean bl = false;
            if (!Reflection.getOrCreateKotlinClass(this.getClass()).isInstance(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<Instrument> findSimilarAndVisible() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.findSimilar();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Instrument it = (Instrument)element$iv$iv;
            boolean bl = false;
            if (!it.isVisible()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final String formatProperty(@NotNull String name, @NotNull Object value) {
        String string;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        if (value instanceof Float) {
            String string2 = "%.3f";
            Object[] objectArray = new Object[]{value};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            string = "\t- " + name + ": " + string3 + "\n";
        } else {
            string = "\t- " + name + ": " + value + "\n";
        }
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        String string2 = "%.3f";
        Object[] objectArray = new Object[]{this.index};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        return "* " + string + " / " + string3 + "\n";
    }
}

