/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.gui.viewmodel;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.midis2jam2.gui.viewmodel.ConfigurationViewModel;
import org.wysko.midis2jam2.gui.viewmodel.SoundBankConfigurationViewModel;
import org.wysko.midis2jam2.starter.configuration.SoundbankConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B%\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\b\u0010\u0017\u001a\u00020\u0002H\u0016J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000bR\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/wysko/midis2jam2/gui/viewmodel/SoundBankConfigurationViewModel;", "Lorg/wysko/midis2jam2/gui/viewmodel/ConfigurationViewModel;", "Lorg/wysko/midis2jam2/starter/configuration/SoundbankConfiguration;", "initialConfiguration", "onConfigurationChanged", "Lkotlin/Function1;", "", "(Lorg/wysko/midis2jam2/starter/configuration/SoundbankConfiguration;Lkotlin/jvm/functions/Function1;)V", "_soundbanks", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Ljava/io/File;", "getOnConfigurationChanged", "()Lkotlin/jvm/functions/Function1;", "soundbanks", "Lkotlinx/coroutines/flow/StateFlow;", "getSoundbanks", "()Lkotlinx/coroutines/flow/StateFlow;", "addSoundbank", "soundbank", "", "applyConfiguration", "configuration", "generateConfiguration", "removeSoundbank", "Companion", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSoundBankConfigurationViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoundBankConfigurationViewModel.kt\norg/wysko/midis2jam2/gui/viewmodel/SoundBankConfigurationViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class SoundBankConfigurationViewModel
implements ConfigurationViewModel<SoundbankConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<SoundbankConfiguration, Unit> onConfigurationChanged;
    @NotNull
    private final MutableStateFlow<Set<File>> _soundbanks;
    public static final int $stable = 8;

    public SoundBankConfigurationViewModel(@Nullable SoundbankConfiguration initialConfiguration, @NotNull Function1<? super SoundbankConfiguration, Unit> onConfigurationChanged) {
        block0: {
            Intrinsics.checkNotNullParameter(onConfigurationChanged, "onConfigurationChanged");
            this.onConfigurationChanged = onConfigurationChanged;
            this._soundbanks = StateFlowKt.MutableStateFlow(SetsKt.emptySet());
            SoundbankConfiguration soundbankConfiguration = initialConfiguration;
            if (soundbankConfiguration == null) break block0;
            SoundbankConfiguration it = soundbankConfiguration;
            boolean bl = false;
            this.applyConfiguration(it);
        }
    }

    public /* synthetic */ SoundBankConfigurationViewModel(SoundbankConfiguration soundbankConfiguration, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            soundbankConfiguration = null;
        }
        this(soundbankConfiguration, function1);
    }

    @Override
    @NotNull
    public Function1<SoundbankConfiguration, Unit> getOnConfigurationChanged() {
        return this.onConfigurationChanged;
    }

    @NotNull
    public final StateFlow<Set<File>> getSoundbanks() {
        return this._soundbanks;
    }

    public final void addSoundbank(@NotNull String soundbank) {
        Intrinsics.checkNotNullParameter(soundbank, "soundbank");
        File file = new File(soundbank);
        if (!SoundbankConfiguration.Companion.isValidSoundbankFile(file)) {
            return;
        }
        MutableStateFlow<Set<File>> mutableStateFlow = this._soundbanks;
        mutableStateFlow.setValue(SetsKt.plus(mutableStateFlow.getValue(), file));
        this.getOnConfigurationChanged().invoke(this.generateConfiguration());
    }

    public final void removeSoundbank(@NotNull File soundbank) {
        Intrinsics.checkNotNullParameter(soundbank, "soundbank");
        MutableStateFlow<Set<File>> mutableStateFlow = this._soundbanks;
        mutableStateFlow.setValue(SetsKt.minus(mutableStateFlow.getValue(), soundbank));
        this.getOnConfigurationChanged().invoke(this.generateConfiguration());
    }

    @Override
    @NotNull
    public SoundbankConfiguration generateConfiguration() {
        return new SoundbankConfiguration(this.getSoundbanks().getValue());
    }

    @Override
    public void applyConfiguration(@NotNull SoundbankConfiguration configuration) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        this._soundbanks.setValue(configuration.getSoundbanks());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a8\u0006\t"}, d2={"Lorg/wysko/midis2jam2/gui/viewmodel/SoundBankConfigurationViewModel$Companion;", "", "()V", "create", "Lorg/wysko/midis2jam2/gui/viewmodel/SoundBankConfigurationViewModel;", "onConfigurationChanged", "Lkotlin/Function1;", "Lorg/wysko/midis2jam2/starter/configuration/SoundbankConfiguration;", "", "midis2jam2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SoundBankConfigurationViewModel create(@NotNull Function1<? super SoundbankConfiguration, Unit> onConfigurationChanged) {
            Intrinsics.checkNotNullParameter(onConfigurationChanged, "onConfigurationChanged");
            return new SoundBankConfigurationViewModel(SoundbankConfiguration.Companion.getPreserver().getConfiguration(), (Function1<? super SoundbankConfiguration, Unit>)new Function1<SoundbankConfiguration, Unit>(onConfigurationChanged){
                final /* synthetic */ Function1<SoundbankConfiguration, Unit> $onConfigurationChanged;
                {
                    this.$onConfigurationChanged = $onConfigurationChanged;
                    super(1);
                }

                public final void invoke(@NotNull SoundbankConfiguration it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    this.$onConfigurationChanged.invoke(it);
                }
            });
        }

        public static /* synthetic */ SoundBankConfigurationViewModel create$default(Companion companion, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = create.1.INSTANCE;
            }
            return companion.create(function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

