/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.gui.viewmodel;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.midis2jam2.midi.search.MidiSearchEngine;
import org.wysko.midis2jam2.util.LoggingKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\nJ\b\u0010'\u001a\u00020%H\u0002J\u0006\u0010(\u001a\u00020%J\u000e\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\nJ\b\u0010+\u001a\u00020%H\u0002J\u000e\u0010,\u001a\u00020%2\u0006\u0010&\u001a\u00020\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u001d\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u0019\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00158F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00158F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0017\u00a8\u0006."}, d2={"Lorg/wysko/midis2jam2/gui/viewmodel/SearchViewModel;", "", "()V", "_indexProgress", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "_matchingMidiFiles", "", "Ljava/io/File;", "_selectedDirectory", "", "_selectedInstruments", "_showError", "_showProgress", "", "generalMidiInstruments", "getGeneralMidiInstruments", "()Ljava/util/List;", "generalMidiInstruments$delegate", "Lkotlin/Lazy;", "indexProgress", "Lkotlinx/coroutines/flow/StateFlow;", "getIndexProgress", "()Lkotlinx/coroutines/flow/StateFlow;", "matchingMidiFiles", "getMatchingMidiFiles", "searchEngine", "Lorg/wysko/midis2jam2/midi/search/MidiSearchEngine;", "selectedDirectory", "getSelectedDirectory", "selectedInstruments", "getSelectedInstruments", "showError", "getShowError", "showProgress", "getShowProgress", "addInstrument", "", "instrument", "buildSearchIndex", "cancelIndex", "directorySelected", "path", "queryMatchingFiles", "removeInstrument", "Companion", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSearchViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchViewModel.kt\norg/wysko/midis2jam2/gui/viewmodel/SearchViewModel\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n526#2:201\n511#2,2:202\n513#2,4:208\n1549#3:204\n1620#3,3:205\n1045#3:212\n*S KotlinDebug\n*F\n+ 1 SearchViewModel.kt\norg/wysko/midis2jam2/gui/viewmodel/SearchViewModel\n*L\n189#1:201\n189#1:202,2\n189#1:208,4\n190#1:204\n190#1:205,3\n191#1:212\n*E\n"})
public final class SearchViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableStateFlow<List<String>> _selectedInstruments = StateFlowKt.MutableStateFlow(CollectionsKt.emptyList());
    @NotNull
    private final MutableStateFlow<String> _selectedDirectory = StateFlowKt.MutableStateFlow("");
    @NotNull
    private final MutableStateFlow<List<File>> _matchingMidiFiles = StateFlowKt.MutableStateFlow(CollectionsKt.emptyList());
    @NotNull
    private final MutableStateFlow<Float> _indexProgress = StateFlowKt.MutableStateFlow(Float.valueOf(0.0f));
    @NotNull
    private final MutableStateFlow<Boolean> _showProgress = StateFlowKt.MutableStateFlow(false);
    @NotNull
    private final MutableStateFlow<String> _showError = StateFlowKt.MutableStateFlow(null);
    @NotNull
    private final Lazy generalMidiInstruments$delegate = LazyKt.lazy((Function0)new Function0<List<? extends String>>(this){
        final /* synthetic */ SearchViewModel this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final List<String> invoke() {
            List<String> list2;
            List<String> list3;
            try {
                List<String> list4;
                URL uRL = SearchViewModel.class.getResource("/instruments.txt");
                if (uRL != null) {
                    URL uRL2 = uRL;
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = TextStreamsKt.readBytes(uRL2);
                    list4 = StringsKt.lines(new String(byArray, charset));
                } else {
                    list4 = null;
                }
                list3 = list4;
            }
            catch (Exception exception) {
                LoggingKt.logger(this.this$0).error("An error occurred while reading instruments from /instruments.txt.", exception);
                list3 = null;
            }
            if ((list2 = list3) == null) {
                SearchViewModel $this$invoke_u24lambda_u241 = this.this$0;
                boolean bl = false;
                String $this$invoke_u24lambda_u241_u24lambda_u240 = "Could not load general MIDI instruments.";
                boolean bl2 = false;
                SearchViewModel.access$get_showError$p($this$invoke_u24lambda_u241).setValue($this$invoke_u24lambda_u241_u24lambda_u240);
                LoggingKt.logger($this$invoke_u24lambda_u241_u24lambda_u240).error($this$invoke_u24lambda_u241_u24lambda_u240);
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }
    });
    private MidiSearchEngine searchEngine;
    public static final int $stable = 8;
    @NotNull
    private static final String INSTRUMENTS_RESOURCE_PATH = "/instruments.txt";

    @NotNull
    public final StateFlow<List<String>> getSelectedInstruments() {
        return this._selectedInstruments;
    }

    @NotNull
    public final StateFlow<String> getSelectedDirectory() {
        return this._selectedDirectory;
    }

    @NotNull
    public final StateFlow<List<File>> getMatchingMidiFiles() {
        return this._matchingMidiFiles;
    }

    @NotNull
    public final StateFlow<Float> getIndexProgress() {
        return this._indexProgress;
    }

    @NotNull
    public final StateFlow<Boolean> getShowProgress() {
        return this._showProgress;
    }

    @NotNull
    public final StateFlow<String> getShowError() {
        return this._showError;
    }

    @NotNull
    public final List<String> getGeneralMidiInstruments() {
        Lazy lazy = this.generalMidiInstruments$delegate;
        return (List)lazy.getValue();
    }

    public final void directorySelected(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        this._selectedDirectory.setValue(path);
        this.buildSearchIndex();
    }

    public final void addInstrument(@NotNull String instrument) {
        Intrinsics.checkNotNullParameter(instrument, "instrument");
        MutableStateFlow<List<String>> mutableStateFlow = this._selectedInstruments;
        mutableStateFlow.setValue(CollectionsKt.plus((Collection)mutableStateFlow.getValue(), instrument));
        this.queryMatchingFiles();
    }

    public final void removeInstrument(@NotNull String instrument) {
        Intrinsics.checkNotNullParameter(instrument, "instrument");
        MutableStateFlow<List<String>> mutableStateFlow = this._selectedInstruments;
        mutableStateFlow.setValue(CollectionsKt.minus((Iterable)mutableStateFlow.getValue(), instrument));
        this.queryMatchingFiles();
    }

    public final void cancelIndex() {
        if (this.searchEngine != null) {
            MidiSearchEngine midiSearchEngine = this.searchEngine;
            if (midiSearchEngine == null) {
                Intrinsics.throwUninitializedPropertyAccessException("searchEngine");
                midiSearchEngine = null;
            }
            midiSearchEngine.cancelIndex();
        }
        this._indexProgress.setValue(Float.valueOf(0.0f));
        this._showProgress.setValue(false);
        this._selectedDirectory.setValue("");
        this._matchingMidiFiles.setValue(CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final void buildSearchIndex() {
        void engine;
        MidiSearchEngine midiSearchEngine;
        MidiSearchEngine midiSearchEngine2 = midiSearchEngine = new MidiSearchEngine(new File(this.getSelectedDirectory().getValue()), true);
        SearchViewModel searchViewModel = this;
        boolean bl = false;
        Job waitThenShowProgressTask2 = BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(Dispatchers.getIO()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SearchViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay(1000L, this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        SearchViewModel.access$get_showProgress$p(this.this$0).setValue(Boxing.boxBoolean(true));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        engine.buildIndex(new Function0<Unit>(this, waitThenShowProgressTask2){
            final /* synthetic */ SearchViewModel this$0;
            final /* synthetic */ Job $waitThenShowProgressTask;
            {
                this.this$0 = $receiver;
                this.$waitThenShowProgressTask = $waitThenShowProgressTask;
                super(0);
            }

            public final void invoke() {
                SearchViewModel.access$queryMatchingFiles(this.this$0);
                Job.DefaultImpls.cancel$default(this.$waitThenShowProgressTask, null, 1, null);
                SearchViewModel.access$get_showProgress$p(this.this$0).setValue(false);
            }
        }, (Function1<? super MidiSearchEngine.IndexingProgress, Unit>)new Function1<MidiSearchEngine.IndexingProgress, Unit>(this){
            final /* synthetic */ SearchViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MidiSearchEngine.IndexingProgress it) {
                Intrinsics.checkNotNullParameter(it, "it");
                MidiSearchEngine.IndexingProgress indexingProgress = it;
                if (indexingProgress instanceof MidiSearchEngine.IndexingProgress.Indeterminate) {
                    SearchViewModel.access$get_indexProgress$p(this.this$0).setValue(Float.valueOf(-1.0f));
                } else if (indexingProgress instanceof MidiSearchEngine.IndexingProgress.Percentage) {
                    SearchViewModel.access$get_indexProgress$p(this.this$0).setValue(Float.valueOf((float)((MidiSearchEngine.IndexingProgress.Percentage)it).getValue() / 100.0f));
                }
            }
        }, (Function1<? super Throwable, Unit>)new Function1<Throwable, Unit>(this){
            final /* synthetic */ SearchViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it instanceof OutOfMemoryError) {
                    SearchViewModel.access$get_showError$p(this.this$0).setValue("The selected directory contained too many files to search. Please select a smaller directory.");
                    LoggingKt.logger(this.this$0).warn("MIDI search indexing overflowed memory.", it);
                } else {
                    String string = "An error occurred while searching for MIDI files.";
                    SearchViewModel searchViewModel = this.this$0;
                    String $this$invoke_u24lambda_u240 = string;
                    boolean bl = false;
                    SearchViewModel.access$get_showError$p(searchViewModel).setValue($this$invoke_u24lambda_u240);
                    LoggingKt.logger($this$invoke_u24lambda_u240).error($this$invoke_u24lambda_u240, it);
                }
                this.this$0.cancelIndex();
            }
        });
        searchViewModel.searchEngine = midiSearchEngine;
    }

    /*
     * WARNING - void declaration
     */
    private final void queryMatchingFiles() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (this.searchEngine == null) {
            return;
        }
        MidiSearchEngine midiSearchEngine = this.searchEngine;
        if (midiSearchEngine == null) {
            Intrinsics.throwUninitializedPropertyAccessException("searchEngine");
            midiSearchEngine = null;
        }
        Map<File, List<Byte>> map2 = midiSearchEngine.getIndex();
        MutableStateFlow<List<File>> mutableStateFlow = this._matchingMidiFiles;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            List instruments = (List)entry.getValue();
            Iterable iterable = this.getSelectedInstruments().getValue();
            List list2 = instruments;
            boolean $i$f$map = false;
            void var14_15 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add((byte)this.getGeneralMidiInstruments().indexOf(it));
            }
            if (!list2.containsAll((List)destination$iv$iv2)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable $this$sortedBy$iv = CollectionsKt.toList(destination$iv$iv.keySet());
        boolean $i$f$sortedBy = false;
        mutableStateFlow.setValue(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                it = (File)b;
                Comparable comparable = (Comparable)((Object)string2);
                bl = false;
                String string3 = it.getName();
                Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                String string4 = string3.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                return ComparisonsKt.compareValues(comparable, (Comparable)((Object)string4));
            }
        }));
    }

    public static final /* synthetic */ MutableStateFlow access$get_showProgress$p(SearchViewModel $this) {
        return $this._showProgress;
    }

    public static final /* synthetic */ void access$queryMatchingFiles(SearchViewModel $this) {
        $this.queryMatchingFiles();
    }

    public static final /* synthetic */ MutableStateFlow access$get_indexProgress$p(SearchViewModel $this) {
        return $this._indexProgress;
    }

    public static final /* synthetic */ MutableStateFlow access$get_showError$p(SearchViewModel $this) {
        return $this._showError;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/wysko/midis2jam2/gui/viewmodel/SearchViewModel$Companion;", "", "()V", "INSTRUMENTS_RESOURCE_PATH", "", "midis2jam2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

