/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2.datastructure;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001\u001cB\u001d\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u0018\u0012\u0014\u0012\u00120\nR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\tJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J+\u0010\u0011\u001a\u00120\nR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u0014\u0018\u00010\nR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0018\u0010\u0016\u001a\u0014\u0018\u00010\nR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0006\u0010\u0017\u001a\u00020\u0010J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0018\u0012\u0014\u0012\u00120\nR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/wysko/midis2jam2/datastructure/HeapAPQ;", "K", "V", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/util/Comparator;)V", "entries", "", "Lorg/wysko/midis2jam2/datastructure/HeapAPQ$PQEntry;", "clear", "", "data", "downHeap", "index", "", "insert", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/wysko/midis2jam2/datastructure/HeapAPQ$PQEntry;", "min", "removeMin", "size", "swapEntries", "i1", "i2", "upHeap", "PQEntry", "midis2jam2"})
@StabilityInferred(parameters=0)
public final class HeapAPQ<K, V> {
    @NotNull
    private final Comparator<K> comparator;
    @NotNull
    private final List<PQEntry> entries;
    public static final int $stable = 8;

    public HeapAPQ(@NotNull Comparator<K> comparator) {
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        this.comparator = comparator;
        this.entries = new ArrayList();
    }

    @NotNull
    public final PQEntry insert(K key, V value) {
        int index2 = this.entries.size();
        PQEntry it = new PQEntry(key, value, index2);
        boolean bl = false;
        this.entries.add(it);
        this.upHeap(index2);
        return it;
    }

    @Nullable
    public final PQEntry removeMin() {
        if (this.entries.isEmpty()) {
            return null;
        }
        PQEntry entry = this.entries.get(0);
        PQEntry e = CollectionsKt.removeLast(this.entries);
        if (!((Collection)this.entries).isEmpty()) {
            this.entries.set(0, e);
            e.setIndex(0);
            this.downHeap(0);
        }
        return entry;
    }

    @Nullable
    public final PQEntry min() {
        return CollectionsKt.firstOrNull(this.entries);
    }

    @NotNull
    public final List<PQEntry> data() {
        return this.entries;
    }

    public final int size() {
        return this.entries.size();
    }

    public final void clear() {
        this.entries.clear();
    }

    private final void upHeap(int index2) {
        block1: {
            PQEntry target = this.entries.get(index2);
            PQEntry pQEntry = target.parent$midis2jam2();
            if (pQEntry == null) break block1;
            PQEntry parent2 = pQEntry;
            boolean bl = false;
            if (this.comparator.compare(target.getKey(), parent2.getKey()) < 0) {
                int parentIndex = parent2.getIndex();
                this.swapEntries(index2, parentIndex);
                this.upHeap(parentIndex);
            }
        }
    }

    private final void downHeap(int index2) {
        block2: {
            PQEntry entry = this.entries.get(index2);
            PQEntry pQEntry = entry.leftChild$midis2jam2();
            if (pQEntry == null) break block2;
            PQEntry it = pQEntry;
            boolean bl = false;
            PQEntry pQEntry2 = entry.smallestChild$midis2jam2();
            if (pQEntry2 != null) {
                int smallestChildIndex = pQEntry2.getIndex();
                if (this.comparator.compare(entry.getKey(), this.entries.get(smallestChildIndex).getKey()) > 0) {
                    this.swapEntries(entry.getIndex(), smallestChildIndex);
                    this.downHeap(smallestChildIndex);
                }
            }
        }
    }

    private final void swapEntries(int i1, int i2) {
        PQEntry e1 = this.entries.get(i1);
        PQEntry e2 = this.entries.get(i2);
        this.entries.set(i1, e2);
        this.entries.set(i2, e1);
        e1.setIndex(i2);
        e2.setIndex(i1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u000f\u001a\u0014\u0018\u00010\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u001f\u0010\u0012\u001a\u0014\u0018\u00010\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0013J\u001a\u0010\u0014\u001a\u0014\u0018\u00010\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0002J\u001f\u0010\u0015\u001a\u0014\u0018\u00010\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/wysko/midis2jam2/datastructure/HeapAPQ$PQEntry;", "", "key", "value", "index", "", "(Lorg/wysko/midis2jam2/datastructure/HeapAPQ;Ljava/lang/Object;Ljava/lang/Object;I)V", "getIndex", "()I", "setIndex", "(I)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "leftChild", "Lorg/wysko/midis2jam2/datastructure/HeapAPQ;", "leftChild$midis2jam2", "parent", "parent$midis2jam2", "rightChild", "smallestChild", "smallestChild$midis2jam2", "midis2jam2"})
    public final class PQEntry {
        private final K key;
        private final V value;
        private int index;

        public PQEntry(K key, V value, int index2) {
            this.key = key;
            this.value = value;
            this.index = index2;
        }

        public final K getKey() {
            return this.key;
        }

        public final V getValue() {
            return this.value;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @Nullable
        public final PQEntry leftChild$midis2jam2() {
            return HeapAPQ.this.entries.size() <= 2 * this.index + 1 ? null : (PQEntry)HeapAPQ.this.entries.get(2 * this.index + 1);
        }

        private final PQEntry rightChild() {
            return HeapAPQ.this.entries.size() <= 2 * this.index + 2 ? null : (PQEntry)HeapAPQ.this.entries.get(2 * this.index + 2);
        }

        @Nullable
        public final PQEntry parent$midis2jam2() {
            return this.index == 0 ? null : (PQEntry)HeapAPQ.this.entries.get((this.index - 1) / 2);
        }

        @Nullable
        public final PQEntry smallestChild$midis2jam2() {
            PQEntry[] pQEntryArray = new PQEntry[]{this.leftChild$midis2jam2(), this.rightChild()};
            List set = CollectionsKt.filterNotNull((Iterable)SetsKt.setOf(pQEntryArray));
            return set.isEmpty() ? null : (set.size() == 1 ? (PQEntry)CollectionsKt.first(set) : (HeapAPQ.this.comparator.compare(((PQEntry)set.get((int)0)).key, ((PQEntry)set.get((int)1)).key) < 0 ? (PQEntry)set.get(0) : (PQEntry)set.get(1)));
        }
    }
}

