/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.app.Application;
import com.jme3.app.LegacyApplication;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.input.FlyByCamera;
import com.jme3.input.controls.ActionListener;
import com.jme3.material.Material;
import com.jme3.post.filters.FadeFilter;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.TimeBasedSequence;
import org.wysko.kmidi.midi.event.MetaEvent;
import org.wysko.midis2jam2.instrument.Instrument;
import org.wysko.midis2jam2.instrument.algorithmic.Collector;
import org.wysko.midis2jam2.instrument.algorithmic.InstrumentAssignment;
import org.wysko.midis2jam2.instrument.family.percussion.drumset.DrumSet;
import org.wysko.midis2jam2.instrument.family.percussion.drumset.DrumSetVisibilityManager;
import org.wysko.midis2jam2.starter.configuration.Configuration;
import org.wysko.midis2jam2.starter.configuration.ConfigurationKt;
import org.wysko.midis2jam2.starter.configuration.SettingsConfiguration;
import org.wysko.midis2jam2.util.JmeDslKt;
import org.wysko.midis2jam2.util.Utils;
import org.wysko.midis2jam2.world.AssetLoader;
import org.wysko.midis2jam2.world.AssetLoaderKt;
import org.wysko.midis2jam2.world.DebugTextController;
import org.wysko.midis2jam2.world.HudController;
import org.wysko.midis2jam2.world.ShadowController;
import org.wysko.midis2jam2.world.StandController;
import org.wysko.midis2jam2.world.camera.AutoCamController;
import org.wysko.midis2jam2.world.camera.CameraAngle;
import org.wysko.midis2jam2.world.camera.CameraState;
import org.wysko.midis2jam2.world.camera.SlideCameraController;
import org.wysko.midis2jam2.world.camera.SmoothFlyByCamera;
import org.wysko.midis2jam2.world.lyric.LyricController;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\b'\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u00020\u0006J\n\u0010\u0097\u0001\u001a\u00030\u0098\u0001H&J\u001c\u0010\u0099\u0001\u001a\u00030\u0098\u00012\u0007\u0010\u009a\u0001\u001a\u00020\u00062\u0007\u0010\u009b\u0001\u001a\u00020cH\u0002J\u001d\u0010\u009c\u0001\u001a\u00030\u0098\u00012\b\u0010\u009d\u0001\u001a\u00030\u009e\u00012\u0007\u0010\u000b\u001a\u00030\u009f\u0001H\u0016J&\u0010\u00a0\u0001\u001a\u00030\u0098\u00012\u0007\u0010\u009a\u0001\u001a\u00020\u00062\u0007\u0010\u009b\u0001\u001a\u00020c2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001H\u0016J\u0011\u0010\u00a3\u0001\u001a\u00030\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u00020\u0006J\u0015\u0010\u00a4\u0001\u001a\u00030\u0098\u00012\u000b\u0010\u00a5\u0001\u001a\u0006\u0012\u0002\b\u00030/J\u001e\u0010\u00a6\u0001\u001a\u00030\u0098\u00012\u0007\u0010\u008e\u0001\u001a\u00020AH&\u00f8\u0001\u0000\u00a2\u0006\u0005\b\u00a7\u0001\u0010FJ\u001c\u0010\u00a8\u0001\u001a\u00030\u0098\u00012\u0007\u0010\u009a\u0001\u001a\u00020\u00062\u0007\u0010\u00a9\u0001\u001a\u00020cH\u0002J\n\u0010\u00aa\u0001\u001a\u00030\u0098\u0001H\u0014J\u0014\u0010\u00ab\u0001\u001a\u00030\u0098\u00012\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001H\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R$\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001e\u0010-\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0.X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u001e\u00105\u001a\u0002042\u0006\u0010&\u001a\u000204@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b6\u00107R\u000e\u00108\u001a\u000209X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010:\u001a\u00020;X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R1\u0010B\u001a\u00020A2\u0006\u0010@\u001a\u00020A8D@DX\u0084\u008e\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0012\n\u0004\bG\u0010H\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001a\u0010I\u001a\u00020JX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010%R\u001a\u0010P\u001a\u00020QX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u001a\u0010V\u001a\u00020WX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R \u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u00101\"\u0004\b`\u0010aR\u001a\u0010b\u001a\u00020cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010d\"\u0004\be\u0010fR\u001c\u0010g\u001a\u0004\u0018\u00010hX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR\u001a\u0010m\u001a\u00020cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010d\"\u0004\bo\u0010fR\u0011\u0010p\u001a\u00020q\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010sR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010uR\u001c\u0010v\u001a\u0004\u0018\u00010wX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bx\u0010y\"\u0004\bz\u0010{R\u001c\u0010|\u001a\u00020}X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0004\b~\u0010\u007f\"\u0006\b\u0080\u0001\u0010\u0081\u0001R \u0010\u0082\u0001\u001a\u00030\u0083\u0001X\u0086.\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001\"\u0006\b\u0086\u0001\u0010\u0087\u0001R \u0010\u0088\u0001\u001a\u00030\u0089\u0001X\u0086.\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008a\u0001\u0010\u008b\u0001\"\u0006\b\u008c\u0001\u0010\u008d\u0001R0\u0010\u008e\u0001\u001a\u00020A2\u0006\u0010@\u001a\u00020A@DX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0013\n\u0003\u0010\u0091\u0001\u001a\u0005\b\u008f\u0001\u0010D\"\u0005\b\u0090\u0001\u0010FR\u0013\u0010\u0092\u0001\u001a\u00020\u0006\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0093\u0001\u0010%\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u00ac\u0001"}, d2={"Lorg/wysko/midis2jam2/Midis2jam2;", "Lcom/jme3/app/state/AbstractAppState;", "Lcom/jme3/input/controls/ActionListener;", "sequence", "Lorg/wysko/kmidi/midi/TimeBasedSequence;", "fileName", "", "configs", "", "Lorg/wysko/midis2jam2/starter/configuration/Configuration;", "(Lorg/wysko/kmidi/midi/TimeBasedSequence;Ljava/lang/String;Ljava/util/Collection;)V", "app", "Lcom/jme3/app/SimpleApplication;", "getApp", "()Lcom/jme3/app/SimpleApplication;", "setApp", "(Lcom/jme3/app/SimpleApplication;)V", "assetLoader", "Lorg/wysko/midis2jam2/world/AssetLoader;", "getAssetLoader", "()Lorg/wysko/midis2jam2/world/AssetLoader;", "setAssetLoader", "(Lorg/wysko/midis2jam2/world/AssetLoader;)V", "assetManager", "Lcom/jme3/asset/AssetManager;", "getAssetManager", "()Lcom/jme3/asset/AssetManager;", "assetManager$delegate", "Lkotlin/Lazy;", "autocamController", "Lorg/wysko/midis2jam2/world/camera/AutoCamController;", "getAutocamController", "()Lorg/wysko/midis2jam2/world/camera/AutoCamController;", "setAutocamController", "(Lorg/wysko/midis2jam2/world/camera/AutoCamController;)V", "build", "getBuild", "()Ljava/lang/String;", "value", "Lorg/wysko/midis2jam2/world/camera/CameraState;", "cameraState", "getCameraState", "()Lorg/wysko/midis2jam2/world/camera/CameraState;", "setCameraState", "(Lorg/wysko/midis2jam2/world/camera/CameraState;)V", "collectors", "", "Lorg/wysko/midis2jam2/instrument/algorithmic/Collector;", "getCollectors", "()Ljava/util/List;", "getConfigs", "()Ljava/util/Collection;", "Lorg/wysko/midis2jam2/world/camera/CameraAngle;", "currentCameraAngle", "setCurrentCameraAngle", "(Lorg/wysko/midis2jam2/world/camera/CameraAngle;)V", "debugTextController", "Lorg/wysko/midis2jam2/world/DebugTextController;", "drumSetVisibilityManager", "Lorg/wysko/midis2jam2/instrument/family/percussion/drumset/DrumSetVisibilityManager;", "getDrumSetVisibilityManager", "()Lorg/wysko/midis2jam2/instrument/family/percussion/drumset/DrumSetVisibilityManager;", "setDrumSetVisibilityManager", "(Lorg/wysko/midis2jam2/instrument/family/percussion/drumset/DrumSetVisibilityManager;)V", "<set-?>", "Lkotlin/time/Duration;", "endTime", "getEndTime-UwyO8pc", "()J", "setEndTime-LRDsOJo", "(J)V", "endTime$delegate", "Lkotlin/properties/ReadWriteProperty;", "fadeFilter", "Lcom/jme3/post/filters/FadeFilter;", "getFadeFilter", "()Lcom/jme3/post/filters/FadeFilter;", "setFadeFilter", "(Lcom/jme3/post/filters/FadeFilter;)V", "getFileName", "flyByCamera", "Lorg/wysko/midis2jam2/world/camera/SmoothFlyByCamera;", "getFlyByCamera", "()Lorg/wysko/midis2jam2/world/camera/SmoothFlyByCamera;", "setFlyByCamera", "(Lorg/wysko/midis2jam2/world/camera/SmoothFlyByCamera;)V", "hudController", "Lorg/wysko/midis2jam2/world/HudController;", "getHudController", "()Lorg/wysko/midis2jam2/world/HudController;", "setHudController", "(Lorg/wysko/midis2jam2/world/HudController;)V", "instruments", "", "Lorg/wysko/midis2jam2/instrument/Instrument;", "getInstruments", "setInstruments", "(Ljava/util/List;)V", "isSongFinished", "", "()Z", "setSongFinished", "(Z)V", "lyricController", "Lorg/wysko/midis2jam2/world/lyric/LyricController;", "getLyricController", "()Lorg/wysko/midis2jam2/world/lyric/LyricController;", "setLyricController", "(Lorg/wysko/midis2jam2/world/lyric/LyricController;)V", "paused", "getPaused", "setPaused", "root", "Lcom/jme3/scene/Node;", "getRoot", "()Lcom/jme3/scene/Node;", "getSequence", "()Lorg/wysko/kmidi/midi/TimeBasedSequence;", "shadowController", "Lorg/wysko/midis2jam2/world/ShadowController;", "getShadowController", "()Lorg/wysko/midis2jam2/world/ShadowController;", "setShadowController", "(Lorg/wysko/midis2jam2/world/ShadowController;)V", "slideCamController", "Lorg/wysko/midis2jam2/world/camera/SlideCameraController;", "getSlideCamController", "()Lorg/wysko/midis2jam2/world/camera/SlideCameraController;", "setSlideCamController", "(Lorg/wysko/midis2jam2/world/camera/SlideCameraController;)V", "stage", "Lcom/jme3/scene/Spatial;", "getStage", "()Lcom/jme3/scene/Spatial;", "setStage", "(Lcom/jme3/scene/Spatial;)V", "standController", "Lorg/wysko/midis2jam2/world/StandController;", "getStandController", "()Lorg/wysko/midis2jam2/world/StandController;", "setStandController", "(Lorg/wysko/midis2jam2/world/StandController;)V", "time", "getTime-UwyO8pc", "setTime-LRDsOJo", "J", "version", "getVersion", "diffuseMaterial", "Lcom/jme3/material/Material;", "texture", "exit", "", "handleCameraSetting", "name", "isPressed", "initialize", "stateManager", "Lcom/jme3/app/state/AppStateManager;", "Lcom/jme3/app/Application;", "onAction", "tpf", "", "reflectiveMaterial", "registerCollector", "collector", "seek", "seek-LRDsOJo", "setCameraSpeed", "pressed", "togglePause", "update", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMidis2jam2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Midis2jam2.kt\norg/wysko/midis2jam2/Midis2jam2\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n1#2:369\n1#2:371\n2634#3:370\n800#3,11:372\n1360#3:383\n1446#3,5:384\n800#3,11:389\n*S KotlinDebug\n*F\n+ 1 Midis2jam2.kt\norg/wysko/midis2jam2/Midis2jam2\n*L\n235#1:371\n235#1:370\n240#1:372,11\n247#1:383\n247#1:384,5\n248#1:389,11\n*E\n"})
public abstract class Midis2jam2
extends AbstractAppState
implements ActionListener {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final TimeBasedSequence sequence;
    @NotNull
    private final String fileName;
    @NotNull
    private final Collection<Configuration> configs;
    @NotNull
    private final Node root;
    @NotNull
    private final Lazy assetManager$delegate;
    @NotNull
    private final String version;
    @NotNull
    private final String build;
    private long time;
    @NotNull
    private CameraState cameraState;
    public SimpleApplication app;
    public AssetLoader assetLoader;
    public Spatial stage;
    public DrumSetVisibilityManager drumSetVisibilityManager;
    @NotNull
    private final List<Collector<?>> collectors;
    private boolean isSongFinished;
    private boolean paused;
    @NotNull
    private final ReadWriteProperty endTime$delegate;
    protected FadeFilter fadeFilter;
    @Nullable
    private ShadowController shadowController;
    @Nullable
    private LyricController lyricController;
    public List<? extends Instrument> instruments;
    public StandController standController;
    public AutoCamController autocamController;
    public SlideCameraController slideCamController;
    public HudController hudController;
    public SmoothFlyByCamera flyByCamera;
    private DebugTextController debugTextController;
    @NotNull
    private CameraAngle currentCameraAngle;
    public static final int $stable;

    public Midis2jam2(@NotNull TimeBasedSequence sequence, @NotNull String fileName, @NotNull Collection<? extends Configuration> configs) {
        Intrinsics.checkNotNullParameter(sequence, "sequence");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(configs, "configs");
        this.sequence = sequence;
        this.fileName = fileName;
        this.configs = configs;
        this.root = new Node();
        this.assetManager$delegate = LazyKt.lazy((Function0)new Function0<AssetManager>(this){
            final /* synthetic */ Midis2jam2 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AssetManager invoke() {
                return this.this$0.getApp().getAssetManager();
            }
        });
        this.version = Utils.INSTANCE.resourceToString("/version.txt");
        this.build = Utils.INSTANCE.resourceToString("/build.txt");
        this.time = DurationKt.toDuration(-2.0, DurationUnit.SECONDS);
        this.cameraState = ((SettingsConfiguration)ConfigurationKt.getType(this.configs, Reflection.getOrCreateKotlinClass(SettingsConfiguration.class))).getStartAutocamWithSong() ? CameraState.AUTO_CAM : CameraState.FREE_CAM;
        this.collectors = new ArrayList();
        this.endTime$delegate = Delegates.INSTANCE.notNull();
        this.currentCameraAngle = CameraAngle.CAMERA_1A;
    }

    @NotNull
    public final TimeBasedSequence getSequence() {
        return this.sequence;
    }

    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final Collection<Configuration> getConfigs() {
        return this.configs;
    }

    @NotNull
    public final Node getRoot() {
        return this.root;
    }

    @NotNull
    public final AssetManager getAssetManager() {
        Lazy lazy = this.assetManager$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "getValue(...)");
        return (AssetManager)t;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getBuild() {
        return this.build;
    }

    public final long getTime-UwyO8pc() {
        return this.time;
    }

    protected final void setTime-LRDsOJo(long l) {
        this.time = l;
    }

    @NotNull
    public final CameraState getCameraState() {
        return this.cameraState;
    }

    public final void setCameraState(@NotNull CameraState value) {
        Intrinsics.checkNotNullParameter((Object)value, "value");
        this.getAutocamController().setEnabled(value == CameraState.AUTO_CAM);
        this.getFlyByCamera().setEnabled(value == CameraState.FREE_CAM);
        this.getSlideCamController().setEnabled(value == CameraState.SLIDE_CAM);
        this.cameraState = value;
    }

    @NotNull
    public final SimpleApplication getApp() {
        SimpleApplication simpleApplication = this.app;
        if (simpleApplication != null) {
            return simpleApplication;
        }
        Intrinsics.throwUninitializedPropertyAccessException("app");
        return null;
    }

    public final void setApp(@NotNull SimpleApplication simpleApplication) {
        Intrinsics.checkNotNullParameter(simpleApplication, "<set-?>");
        this.app = simpleApplication;
    }

    @NotNull
    public final AssetLoader getAssetLoader() {
        AssetLoader assetLoader = this.assetLoader;
        if (assetLoader != null) {
            return assetLoader;
        }
        Intrinsics.throwUninitializedPropertyAccessException("assetLoader");
        return null;
    }

    public final void setAssetLoader(@NotNull AssetLoader assetLoader) {
        Intrinsics.checkNotNullParameter(assetLoader, "<set-?>");
        this.assetLoader = assetLoader;
    }

    @NotNull
    public final Spatial getStage() {
        Spatial spatial = this.stage;
        if (spatial != null) {
            return spatial;
        }
        Intrinsics.throwUninitializedPropertyAccessException("stage");
        return null;
    }

    public final void setStage(@NotNull Spatial spatial) {
        Intrinsics.checkNotNullParameter(spatial, "<set-?>");
        this.stage = spatial;
    }

    @NotNull
    public final DrumSetVisibilityManager getDrumSetVisibilityManager() {
        DrumSetVisibilityManager drumSetVisibilityManager = this.drumSetVisibilityManager;
        if (drumSetVisibilityManager != null) {
            return drumSetVisibilityManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("drumSetVisibilityManager");
        return null;
    }

    public final void setDrumSetVisibilityManager(@NotNull DrumSetVisibilityManager drumSetVisibilityManager) {
        Intrinsics.checkNotNullParameter(drumSetVisibilityManager, "<set-?>");
        this.drumSetVisibilityManager = drumSetVisibilityManager;
    }

    @NotNull
    protected final List<Collector<?>> getCollectors() {
        return this.collectors;
    }

    protected final boolean isSongFinished() {
        return this.isSongFinished;
    }

    protected final void setSongFinished(boolean bl) {
        this.isSongFinished = bl;
    }

    protected final boolean getPaused() {
        return this.paused;
    }

    protected final void setPaused(boolean bl) {
        this.paused = bl;
    }

    protected final long getEndTime-UwyO8pc() {
        return ((Duration)this.endTime$delegate.getValue(this, $$delegatedProperties[0])).unbox-impl();
    }

    protected final void setEndTime-LRDsOJo(long l) {
        this.endTime$delegate.setValue(this, $$delegatedProperties[0], Duration.box-impl(l));
    }

    @NotNull
    protected final FadeFilter getFadeFilter() {
        FadeFilter fadeFilter = this.fadeFilter;
        if (fadeFilter != null) {
            return fadeFilter;
        }
        Intrinsics.throwUninitializedPropertyAccessException("fadeFilter");
        return null;
    }

    protected final void setFadeFilter(@NotNull FadeFilter fadeFilter) {
        Intrinsics.checkNotNullParameter(fadeFilter, "<set-?>");
        this.fadeFilter = fadeFilter;
    }

    @Nullable
    public final ShadowController getShadowController() {
        return this.shadowController;
    }

    public final void setShadowController(@Nullable ShadowController shadowController) {
        this.shadowController = shadowController;
    }

    @Nullable
    public final LyricController getLyricController() {
        return this.lyricController;
    }

    public final void setLyricController(@Nullable LyricController lyricController) {
        this.lyricController = lyricController;
    }

    @NotNull
    public final List<Instrument> getInstruments() {
        List<Instrument> list2 = this.instruments;
        if (list2 != null) {
            return list2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("instruments");
        return null;
    }

    public final void setInstruments(@NotNull List<? extends Instrument> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.instruments = list2;
    }

    @NotNull
    public final StandController getStandController() {
        StandController standController = this.standController;
        if (standController != null) {
            return standController;
        }
        Intrinsics.throwUninitializedPropertyAccessException("standController");
        return null;
    }

    public final void setStandController(@NotNull StandController standController) {
        Intrinsics.checkNotNullParameter(standController, "<set-?>");
        this.standController = standController;
    }

    @NotNull
    public final AutoCamController getAutocamController() {
        AutoCamController autoCamController = this.autocamController;
        if (autoCamController != null) {
            return autoCamController;
        }
        Intrinsics.throwUninitializedPropertyAccessException("autocamController");
        return null;
    }

    public final void setAutocamController(@NotNull AutoCamController autoCamController) {
        Intrinsics.checkNotNullParameter(autoCamController, "<set-?>");
        this.autocamController = autoCamController;
    }

    @NotNull
    public final SlideCameraController getSlideCamController() {
        SlideCameraController slideCameraController = this.slideCamController;
        if (slideCameraController != null) {
            return slideCameraController;
        }
        Intrinsics.throwUninitializedPropertyAccessException("slideCamController");
        return null;
    }

    public final void setSlideCamController(@NotNull SlideCameraController slideCameraController) {
        Intrinsics.checkNotNullParameter(slideCameraController, "<set-?>");
        this.slideCamController = slideCameraController;
    }

    @NotNull
    public final HudController getHudController() {
        HudController hudController = this.hudController;
        if (hudController != null) {
            return hudController;
        }
        Intrinsics.throwUninitializedPropertyAccessException("hudController");
        return null;
    }

    public final void setHudController(@NotNull HudController hudController) {
        Intrinsics.checkNotNullParameter(hudController, "<set-?>");
        this.hudController = hudController;
    }

    @NotNull
    public final SmoothFlyByCamera getFlyByCamera() {
        SmoothFlyByCamera smoothFlyByCamera = this.flyByCamera;
        if (smoothFlyByCamera != null) {
            return smoothFlyByCamera;
        }
        Intrinsics.throwUninitializedPropertyAccessException("flyByCamera");
        return null;
    }

    public final void setFlyByCamera(@NotNull SmoothFlyByCamera smoothFlyByCamera) {
        Intrinsics.checkNotNullParameter(smoothFlyByCamera, "<set-?>");
        this.flyByCamera = smoothFlyByCamera;
    }

    private final void setCurrentCameraAngle(CameraAngle value) {
        this.setCameraState(CameraState.FREE_CAM);
        this.getFlyByCamera().setTargetTransform(value.getLocation(), value.getRotation());
        this.currentCameraAngle = value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(@NotNull AppStateManager stateManager, @NotNull Application app) {
        LyricController lyricController;
        List list2;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Object it;
        Iterable $this$onEach$iv;
        void $this$initialize_u24lambda_u244;
        Object $this$initialize_u24lambda_u243;
        Node $this$initialize_u24lambda_u242;
        Object object;
        Intrinsics.checkNotNullParameter(stateManager, "stateManager");
        Intrinsics.checkNotNullParameter(app, "app");
        SettingsConfiguration settingsConfig = (SettingsConfiguration)ConfigurationKt.getType(this.configs, Reflection.getOrCreateKotlinClass(SettingsConfiguration.class));
        this.setApp((SimpleApplication)app);
        Object $this$initialize_u24lambda_u241 = this.getApp();
        boolean bl = false;
        ((LegacyApplication)$this$initialize_u24lambda_u241).getRenderer().setDefaultAnisotropicFilter(4);
        FlyByCamera $this$initialize_u24lambda_u241_u24lambda_u240 = ((SimpleApplication)$this$initialize_u24lambda_u241).getFlyByCamera();
        boolean bl2 = false;
        $this$initialize_u24lambda_u241_u24lambda_u240.unregisterInput();
        $this$initialize_u24lambda_u241_u24lambda_u240.setEnabled(false);
        this.setAssetLoader(new AssetLoader(this));
        $this$initialize_u24lambda_u241 = object = new SmoothFlyByCamera(this, new Function0<Unit>(this){
            final /* synthetic */ Midis2jam2 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.setEnabled(true);
                this.this$0.setCameraState(CameraState.FREE_CAM);
            }
        });
        Midis2jam2 midis2jam2 = this;
        boolean bl3 = false;
        ((SmoothFlyByCamera)((Object)$this$initialize_u24lambda_u242)).setActLikeNormalFlyByCamera(!settingsConfig.isCameraSmooth());
        ((SmoothFlyByCamera)((Object)$this$initialize_u24lambda_u242)).setEnabled(!settingsConfig.getStartAutocamWithSong());
        midis2jam2.setFlyByCamera((SmoothFlyByCamera)object);
        $this$initialize_u24lambda_u242 = this.root;
        midis2jam2 = this;
        boolean bl4 = false;
        midis2jam2.setStage(JmeDslKt.unaryPlus((Node)$this$initialize_u24lambda_u243, AssetLoaderKt.modelD(this, "Stage.obj", "Stage.bmp")));
        $this$initialize_u24lambda_u243 = object = new FadeFilter(0.5f);
        midis2jam2 = this;
        boolean $i$a$-apply-Midis2jam2$initialize$62 = false;
        $this$initialize_u24lambda_u244.setValue(0.0f);
        midis2jam2.setFadeFilter((FadeFilter)object);
        object = InstrumentAssignment.INSTANCE.assign(this, this.sequence);
        midis2jam2 = this;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = $i$a$-apply-Midis2jam2$initialize$62 = $this$onEach$iv;
        boolean bl5 = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            it = (Instrument)element$iv;
            boolean bl6 = false;
            JmeDslKt.plusAssign(this.root, ((Instrument)it).getRoot());
            JmeDslKt.minusAssign(this.root, ((Instrument)it).getRoot());
        }
        midis2jam2.setInstruments((List)$i$a$-apply-Midis2jam2$initialize$62);
        $this$onEach$iv = this.getInstruments();
        Midis2jam2 midis2jam22 = this;
        midis2jam2 = this;
        boolean $i$f$filterIsInstance = false;
        void $i$a$-apply-Midis2jam2$initialize$62 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DrumSet)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = list2 = (List)destination$iv$iv;
        Midis2jam2 midis2jam23 = midis2jam22;
        midis2jam2.setDrumSetVisibilityManager(new DrumSetVisibilityManager(midis2jam23, list3));
        this.setStandController(new StandController(this));
        Midis2jam2 midis2jam24 = this;
        if (settingsConfig.getShowLyrics()) {
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            $this$filterIsInstance$iv = this.sequence.getSmf().getTracks();
            midis2jam22 = this;
            midis2jam2 = midis2jam24;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (StandardMidiFile.Track)element$iv$iv;
                boolean bl7 = false;
                Iterable list$iv$iv = ((StandardMidiFile.Track)it).getEvents();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            $this$flatMap$iv = list2;
            $i$f$filterIsInstance = false;
            $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MetaEvent.Lyric)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            midis2jam24 = midis2jam2;
            List list4 = list2;
            Midis2jam2 midis2jam25 = midis2jam22;
            lyricController = new LyricController(midis2jam25, list4);
        } else {
            lyricController = null;
        }
        midis2jam24.lyricController = lyricController;
        this.setAutocamController(new AutoCamController(this, settingsConfig.getStartAutocamWithSong()));
        this.setSlideCamController(new SlideCameraController(this));
        this.debugTextController = new DebugTextController(this);
        this.setHudController(new HudController(this));
        ShadowController.Companion.configureShadows(this, this.getFadeFilter());
        if (settingsConfig.getStartAutocamWithSong()) {
            Camera $this$initialize_u24lambda_u248 = this.getApp().getCamera();
            boolean bl8 = false;
            Camera it2 = $this$initialize_u24lambda_u248;
            boolean bl9 = false;
            $this$initialize_u24lambda_u248.setLocation(it2.getLocation());
            $this$initialize_u24lambda_u248.setRotation(it2.getRotation());
        }
        super.initialize(stateManager, app);
    }

    @Override
    public void update(float tpf) {
        super.update(tpf);
        DebugTextController debugTextController = this.debugTextController;
        if (debugTextController == null) {
            Intrinsics.throwUninitializedPropertyAccessException("debugTextController");
            debugTextController = null;
        }
        debugTextController.tick-LRDsOJo(DurationKt.toDuration(tpf, DurationUnit.SECONDS));
    }

    private final void setCameraSpeed(String name, boolean pressed) {
        if (!pressed) {
            this.getFlyByCamera().setMoveSpeed(100.0f);
        } else {
            String string;
            this.getFlyByCamera().setMoveSpeed(Intrinsics.areEqual(string = name, "slow") ? 10.0f : (Intrinsics.areEqual(string, "fast") ? 200.0f : 100.0f));
        }
    }

    private final void handleCameraSetting(String name, boolean isPressed) {
        if (!isPressed) {
            return;
        }
        String string = name;
        if (Intrinsics.areEqual(string, "autoCam")) {
            this.getAutocamController().trigger();
            this.setCameraState(CameraState.AUTO_CAM);
        } else if (Intrinsics.areEqual(string, "slideCam")) {
            this.setCameraState(CameraState.SLIDE_CAM);
        }
        if (StringsKt.startsWith$default(name, "cam", false, 2, null)) {
            this.setCurrentCameraAngle(CameraAngle.Companion.handleCameraAngle(this.currentCameraAngle, name));
            this.setCameraState(CameraState.FREE_CAM);
        }
    }

    @Override
    public void onAction(@NotNull String name, boolean isPressed, float tpf) {
        block20: {
            Intrinsics.checkNotNullParameter(name, "name");
            this.setCameraSpeed(name, isPressed);
            this.handleCameraSetting(name, isPressed);
            if (!isPressed) break block20;
            switch (name) {
                case "exit": {
                    this.exit();
                    break;
                }
                case "debug": {
                    DebugTextController debugTextController = this.debugTextController;
                    if (debugTextController == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("debugTextController");
                        debugTextController = null;
                    }
                    debugTextController.toggle();
                    break;
                }
                case "seek_forward": {
                    this.seek-LRDsOJo(Duration.plus-LRDsOJo(this.time, DurationKt.toDuration(10, DurationUnit.SECONDS)));
                    break;
                }
                case "seek_backward": {
                    this.seek-LRDsOJo(RangesKt.coerceAtLeast(Duration.box-impl(Duration.minus-LRDsOJo(this.time, DurationKt.toDuration(10, DurationUnit.SECONDS))), Duration.box-impl(DurationKt.toDuration(0, DurationUnit.SECONDS))).unbox-impl());
                    break;
                }
                case "play/pause": {
                    this.togglePause();
                }
            }
        }
    }

    public abstract void seek-LRDsOJo(long var1);

    public abstract void exit();

    protected void togglePause() {
        this.paused = !this.paused;
    }

    @NotNull
    public final Material reflectiveMaterial(@NotNull String texture) {
        Intrinsics.checkNotNullParameter(texture, "texture");
        return this.getAssetLoader().reflectiveMaterial(texture);
    }

    @NotNull
    public final Material diffuseMaterial(@NotNull String texture) {
        Intrinsics.checkNotNullParameter(texture, "texture");
        return this.getAssetLoader().diffuseMaterial(texture);
    }

    public final void registerCollector(@NotNull Collector<?> collector2) {
        Intrinsics.checkNotNullParameter(collector2, "collector");
        ((Collection)this.collectors).add(collector2);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(Midis2jam2.class, "endTime", "getEndTime-UwyO8pc()J", 0))};
        $$delegatedProperties = kPropertyArray;
        $stable = 8;
    }
}

