/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.midis2jam2;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppStateManager;
import com.jme3.renderer.Camera;
import java.util.Collection;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.wysko.gervill.JwRealTimeSequencer;
import org.wysko.kmidi.midi.TimeBasedSequence;
import org.wysko.midis2jam2.Midis2jam2;
import org.wysko.midis2jam2.instrument.Instrument;
import org.wysko.midis2jam2.instrument.algorithmic.Collector;
import org.wysko.midis2jam2.starter.configuration.BackgroundConfiguration;
import org.wysko.midis2jam2.starter.configuration.Configuration;
import org.wysko.midis2jam2.starter.configuration.ConfigurationKt;
import org.wysko.midis2jam2.starter.configuration.HomeConfiguration;
import org.wysko.midis2jam2.starter.configuration.SynthesizerConfiguration;
import org.wysko.midis2jam2.util.ErrorHandling;
import org.wysko.midis2jam2.util.LoggingKt;
import org.wysko.midis2jam2.world.KeyMap;
import org.wysko.midis2jam2.world.ShadowController;
import org.wysko.midis2jam2.world.background.BackgroundController;
import org.wysko.midis2jam2.world.background.BackgroundImageFormatException;
import org.wysko.midis2jam2.world.camera.CameraAngle;
import org.wysko.midis2jam2.world.lyric.LyricController;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0000\b\u0007\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010 \u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\nH\u0016J\b\u0010\"\u001a\u00020\nH\u0002J\u0018\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u001a\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010,J\b\u0010-\u001a\u00020\nH\u0002J\b\u0010.\u001a\u00020\nH\u0002J\b\u0010/\u001a\u00020\nH\u0002J\u001a\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020*H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b2\u0010,J\b\u00103\u001a\u00020\nH\u0014J\u0010\u00104\u001a\u00020\n2\u0006\u00105\u001a\u000206H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00067"}, d2={"Lorg/wysko/midis2jam2/DesktopMidis2jam2;", "Lorg/wysko/midis2jam2/Midis2jam2;", "fileName", "", "sequencer", "Ljavax/sound/midi/Sequencer;", "midiFile", "Lorg/wysko/kmidi/midi/TimeBasedSequence;", "onClose", "Lkotlin/Function0;", "", "synthesizer", "Ljavax/sound/midi/Synthesizer;", "configs", "", "Lorg/wysko/midis2jam2/starter/configuration/Configuration;", "(Ljava/lang/String;Ljavax/sound/midi/Sequencer;Lorg/wysko/kmidi/midi/TimeBasedSequence;Lkotlin/jvm/functions/Function0;Ljavax/sound/midi/Synthesizer;Ljava/util/Collection;)V", "getFileName", "()Ljava/lang/String;", "isFadeStarted", "", "isSequencerStarted", "getMidiFile", "()Lorg/wysko/kmidi/midi/TimeBasedSequence;", "getOnClose", "()Lkotlin/jvm/functions/Function0;", "getSequencer", "()Ljavax/sound/midi/Sequencer;", "skippedFrames", "", "getSynthesizer", "()Ljavax/sound/midi/Synthesizer;", "cleanup", "exit", "handleSongCompletionAndLoopOrExit", "initialize", "stateManager", "Lcom/jme3/app/state/AppStateManager;", "app", "Lcom/jme3/app/Application;", "seek", "time", "Lkotlin/time/Duration;", "seek-LRDsOJo", "(J)V", "setSynthEffects", "startFadeIfNeeded", "startSequencerIfNeeded", "tickControllers", "delta", "tickControllers-LRDsOJo", "togglePause", "update", "tpf", "", "midis2jam2"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesktopMidis2jam2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopMidis2jam2.kt\norg/wysko/midis2jam2/DesktopMidis2jam2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,211:1\n1855#2,2:212\n1855#2,2:214\n13309#3,2:216\n13309#3,2:218\n*S KotlinDebug\n*F\n+ 1 DesktopMidis2jam2.kt\norg/wysko/midis2jam2/DesktopMidis2jam2\n*L\n108#1:212,2\n146#1:214,2\n203#1:216,2\n206#1:218,2\n*E\n"})
public final class DesktopMidis2jam2
extends Midis2jam2 {
    @NotNull
    private final String fileName;
    @NotNull
    private final Sequencer sequencer;
    @NotNull
    private final TimeBasedSequence midiFile;
    @NotNull
    private final Function0<Unit> onClose;
    @Nullable
    private final Synthesizer synthesizer;
    private boolean isSequencerStarted;
    private int skippedFrames;
    private boolean isFadeStarted;
    public static final int $stable = 8;

    public DesktopMidis2jam2(@NotNull String fileName, @NotNull Sequencer sequencer, @NotNull TimeBasedSequence midiFile, @NotNull Function0<Unit> onClose, @Nullable Synthesizer synthesizer, @NotNull Collection<? extends Configuration> configs) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(sequencer, "sequencer");
        Intrinsics.checkNotNullParameter(midiFile, "midiFile");
        Intrinsics.checkNotNullParameter(onClose, "onClose");
        Intrinsics.checkNotNullParameter(configs, "configs");
        super(midiFile, fileName, configs);
        this.fileName = fileName;
        this.sequencer = sequencer;
        this.midiFile = midiFile;
        this.onClose = onClose;
        this.synthesizer = synthesizer;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final Sequencer getSequencer() {
        return this.sequencer;
    }

    @NotNull
    public final TimeBasedSequence getMidiFile() {
        return this.midiFile;
    }

    @NotNull
    public final Function0<Unit> getOnClose() {
        return this.onClose;
    }

    @Nullable
    public final Synthesizer getSynthesizer() {
        return this.synthesizer;
    }

    @Override
    public void initialize(@NotNull AppStateManager stateManager, @NotNull Application app) {
        Intrinsics.checkNotNullParameter(stateManager, "stateManager");
        Intrinsics.checkNotNullParameter(app, "app");
        super.initialize(stateManager, app);
        LoggingKt.logger(this).debug("Initializing application...");
        KeyMap.Companion.registerMappings(app, this);
        try {
            BackgroundController.INSTANCE.configureBackground(this, (BackgroundConfiguration)ConfigurationKt.getType(this.getConfigs(), Reflection.getOrCreateKotlinClass(BackgroundConfiguration.class)), this.getRoot());
        }
        catch (BackgroundImageFormatException e) {
            this.exit();
            Logger logger = LoggingKt.logger(this);
            String string = e.getMessage();
            if (string == null) {
                string = "There was an error loading the images for the background.";
            }
            ErrorHandling.INSTANCE.errorDisp(logger, string, e);
        }
        catch (IllegalArgumentException e) {
            String string;
            this.exit();
            Logger logger = LoggingKt.logger(this);
            if (Intrinsics.areEqual(e.getMessage(), "Image width and height must be the same")) {
                string = "The background image(s) must be square.";
            } else {
                string = e.getMessage();
                if (string == null) {
                    string = "There was an error loading the images for the background.";
                }
            }
            ErrorHandling.INSTANCE.errorDisp(logger, string, e);
        }
        LoggingKt.logger(this).debug("Application initialized");
    }

    @Override
    public void cleanup() {
        LoggingKt.logger(this).debug("Cleaning up...");
        Sequencer $this$cleanup_u24lambda_u240 = this.sequencer;
        boolean bl = false;
        $this$cleanup_u24lambda_u240.stop();
        $this$cleanup_u24lambda_u240.close();
        this.onClose.invoke();
        LoggingKt.logger(this).debug("Cleanup complete");
    }

    @Override
    public void update(float tpf) {
        super.update(tpf);
        long delta = DurationKt.toDuration(tpf, DurationUnit.SECONDS);
        this.startSequencerIfNeeded();
        this.startFadeIfNeeded();
        Iterable $this$forEach$iv = this.getInstruments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Instrument it = (Instrument)element$iv;
            boolean bl = false;
            it.tick-QTBD994(this.getTime-UwyO8pc(), delta);
        }
        if (Duration.compareTo-LRDsOJo(this.getTime-UwyO8pc(), this.getSequence().getDuration-UwyO8pc()) >= 0) {
            if (!this.isSongFinished()) {
                this.setEndTime-LRDsOJo(this.getTime-UwyO8pc());
            }
            this.setSongFinished(true);
        }
        this.handleSongCompletionAndLoopOrExit();
        int n = this.skippedFrames;
        this.skippedFrames = n + 1;
        if (n < 3) {
            return;
        }
        this.tickControllers-LRDsOJo(delta);
        if (this.sequencer.isOpen() && !this.getPaused()) {
            this.setTime-LRDsOJo(Duration.plus-LRDsOJo(this.getTime-UwyO8pc(), delta));
        }
    }

    @Override
    public void exit() {
        LoggingKt.logger(this).debug("Exiting...");
        if (this.sequencer.isOpen()) {
            this.sequencer.stop();
        }
        SimpleApplication $this$exit_u24lambda_u242 = this.getApp();
        boolean bl = false;
        $this$exit_u24lambda_u242.getStateManager().detach(this);
        $this$exit_u24lambda_u242.stop(false);
        this.onClose.invoke();
        LoggingKt.logger(this).debug("Exit complete");
    }

    @Override
    public void seek-LRDsOJo(long time) {
        LoggingKt.logger(this).debug("Seeking to time: " + Duration.toString-impl(time));
        this.setTime-LRDsOJo(time);
        this.sequencer.setMicrosecondPosition(Duration.getInWholeMicroseconds-impl(RangesKt.coerceAtLeast(Duration.box-impl(time), Duration.box-impl(Duration.Companion.getZERO-UwyO8pc())).unbox-impl()));
        Iterable $this$forEach$iv = this.getCollectors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collector it = (Collector)element$iv;
            boolean bl = false;
            it.seek-LRDsOJo(time);
        }
    }

    @Override
    protected void togglePause() {
        super.togglePause();
        if (this.getPaused()) {
            this.sequencer.stop();
        } else {
            this.sequencer.start();
        }
    }

    private final void tickControllers-LRDsOJo(long delta) {
        ShadowController shadowController = this.getShadowController();
        if (shadowController != null) {
            shadowController.tick();
        }
        this.getStandController().tick();
        LyricController lyricController = this.getLyricController();
        if (lyricController != null) {
            lyricController.tick-QTBD994(this.getTime-UwyO8pc(), delta);
        }
        this.getHudController().tick-VtjQ1oo(this.getTime-UwyO8pc(), this.getFadeFilter().getValue());
        this.getFlyByCamera().tick-LRDsOJo(delta);
        this.getAutocamController().tick-QTBD994(this.getTime-UwyO8pc(), delta);
        this.getSlideCamController().tick-QTBD994(this.getTime-UwyO8pc(), delta);
        Camera camera = this.getApp().getCamera();
        Intrinsics.checkNotNullExpressionValue(camera, "getCamera(...)");
        CameraAngle.Companion.preventCameraFromLeaving(camera);
        this.getDrumSetVisibilityManager().tick-LRDsOJo(this.getTime-UwyO8pc());
    }

    private final void handleSongCompletionAndLoopOrExit() {
        if (this.isSongFinished()) {
            if (Duration.compareTo-LRDsOJo(this.getTime-UwyO8pc(), Duration.plus-LRDsOJo(this.getEndTime-UwyO8pc(), DurationKt.toDuration(3, DurationUnit.SECONDS))) >= 0) {
                if (((HomeConfiguration)ConfigurationKt.getType(this.getConfigs(), Reflection.getOrCreateKotlinClass(HomeConfiguration.class))).isLooping()) {
                    this.isSequencerStarted = false;
                    this.sequencer.stop();
                    this.seek-LRDsOJo(DurationKt.toDuration(-2, DurationUnit.SECONDS));
                    this.getSlideCamController().onLoop();
                    Sequencer sequencer = this.sequencer;
                    Intrinsics.checkNotNull(sequencer, "null cannot be cast to non-null type org.wysko.gervill.JwRealTimeSequencer");
                    ((JwRealTimeSequencer)sequencer).resetDevice();
                } else {
                    this.exit();
                }
            }
        }
    }

    private final void startFadeIfNeeded() {
        if (!this.isFadeStarted) {
            if (Duration.compareTo-LRDsOJo(this.getTime-UwyO8pc(), DurationKt.toDuration(-1.5, DurationUnit.SECONDS)) > 0) {
                this.getFadeFilter().fadeIn();
                this.isFadeStarted = true;
            }
        }
    }

    private final void startSequencerIfNeeded() {
        if (!this.isSequencerStarted && Duration.compareTo-LRDsOJo(this.getTime-UwyO8pc(), Duration.Companion.getZERO-UwyO8pc()) > 0) {
            this.sequencer.start();
            this.isSequencerStarted = true;
            this.setSynthEffects();
        }
    }

    private final void setSynthEffects() {
        block4: {
            MidiChannel it;
            boolean $i$f$forEach;
            Object[] $this$forEach$iv;
            Synthesizer synthesizer = this.synthesizer;
            if (synthesizer == null) break block4;
            Synthesizer it2 = synthesizer;
            boolean bl = false;
            if (!((SynthesizerConfiguration)ConfigurationKt.getType(this.getConfigs(), Reflection.getOrCreateKotlinClass(SynthesizerConfiguration.class))).isReverbEnabled()) {
                MidiChannel[] midiChannelArray = this.synthesizer.getChannels();
                Intrinsics.checkNotNullExpressionValue(midiChannelArray, "getChannels(...)");
                $this$forEach$iv = midiChannelArray;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (MidiChannel)element$iv;
                    boolean bl2 = false;
                    it.controlChange(91, 0);
                }
            }
            if (!((SynthesizerConfiguration)ConfigurationKt.getType(this.getConfigs(), Reflection.getOrCreateKotlinClass(SynthesizerConfiguration.class))).isChorusEnabled()) {
                MidiChannel[] midiChannelArray = this.synthesizer.getChannels();
                Intrinsics.checkNotNullExpressionValue(midiChannelArray, "getChannels(...)");
                $this$forEach$iv = midiChannelArray;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (MidiChannel)element$iv;
                    boolean bl3 = false;
                    it.controlChange(93, 0);
                }
            }
        }
    }
}

