/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.kmidi.midi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wysko.kmidi.ArrayInputStream;
import org.wysko.kmidi.SmpteTimecode;
import org.wysko.kmidi.midi.IncompleteMetaEventException;
import org.wysko.kmidi.midi.InvalidHeaderException;
import org.wysko.kmidi.midi.StandardMidiFile;
import org.wysko.kmidi.midi.StandardMidiFileReaderKt;
import org.wysko.kmidi.midi.UnexpectedEndOfFileException;
import org.wysko.kmidi.midi.event.ChannelPressureEvent;
import org.wysko.kmidi.midi.event.ControlChangeEvent;
import org.wysko.kmidi.midi.event.Event;
import org.wysko.kmidi.midi.event.MetaEvent;
import org.wysko.kmidi.midi.event.NoteEvent;
import org.wysko.kmidi.midi.event.PitchWheelChangeEvent;
import org.wysko.kmidi.midi.event.PolyphonicKeyPressureEvent;
import org.wysko.kmidi.midi.event.ProgramEvent;
import org.wysko.kmidi.midi.event.SysexEvent;
import org.wysko.kmidi.util.BitwiseOperationsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001'B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0&2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFileReader;", "", "policies", "Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies;", "(Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies;)V", "readByteArray", "Lorg/wysko/kmidi/midi/StandardMidiFile;", "bytes", "", "readDataByte", "", "data1", "stream", "Lorg/wysko/kmidi/ArrayInputStream;", "readHeader", "Lorg/wysko/kmidi/midi/StandardMidiFile$Header;", "readKeySignature", "Lorg/wysko/kmidi/midi/event/MetaEvent$KeySignature;", "time", "", "readMetaEvent", "Lorg/wysko/kmidi/midi/event/Event;", "metaType", "readMidiChannelPrefix", "Lorg/wysko/kmidi/midi/event/MetaEvent$ChannelPrefix;", "readRemainingChunks", "", "Lorg/wysko/kmidi/midi/StandardMidiFile$Track;", "header", "readSequenceNumber", "Lorg/wysko/kmidi/midi/event/MetaEvent$SequenceNumber;", "readSmpteOffset", "Lorg/wysko/kmidi/midi/event/MetaEvent$SmpteOffset;", "readTempo", "Lorg/wysko/kmidi/midi/event/MetaEvent$SetTempo;", "readTimeSignature", "Lorg/wysko/kmidi/midi/event/MetaEvent$TimeSignature;", "readTwoDataBytes", "Lkotlin/Pair;", "Policies", "kmidi"})
@SourceDebugExtension(value={"SMAP\nStandardMidiFileReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardMidiFileReader.kt\norg/wysko/kmidi/midi/StandardMidiFileReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,650:1\n1#2:651\n*E\n"})
public final class StandardMidiFileReader {
    @NotNull
    private final Policies policies;

    public StandardMidiFileReader(@NotNull Policies policies) {
        Intrinsics.checkNotNullParameter(policies, "policies");
        this.policies = policies;
    }

    public /* synthetic */ StandardMidiFileReader(Policies policies, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            policies = Policies.Companion.getLenient();
        }
        this(policies);
    }

    @NotNull
    public final StandardMidiFile readByteArray(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        ArrayInputStream stream = new ArrayInputStream(bytes);
        StandardMidiFile.Header header = this.readHeader(stream);
        List<StandardMidiFile.Track> tracks = this.readRemainingChunks(stream, header);
        return new StandardMidiFile(header, tracks);
    }

    private final StandardMidiFile.Header readHeader(ArrayInputStream stream) {
        String chunkType = StringsKt.decodeToString(stream.readNBytes(4));
        if (!Intrinsics.areEqual(chunkType, "MThd")) {
            throw new InvalidHeaderException(InvalidHeaderException.HeaderExceptionType.MissingHeader.INSTANCE);
        }
        int length = stream.readDWord();
        if (length < 6) {
            throw new InvalidHeaderException(new InvalidHeaderException.HeaderExceptionType.InvalidHeaderLength(length));
        }
        short format2 = stream.readWord();
        short s = format2;
        if (!(0 <= s ? s < 3 : false)) {
            throw new InvalidHeaderException(new InvalidHeaderException.HeaderExceptionType.InvalidFormat(format2));
        }
        short trackCount = stream.readWord();
        short timeDivision = stream.readWord();
        StandardMidiFile.Header.Division division = (short)(timeDivision & Short.MIN_VALUE) == 0 ? (StandardMidiFile.Header.Division)new StandardMidiFile.Header.Division.MetricalTime(timeDivision) : (StandardMidiFile.Header.Division)new StandardMidiFile.Header.Division.TimecodeBasedTime(BitwiseOperationsKt.shr((short)(timeDivision & 0xFFFFFF00), 8), (short)(timeDivision & 0xFF));
        stream.skip(length - 6);
        return new StandardMidiFile.Header(chunkType, StandardMidiFile.Header.Format.Companion.fromValue(format2), trackCount, division);
    }

    private final List<StandardMidiFile.Track> readRemainingChunks(ArrayInputStream stream, StandardMidiFile.Header header) {
        List tracks = new ArrayList();
        int n = header.getTrackCount();
        for (int i = 0; i < n; ++i) {
            int time = 0;
            byte prefix = 0;
            List events = new ArrayList();
            try {
                int startingPosition;
                String trackType = StringsKt.decodeToString(stream.readNBytes(4));
                int trackLength = stream.readDWord();
                if (!Intrinsics.areEqual(trackType, "MTrk")) {
                    stream.skip(trackLength);
                    continue;
                }
                for (int bytesRead = 0; bytesRead < trackLength; bytesRead += stream.getPosition() - startingPosition) {
                    boolean noMoreEventsAndPolicyAllows;
                    boolean isTrailingNullByte = trackLength - bytesRead == 1 && stream.read() == 0;
                    boolean bl = noMoreEventsAndPolicyAllows = stream.getAvailable() == 0 && Intrinsics.areEqual(this.policies.getUnexpectedEndOfFilePolicy(), Policies.UnexpectedEndOfFileExceptionPolicy.AllowClean.INSTANCE);
                    if (isTrailingNullByte || noMoreEventsAndPolicyAllows) break;
                    startingPosition = stream.getPosition();
                    byte data1 = -1;
                    byte data2 = 0;
                    int deltaTime = ((Number)stream.readVlq().component1()).intValue();
                    time += deltaTime;
                    byte lastPrefix = prefix;
                    byte statusByte = stream.read();
                    if ((byte)(statusByte & 0xFFFFFF80) != 0) {
                        prefix = statusByte;
                    } else {
                        data1 = statusByte;
                    }
                    byte status = (byte)(prefix & 0xFFFFFFF0);
                    byte channel = (byte)(prefix & 0xF);
                    if (status == -128) {
                        data1 = this.readDataByte(data1, stream);
                        stream.read();
                        ((Collection)events).add(new NoteEvent.NoteOff(time, channel, data1));
                        continue;
                    }
                    if (status == -112) {
                        Pair<Byte, Byte> bytes = this.readTwoDataBytes(data1, stream);
                        data1 = ((Number)bytes.getFirst()).byteValue();
                        data2 = ((Number)bytes.getSecond()).byteValue();
                        if (this.policies.getCoerceVelocityToRange()) {
                            data2 = (byte)RangesKt.coerceIn(UByte.constructor-impl(data2) & 0xFF, StandardMidiFileReaderKt.access$getSEVEN_BIT_RANGE$p());
                        }
                        if (data2 == 0) {
                            ((Collection)events).add(new NoteEvent.NoteOff(time, channel, data1));
                            continue;
                        }
                        ((Collection)events).add(new NoteEvent.NoteOn(time, channel, data1, data2));
                        continue;
                    }
                    if (status == -96) {
                        Pair<Byte, Byte> bytes = this.readTwoDataBytes(data1, stream);
                        data1 = ((Number)bytes.getFirst()).byteValue();
                        data2 = ((Number)bytes.getSecond()).byteValue();
                        ((Collection)events).add(new PolyphonicKeyPressureEvent(time, channel, data1, data2));
                        continue;
                    }
                    if (status == -80) {
                        Pair<Byte, Byte> bytes = this.readTwoDataBytes(data1, stream);
                        data1 = ((Number)bytes.getFirst()).byteValue();
                        data2 = ((Number)bytes.getSecond()).byteValue();
                        ((Collection)events).add(new ControlChangeEvent(time, channel, data1, data2));
                        continue;
                    }
                    if (status == -64) {
                        data1 = this.readDataByte(data1, stream);
                        ((Collection)events).add(new ProgramEvent(time, channel, data1));
                        continue;
                    }
                    if (status == -48) {
                        data1 = this.readDataByte(data1, stream);
                        ((Collection)events).add(new ChannelPressureEvent(time, channel, data1));
                        continue;
                    }
                    if (status == -32) {
                        Pair<Byte, Byte> bytes = this.readTwoDataBytes(data1, stream);
                        data1 = ((Number)bytes.getFirst()).byteValue();
                        data2 = ((Number)bytes.getSecond()).byteValue();
                        ((Collection)events).add(new PitchWheelChangeEvent(time, channel, (short)(BitwiseOperationsKt.shl((short)data2, 7) | (short)data1)));
                        continue;
                    }
                    if (status == -16 && (prefix == -16 || prefix == -9)) {
                        int length = ((Number)stream.readVlq().component1()).intValue();
                        byte[] message = stream.readNBytes(length);
                        ((Collection)events).add(new SysexEvent(time, message));
                        if (!this.policies.getAllowRunningStatusAcrossNonMidiEvents()) continue;
                        prefix = lastPrefix;
                        continue;
                    }
                    if (status != -16 || prefix != -1) continue;
                    byte metaType = stream.read();
                    if (this.readMetaEvent(stream, time, metaType) != null) {
                        Event it;
                        boolean bl2 = false;
                        ((Collection)events).add(it);
                    }
                    if (!this.policies.getAllowRunningStatusAcrossNonMidiEvents()) continue;
                    prefix = lastPrefix;
                }
                ((Collection)tracks).add(new StandardMidiFile.Track(events));
                continue;
            }
            catch (UnexpectedEndOfFileException e) {
                if (Intrinsics.areEqual(this.policies.getUnexpectedEndOfFilePolicy(), Policies.UnexpectedEndOfFileExceptionPolicy.AllowDirty.INSTANCE)) {
                    ((Collection)tracks).add(new StandardMidiFile.Track(events));
                    break;
                }
                throw e;
            }
        }
        if (this.policies.getAllowTrackCountDiscrepancy()) {
            int n2 = header.getTrackCount() - tracks.size();
            n = 0;
            while (n < n2) {
                int it = n++;
                boolean bl = false;
                ((Collection)tracks).add(new StandardMidiFile.Track(CollectionsKt.emptyList()));
            }
        }
        return tracks;
    }

    private final Pair<Byte, Byte> readTwoDataBytes(byte data1, ArrayInputStream stream) {
        return data1 == -1 ? new Pair<Byte, Byte>(stream.read(), stream.read()) : new Pair<Byte, Byte>(data1, stream.read());
    }

    private final byte readDataByte(byte data1, ArrayInputStream stream) {
        return data1 == -1 ? stream.read() : data1;
    }

    private final Event readMetaEvent(ArrayInputStream stream, int time, byte metaType) {
        Event event;
        byte by = metaType;
        if (by == 0) {
            event = this.readSequenceNumber(stream);
        } else if (by == 1) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text2 = StringsKt.decodeToString(stream.readNBytes(length));
            event = new MetaEvent.Text(time, text2);
        } else if (by == 2) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text3 = StringsKt.decodeToString(stream.readNBytes(length));
            event = new MetaEvent.CopyrightNotice(text3);
        } else if (by == 3) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text4 = StringsKt.decodeToString(stream.readNBytes(length));
            event = new MetaEvent.SequenceTrackName(text4);
        } else if (by == 4) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text5 = StringsKt.decodeToString(stream.readNBytes(length));
            event = new MetaEvent.InstrumentName(text5);
        } else if (by == 5) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text6 = StringsKt.decodeToString(stream.readNBytes(length));
            event = new MetaEvent.Lyric(time, text6);
        } else if (by == 6) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text7 = StringsKt.decodeToString(stream.readNBytes(length));
            event = new MetaEvent.Marker(time, text7);
        } else if (by == 7) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            String text8 = StringsKt.decodeToString(stream.readNBytes(length));
            event = new MetaEvent.CuePoint(time, text8);
        } else if (by == 32) {
            event = this.readMidiChannelPrefix(stream, time);
        } else if (by == 47) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            stream.skip(length);
            event = new MetaEvent.EndOfTrack(time);
        } else if (by == 81) {
            event = this.readTempo(stream, time);
        } else if (by == 84) {
            event = this.readSmpteOffset(stream);
        } else if (by == 89) {
            event = this.readKeySignature(stream, time);
        } else if (by == 88) {
            event = this.readTimeSignature(stream, time);
        } else if (by == 127) {
            int length = ((Number)stream.readVlq().component1()).intValue();
            byte[] data2 = stream.readNBytes(length);
            event = new MetaEvent.SequencerSpecific(time, data2);
        } else {
            int length = ((Number)stream.readVlq().component1()).intValue();
            byte[] bytes = stream.readNBytes(length);
            event = new MetaEvent.Unknown(time, metaType, bytes);
        }
        return event;
    }

    private final MetaEvent.TimeSignature readTimeSignature(ArrayInputStream stream, int time) {
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 4) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException(Reflection.getOrCreateKotlinClass(MetaEvent.TimeSignature.class));
        }
        byte numerator = stream.read();
        byte denominator = stream.read();
        byte clocksInMetronomeClick = stream.read();
        byte thirtySecondNotesInMidiQuarterNote = stream.read();
        stream.skip(length - 4);
        return new MetaEvent.TimeSignature(time, numerator, denominator, clocksInMetronomeClick, thirtySecondNotesInMidiQuarterNote);
    }

    private final MetaEvent.KeySignature readKeySignature(ArrayInputStream stream, int time) {
        MetaEvent.KeySignature keySignature;
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 2) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException(Reflection.getOrCreateKotlinClass(MetaEvent.KeySignature.class));
        }
        byte key = stream.read();
        byte scale2 = stream.read();
        stream.skip(length - 2);
        try {
            keySignature = new MetaEvent.KeySignature(time, MetaEvent.KeySignature.Key.Companion.fromValue(key), MetaEvent.KeySignature.Scale.Companion.fromValue(scale2));
        }
        catch (IllegalArgumentException e) {
            if (!this.policies.getIgnoreBadKeySignatures()) {
                throw e;
            }
            keySignature = null;
        }
        return keySignature;
    }

    private final MetaEvent.SmpteOffset readSmpteOffset(ArrayInputStream stream) {
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 5) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException(Reflection.getOrCreateKotlinClass(MetaEvent.SmpteOffset.class));
        }
        byte hour2 = stream.read();
        byte minute2 = stream.read();
        byte second2 = stream.read();
        byte frame = stream.read();
        byte subFrame = stream.read();
        stream.skip(length - 5);
        return new MetaEvent.SmpteOffset(new SmpteTimecode(hour2, minute2, second2, frame, subFrame));
    }

    private final MetaEvent.SetTempo readTempo(ArrayInputStream stream, int time) {
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 3) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException(Reflection.getOrCreateKotlinClass(MetaEvent.SetTempo.class));
        }
        int tempo = stream.read24BitInt();
        stream.skip(length - 3);
        return new MetaEvent.SetTempo(time, tempo);
    }

    private final MetaEvent.ChannelPrefix readMidiChannelPrefix(ArrayInputStream stream, int time) {
        MetaEvent.ChannelPrefix channelPrefix;
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 1) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException(Reflection.getOrCreateKotlinClass(MetaEvent.ChannelPrefix.class));
        }
        byte channel = stream.read();
        stream.skip(length - 1);
        try {
            channelPrefix = new MetaEvent.ChannelPrefix(time, channel);
        }
        catch (IllegalArgumentException e) {
            if (!this.policies.getIgnoreBadChannelPrefixes()) {
                throw e;
            }
            channelPrefix = null;
        }
        return channelPrefix;
    }

    private final MetaEvent.SequenceNumber readSequenceNumber(ArrayInputStream stream) {
        int length = ((Number)stream.readVlq().component1()).intValue();
        if (length < 2) {
            if (this.policies.getIgnoreIncompleteMetaEvents()) {
                return null;
            }
            throw new IncompleteMetaEventException(Reflection.getOrCreateKotlinClass(MetaEvent.SequenceNumber.class));
        }
        byte high = stream.read();
        byte low = stream.read();
        stream.skip(length - 2);
        return new MetaEvent.SequenceNumber((short)((short)BitwiseOperationsKt.shl(high, 8) | (short)low));
    }

    public StandardMidiFileReader() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0002#$B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies;", "", "allowRunningStatusAcrossNonMidiEvents", "", "allowTrackCountDiscrepancy", "coerceVelocityToRange", "ignoreBadChannelPrefixes", "ignoreBadKeySignatures", "ignoreIncompleteMetaEvents", "unexpectedEndOfFilePolicy", "Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "(ZZZZZZLorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;)V", "getAllowRunningStatusAcrossNonMidiEvents", "()Z", "getAllowTrackCountDiscrepancy", "getCoerceVelocityToRange", "getIgnoreBadChannelPrefixes", "getIgnoreBadKeySignatures", "getIgnoreIncompleteMetaEvents", "getUnexpectedEndOfFilePolicy", "()Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "UnexpectedEndOfFileExceptionPolicy", "kmidi"})
    public static final class Policies {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean allowRunningStatusAcrossNonMidiEvents;
        private final boolean allowTrackCountDiscrepancy;
        private final boolean coerceVelocityToRange;
        private final boolean ignoreBadChannelPrefixes;
        private final boolean ignoreBadKeySignatures;
        private final boolean ignoreIncompleteMetaEvents;
        @NotNull
        private final UnexpectedEndOfFileExceptionPolicy unexpectedEndOfFilePolicy;
        @NotNull
        private static final Policies lenient = new Policies(true, true, true, true, true, true, UnexpectedEndOfFileExceptionPolicy.AllowDirty.INSTANCE);
        @NotNull
        private static final Policies strict = new Policies(false, false, false, false, false, false, UnexpectedEndOfFileExceptionPolicy.Disallow.INSTANCE);

        public Policies(boolean allowRunningStatusAcrossNonMidiEvents, boolean allowTrackCountDiscrepancy, boolean coerceVelocityToRange, boolean ignoreBadChannelPrefixes, boolean ignoreBadKeySignatures, boolean ignoreIncompleteMetaEvents, @NotNull UnexpectedEndOfFileExceptionPolicy unexpectedEndOfFilePolicy) {
            Intrinsics.checkNotNullParameter(unexpectedEndOfFilePolicy, "unexpectedEndOfFilePolicy");
            this.allowRunningStatusAcrossNonMidiEvents = allowRunningStatusAcrossNonMidiEvents;
            this.allowTrackCountDiscrepancy = allowTrackCountDiscrepancy;
            this.coerceVelocityToRange = coerceVelocityToRange;
            this.ignoreBadChannelPrefixes = ignoreBadChannelPrefixes;
            this.ignoreBadKeySignatures = ignoreBadKeySignatures;
            this.ignoreIncompleteMetaEvents = ignoreIncompleteMetaEvents;
            this.unexpectedEndOfFilePolicy = unexpectedEndOfFilePolicy;
        }

        public final boolean getAllowRunningStatusAcrossNonMidiEvents() {
            return this.allowRunningStatusAcrossNonMidiEvents;
        }

        public final boolean getAllowTrackCountDiscrepancy() {
            return this.allowTrackCountDiscrepancy;
        }

        public final boolean getCoerceVelocityToRange() {
            return this.coerceVelocityToRange;
        }

        public final boolean getIgnoreBadChannelPrefixes() {
            return this.ignoreBadChannelPrefixes;
        }

        public final boolean getIgnoreBadKeySignatures() {
            return this.ignoreBadKeySignatures;
        }

        public final boolean getIgnoreIncompleteMetaEvents() {
            return this.ignoreIncompleteMetaEvents;
        }

        @NotNull
        public final UnexpectedEndOfFileExceptionPolicy getUnexpectedEndOfFilePolicy() {
            return this.unexpectedEndOfFilePolicy;
        }

        public final boolean component1() {
            return this.allowRunningStatusAcrossNonMidiEvents;
        }

        public final boolean component2() {
            return this.allowTrackCountDiscrepancy;
        }

        public final boolean component3() {
            return this.coerceVelocityToRange;
        }

        public final boolean component4() {
            return this.ignoreBadChannelPrefixes;
        }

        public final boolean component5() {
            return this.ignoreBadKeySignatures;
        }

        public final boolean component6() {
            return this.ignoreIncompleteMetaEvents;
        }

        @NotNull
        public final UnexpectedEndOfFileExceptionPolicy component7() {
            return this.unexpectedEndOfFilePolicy;
        }

        @NotNull
        public final Policies copy(boolean allowRunningStatusAcrossNonMidiEvents, boolean allowTrackCountDiscrepancy, boolean coerceVelocityToRange, boolean ignoreBadChannelPrefixes, boolean ignoreBadKeySignatures, boolean ignoreIncompleteMetaEvents, @NotNull UnexpectedEndOfFileExceptionPolicy unexpectedEndOfFilePolicy) {
            Intrinsics.checkNotNullParameter(unexpectedEndOfFilePolicy, "unexpectedEndOfFilePolicy");
            return new Policies(allowRunningStatusAcrossNonMidiEvents, allowTrackCountDiscrepancy, coerceVelocityToRange, ignoreBadChannelPrefixes, ignoreBadKeySignatures, ignoreIncompleteMetaEvents, unexpectedEndOfFilePolicy);
        }

        public static /* synthetic */ Policies copy$default(Policies policies, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, UnexpectedEndOfFileExceptionPolicy unexpectedEndOfFileExceptionPolicy, int n, Object object) {
            if ((n & 1) != 0) {
                bl = policies.allowRunningStatusAcrossNonMidiEvents;
            }
            if ((n & 2) != 0) {
                bl2 = policies.allowTrackCountDiscrepancy;
            }
            if ((n & 4) != 0) {
                bl3 = policies.coerceVelocityToRange;
            }
            if ((n & 8) != 0) {
                bl4 = policies.ignoreBadChannelPrefixes;
            }
            if ((n & 0x10) != 0) {
                bl5 = policies.ignoreBadKeySignatures;
            }
            if ((n & 0x20) != 0) {
                bl6 = policies.ignoreIncompleteMetaEvents;
            }
            if ((n & 0x40) != 0) {
                unexpectedEndOfFileExceptionPolicy = policies.unexpectedEndOfFilePolicy;
            }
            return policies.copy(bl, bl2, bl3, bl4, bl5, bl6, unexpectedEndOfFileExceptionPolicy);
        }

        @NotNull
        public String toString() {
            return "Policies(allowRunningStatusAcrossNonMidiEvents=" + this.allowRunningStatusAcrossNonMidiEvents + ", allowTrackCountDiscrepancy=" + this.allowTrackCountDiscrepancy + ", coerceVelocityToRange=" + this.coerceVelocityToRange + ", ignoreBadChannelPrefixes=" + this.ignoreBadChannelPrefixes + ", ignoreBadKeySignatures=" + this.ignoreBadKeySignatures + ", ignoreIncompleteMetaEvents=" + this.ignoreIncompleteMetaEvents + ", unexpectedEndOfFilePolicy=" + this.unexpectedEndOfFilePolicy + ')';
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.allowRunningStatusAcrossNonMidiEvents);
            result2 = result2 * 31 + Boolean.hashCode(this.allowTrackCountDiscrepancy);
            result2 = result2 * 31 + Boolean.hashCode(this.coerceVelocityToRange);
            result2 = result2 * 31 + Boolean.hashCode(this.ignoreBadChannelPrefixes);
            result2 = result2 * 31 + Boolean.hashCode(this.ignoreBadKeySignatures);
            result2 = result2 * 31 + Boolean.hashCode(this.ignoreIncompleteMetaEvents);
            result2 = result2 * 31 + this.unexpectedEndOfFilePolicy.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Policies)) {
                return false;
            }
            Policies policies = (Policies)other;
            if (this.allowRunningStatusAcrossNonMidiEvents != policies.allowRunningStatusAcrossNonMidiEvents) {
                return false;
            }
            if (this.allowTrackCountDiscrepancy != policies.allowTrackCountDiscrepancy) {
                return false;
            }
            if (this.coerceVelocityToRange != policies.coerceVelocityToRange) {
                return false;
            }
            if (this.ignoreBadChannelPrefixes != policies.ignoreBadChannelPrefixes) {
                return false;
            }
            if (this.ignoreBadKeySignatures != policies.ignoreBadKeySignatures) {
                return false;
            }
            if (this.ignoreIncompleteMetaEvents != policies.ignoreIncompleteMetaEvents) {
                return false;
            }
            return Intrinsics.areEqual(this.unexpectedEndOfFilePolicy, policies.unexpectedEndOfFilePolicy);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$Companion;", "", "()V", "lenient", "Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies;", "getLenient", "()Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies;", "strict", "getStrict", "kmidi"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Policies getLenient() {
                return lenient;
            }

            @NotNull
            public final Policies getStrict() {
                return strict;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "", "()V", "AllowClean", "AllowDirty", "Disallow", "Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$AllowClean;", "Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$AllowDirty;", "Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$Disallow;", "kmidi"})
        public static abstract class UnexpectedEndOfFileExceptionPolicy {
            private UnexpectedEndOfFileExceptionPolicy() {
            }

            public /* synthetic */ UnexpectedEndOfFileExceptionPolicy(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$AllowClean;", "Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "kmidi"})
            public static final class AllowClean
            extends UnexpectedEndOfFileExceptionPolicy {
                @NotNull
                public static final AllowClean INSTANCE = new AllowClean();

                private AllowClean() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "AllowClean";
                }

                public int hashCode() {
                    return -1594219243;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof AllowClean)) {
                        return false;
                    }
                    AllowClean cfr_ignored_0 = (AllowClean)other;
                    return true;
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$AllowDirty;", "Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "kmidi"})
            public static final class AllowDirty
            extends UnexpectedEndOfFileExceptionPolicy {
                @NotNull
                public static final AllowDirty INSTANCE = new AllowDirty();

                private AllowDirty() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "AllowDirty";
                }

                public int hashCode() {
                    return -1593372002;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof AllowDirty)) {
                        return false;
                    }
                    AllowDirty cfr_ignored_0 = (AllowDirty)other;
                    return true;
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy$Disallow;", "Lorg/wysko/kmidi/midi/StandardMidiFileReader$Policies$UnexpectedEndOfFileExceptionPolicy;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "kmidi"})
            public static final class Disallow
            extends UnexpectedEndOfFileExceptionPolicy {
                @NotNull
                public static final Disallow INSTANCE = new Disallow();

                private Disallow() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "Disallow";
                }

                public int hashCode() {
                    return 387204432;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Disallow)) {
                        return false;
                    }
                    Disallow cfr_ignored_0 = (Disallow)other;
                    return true;
                }
            }
        }
    }
}

