/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.wysko.gervill.SunFileWriter;
import org.wysko.gervill.WaveFileFormat;

public final class WaveFileWriter
extends SunFileWriter {
    static final int RIFF_MAGIC = 1380533830;
    static final int WAVE_MAGIC = 1463899717;
    static final int FMT_MAGIC = 1718449184;
    static final int DATA_MAGIC = 1684108385;
    static final int WAVE_FORMAT_UNKNOWN = 0;
    static final int WAVE_FORMAT_PCM = 1;
    static final int WAVE_FORMAT_ADPCM = 2;
    static final int WAVE_FORMAT_ALAW = 6;
    static final int WAVE_FORMAT_MULAW = 7;
    static final int WAVE_FORMAT_OKI_ADPCM = 16;
    static final int WAVE_FORMAT_DIGISTD = 21;
    static final int WAVE_FORMAT_DIGIFIX = 22;
    static final int WAVE_IBM_FORMAT_MULAW = 257;
    static final int WAVE_IBM_FORMAT_ALAW = 258;
    static final int WAVE_IBM_FORMAT_ADPCM = 259;
    static final int WAVE_FORMAT_DVI_ADPCM = 17;
    static final int WAVE_FORMAT_SX7383 = 7175;

    public WaveFileWriter() {
        super(new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE});
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        AudioFileFormat.Type[] filetypes = new AudioFileFormat.Type[this.types.length];
        System.arraycopy(this.types, 0, filetypes, 0, this.types.length);
        AudioFormat format2 = stream.getFormat();
        AudioFormat.Encoding encoding = format2.getEncoding();
        if (AudioFormat.Encoding.ALAW.equals(encoding) || AudioFormat.Encoding.ULAW.equals(encoding) || AudioFormat.Encoding.PCM_SIGNED.equals(encoding) || AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding)) {
            return filetypes;
        }
        return new AudioFileFormat.Type[0];
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        WaveFileFormat waveFileFormat = (WaveFileFormat)this.getAudioFileFormat(fileType, stream);
        if (stream.getFrameLength() == -1L) {
            throw new IOException("stream length not specified");
        }
        int bytesWritten = this.writeWaveFile(stream, waveFileFormat, out);
        return bytesWritten;
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        WaveFileFormat waveFileFormat = (WaveFileFormat)this.getAudioFileFormat(fileType, stream);
        FileOutputStream fos = new FileOutputStream(out);
        BufferedOutputStream bos = new BufferedOutputStream(fos, 4096);
        int bytesWritten = this.writeWaveFile(stream, waveFileFormat, bos);
        bos.close();
        if (waveFileFormat.getByteLength() == -1) {
            int dataLength = bytesWritten - waveFileFormat.getHeaderSize();
            int riffLength = dataLength + waveFileFormat.getHeaderSize() - 8;
            RandomAccessFile raf = new RandomAccessFile(out, "rw");
            raf.skipBytes(4);
            raf.writeInt(this.big2little(riffLength));
            raf.skipBytes(12 + WaveFileFormat.getFmtChunkSize(waveFileFormat.getWaveType()) + 4);
            raf.writeInt(this.big2little(dataLength));
            raf.close();
        }
        return bytesWritten;
    }

    private AudioFileFormat getAudioFileFormat(AudioFileFormat.Type type2, AudioInputStream stream) {
        int sampleSizeInBits;
        AudioFormat format2 = null;
        WaveFileFormat fileFormat = null;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        AudioFormat streamFormat = stream.getFormat();
        AudioFormat.Encoding streamEncoding = streamFormat.getEncoding();
        if (!this.types[0].equals(type2)) {
            throw new IllegalArgumentException("File type " + type2 + " not supported.");
        }
        int waveType = 1;
        if (AudioFormat.Encoding.ALAW.equals(streamEncoding) || AudioFormat.Encoding.ULAW.equals(streamEncoding)) {
            encoding = streamEncoding;
            sampleSizeInBits = streamFormat.getSampleSizeInBits();
            waveType = streamEncoding.equals(AudioFormat.Encoding.ALAW) ? 6 : 7;
        } else if (streamFormat.getSampleSizeInBits() == 8) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
            sampleSizeInBits = 8;
        } else {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            sampleSizeInBits = streamFormat.getSampleSizeInBits();
        }
        format2 = new AudioFormat(encoding, streamFormat.getSampleRate(), sampleSizeInBits, streamFormat.getChannels(), streamFormat.getFrameSize(), streamFormat.getFrameRate(), false);
        int fileSize = stream.getFrameLength() != -1L ? (int)stream.getFrameLength() * streamFormat.getFrameSize() + WaveFileFormat.getHeaderSize(waveType) : -1;
        fileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, fileSize, format2, (int)stream.getFrameLength());
        return fileFormat;
    }

    private int writeWaveFile(InputStream in, WaveFileFormat waveFileFormat, OutputStream out) throws IOException {
        int bytesRead = 0;
        int bytesWritten = 0;
        InputStream fileStream = this.getFileStream(waveFileFormat, in);
        byte[] buffer = new byte[4096];
        int maxLength = waveFileFormat.getByteLength();
        while ((bytesRead = fileStream.read(buffer)) >= 0) {
            if (maxLength > 0) {
                if (bytesRead < maxLength) {
                    out.write(buffer, 0, bytesRead);
                    bytesWritten += bytesRead;
                    maxLength -= bytesRead;
                    continue;
                }
                out.write(buffer, 0, maxLength);
                bytesWritten += maxLength;
                maxLength = 0;
                break;
            }
            out.write(buffer, 0, bytesRead);
            bytesWritten += bytesRead;
        }
        return bytesWritten;
    }

    private InputStream getFileStream(WaveFileFormat waveFileFormat, InputStream audioStream) throws IOException {
        AudioFormat audioFormat = waveFileFormat.getFormat();
        int headerLength = waveFileFormat.getHeaderSize();
        int riffMagic = 1380533830;
        int waveMagic = 1463899717;
        int fmtMagic = 1718449184;
        int fmtLength = WaveFileFormat.getFmtChunkSize(waveFileFormat.getWaveType());
        short wav_type = (short)waveFileFormat.getWaveType();
        short channels = (short)audioFormat.getChannels();
        short sampleSizeInBits = (short)audioFormat.getSampleSizeInBits();
        int sampleRate = (int)audioFormat.getSampleRate();
        int frameSizeInBytes = audioFormat.getFrameSize();
        int frameRate = (int)audioFormat.getFrameRate();
        int avgBytesPerSec = channels * sampleSizeInBits * sampleRate / 8;
        short blockAlign = (short)(sampleSizeInBits / 8 * channels);
        int dataMagic = 1684108385;
        int dataLength = waveFileFormat.getFrameLength() * frameSizeInBytes;
        int length = waveFileFormat.getByteLength();
        int riffLength = dataLength + headerLength - 8;
        byte[] header = null;
        ByteArrayInputStream headerStream = null;
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        SequenceInputStream waveStream = null;
        AudioFormat audioStreamFormat = null;
        AudioFormat.Encoding encoding = null;
        InputStream codedAudioStream = audioStream;
        if (audioStream instanceof AudioInputStream) {
            audioStreamFormat = ((AudioInputStream)audioStream).getFormat();
            encoding = audioStreamFormat.getEncoding();
            if (AudioFormat.Encoding.PCM_SIGNED.equals(encoding) && sampleSizeInBits == 8) {
                wav_type = 1;
                codedAudioStream = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioStreamFormat.getSampleRate(), audioStreamFormat.getSampleSizeInBits(), audioStreamFormat.getChannels(), audioStreamFormat.getFrameSize(), audioStreamFormat.getFrameRate(), false), (AudioInputStream)audioStream);
            }
            if ((AudioFormat.Encoding.PCM_SIGNED.equals(encoding) && audioStreamFormat.isBigEndian() || AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding) && !audioStreamFormat.isBigEndian() || AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding) && audioStreamFormat.isBigEndian()) && sampleSizeInBits != 8) {
                wav_type = 1;
                codedAudioStream = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioStreamFormat.getSampleRate(), audioStreamFormat.getSampleSizeInBits(), audioStreamFormat.getChannels(), audioStreamFormat.getFrameSize(), audioStreamFormat.getFrameRate(), false), (AudioInputStream)audioStream);
            }
        }
        baos = new ByteArrayOutputStream();
        dos = new DataOutputStream(baos);
        dos.writeInt(riffMagic);
        dos.writeInt(this.big2little(riffLength));
        dos.writeInt(waveMagic);
        dos.writeInt(fmtMagic);
        dos.writeInt(this.big2little(fmtLength));
        dos.writeShort(this.big2littleShort(wav_type));
        dos.writeShort(this.big2littleShort(channels));
        dos.writeInt(this.big2little(sampleRate));
        dos.writeInt(this.big2little(avgBytesPerSec));
        dos.writeShort(this.big2littleShort(blockAlign));
        dos.writeShort(this.big2littleShort(sampleSizeInBits));
        if (wav_type != 1) {
            dos.writeShort(0);
        }
        dos.writeInt(dataMagic);
        dos.writeInt(this.big2little(dataLength));
        dos.close();
        header = baos.toByteArray();
        headerStream = new ByteArrayInputStream(header);
        waveStream = new SequenceInputStream(headerStream, new SunFileWriter.NoCloseInputStream(codedAudioStream));
        return waveStream;
    }
}

