/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;

final class WaveFileFormat
extends AudioFileFormat {
    private final int waveType;
    private static final int STANDARD_HEADER_SIZE = 28;
    private static final int STANDARD_FMT_CHUNK_SIZE = 16;
    static final int RIFF_MAGIC = 1380533830;
    static final int WAVE_MAGIC = 1463899717;
    static final int FMT_MAGIC = 1718449184;
    static final int DATA_MAGIC = 1684108385;
    static final int WAVE_FORMAT_UNKNOWN = 0;
    static final int WAVE_FORMAT_PCM = 1;
    static final int WAVE_FORMAT_ADPCM = 2;
    static final int WAVE_FORMAT_ALAW = 6;
    static final int WAVE_FORMAT_MULAW = 7;
    static final int WAVE_FORMAT_OKI_ADPCM = 16;
    static final int WAVE_FORMAT_DIGISTD = 21;
    static final int WAVE_FORMAT_DIGIFIX = 22;
    static final int WAVE_IBM_FORMAT_MULAW = 257;
    static final int WAVE_IBM_FORMAT_ALAW = 258;
    static final int WAVE_IBM_FORMAT_ADPCM = 259;
    static final int WAVE_FORMAT_DVI_ADPCM = 17;
    static final int WAVE_FORMAT_SX7383 = 7175;

    WaveFileFormat(AudioFileFormat aff) {
        this(aff.getType(), aff.getByteLength(), aff.getFormat(), aff.getFrameLength());
    }

    WaveFileFormat(AudioFileFormat.Type type2, int lengthInBytes, AudioFormat format2, int lengthInFrames) {
        super(type2, lengthInBytes, format2, lengthInFrames);
        AudioFormat.Encoding encoding = format2.getEncoding();
        this.waveType = encoding.equals(AudioFormat.Encoding.ALAW) ? 6 : (encoding.equals(AudioFormat.Encoding.ULAW) ? 7 : (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) || encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) ? 1 : 0));
    }

    int getWaveType() {
        return this.waveType;
    }

    int getHeaderSize() {
        return WaveFileFormat.getHeaderSize(this.getWaveType());
    }

    static int getHeaderSize(int waveType) {
        return 28 + WaveFileFormat.getFmtChunkSize(waveType);
    }

    static int getFmtChunkSize(int waveType) {
        int result2 = 16;
        if (waveType != 1) {
            result2 += 2;
        }
        return result2;
    }
}

