/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0004\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"tickToSeconds", "", "tempos", "", "Ljavax/sound/midi/MidiEvent;", "resolution", "", "tick", "", "bpm", "spb", "tempoEvents", "toBeats", "", "Gervill"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/wysko/gervill/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n766#2:51\n857#2,2:52\n766#2:54\n857#2,2:55\n1804#2,4:57\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/wysko/gervill/UtilsKt\n*L\n10#1:51\n10#1:52,2\n38#1:54\n38#1:55,2\n38#1:57,4\n*E\n"})
public final class UtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<MidiEvent> tempoEvents(@NotNull List<? extends MidiEvent> $this$tempoEvents) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$tempoEvents, "<this>");
        Iterable $this$filter$iv = $this$tempoEvents;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MidiEvent it = (MidiEvent)element$iv$iv;
            boolean bl = false;
            boolean bl2 = it.getMessage() instanceof MetaMessage && it.getMessage().getLength() == 6 && it.getMessage().getMessage()[0] == -1 && it.getMessage().getMessage()[1] == 81 && it.getMessage().getMessage()[2] == 3;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final double bpm(@NotNull MidiEvent $this$bpm) {
        Intrinsics.checkNotNullParameter($this$bpm, "<this>");
        MidiMessage midiMessage = $this$bpm.getMessage();
        Intrinsics.checkNotNull(midiMessage, "null cannot be cast to non-null type javax.sound.midi.MetaMessage");
        MetaMessage message = (MetaMessage)midiMessage;
        byte[] data2 = message.getData();
        return 6.0E7 / (double)((data2[0] & 0xFF) << 16 | (data2[1] & 0xFF) << 8 | data2[2] & 0xFF);
    }

    public static final double spb(@NotNull MidiEvent $this$spb) {
        Intrinsics.checkNotNullParameter($this$spb, "<this>");
        return 60.0 / UtilsKt.bpm($this$spb);
    }

    /*
     * WARNING - void declaration
     */
    public static final double tickToSeconds(@NotNull List<? extends MidiEvent> tempos, int resolution, long tick2) {
        void $this$foldIndexed$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(tempos, "tempos");
        if (tempos.size() == 1 || tick2 < 0L) {
            return UtilsKt.spb(CollectionsKt.first(tempos)) * ((double)tick2 / (double)resolution);
        }
        Iterable $this$filter$iv = tempos;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MidiEvent it = (MidiEvent)element$iv$iv;
            boolean bl = false;
            if (!(it.getTick() < tick2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        double initial$iv = 0.0;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void tempo;
            void acc;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MidiEvent bl = (MidiEvent)element$iv;
            double d = accumulator$iv;
            int index2 = n;
            boolean bl2 = false;
            int n2 = tempos.size();
            int n3 = index2 + 1;
            accumulator$iv = acc + UtilsKt.toBeats(((0 <= n3 ? n3 < n2 : false) ? RangesKt.coerceAtMost(tempos.get(index2 + 1).getTick(), tick2) : tick2) - tempo.getTick(), resolution) * UtilsKt.spb((MidiEvent)tempo);
        }
        return accumulator$iv;
    }

    private static final double toBeats(Number $this$toBeats, int resolution) {
        return $this$toBeats.doubleValue() / (double)resolution;
    }
}

