/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.Sequence;
import javax.sound.midi.spi.MidiFileReader;
import org.wysko.gervill.SMFParser;

public final class StandardMidiFileReader
extends MidiFileReader {
    private static final int MThd_MAGIC = 1297377380;
    private static final int bisBufferSize = 1024;

    @Override
    public MidiFileFormat getMidiFileFormat(InputStream stream) throws InvalidMidiDataException, IOException {
        return this.getMidiFileFormatFromStream(stream, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MidiFileFormat getMidiFileFormatFromStream(InputStream stream, int fileLength, SMFParser smfParser) throws InvalidMidiDataException, IOException {
        int resolution;
        float divisionType;
        short type2;
        int maxReadLength = 16;
        int duration = -1;
        DataInputStream dis = stream instanceof DataInputStream ? (DataInputStream)stream : new DataInputStream(stream);
        if (smfParser == null) {
            dis.mark(maxReadLength);
        } else {
            smfParser.stream = dis;
        }
        try {
            int magic = dis.readInt();
            if (magic != 1297377380) {
                throw new InvalidMidiDataException("not a valid MIDI file");
            }
            int bytesRemaining = dis.readInt() - 6;
            type2 = dis.readShort();
            short numtracks = dis.readShort();
            int timing = dis.readShort();
            if (timing > 0) {
                divisionType = 0.0f;
                resolution = timing;
            } else {
                int frameCode = -1 * (timing >> 8);
                switch (frameCode) {
                    case 24: {
                        divisionType = 24.0f;
                        break;
                    }
                    case 25: {
                        divisionType = 25.0f;
                        break;
                    }
                    case 29: {
                        divisionType = 29.97f;
                        break;
                    }
                    case 30: {
                        divisionType = 30.0f;
                        break;
                    }
                    default: {
                        throw new InvalidMidiDataException("Unknown frame code: " + frameCode);
                    }
                }
                resolution = timing & 0xFF;
            }
            if (smfParser != null) {
                dis.skip(bytesRemaining);
                smfParser.tracks = numtracks;
            }
        }
        finally {
            if (smfParser == null) {
                dis.reset();
            }
        }
        MidiFileFormat format2 = new MidiFileFormat(type2, divisionType, resolution, fileLength, duration);
        return format2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MidiFileFormat getMidiFileFormat(URL url) throws InvalidMidiDataException, IOException {
        InputStream urlStream = url.openStream();
        MidiFileFormat fileFormat = null;
        try (BufferedInputStream bis = new BufferedInputStream(urlStream, 1024);){
            fileFormat = this.getMidiFileFormat(bis);
        }
        return fileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis, 1024);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            length = -1L;
        }
        MidiFileFormat fileFormat = null;
        try {
            fileFormat = this.getMidiFileFormatFromStream(bis, (int)length, null);
        }
        finally {
            bis.close();
        }
        return fileFormat;
    }

    @Override
    public Sequence getSequence(InputStream stream) throws InvalidMidiDataException, IOException {
        SMFParser smfParser = new SMFParser();
        MidiFileFormat format2 = this.getMidiFileFormatFromStream(stream, -1, smfParser);
        if (format2.getType() != 0 && format2.getType() != 1) {
            throw new InvalidMidiDataException("Invalid or unsupported file type: " + format2.getType());
        }
        Sequence sequence = new Sequence(format2.getDivisionType(), format2.getResolution());
        for (int i = 0; i < smfParser.tracks && smfParser.nextTrack(); ++i) {
            smfParser.readTrack(sequence.createTrack());
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getSequence(URL url) throws InvalidMidiDataException, IOException {
        InputStream is = url.openStream();
        is = new BufferedInputStream(is, 1024);
        Sequence seq = null;
        try {
            seq = this.getSequence(is);
        }
        finally {
            is.close();
        }
        return seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        InputStream is = new FileInputStream(file);
        is = new BufferedInputStream(is, 1024);
        Sequence seq = null;
        try {
            seq = this.getSequence(is);
        }
        finally {
            is.close();
        }
        return seq;
    }
}

