/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.util.TreeMap;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiDeviceReceiver;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import org.wysko.gervill.SoftMainMixer;
import org.wysko.gervill.SoftSynthesizer;

public final class SoftReceiver
implements MidiDeviceReceiver {
    boolean open = true;
    private final Object control_mutex;
    private final SoftSynthesizer synth;
    TreeMap<Long, Object> midimessages;
    SoftMainMixer mainmixer;

    public SoftReceiver(SoftSynthesizer synth) {
        this.control_mutex = synth.control_mutex;
        this.synth = synth;
        this.mainmixer = synth.getMainMixer();
        if (this.mainmixer != null) {
            this.midimessages = this.mainmixer.midimessages;
        }
    }

    @Override
    public MidiDevice getMidiDevice() {
        return this.synth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(MidiMessage message, long timeStamp) {
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.open) {
                throw new IllegalStateException("Receiver is not open");
            }
        }
        if (timeStamp != -1L) {
            object = this.control_mutex;
            synchronized (object) {
                this.mainmixer.activity();
                while (this.midimessages.get(timeStamp) != null) {
                    ++timeStamp;
                }
                if (message instanceof ShortMessage && ((ShortMessage)message).getChannel() > 15) {
                    this.midimessages.put(timeStamp, message.clone());
                } else {
                    this.midimessages.put(timeStamp, message.getMessage());
                }
            }
        } else {
            this.mainmixer.processMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.control_mutex;
        synchronized (object) {
            this.open = false;
        }
        this.synth.removeReceiver(this);
    }
}

