/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import org.wysko.gervill.SoftProcess;
import org.wysko.gervill.SoftSynthesizer;

public final class SoftEnvelopeGenerator
implements SoftProcess {
    public static final int EG_OFF = 0;
    public static final int EG_DELAY = 1;
    public static final int EG_ATTACK = 2;
    public static final int EG_HOLD = 3;
    public static final int EG_DECAY = 4;
    public static final int EG_SUSTAIN = 5;
    public static final int EG_RELEASE = 6;
    public static final int EG_SHUTDOWN = 7;
    public static final int EG_END = 8;
    int max_count = 10;
    int used_count = 0;
    private final int[] stage = new int[this.max_count];
    private final int[] stage_ix = new int[this.max_count];
    private final double[] stage_v = new double[this.max_count];
    private final int[] stage_count = new int[this.max_count];
    private final double[][] on = new double[this.max_count][1];
    private final double[][] active = new double[this.max_count][1];
    private final double[][] out = new double[this.max_count][1];
    private final double[][] delay = new double[this.max_count][1];
    private final double[][] attack = new double[this.max_count][1];
    private final double[][] hold = new double[this.max_count][1];
    private final double[][] decay = new double[this.max_count][1];
    private final double[][] sustain = new double[this.max_count][1];
    private final double[][] release = new double[this.max_count][1];
    private final double[][] shutdown = new double[this.max_count][1];
    private final double[][] release2 = new double[this.max_count][1];
    private final double[][] attack2 = new double[this.max_count][1];
    private final double[][] decay2 = new double[this.max_count][1];
    private double control_time = 0.0;

    @Override
    public void reset() {
        for (int i = 0; i < this.used_count; ++i) {
            this.stage[i] = 0;
            this.on[i][0] = 0.0;
            this.out[i][0] = 0.0;
            this.delay[i][0] = 0.0;
            this.attack[i][0] = 0.0;
            this.hold[i][0] = 0.0;
            this.decay[i][0] = 0.0;
            this.sustain[i][0] = 0.0;
            this.release[i][0] = 0.0;
            this.shutdown[i][0] = 0.0;
            this.attack2[i][0] = 0.0;
            this.decay2[i][0] = 0.0;
            this.release2[i][0] = 0.0;
        }
        this.used_count = 0;
    }

    @Override
    public void init(SoftSynthesizer synth) {
        this.control_time = 1.0 / (double)synth.getControlRate();
        this.processControlLogic();
    }

    @Override
    public double[] get(int instance, String name) {
        if (instance >= this.used_count) {
            this.used_count = instance + 1;
        }
        if (name == null) {
            return this.out[instance];
        }
        if (name.equals("on")) {
            return this.on[instance];
        }
        if (name.equals("active")) {
            return this.active[instance];
        }
        if (name.equals("delay")) {
            return this.delay[instance];
        }
        if (name.equals("attack")) {
            return this.attack[instance];
        }
        if (name.equals("hold")) {
            return this.hold[instance];
        }
        if (name.equals("decay")) {
            return this.decay[instance];
        }
        if (name.equals("sustain")) {
            return this.sustain[instance];
        }
        if (name.equals("release")) {
            return this.release[instance];
        }
        if (name.equals("shutdown")) {
            return this.shutdown[instance];
        }
        if (name.equals("attack2")) {
            return this.attack2[instance];
        }
        if (name.equals("decay2")) {
            return this.decay2[instance];
        }
        if (name.equals("release2")) {
            return this.release2[instance];
        }
        return null;
    }

    @Override
    public void processControlLogic() {
        block10: for (int i = 0; i < this.used_count; ++i) {
            if (this.stage[i] == 8) continue;
            if (this.stage[i] > 0 && this.stage[i] < 6 && this.on[i][0] < 0.5) {
                if (this.on[i][0] < -0.5) {
                    this.stage_count[i] = (int)(Math.pow(2.0, this.shutdown[i][0] / 1200.0) / this.control_time);
                    if (this.stage_count[i] < 0) {
                        this.stage_count[i] = 0;
                    }
                    this.stage_v[i] = this.out[i][0];
                    this.stage_ix[i] = 0;
                    this.stage[i] = 7;
                } else {
                    if (this.release2[i][0] < 1.0E-6 && this.release[i][0] < 0.0 && Double.isInfinite(this.release[i][0])) {
                        this.out[i][0] = 0.0;
                        this.active[i][0] = 0.0;
                        this.stage[i] = 8;
                        continue;
                    }
                    this.stage_count[i] = (int)(Math.pow(2.0, this.release[i][0] / 1200.0) / this.control_time);
                    int n = i;
                    this.stage_count[n] = this.stage_count[n] + (int)(this.release2[i][0] / (this.control_time * 1000.0));
                    if (this.stage_count[i] < 0) {
                        this.stage_count[i] = 0;
                    }
                    this.stage_ix[i] = 0;
                    double m = 1.0 - this.out[i][0];
                    this.stage_ix[i] = (int)((double)this.stage_count[i] * m);
                    this.stage[i] = 6;
                }
            }
            switch (this.stage[i]) {
                case 0: {
                    this.active[i][0] = 1.0;
                    if (this.on[i][0] < 0.5) continue block10;
                    this.stage[i] = 1;
                    this.stage_ix[i] = (int)(Math.pow(2.0, this.delay[i][0] / 1200.0) / this.control_time);
                    if (this.stage_ix[i] < 0) {
                        this.stage_ix[i] = 0;
                    }
                }
                case 1: {
                    if (this.stage_ix[i] == 0) {
                        double attack = this.attack[i][0];
                        double attack2 = this.attack2[i][0];
                        if (attack2 < 1.0E-6 && attack < 0.0 && Double.isInfinite(attack)) {
                            this.out[i][0] = 1.0;
                            this.stage[i] = 3;
                            this.stage_count[i] = (int)(Math.pow(2.0, this.hold[i][0] / 1200.0) / this.control_time);
                            this.stage_ix[i] = 0;
                            continue block10;
                        }
                        this.stage[i] = 2;
                        this.stage_count[i] = (int)(Math.pow(2.0, attack / 1200.0) / this.control_time);
                        int n = i;
                        this.stage_count[n] = this.stage_count[n] + (int)(attack2 / (this.control_time * 1000.0));
                        if (this.stage_count[i] < 0) {
                            this.stage_count[i] = 0;
                        }
                        this.stage_ix[i] = 0;
                        continue block10;
                    }
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] - 1;
                    continue block10;
                }
                case 2: {
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] + 1;
                    if (this.stage_ix[i] >= this.stage_count[i]) {
                        this.out[i][0] = 1.0;
                        this.stage[i] = 3;
                        continue block10;
                    }
                    double a = (double)this.stage_ix[i] / (double)this.stage_count[i];
                    a = 1.0 + 0.4166666666666667 / Math.log(10.0) * Math.log(a);
                    if (a < 0.0) {
                        a = 0.0;
                    } else if (a > 1.0) {
                        a = 1.0;
                    }
                    this.out[i][0] = a;
                    continue block10;
                }
                case 3: {
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] + 1;
                    if (this.stage_ix[i] < this.stage_count[i]) continue block10;
                    this.stage[i] = 4;
                    this.stage_count[i] = (int)(Math.pow(2.0, this.decay[i][0] / 1200.0) / this.control_time);
                    int n2 = i;
                    this.stage_count[n2] = this.stage_count[n2] + (int)(this.decay2[i][0] / (this.control_time * 1000.0));
                    if (this.stage_count[i] < 0) {
                        this.stage_count[i] = 0;
                    }
                    this.stage_ix[i] = 0;
                    continue block10;
                }
                case 4: {
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] + 1;
                    double sustain = this.sustain[i][0] * 0.001;
                    if (this.stage_ix[i] >= this.stage_count[i]) {
                        this.out[i][0] = sustain;
                        this.stage[i] = 5;
                        if (!(sustain < 0.001)) continue block10;
                        this.out[i][0] = 0.0;
                        this.active[i][0] = 0.0;
                        this.stage[i] = 8;
                        continue block10;
                    }
                    double m = (double)this.stage_ix[i] / (double)this.stage_count[i];
                    this.out[i][0] = 1.0 - m + sustain * m;
                    continue block10;
                }
                case 5: {
                    continue block10;
                }
                case 6: {
                    double sustain;
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] + 1;
                    if (this.stage_ix[i] >= this.stage_count[i]) {
                        this.out[i][0] = 0.0;
                        this.active[i][0] = 0.0;
                        this.stage[i] = 8;
                        continue block10;
                    }
                    double m = (double)this.stage_ix[i] / (double)this.stage_count[i];
                    this.out[i][0] = 1.0 - m;
                    if (this.on[i][0] < -0.5) {
                        this.stage_count[i] = (int)(Math.pow(2.0, this.shutdown[i][0] / 1200.0) / this.control_time);
                        if (this.stage_count[i] < 0) {
                            this.stage_count[i] = 0;
                        }
                        this.stage_v[i] = this.out[i][0];
                        this.stage_ix[i] = 0;
                        this.stage[i] = 7;
                    }
                    if (!(this.on[i][0] > 0.5) || !(this.out[i][0] > (sustain = this.sustain[i][0] * 0.001))) continue block10;
                    this.stage[i] = 4;
                    this.stage_count[i] = (int)(Math.pow(2.0, this.decay[i][0] / 1200.0) / this.control_time);
                    int n3 = i;
                    this.stage_count[n3] = this.stage_count[n3] + (int)(this.decay2[i][0] / (this.control_time * 1000.0));
                    if (this.stage_count[i] < 0) {
                        this.stage_count[i] = 0;
                    }
                    m = (this.out[i][0] - 1.0) / (sustain - 1.0);
                    this.stage_ix[i] = (int)((double)this.stage_count[i] * m);
                    continue block10;
                }
                case 7: {
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] + 1;
                    if (this.stage_ix[i] >= this.stage_count[i]) {
                        this.out[i][0] = 0.0;
                        this.active[i][0] = 0.0;
                        this.stage[i] = 8;
                        continue block10;
                    }
                    double m = (double)this.stage_ix[i] / (double)this.stage_count[i];
                    this.out[i][0] = (1.0 - m) * this.stage_v[i];
                    continue block10;
                }
            }
        }
    }
}

