/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import org.wysko.gervill.AudioFloatConverter;

public final class SoftAudioBuffer {
    private int size;
    private float[] buffer;
    private boolean empty = true;
    private AudioFormat format;
    private AudioFloatConverter converter;
    private byte[] converter_buffer;

    public SoftAudioBuffer(int size2, AudioFormat format2) {
        this.size = size2;
        this.format = format2;
        this.converter = AudioFloatConverter.getConverter(format2);
    }

    public void swap(SoftAudioBuffer swap) {
        int bak_size = this.size;
        float[] bak_buffer = this.buffer;
        boolean bak_empty = this.empty;
        AudioFormat bak_format = this.format;
        AudioFloatConverter bak_converter = this.converter;
        byte[] bak_converter_buffer = this.converter_buffer;
        this.size = swap.size;
        this.buffer = swap.buffer;
        this.empty = swap.empty;
        this.format = swap.format;
        this.converter = swap.converter;
        this.converter_buffer = swap.converter_buffer;
        swap.size = bak_size;
        swap.buffer = bak_buffer;
        swap.empty = bak_empty;
        swap.format = bak_format;
        swap.converter = bak_converter;
        swap.converter_buffer = bak_converter_buffer;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        if (!this.empty) {
            Arrays.fill(this.buffer, 0.0f);
            this.empty = true;
        }
    }

    public boolean isSilent() {
        return this.empty;
    }

    public float[] array() {
        this.empty = false;
        if (this.buffer == null) {
            this.buffer = new float[this.size];
        }
        return this.buffer;
    }

    public void get(byte[] buffer, int channel) {
        int framesize_pc = this.format.getFrameSize() / this.format.getChannels();
        int c_len = this.size * framesize_pc;
        if (this.converter_buffer == null || this.converter_buffer.length < c_len) {
            this.converter_buffer = new byte[c_len];
        }
        if (this.format.getChannels() == 1) {
            this.converter.toByteArray(this.array(), this.size, buffer);
        } else {
            this.converter.toByteArray(this.array(), this.size, this.converter_buffer);
            if (channel >= this.format.getChannels()) {
                return;
            }
            int z_stepover = this.format.getChannels() * framesize_pc;
            int k_stepover = framesize_pc;
            for (int j = 0; j < framesize_pc; ++j) {
                int k = j;
                int z = channel * framesize_pc + j;
                for (int i = 0; i < this.size; ++i) {
                    buffer[z] = this.converter_buffer[k];
                    z += z_stepover;
                    k += k_stepover;
                }
            }
        }
    }
}

