/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import org.wysko.gervill.ModelByteBuffer;
import org.wysko.gervill.ModelInstrumentComparator;
import org.wysko.gervill.ModelPatch;
import org.wysko.gervill.RIFFInvalidDataException;
import org.wysko.gervill.RIFFInvalidFormatException;
import org.wysko.gervill.RIFFReader;
import org.wysko.gervill.RIFFWriter;
import org.wysko.gervill.SF2GlobalRegion;
import org.wysko.gervill.SF2Instrument;
import org.wysko.gervill.SF2InstrumentRegion;
import org.wysko.gervill.SF2Layer;
import org.wysko.gervill.SF2LayerRegion;
import org.wysko.gervill.SF2Modulator;
import org.wysko.gervill.SF2Region;
import org.wysko.gervill.SF2Sample;

public final class SF2Soundbank
implements Soundbank {
    int major = 2;
    int minor = 1;
    String targetEngine = "EMU8000";
    String name = "untitled";
    String romName = null;
    int romVersionMajor = -1;
    int romVersionMinor = -1;
    String creationDate = null;
    String engineers = null;
    String product = null;
    String copyright = null;
    String comments = null;
    String tools = null;
    private ModelByteBuffer sampleData = null;
    private ModelByteBuffer sampleData24 = null;
    private File sampleFile = null;
    private boolean largeFormat = false;
    private final List<SF2Instrument> instruments = new ArrayList<SF2Instrument>();
    private final List<SF2Layer> layers = new ArrayList<SF2Layer>();
    private final List<SF2Sample> samples = new ArrayList<SF2Sample>();

    public SF2Soundbank() {
    }

    public SF2Soundbank(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            this.readSoundbank(is);
        }
    }

    public SF2Soundbank(File file) throws IOException {
        this.largeFormat = true;
        this.sampleFile = file;
        try (FileInputStream is = new FileInputStream(file);){
            this.readSoundbank(is);
        }
    }

    public SF2Soundbank(InputStream inputstream) throws IOException {
        this.readSoundbank(inputstream);
    }

    private void readSoundbank(InputStream inputstream) throws IOException {
        RIFFReader riff = new RIFFReader(inputstream);
        if (!riff.getFormat().equals("RIFF")) {
            throw new RIFFInvalidFormatException("Input stream is not a valid RIFF stream!");
        }
        if (!riff.getType().equals("sfbk")) {
            throw new RIFFInvalidFormatException("Input stream is not a valid SoundFont!");
        }
        while (riff.hasNextChunk()) {
            RIFFReader chunk = riff.nextChunk();
            if (!chunk.getFormat().equals("LIST")) continue;
            if (chunk.getType().equals("INFO")) {
                this.readInfoChunk(chunk);
            }
            if (chunk.getType().equals("sdta")) {
                this.readSdtaChunk(chunk);
            }
            if (!chunk.getType().equals("pdta")) continue;
            this.readPdtaChunk(chunk);
        }
    }

    private void readInfoChunk(RIFFReader riff) throws IOException {
        while (riff.hasNextChunk()) {
            RIFFReader chunk = riff.nextChunk();
            String format2 = chunk.getFormat();
            if (format2.equals("ifil")) {
                this.major = chunk.readUnsignedShort();
                this.minor = chunk.readUnsignedShort();
                continue;
            }
            if (format2.equals("isng")) {
                this.targetEngine = chunk.readString(chunk.available());
                continue;
            }
            if (format2.equals("INAM")) {
                this.name = chunk.readString(chunk.available());
                continue;
            }
            if (format2.equals("irom")) {
                this.romName = chunk.readString(chunk.available());
                continue;
            }
            if (format2.equals("iver")) {
                this.romVersionMajor = chunk.readUnsignedShort();
                this.romVersionMinor = chunk.readUnsignedShort();
                continue;
            }
            if (format2.equals("ICRD")) {
                this.creationDate = chunk.readString(chunk.available());
                continue;
            }
            if (format2.equals("IENG")) {
                this.engineers = chunk.readString(chunk.available());
                continue;
            }
            if (format2.equals("IPRD")) {
                this.product = chunk.readString(chunk.available());
                continue;
            }
            if (format2.equals("ICOP")) {
                this.copyright = chunk.readString(chunk.available());
                continue;
            }
            if (format2.equals("ICMT")) {
                this.comments = chunk.readString(chunk.available());
                continue;
            }
            if (!format2.equals("ISFT")) continue;
            this.tools = chunk.readString(chunk.available());
        }
    }

    private void readSdtaChunk(RIFFReader riff) throws IOException {
        while (riff.hasNextChunk()) {
            int avail;
            int read;
            RIFFReader chunk = riff.nextChunk();
            if (chunk.getFormat().equals("smpl")) {
                if (!this.largeFormat) {
                    byte[] sampleData = new byte[chunk.available()];
                    read = 0;
                    avail = chunk.available();
                    while (read != avail) {
                        if (avail - read > 65536) {
                            chunk.readFully(sampleData, read, 65536);
                            read += 65536;
                            continue;
                        }
                        chunk.readFully(sampleData, read, avail - read);
                        read = avail;
                    }
                    this.sampleData = new ModelByteBuffer(sampleData);
                } else {
                    this.sampleData = new ModelByteBuffer(this.sampleFile, chunk.getFilePointer(), (long)chunk.available());
                }
            }
            if (!chunk.getFormat().equals("sm24")) continue;
            if (!this.largeFormat) {
                byte[] sampleData24 = new byte[chunk.available()];
                read = 0;
                avail = chunk.available();
                while (read != avail) {
                    if (avail - read > 65536) {
                        chunk.readFully(sampleData24, read, 65536);
                        read += 65536;
                        continue;
                    }
                    chunk.readFully(sampleData24, read, avail - read);
                    read = avail;
                }
                this.sampleData24 = new ModelByteBuffer(sampleData24);
                continue;
            }
            this.sampleData24 = new ModelByteBuffer(this.sampleFile, chunk.getFilePointer(), (long)chunk.available());
        }
    }

    private void readPdtaChunk(RIFFReader riff) throws IOException {
        ArrayList<SF2Instrument> presets = new ArrayList<SF2Instrument>();
        ArrayList<Integer> presets_bagNdx = new ArrayList<Integer>();
        ArrayList<SF2InstrumentRegion> presets_splits_gen = new ArrayList<SF2InstrumentRegion>();
        ArrayList<SF2InstrumentRegion> presets_splits_mod = new ArrayList<SF2InstrumentRegion>();
        ArrayList<SF2Layer> instruments = new ArrayList<SF2Layer>();
        ArrayList<Integer> instruments_bagNdx = new ArrayList<Integer>();
        ArrayList<SF2InstrumentRegion> instruments_splits_gen = new ArrayList<SF2InstrumentRegion>();
        ArrayList<SF2InstrumentRegion> instruments_splits_mod = new ArrayList<SF2InstrumentRegion>();
        while (riff.hasNextChunk()) {
            int operator;
            int i;
            SF2Region split;
            int modcount;
            int gencount;
            int i2;
            int offset2;
            int modcount2;
            int gencount2;
            int i3;
            int count2;
            RIFFReader chunk = riff.nextChunk();
            String format2 = chunk.getFormat();
            if (format2.equals("phdr")) {
                if (chunk.available() % 38 != 0) {
                    throw new RIFFInvalidDataException();
                }
                count2 = chunk.available() / 38;
                for (i3 = 0; i3 < count2; ++i3) {
                    SF2Instrument preset = new SF2Instrument(this);
                    preset.name = chunk.readString(20);
                    preset.preset = chunk.readUnsignedShort();
                    preset.bank = chunk.readUnsignedShort();
                    presets_bagNdx.add(chunk.readUnsignedShort());
                    preset.library = chunk.readUnsignedInt();
                    preset.genre = chunk.readUnsignedInt();
                    preset.morphology = chunk.readUnsignedInt();
                    presets.add(preset);
                    if (i3 == count2 - 1) continue;
                    this.instruments.add(preset);
                }
                continue;
            }
            if (format2.equals("pbag")) {
                if (chunk.available() % 4 != 0) {
                    throw new RIFFInvalidDataException();
                }
                count2 = chunk.available() / 4;
                gencount2 = chunk.readUnsignedShort();
                modcount2 = chunk.readUnsignedShort();
                while (presets_splits_gen.size() < gencount2) {
                    presets_splits_gen.add(null);
                }
                while (presets_splits_mod.size() < modcount2) {
                    presets_splits_mod.add(null);
                }
                --count2;
                if (presets_bagNdx.isEmpty()) {
                    throw new RIFFInvalidDataException();
                }
                offset2 = (Integer)presets_bagNdx.get(0);
                for (i2 = 0; i2 < offset2; ++i2) {
                    if (count2 == 0) {
                        throw new RIFFInvalidDataException();
                    }
                    int gencount3 = chunk.readUnsignedShort();
                    int modcount3 = chunk.readUnsignedShort();
                    while (presets_splits_gen.size() < gencount3) {
                        presets_splits_gen.add(null);
                    }
                    while (presets_splits_mod.size() < modcount3) {
                        presets_splits_mod.add(null);
                    }
                    --count2;
                }
                for (i2 = 0; i2 < presets_bagNdx.size() - 1; ++i2) {
                    int zone_count = (Integer)presets_bagNdx.get(i2 + 1) - (Integer)presets_bagNdx.get(i2);
                    SF2Instrument preset = (SF2Instrument)presets.get(i2);
                    for (int ii = 0; ii < zone_count; ++ii) {
                        if (count2 == 0) {
                            throw new RIFFInvalidDataException();
                        }
                        gencount = chunk.readUnsignedShort();
                        modcount = chunk.readUnsignedShort();
                        split = new SF2InstrumentRegion();
                        preset.regions.add((SF2InstrumentRegion)split);
                        while (presets_splits_gen.size() < gencount) {
                            presets_splits_gen.add((SF2InstrumentRegion)split);
                        }
                        while (presets_splits_mod.size() < modcount) {
                            presets_splits_mod.add((SF2InstrumentRegion)split);
                        }
                        --count2;
                    }
                }
                continue;
            }
            if (format2.equals("pmod")) {
                for (i = 0; i < presets_splits_mod.size(); ++i) {
                    SF2Modulator modulator = new SF2Modulator();
                    modulator.sourceOperator = chunk.readUnsignedShort();
                    modulator.destinationOperator = chunk.readUnsignedShort();
                    modulator.amount = chunk.readShort();
                    modulator.amountSourceOperator = chunk.readUnsignedShort();
                    modulator.transportOperator = chunk.readUnsignedShort();
                    SF2InstrumentRegion split2 = (SF2InstrumentRegion)presets_splits_mod.get(i);
                    if (split2 == null) continue;
                    split2.modulators.add(modulator);
                }
                continue;
            }
            if (format2.equals("pgen")) {
                for (i = 0; i < presets_splits_gen.size(); ++i) {
                    operator = chunk.readUnsignedShort();
                    short amount = chunk.readShort();
                    SF2InstrumentRegion split3 = (SF2InstrumentRegion)presets_splits_gen.get(i);
                    if (split3 == null) continue;
                    split3.generators.put(operator, amount);
                }
                continue;
            }
            if (format2.equals("inst")) {
                if (chunk.available() % 22 != 0) {
                    throw new RIFFInvalidDataException();
                }
                count2 = chunk.available() / 22;
                for (i3 = 0; i3 < count2; ++i3) {
                    SF2Layer layer = new SF2Layer(this);
                    layer.name = chunk.readString(20);
                    instruments_bagNdx.add(chunk.readUnsignedShort());
                    instruments.add(layer);
                    if (i3 == count2 - 1) continue;
                    this.layers.add(layer);
                }
                continue;
            }
            if (format2.equals("ibag")) {
                if (chunk.available() % 4 != 0) {
                    throw new RIFFInvalidDataException();
                }
                count2 = chunk.available() / 4;
                gencount2 = chunk.readUnsignedShort();
                modcount2 = chunk.readUnsignedShort();
                while (instruments_splits_gen.size() < gencount2) {
                    instruments_splits_gen.add(null);
                }
                while (instruments_splits_mod.size() < modcount2) {
                    instruments_splits_mod.add(null);
                }
                --count2;
                if (instruments_bagNdx.isEmpty()) {
                    throw new RIFFInvalidDataException();
                }
                offset2 = (Integer)instruments_bagNdx.get(0);
                for (i2 = 0; i2 < offset2; ++i2) {
                    if (count2 == 0) {
                        throw new RIFFInvalidDataException();
                    }
                    int gencount4 = chunk.readUnsignedShort();
                    int modcount4 = chunk.readUnsignedShort();
                    while (instruments_splits_gen.size() < gencount4) {
                        instruments_splits_gen.add(null);
                    }
                    while (instruments_splits_mod.size() < modcount4) {
                        instruments_splits_mod.add(null);
                    }
                    --count2;
                }
                for (i2 = 0; i2 < instruments_bagNdx.size() - 1; ++i2) {
                    int zone_count = (Integer)instruments_bagNdx.get(i2 + 1) - (Integer)instruments_bagNdx.get(i2);
                    SF2Layer layer = this.layers.get(i2);
                    for (int ii = 0; ii < zone_count; ++ii) {
                        if (count2 == 0) {
                            throw new RIFFInvalidDataException();
                        }
                        gencount = chunk.readUnsignedShort();
                        modcount = chunk.readUnsignedShort();
                        split = new SF2LayerRegion();
                        layer.regions.add((SF2LayerRegion)split);
                        while (instruments_splits_gen.size() < gencount) {
                            instruments_splits_gen.add((SF2InstrumentRegion)split);
                        }
                        while (instruments_splits_mod.size() < modcount) {
                            instruments_splits_mod.add((SF2InstrumentRegion)split);
                        }
                        --count2;
                    }
                }
                continue;
            }
            if (format2.equals("imod")) {
                for (i = 0; i < instruments_splits_mod.size(); ++i) {
                    SF2Modulator modulator = new SF2Modulator();
                    modulator.sourceOperator = chunk.readUnsignedShort();
                    modulator.destinationOperator = chunk.readUnsignedShort();
                    modulator.amount = chunk.readShort();
                    modulator.amountSourceOperator = chunk.readUnsignedShort();
                    modulator.transportOperator = chunk.readUnsignedShort();
                    if (i < 0 || i >= instruments_splits_gen.size()) {
                        throw new RIFFInvalidDataException();
                    }
                    SF2LayerRegion split4 = (SF2LayerRegion)instruments_splits_gen.get(i);
                    if (split4 == null) continue;
                    split4.modulators.add(modulator);
                }
                continue;
            }
            if (format2.equals("igen")) {
                for (i = 0; i < instruments_splits_gen.size(); ++i) {
                    operator = chunk.readUnsignedShort();
                    short amount = chunk.readShort();
                    SF2LayerRegion split5 = (SF2LayerRegion)instruments_splits_gen.get(i);
                    if (split5 == null) continue;
                    split5.generators.put(operator, amount);
                }
                continue;
            }
            if (!format2.equals("shdr")) continue;
            if (chunk.available() % 46 != 0) {
                throw new RIFFInvalidDataException();
            }
            count2 = chunk.available() / 46;
            for (i3 = 0; i3 < count2; ++i3) {
                SF2Sample sample2 = new SF2Sample(this);
                sample2.name = chunk.readString(20);
                long start2 = chunk.readUnsignedInt();
                long end2 = chunk.readUnsignedInt();
                if (this.sampleData != null) {
                    sample2.data = this.sampleData.subbuffer(start2 * 2L, end2 * 2L, true);
                }
                if (this.sampleData24 != null) {
                    sample2.data24 = this.sampleData24.subbuffer(start2, end2, true);
                }
                sample2.startLoop = chunk.readUnsignedInt() - start2;
                sample2.endLoop = chunk.readUnsignedInt() - start2;
                if (sample2.startLoop < 0L) {
                    sample2.startLoop = -1L;
                }
                if (sample2.endLoop < 0L) {
                    sample2.endLoop = -1L;
                }
                sample2.sampleRate = chunk.readUnsignedInt();
                sample2.originalPitch = chunk.readUnsignedByte();
                sample2.pitchCorrection = chunk.readByte();
                sample2.sampleLink = chunk.readUnsignedShort();
                sample2.sampleType = chunk.readUnsignedShort();
                if (i3 == count2 - 1) continue;
                this.samples.add(sample2);
            }
        }
        for (SF2Layer layer : this.layers) {
            Iterator<SF2LayerRegion> siter = layer.regions.iterator();
            SF2LayerRegion globalsplit = null;
            while (siter.hasNext()) {
                SF2LayerRegion split = siter.next();
                if (split.generators.get(53) != null) {
                    short sampleid = (Short)split.generators.get(53);
                    split.generators.remove(53);
                    if (sampleid < 0 || sampleid >= this.samples.size()) {
                        throw new RIFFInvalidDataException();
                    }
                    split.sample = this.samples.get(sampleid);
                    continue;
                }
                globalsplit = split;
            }
            if (globalsplit == null) continue;
            layer.getRegions().remove(globalsplit);
            SF2GlobalRegion gsplit = new SF2GlobalRegion();
            gsplit.generators = globalsplit.generators;
            gsplit.modulators = globalsplit.modulators;
            layer.setGlobalZone(gsplit);
        }
        for (SF2Instrument instrument : this.instruments) {
            Iterator<SF2InstrumentRegion> siter = instrument.regions.iterator();
            SF2InstrumentRegion globalsplit = null;
            while (siter.hasNext()) {
                SF2InstrumentRegion split = siter.next();
                if (split.generators.get(41) != null) {
                    short instrumentid = (Short)split.generators.get(41);
                    split.generators.remove(41);
                    if (instrumentid < 0 || instrumentid >= this.layers.size()) {
                        throw new RIFFInvalidDataException();
                    }
                    split.layer = this.layers.get(instrumentid);
                    continue;
                }
                globalsplit = split;
            }
            if (globalsplit == null) continue;
            instrument.getRegions().remove(globalsplit);
            SF2GlobalRegion gsplit = new SF2GlobalRegion();
            gsplit.generators = globalsplit.generators;
            gsplit.modulators = globalsplit.modulators;
            instrument.setGlobalZone(gsplit);
        }
    }

    public void save(String name) throws IOException {
        this.writeSoundbank(new RIFFWriter(name, "sfbk"));
    }

    public void save(File file) throws IOException {
        this.writeSoundbank(new RIFFWriter(file, "sfbk"));
    }

    public void save(OutputStream out) throws IOException {
        this.writeSoundbank(new RIFFWriter(out, "sfbk"));
    }

    private void writeSoundbank(RIFFWriter writer) throws IOException {
        this.writeInfo(writer.writeList("INFO"));
        this.writeSdtaChunk(writer.writeList("sdta"));
        this.writePdtaChunk(writer.writeList("pdta"));
        writer.close();
    }

    private void writeInfoStringChunk(RIFFWriter writer, String name, String value) throws IOException {
        if (value == null) {
            return;
        }
        RIFFWriter chunk = writer.writeChunk(name);
        chunk.writeString(value);
        int len = value.getBytes("ascii").length;
        chunk.write(0);
        if (++len % 2 != 0) {
            chunk.write(0);
        }
    }

    private void writeInfo(RIFFWriter writer) throws IOException {
        if (this.targetEngine == null) {
            this.targetEngine = "EMU8000";
        }
        if (this.name == null) {
            this.name = "";
        }
        RIFFWriter ifil_chunk = writer.writeChunk("ifil");
        ifil_chunk.writeUnsignedShort(this.major);
        ifil_chunk.writeUnsignedShort(this.minor);
        this.writeInfoStringChunk(writer, "isng", this.targetEngine);
        this.writeInfoStringChunk(writer, "INAM", this.name);
        this.writeInfoStringChunk(writer, "irom", this.romName);
        if (this.romVersionMajor != -1) {
            RIFFWriter iver_chunk = writer.writeChunk("iver");
            iver_chunk.writeUnsignedShort(this.romVersionMajor);
            iver_chunk.writeUnsignedShort(this.romVersionMinor);
        }
        this.writeInfoStringChunk(writer, "ICRD", this.creationDate);
        this.writeInfoStringChunk(writer, "IENG", this.engineers);
        this.writeInfoStringChunk(writer, "IPRD", this.product);
        this.writeInfoStringChunk(writer, "ICOP", this.copyright);
        this.writeInfoStringChunk(writer, "ICMT", this.comments);
        this.writeInfoStringChunk(writer, "ISFT", this.tools);
        writer.close();
    }

    private void writeSdtaChunk(RIFFWriter writer) throws IOException {
        byte[] pad = new byte[32];
        RIFFWriter smpl_chunk = writer.writeChunk("smpl");
        for (SF2Sample sample2 : this.samples) {
            ModelByteBuffer data2 = sample2.getDataBuffer();
            data2.writeTo(smpl_chunk);
            smpl_chunk.write(pad);
            smpl_chunk.write(pad);
        }
        if (this.major < 2) {
            return;
        }
        if (this.major == 2 && this.minor < 4) {
            return;
        }
        for (SF2Sample sample2 : this.samples) {
            ModelByteBuffer data24 = sample2.getData24Buffer();
            if (data24 != null) continue;
            return;
        }
        RIFFWriter sm24_chunk = writer.writeChunk("sm24");
        for (SF2Sample sample3 : this.samples) {
            ModelByteBuffer data3 = sample3.getData24Buffer();
            data3.writeTo(sm24_chunk);
            smpl_chunk.write(pad);
        }
    }

    private void writeModulators(RIFFWriter writer, List<SF2Modulator> modulators) throws IOException {
        for (SF2Modulator modulator : modulators) {
            writer.writeUnsignedShort(modulator.sourceOperator);
            writer.writeUnsignedShort(modulator.destinationOperator);
            writer.writeShort(modulator.amount);
            writer.writeUnsignedShort(modulator.amountSourceOperator);
            writer.writeUnsignedShort(modulator.transportOperator);
        }
    }

    private void writeGenerators(RIFFWriter writer, Map<Integer, Short> generators) throws IOException {
        Short keyrange = generators.get(43);
        Short velrange = generators.get(44);
        if (keyrange != null) {
            writer.writeUnsignedShort(43);
            writer.writeShort(keyrange);
        }
        if (velrange != null) {
            writer.writeUnsignedShort(44);
            writer.writeShort(velrange);
        }
        for (Map.Entry<Integer, Short> generator : generators.entrySet()) {
            if (generator.getKey() == 43 || generator.getKey() == 44) continue;
            writer.writeUnsignedShort(generator.getKey());
            writer.writeShort(generator.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writePdtaChunk(RIFFWriter writer) throws IOException {
        void var10_23;
        RIFFWriter phdr_chunk = writer.writeChunk("phdr");
        int phdr_zone_count = 0;
        for (SF2Instrument preset : this.instruments) {
            phdr_chunk.writeString(preset.name, 20);
            phdr_chunk.writeUnsignedShort(preset.preset);
            phdr_chunk.writeUnsignedShort(preset.bank);
            phdr_chunk.writeUnsignedShort(phdr_zone_count);
            if (preset.getGlobalRegion() != null) {
                ++phdr_zone_count;
            }
            phdr_zone_count += preset.getRegions().size();
            phdr_chunk.writeUnsignedInt(preset.library);
            phdr_chunk.writeUnsignedInt(preset.genre);
            phdr_chunk.writeUnsignedInt(preset.morphology);
        }
        phdr_chunk.writeString("EOP", 20);
        phdr_chunk.writeUnsignedShort(0);
        phdr_chunk.writeUnsignedShort(0);
        phdr_chunk.writeUnsignedShort(phdr_zone_count);
        phdr_chunk.writeUnsignedInt(0L);
        phdr_chunk.writeUnsignedInt(0L);
        phdr_chunk.writeUnsignedInt(0L);
        RIFFWriter pbag_chunk = writer.writeChunk("pbag");
        int pbag_gencount = 0;
        int pbag_modcount = 0;
        for (SF2Instrument sF2Instrument : this.instruments) {
            if (sF2Instrument.getGlobalRegion() != null) {
                pbag_chunk.writeUnsignedShort(pbag_gencount);
                pbag_chunk.writeUnsignedShort(pbag_modcount);
                pbag_gencount += sF2Instrument.getGlobalRegion().getGenerators().size();
                pbag_modcount += sF2Instrument.getGlobalRegion().getModulators().size();
            }
            for (SF2InstrumentRegion sF2InstrumentRegion : sF2Instrument.getRegions()) {
                pbag_chunk.writeUnsignedShort(pbag_gencount);
                pbag_chunk.writeUnsignedShort(pbag_modcount);
                if (this.layers.indexOf(sF2InstrumentRegion.layer) != -1) {
                    ++pbag_gencount;
                }
                pbag_gencount += sF2InstrumentRegion.getGenerators().size();
                pbag_modcount += sF2InstrumentRegion.getModulators().size();
            }
        }
        pbag_chunk.writeUnsignedShort(pbag_gencount);
        pbag_chunk.writeUnsignedShort(pbag_modcount);
        RIFFWriter pmod_chunk = writer.writeChunk("pmod");
        for (SF2Instrument sF2Instrument : this.instruments) {
            if (sF2Instrument.getGlobalRegion() != null) {
                this.writeModulators(pmod_chunk, sF2Instrument.getGlobalRegion().getModulators());
            }
            for (SF2InstrumentRegion sF2InstrumentRegion : sF2Instrument.getRegions()) {
                this.writeModulators(pmod_chunk, sF2InstrumentRegion.getModulators());
            }
        }
        pmod_chunk.write(new byte[10]);
        RIFFWriter rIFFWriter = writer.writeChunk("pgen");
        for (SF2Instrument sF2Instrument : this.instruments) {
            if (sF2Instrument.getGlobalRegion() != null) {
                this.writeGenerators(rIFFWriter, sF2Instrument.getGlobalRegion().getGenerators());
            }
            for (SF2InstrumentRegion region : sF2Instrument.getRegions()) {
                this.writeGenerators(rIFFWriter, region.getGenerators());
                int ix = this.layers.indexOf(region.layer);
                if (ix == -1) continue;
                rIFFWriter.writeUnsignedShort(41);
                rIFFWriter.writeShort((short)ix);
            }
        }
        rIFFWriter.write(new byte[4]);
        RIFFWriter rIFFWriter2 = writer.writeChunk("inst");
        boolean bl = false;
        for (SF2Layer instrument : this.layers) {
            rIFFWriter2.writeString(instrument.name, 20);
            rIFFWriter2.writeUnsignedShort((int)var10_23);
            if (instrument.getGlobalRegion() != null) {
                ++var10_23;
            }
            var10_23 += instrument.getRegions().size();
        }
        rIFFWriter2.writeString("EOI", 20);
        rIFFWriter2.writeUnsignedShort((int)var10_23);
        RIFFWriter rIFFWriter3 = writer.writeChunk("ibag");
        int ibag_gencount = 0;
        int ibag_modcount = 0;
        for (SF2Layer sF2Layer : this.layers) {
            if (sF2Layer.getGlobalRegion() != null) {
                rIFFWriter3.writeUnsignedShort(ibag_gencount);
                rIFFWriter3.writeUnsignedShort(ibag_modcount);
                ibag_gencount += sF2Layer.getGlobalRegion().getGenerators().size();
                ibag_modcount += sF2Layer.getGlobalRegion().getModulators().size();
            }
            for (SF2LayerRegion sF2LayerRegion : sF2Layer.getRegions()) {
                rIFFWriter3.writeUnsignedShort(ibag_gencount);
                rIFFWriter3.writeUnsignedShort(ibag_modcount);
                if (this.samples.indexOf(sF2LayerRegion.sample) != -1) {
                    ++ibag_gencount;
                }
                ibag_gencount += sF2LayerRegion.getGenerators().size();
                ibag_modcount += sF2LayerRegion.getModulators().size();
            }
        }
        rIFFWriter3.writeUnsignedShort(ibag_gencount);
        rIFFWriter3.writeUnsignedShort(ibag_modcount);
        RIFFWriter imod_chunk = writer.writeChunk("imod");
        for (SF2Layer sF2Layer : this.layers) {
            if (sF2Layer.getGlobalRegion() != null) {
                this.writeModulators(imod_chunk, sF2Layer.getGlobalRegion().getModulators());
            }
            for (SF2LayerRegion region : sF2Layer.getRegions()) {
                this.writeModulators(imod_chunk, region.getModulators());
            }
        }
        imod_chunk.write(new byte[10]);
        RIFFWriter rIFFWriter4 = writer.writeChunk("igen");
        for (SF2Layer sF2Layer : this.layers) {
            if (sF2Layer.getGlobalRegion() != null) {
                this.writeGenerators(rIFFWriter4, sF2Layer.getGlobalRegion().getGenerators());
            }
            for (SF2LayerRegion region : sF2Layer.getRegions()) {
                this.writeGenerators(rIFFWriter4, region.getGenerators());
                int ix = this.samples.indexOf(region.sample);
                if (ix == -1) continue;
                rIFFWriter4.writeUnsignedShort(53);
                rIFFWriter4.writeShort((short)ix);
            }
        }
        rIFFWriter4.write(new byte[4]);
        RIFFWriter rIFFWriter5 = writer.writeChunk("shdr");
        long l = 0L;
        for (SF2Sample sample2 : this.samples) {
            rIFFWriter5.writeString(sample2.name, 20);
            long start2 = l;
            long end2 = l += sample2.data.capacity() / 2L;
            long startLoop = sample2.startLoop + start2;
            long endLoop = sample2.endLoop + start2;
            if (startLoop < start2) {
                startLoop = start2;
            }
            if (endLoop > end2) {
                endLoop = end2;
            }
            rIFFWriter5.writeUnsignedInt(start2);
            rIFFWriter5.writeUnsignedInt(end2);
            rIFFWriter5.writeUnsignedInt(startLoop);
            rIFFWriter5.writeUnsignedInt(endLoop);
            rIFFWriter5.writeUnsignedInt(sample2.sampleRate);
            rIFFWriter5.writeUnsignedByte(sample2.originalPitch);
            rIFFWriter5.writeByte(sample2.pitchCorrection);
            rIFFWriter5.writeUnsignedShort(sample2.sampleLink);
            rIFFWriter5.writeUnsignedShort(sample2.sampleType);
            l += 32L;
        }
        rIFFWriter5.writeString("EOS", 20);
        rIFFWriter5.write(new byte[26]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.major + "." + this.minor;
    }

    @Override
    public String getVendor() {
        return this.engineers;
    }

    @Override
    public String getDescription() {
        return this.comments;
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setVendor(String s) {
        this.engineers = s;
    }

    public void setDescription(String s) {
        this.comments = s;
    }

    @Override
    public SoundbankResource[] getResources() {
        int i;
        SoundbankResource[] resources = new SoundbankResource[this.layers.size() + this.samples.size()];
        int j = 0;
        for (i = 0; i < this.layers.size(); ++i) {
            resources[j++] = this.layers.get(i);
        }
        for (i = 0; i < this.samples.size(); ++i) {
            resources[j++] = this.samples.get(i);
        }
        return resources;
    }

    public SF2Instrument[] getInstruments() {
        SF2Instrument[] inslist_array = this.instruments.toArray(new SF2Instrument[this.instruments.size()]);
        Arrays.sort(inslist_array, new ModelInstrumentComparator());
        return inslist_array;
    }

    public SF2Layer[] getLayers() {
        return this.layers.toArray(new SF2Layer[this.layers.size()]);
    }

    public SF2Sample[] getSamples() {
        return this.samples.toArray(new SF2Sample[this.samples.size()]);
    }

    @Override
    public Instrument getInstrument(Patch patch) {
        int program = patch.getProgram();
        int bank = patch.getBank();
        boolean percussion = false;
        if (patch instanceof ModelPatch) {
            percussion = ((ModelPatch)patch).isPercussion();
        }
        for (Instrument instrument : this.instruments) {
            Patch patch2 = instrument.getPatch();
            int program2 = patch2.getProgram();
            int bank2 = patch2.getBank();
            if (program != program2 || bank != bank2) continue;
            boolean percussion2 = false;
            if (patch2 instanceof ModelPatch) {
                percussion2 = ((ModelPatch)patch2).isPercussion();
            }
            if (percussion != percussion2) continue;
            return instrument;
        }
        return null;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getRomName() {
        return this.romName;
    }

    public void setRomName(String romName) {
        this.romName = romName;
    }

    public int getRomVersionMajor() {
        return this.romVersionMajor;
    }

    public void setRomVersionMajor(int romVersionMajor) {
        this.romVersionMajor = romVersionMajor;
    }

    public int getRomVersionMinor() {
        return this.romVersionMinor;
    }

    public void setRomVersionMinor(int romVersionMinor) {
        this.romVersionMinor = romVersionMinor;
    }

    public String getTargetEngine() {
        return this.targetEngine;
    }

    public void setTargetEngine(String targetEngine) {
        this.targetEngine = targetEngine;
    }

    public String getTools() {
        return this.tools;
    }

    public void setTools(String tools) {
        this.tools = tools;
    }

    public void addResource(SoundbankResource resource2) {
        if (resource2 instanceof SF2Instrument) {
            this.instruments.add((SF2Instrument)resource2);
        }
        if (resource2 instanceof SF2Layer) {
            this.layers.add((SF2Layer)resource2);
        }
        if (resource2 instanceof SF2Sample) {
            this.samples.add((SF2Sample)resource2);
        }
    }

    public void removeResource(SoundbankResource resource2) {
        if (resource2 instanceof SF2Instrument) {
            this.instruments.remove((SF2Instrument)resource2);
        }
        if (resource2 instanceof SF2Layer) {
            this.layers.remove((SF2Layer)resource2);
        }
        if (resource2 instanceof SF2Sample) {
            this.samples.remove((SF2Sample)resource2);
        }
    }

    public void addInstrument(SF2Instrument resource2) {
        this.instruments.add(resource2);
    }

    public void removeInstrument(SF2Instrument resource2) {
        this.instruments.remove(resource2);
    }
}

