/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public final class RIFFWriter
extends OutputStream {
    private int chunktype = 0;
    private RandomAccessWriter raf;
    private final long chunksizepointer;
    private final long startpointer;
    private RIFFWriter childchunk = null;
    private boolean open = true;
    private boolean writeoverride = false;

    public RIFFWriter(String name, String format2) throws IOException {
        this(new RandomAccessFileWriter(name), format2, 0);
    }

    public RIFFWriter(File file, String format2) throws IOException {
        this(new RandomAccessFileWriter(file), format2, 0);
    }

    public RIFFWriter(OutputStream stream, String format2) throws IOException {
        this(new RandomAccessByteWriter(stream), format2, 0);
    }

    private RIFFWriter(RandomAccessWriter raf, String format2, int chunktype) throws IOException {
        if (chunktype == 0 && raf.length() != 0L) {
            raf.setLength(0L);
        }
        this.raf = raf;
        if (raf.getPointer() % 2L != 0L) {
            raf.write(0);
        }
        if (chunktype == 0) {
            raf.write("RIFF".getBytes("ascii"));
        } else if (chunktype == 1) {
            raf.write("LIST".getBytes("ascii"));
        } else {
            raf.write((format2 + "    ").substring(0, 4).getBytes("ascii"));
        }
        this.chunksizepointer = raf.getPointer();
        this.chunktype = 2;
        this.writeUnsignedInt(0L);
        this.chunktype = chunktype;
        this.startpointer = raf.getPointer();
        if (chunktype != 2) {
            raf.write((format2 + "    ").substring(0, 4).getBytes("ascii"));
        }
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.raf.getPointer();
    }

    public void setWriteOverride(boolean writeoverride) {
        this.writeoverride = writeoverride;
    }

    public boolean getWriteOverride() {
        return this.writeoverride;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        if (this.childchunk != null) {
            this.childchunk.close();
            this.childchunk = null;
        }
        int bakchunktype = this.chunktype;
        long fpointer = this.raf.getPointer();
        this.raf.seek(this.chunksizepointer);
        this.chunktype = 2;
        this.writeUnsignedInt(fpointer - this.startpointer);
        if (bakchunktype == 0) {
            this.raf.close();
        } else {
            this.raf.seek(fpointer);
        }
        this.open = false;
        this.raf = null;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.writeoverride) {
            if (this.chunktype != 2) {
                throw new IllegalArgumentException("Only chunks can write bytes!");
            }
            if (this.childchunk != null) {
                this.childchunk.close();
                this.childchunk = null;
            }
        }
        this.raf.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.writeoverride) {
            if (this.chunktype != 2) {
                throw new IllegalArgumentException("Only chunks can write bytes!");
            }
            if (this.childchunk != null) {
                this.childchunk.close();
                this.childchunk = null;
            }
        }
        this.raf.write(b, off, len);
    }

    public RIFFWriter writeList(String format2) throws IOException {
        if (this.chunktype == 2) {
            throw new IllegalArgumentException("Only LIST and RIFF can write lists!");
        }
        if (this.childchunk != null) {
            this.childchunk.close();
            this.childchunk = null;
        }
        this.childchunk = new RIFFWriter(this.raf, format2, 1);
        return this.childchunk;
    }

    public RIFFWriter writeChunk(String format2) throws IOException {
        if (this.chunktype == 2) {
            throw new IllegalArgumentException("Only LIST and RIFF can write chunks!");
        }
        if (this.childchunk != null) {
            this.childchunk.close();
            this.childchunk = null;
        }
        this.childchunk = new RIFFWriter(this.raf, format2, 2);
        return this.childchunk;
    }

    public void writeString(String string) throws IOException {
        byte[] buff = string.getBytes();
        this.write(buff);
    }

    public void writeString(String string, int len) throws IOException {
        byte[] buff = string.getBytes();
        if (buff.length > len) {
            this.write(buff, 0, len);
        } else {
            this.write(buff);
            for (int i = buff.length; i < len; ++i) {
                this.write(0);
            }
        }
    }

    public void writeByte(int b) throws IOException {
        this.write(b);
    }

    public void writeShort(short b) throws IOException {
        this.write(b >>> 0 & 0xFF);
        this.write(b >>> 8 & 0xFF);
    }

    public void writeInt(int b) throws IOException {
        this.write(b >>> 0 & 0xFF);
        this.write(b >>> 8 & 0xFF);
        this.write(b >>> 16 & 0xFF);
        this.write(b >>> 24 & 0xFF);
    }

    public void writeLong(long b) throws IOException {
        this.write((int)(b >>> 0) & 0xFF);
        this.write((int)(b >>> 8) & 0xFF);
        this.write((int)(b >>> 16) & 0xFF);
        this.write((int)(b >>> 24) & 0xFF);
        this.write((int)(b >>> 32) & 0xFF);
        this.write((int)(b >>> 40) & 0xFF);
        this.write((int)(b >>> 48) & 0xFF);
        this.write((int)(b >>> 56) & 0xFF);
    }

    public void writeUnsignedByte(int b) throws IOException {
        this.writeByte((byte)b);
    }

    public void writeUnsignedShort(int b) throws IOException {
        this.writeShort((short)b);
    }

    public void writeUnsignedInt(long b) throws IOException {
        this.writeInt((int)b);
    }

    private static class RandomAccessByteWriter
    implements RandomAccessWriter {
        byte[] buff = new byte[32];
        int length = 0;
        int pos = 0;
        byte[] s;
        final OutputStream stream;

        RandomAccessByteWriter(OutputStream stream) {
            this.stream = stream;
        }

        @Override
        public void seek(long chunksizepointer) throws IOException {
            this.pos = (int)chunksizepointer;
        }

        @Override
        public long getPointer() throws IOException {
            return this.pos;
        }

        @Override
        public void close() throws IOException {
            this.stream.write(this.buff, 0, this.length);
            this.stream.close();
        }

        @Override
        public void write(int b) throws IOException {
            if (this.s == null) {
                this.s = new byte[1];
            }
            this.s[0] = (byte)b;
            this.write(this.s, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int newsize = this.pos + len;
            if (newsize > this.length) {
                this.setLength(newsize);
            }
            int end2 = off + len;
            for (int i = off; i < end2; ++i) {
                this.buff[this.pos++] = b[i];
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public long length() throws IOException {
            return this.length;
        }

        @Override
        public void setLength(long i) throws IOException {
            this.length = (int)i;
            if (this.length > this.buff.length) {
                int newlen = Math.max(this.buff.length << 1, this.length);
                byte[] newbuff = new byte[newlen];
                System.arraycopy(this.buff, 0, newbuff, 0, this.buff.length);
                this.buff = newbuff;
            }
        }
    }

    private static class RandomAccessFileWriter
    implements RandomAccessWriter {
        RandomAccessFile raf;

        RandomAccessFileWriter(File file) throws FileNotFoundException {
            this.raf = new RandomAccessFile(file, "rw");
        }

        RandomAccessFileWriter(String name) throws FileNotFoundException {
            this.raf = new RandomAccessFile(name, "rw");
        }

        @Override
        public void seek(long chunksizepointer) throws IOException {
            this.raf.seek(chunksizepointer);
        }

        @Override
        public long getPointer() throws IOException {
            return this.raf.getFilePointer();
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }

        @Override
        public void write(int b) throws IOException {
            this.raf.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.raf.write(b, off, len);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.raf.write(bytes);
        }

        @Override
        public long length() throws IOException {
            return this.raf.length();
        }

        @Override
        public void setLength(long i) throws IOException {
            this.raf.setLength(i);
        }
    }

    private static interface RandomAccessWriter {
        public void seek(long var1) throws IOException;

        public long getPointer() throws IOException;

        public void close() throws IOException;

        public void write(int var1) throws IOException;

        public void write(byte[] var1, int var2, int var3) throws IOException;

        public void write(byte[] var1) throws IOException;

        public long length() throws IOException;

        public void setLength(long var1) throws IOException;
    }
}

