/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;
import org.wysko.gervill.Platform;
import org.wysko.gervill.PortMixer;

public final class PortMixerProvider
extends MixerProvider {
    private static PortMixerInfo[] infos;
    private static PortMixer[] devices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortMixerProvider() {
        Class<PortMixerProvider> clazz = PortMixerProvider.class;
        synchronized (PortMixerProvider.class) {
            if (Platform.isPortsEnabled()) {
                PortMixerProvider.init();
            } else {
                infos = new PortMixerInfo[0];
                devices = new PortMixer[0];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void init() {
        int numDevices = PortMixerProvider.nGetNumDevices();
        if (infos == null || infos.length != numDevices) {
            infos = new PortMixerInfo[numDevices];
            devices = new PortMixer[numDevices];
            for (int i = 0; i < infos.length; ++i) {
                PortMixerProvider.infos[i] = PortMixerProvider.nNewPortMixerInfo(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer.Info[] getMixerInfo() {
        Class<PortMixerProvider> clazz = PortMixerProvider.class;
        synchronized (PortMixerProvider.class) {
            Mixer.Info[] localArray = new Mixer.Info[infos.length];
            System.arraycopy(infos, 0, localArray, 0, infos.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer getMixer(Mixer.Info info2) {
        Class<PortMixerProvider> clazz = PortMixerProvider.class;
        synchronized (PortMixerProvider.class) {
            for (int i = 0; i < infos.length; ++i) {
                if (!infos[i].equals(info2)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return PortMixerProvider.getDevice(infos[i]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            throw new IllegalArgumentException("Mixer " + info2.toString() + " not supported by this provider.");
        }
    }

    private static Mixer getDevice(PortMixerInfo info2) {
        int index2 = info2.getIndex();
        if (devices[index2] == null) {
            PortMixerProvider.devices[index2] = new PortMixer(info2);
        }
        return devices[index2];
    }

    private static native int nGetNumDevices();

    private static native PortMixerInfo nNewPortMixerInfo(int var0);

    static {
        Platform.initialize();
    }

    static final class PortMixerInfo
    extends Mixer.Info {
        private final int index;

        private PortMixerInfo(int index2, String name, String vendor, String description2, String version) {
            super("Port " + name, vendor, description2, version);
            this.index = index2;
        }

        int getIndex() {
            return this.index;
        }
    }
}

