/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.security.AccessController;
import java.util.StringTokenizer;

final class Platform {
    private static final String libNameMain = "jsound";
    private static final String libNameALSA = "jsoundalsa";
    private static final String libNameDSound = "jsoundds";
    public static final int LIB_MAIN = 1;
    public static final int LIB_ALSA = 2;
    public static final int LIB_DSOUND = 4;
    private static int loadedLibs = 0;
    public static final int FEATURE_MIDIIO = 1;
    public static final int FEATURE_PORTS = 2;
    public static final int FEATURE_DIRECT_AUDIO = 3;
    private static boolean signed8;
    private static boolean bigEndian;

    private Platform() {
    }

    static void initialize() {
    }

    static boolean isBigEndian() {
        return bigEndian;
    }

    static boolean isSigned8() {
        return signed8;
    }

    private static void loadLibraries() {
        AccessController.doPrivileged(() -> {
            System.loadLibrary(libNameMain);
            return null;
        });
        loadedLibs |= 1;
        String extraLibs = Platform.nGetExtraLibraries();
        StringTokenizer st = new StringTokenizer(extraLibs);
        while (st.hasMoreTokens()) {
            String lib = st.nextToken();
            try {
                AccessController.doPrivileged(() -> {
                    System.loadLibrary(lib);
                    return null;
                });
                if (lib.equals(libNameALSA)) {
                    loadedLibs |= 2;
                    continue;
                }
                if (!lib.equals(libNameDSound)) continue;
                loadedLibs |= 4;
            }
            catch (Throwable throwable) {}
        }
    }

    static boolean isMidiIOEnabled() {
        return Platform.isFeatureLibLoaded(1);
    }

    static boolean isPortsEnabled() {
        return Platform.isFeatureLibLoaded(2);
    }

    static boolean isDirectAudioEnabled() {
        return Platform.isFeatureLibLoaded(3);
    }

    private static boolean isFeatureLibLoaded(int feature) {
        int requiredLib = Platform.nGetLibraryForFeature(feature);
        boolean isLoaded = requiredLib != 0 && (loadedLibs & requiredLib) == requiredLib;
        return isLoaded;
    }

    private static native boolean nIsBigEndian();

    private static native boolean nIsSigned8();

    private static native String nGetExtraLibraries();

    private static native int nGetLibraryForFeature(int var0);

    private static void readProperties() {
        bigEndian = Platform.nIsBigEndian();
        signed8 = Platform.nIsSigned8();
    }

    static {
        Platform.loadLibraries();
        Platform.readProperties();
    }
}

