/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.wysko.gervill.SunCodec;

public final class PCMtoPCMCodec
extends SunCodec {
    private static final AudioFormat.Encoding[] inputEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED};
    private static final AudioFormat.Encoding[] outputEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED};
    private static final int tempBufferSize = 64;
    private byte[] tempBuffer = null;

    public PCMtoPCMCodec() {
        super(inputEncodings, outputEncodings);
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            AudioFormat.Encoding[] encs = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED};
            return encs;
        }
        return new AudioFormat.Encoding[0];
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        AudioFormat[] formats = this.getOutputFormats(sourceFormat);
        Vector<AudioFormat> newFormats = new Vector<AudioFormat>();
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].getEncoding().equals(targetEncoding)) continue;
            newFormats.addElement(formats[i]);
        }
        AudioFormat[] formatArray = new AudioFormat[newFormats.size()];
        for (int i = 0; i < formatArray.length; ++i) {
            formatArray[i] = (AudioFormat)newFormats.elementAt(i);
        }
        return formatArray;
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        if (this.isConversionSupported(targetEncoding, sourceStream.getFormat())) {
            AudioFormat sourceFormat = sourceStream.getFormat();
            AudioFormat targetFormat = new AudioFormat(targetEncoding, sourceFormat.getSampleRate(), sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), sourceFormat.getFrameSize(), sourceFormat.getFrameRate(), sourceFormat.isBigEndian());
            return this.getAudioInputStream(targetFormat, sourceStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + sourceStream.getFormat().toString() + " to " + targetEncoding.toString());
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        return this.getConvertedStream(targetFormat, sourceStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat outputFormat, AudioInputStream stream) {
        AudioInputStream cs = null;
        AudioFormat inputFormat = stream.getFormat();
        if (inputFormat.matches(outputFormat)) {
            cs = stream;
        } else {
            cs = new PCMtoPCMCodecStream(stream, outputFormat);
            this.tempBuffer = new byte[64];
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioFormat[] getOutputFormats(AudioFormat inputFormat) {
        AudioFormat[] formatArray;
        AudioFormat format2;
        Vector<AudioFormat> formats = new Vector<AudioFormat>();
        int sampleSize = inputFormat.getSampleSizeInBits();
        boolean isBigEndian = inputFormat.isBigEndian();
        if (sampleSize == 8) {
            if (AudioFormat.Encoding.PCM_SIGNED.equals(inputFormat.getEncoding())) {
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format2);
            }
            if (AudioFormat.Encoding.PCM_UNSIGNED.equals(inputFormat.getEncoding())) {
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format2);
            }
        } else if (sampleSize == 16) {
            if (AudioFormat.Encoding.PCM_SIGNED.equals(inputFormat.getEncoding()) && isBigEndian) {
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format2);
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format2);
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format2);
            }
            if (AudioFormat.Encoding.PCM_UNSIGNED.equals(inputFormat.getEncoding()) && isBigEndian) {
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format2);
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format2);
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format2);
            }
            if (AudioFormat.Encoding.PCM_SIGNED.equals(inputFormat.getEncoding()) && !isBigEndian) {
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format2);
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format2);
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format2);
            }
            if (AudioFormat.Encoding.PCM_UNSIGNED.equals(inputFormat.getEncoding()) && !isBigEndian) {
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format2);
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format2);
                format2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format2);
            }
        }
        Vector<AudioFormat> vector2 = formats;
        synchronized (vector2) {
            formatArray = new AudioFormat[formats.size()];
            for (int i = 0; i < formatArray.length; ++i) {
                formatArray[i] = (AudioFormat)formats.elementAt(i);
            }
        }
        return formatArray;
    }

    class PCMtoPCMCodecStream
    extends AudioInputStream {
        private final int PCM_SWITCH_SIGNED_8BIT = 1;
        private final int PCM_SWITCH_ENDIAN = 2;
        private final int PCM_SWITCH_SIGNED_LE = 3;
        private final int PCM_SWITCH_SIGNED_BE = 4;
        private final int PCM_UNSIGNED_LE2SIGNED_BE = 5;
        private final int PCM_SIGNED_LE2UNSIGNED_BE = 6;
        private final int PCM_UNSIGNED_BE2SIGNED_LE = 7;
        private final int PCM_SIGNED_BE2UNSIGNED_LE = 8;
        private final int sampleSizeInBytes;
        private int conversionType;

        PCMtoPCMCodecStream(AudioInputStream stream, AudioFormat outputFormat) {
            super(stream, outputFormat, -1L);
            this.PCM_SWITCH_SIGNED_8BIT = 1;
            this.PCM_SWITCH_ENDIAN = 2;
            this.PCM_SWITCH_SIGNED_LE = 3;
            this.PCM_SWITCH_SIGNED_BE = 4;
            this.PCM_UNSIGNED_LE2SIGNED_BE = 5;
            this.PCM_SIGNED_LE2UNSIGNED_BE = 6;
            this.PCM_UNSIGNED_BE2SIGNED_LE = 7;
            this.PCM_SIGNED_BE2UNSIGNED_LE = 8;
            this.conversionType = 0;
            int sampleSizeInBits = 0;
            AudioFormat.Encoding inputEncoding = null;
            AudioFormat.Encoding outputEncoding = null;
            AudioFormat inputFormat = stream.getFormat();
            if (!PCMtoPCMCodec.this.isConversionSupported(inputFormat, outputFormat)) {
                throw new IllegalArgumentException("Unsupported conversion: " + inputFormat.toString() + " to " + outputFormat.toString());
            }
            inputEncoding = inputFormat.getEncoding();
            outputEncoding = outputFormat.getEncoding();
            boolean inputIsBigEndian = inputFormat.isBigEndian();
            boolean outputIsBigEndian = outputFormat.isBigEndian();
            sampleSizeInBits = inputFormat.getSampleSizeInBits();
            this.sampleSizeInBytes = sampleSizeInBits / 8;
            if (sampleSizeInBits == 8) {
                if (AudioFormat.Encoding.PCM_UNSIGNED.equals(inputEncoding) && AudioFormat.Encoding.PCM_SIGNED.equals(outputEncoding)) {
                    this.conversionType = 1;
                } else if (AudioFormat.Encoding.PCM_SIGNED.equals(inputEncoding) && AudioFormat.Encoding.PCM_UNSIGNED.equals(outputEncoding)) {
                    this.conversionType = 1;
                }
            } else if (inputEncoding.equals(outputEncoding) && inputIsBigEndian != outputIsBigEndian) {
                this.conversionType = 2;
            } else if (AudioFormat.Encoding.PCM_UNSIGNED.equals(inputEncoding) && !inputIsBigEndian && AudioFormat.Encoding.PCM_SIGNED.equals(outputEncoding) && outputIsBigEndian) {
                this.conversionType = 5;
            } else if (AudioFormat.Encoding.PCM_SIGNED.equals(inputEncoding) && !inputIsBigEndian && AudioFormat.Encoding.PCM_UNSIGNED.equals(outputEncoding) && outputIsBigEndian) {
                this.conversionType = 6;
            } else if (AudioFormat.Encoding.PCM_UNSIGNED.equals(inputEncoding) && inputIsBigEndian && AudioFormat.Encoding.PCM_SIGNED.equals(outputEncoding) && !outputIsBigEndian) {
                this.conversionType = 7;
            } else if (AudioFormat.Encoding.PCM_SIGNED.equals(inputEncoding) && inputIsBigEndian && AudioFormat.Encoding.PCM_UNSIGNED.equals(outputEncoding) && !outputIsBigEndian) {
                this.conversionType = 8;
            }
            this.frameSize = inputFormat.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
            this.frameLength = stream instanceof AudioInputStream ? stream.getFrameLength() : -1L;
            this.framePos = 0L;
        }

        @Override
        public int read() throws IOException {
            if (this.frameSize == 1) {
                if (this.conversionType == 1) {
                    int temp = super.read();
                    if (temp < 0) {
                        return temp;
                    }
                    byte tempbyte = (byte)(temp & 0xF);
                    tempbyte = tempbyte >= 0 ? (byte)(0x80 | tempbyte) : (byte)(0x7F & tempbyte);
                    temp = tempbyte & 0xF;
                    return temp;
                }
                throw new IOException("cannot read a single byte if frame size > 1");
            }
            throw new IOException("cannot read a single byte if frame size > 1");
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int readCount;
            if (len % this.frameSize != 0) {
                len -= len % this.frameSize;
            }
            if (this.frameLength != -1L && (long)(len / this.frameSize) > this.frameLength - this.framePos) {
                len = (int)(this.frameLength - this.framePos) * this.frameSize;
            }
            if ((readCount = super.read(b, off, len)) < 0) {
                return readCount;
            }
            switch (this.conversionType) {
                case 1: {
                    this.switchSigned8bit(b, off, len, readCount);
                    break;
                }
                case 2: {
                    this.switchEndian(b, off, len, readCount);
                    break;
                }
                case 3: {
                    this.switchSignedLE(b, off, len, readCount);
                    break;
                }
                case 4: {
                    this.switchSignedBE(b, off, len, readCount);
                    break;
                }
                case 5: 
                case 6: {
                    this.switchSignedLE(b, off, len, readCount);
                    this.switchEndian(b, off, len, readCount);
                    break;
                }
                case 7: 
                case 8: {
                    this.switchSignedBE(b, off, len, readCount);
                    this.switchEndian(b, off, len, readCount);
                    break;
                }
            }
            return readCount;
        }

        private void switchSigned8bit(byte[] b, int off, int len, int readCount) {
            for (int i = off; i < off + readCount; ++i) {
                b[i] = b[i] >= 0 ? (byte)(0x80 | b[i]) : (byte)(0x7F & b[i]);
            }
        }

        private void switchSignedBE(byte[] b, int off, int len, int readCount) {
            for (int i = off; i < off + readCount; i += this.sampleSizeInBytes) {
                b[i] = b[i] >= 0 ? (byte)(0x80 | b[i]) : (byte)(0x7F & b[i]);
            }
        }

        private void switchSignedLE(byte[] b, int off, int len, int readCount) {
            for (int i = off + this.sampleSizeInBytes - 1; i < off + readCount; i += this.sampleSizeInBytes) {
                b[i] = b[i] >= 0 ? (byte)(0x80 | b[i]) : (byte)(0x7F & b[i]);
            }
        }

        private void switchEndian(byte[] b, int off, int len, int readCount) {
            if (this.sampleSizeInBytes == 2) {
                for (int i = off; i < off + readCount; i += this.sampleSizeInBytes) {
                    byte temp = b[i];
                    b[i] = b[i + 1];
                    b[i + 1] = temp;
                }
            }
        }
    }
}

