/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import org.wysko.gervill.ModelTransform;

public final class ModelStandardTransform
implements ModelTransform {
    public static final boolean DIRECTION_MIN2MAX = false;
    public static final boolean DIRECTION_MAX2MIN = true;
    public static final boolean POLARITY_UNIPOLAR = false;
    public static final boolean POLARITY_BIPOLAR = true;
    public static final int TRANSFORM_LINEAR = 0;
    public static final int TRANSFORM_CONCAVE = 1;
    public static final int TRANSFORM_CONVEX = 2;
    public static final int TRANSFORM_SWITCH = 3;
    public static final int TRANSFORM_ABSOLUTE = 4;
    private boolean direction = false;
    private boolean polarity = false;
    private int transform = 0;

    public ModelStandardTransform() {
    }

    public ModelStandardTransform(boolean direction) {
        this.direction = direction;
    }

    public ModelStandardTransform(boolean direction, boolean polarity) {
        this.direction = direction;
        this.polarity = polarity;
    }

    public ModelStandardTransform(boolean direction, boolean polarity, int transform2) {
        this.direction = direction;
        this.polarity = polarity;
        this.transform = transform2;
    }

    @Override
    public double transform(double value) {
        if (this.direction) {
            value = 1.0 - value;
        }
        if (this.polarity) {
            value = value * 2.0 - 1.0;
        }
        switch (this.transform) {
            case 1: {
                double s = Math.signum(value);
                double a = Math.abs(value);
                a = -(0.4166666666666667 / Math.log(10.0)) * Math.log(1.0 - a);
                if (a < 0.0) {
                    a = 0.0;
                } else if (a > 1.0) {
                    a = 1.0;
                }
                return s * a;
            }
            case 2: {
                double s = Math.signum(value);
                double a = Math.abs(value);
                a = 1.0 + 0.4166666666666667 / Math.log(10.0) * Math.log(a);
                if (a < 0.0) {
                    a = 0.0;
                } else if (a > 1.0) {
                    a = 1.0;
                }
                return s * a;
            }
            case 3: {
                if (this.polarity) {
                    return value > 0.0 ? 1.0 : -1.0;
                }
                return value > 0.5 ? 1.0 : 0.0;
            }
            case 4: {
                return Math.abs(value);
            }
        }
        return value;
    }

    public boolean getDirection() {
        return this.direction;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public boolean getPolarity() {
        return this.polarity;
    }

    public void setPolarity(boolean polarity) {
        this.polarity = polarity;
    }

    public int getTransform() {
        return this.transform;
    }

    public void setTransform(int transform2) {
        this.transform = transform2;
    }
}

