/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.util.Arrays;
import org.wysko.gervill.ModelDirectedPlayer;
import org.wysko.gervill.ModelDirector;
import org.wysko.gervill.ModelPerformer;

public final class ModelStandardIndexedDirector
implements ModelDirector {
    private final ModelPerformer[] performers;
    private final ModelDirectedPlayer player;
    private boolean noteOnUsed = false;
    private boolean noteOffUsed = false;
    private byte[][] trantables;
    private int[] counters;
    private int[][] mat;

    public ModelStandardIndexedDirector(ModelPerformer[] performers, ModelDirectedPlayer player) {
        this.performers = Arrays.copyOf(performers, performers.length);
        this.player = player;
        for (ModelPerformer p : this.performers) {
            if (p.isReleaseTriggered()) {
                this.noteOffUsed = true;
                continue;
            }
            this.noteOnUsed = true;
        }
        this.buildindex();
    }

    private int[] lookupIndex(int x2, int y2) {
        if (x2 >= 0 && x2 < 128 && y2 >= 0 && y2 < 128) {
            byte xt = this.trantables[0][x2];
            byte yt = this.trantables[1][y2];
            if (xt != -1 && yt != -1) {
                return this.mat[xt + yt * this.counters[0]];
            }
        }
        return null;
    }

    private int restrict(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 127) {
            return 127;
        }
        return value;
    }

    private void buildindex() {
        this.trantables = new byte[2][129];
        this.counters = new int[this.trantables.length];
        for (ModelPerformer performer : this.performers) {
            int keyFrom = performer.getKeyFrom();
            int keyTo = performer.getKeyTo();
            int velFrom = performer.getVelFrom();
            int velTo = performer.getVelTo();
            if (keyFrom > keyTo || velFrom > velTo) continue;
            keyFrom = this.restrict(keyFrom);
            keyTo = this.restrict(keyTo);
            velFrom = this.restrict(velFrom);
            velTo = this.restrict(velTo);
            this.trantables[0][keyFrom] = 1;
            this.trantables[0][keyTo + 1] = 1;
            this.trantables[1][velFrom] = 1;
            this.trantables[1][velTo + 1] = 1;
        }
        for (int d = 0; d < this.trantables.length; ++d) {
            byte[] trantable = this.trantables[d];
            int transize = trantable.length;
            for (int i = transize - 1; i >= 0; --i) {
                if (trantable[i] == 1) {
                    trantable[i] = -1;
                    break;
                }
                trantable[i] = -1;
            }
            int counter = -1;
            for (int i = 0; i < transize; ++i) {
                if (trantable[i] != 0) {
                    ++counter;
                    if (trantable[i] == -1) break;
                }
                trantable[i] = (byte)counter;
            }
            this.counters[d] = counter;
        }
        this.mat = new int[this.counters[0] * this.counters[1]][];
        int ix = 0;
        for (ModelPerformer performer : this.performers) {
            int keyFrom = performer.getKeyFrom();
            int keyTo = performer.getKeyTo();
            int velFrom = performer.getVelFrom();
            int velTo = performer.getVelTo();
            if (keyFrom > keyTo || velFrom > velTo) continue;
            keyFrom = this.restrict(keyFrom);
            keyTo = this.restrict(keyTo);
            velFrom = this.restrict(velFrom);
            velTo = this.restrict(velTo);
            int x_from = this.trantables[0][keyFrom];
            int x_to = this.trantables[0][keyTo + 1];
            int y_from = this.trantables[1][velFrom];
            int y_to = this.trantables[1][velTo + 1];
            if (x_to == -1) {
                x_to = this.counters[0];
            }
            if (y_to == -1) {
                y_to = this.counters[1];
            }
            for (int y2 = y_from; y2 < y_to; ++y2) {
                int i = x_from + y2 * this.counters[0];
                for (int x2 = x_from; x2 < x_to; ++x2) {
                    int[] mprev = this.mat[i];
                    if (mprev == null) {
                        this.mat[i] = new int[]{ix};
                    } else {
                        int[] mnew = new int[mprev.length + 1];
                        mnew[mnew.length - 1] = ix;
                        for (int k = 0; k < mprev.length; ++k) {
                            mnew[k] = mprev[k];
                        }
                        this.mat[i] = mnew;
                    }
                    ++i;
                }
            }
            ++ix;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void noteOff(int noteNumber, int velocity) {
        if (!this.noteOffUsed) {
            return;
        }
        int[] plist = this.lookupIndex(noteNumber, velocity);
        if (plist == null) {
            return;
        }
        for (int i : plist) {
            ModelPerformer p = this.performers[i];
            if (!p.isReleaseTriggered()) continue;
            this.player.play(i, null);
        }
    }

    @Override
    public void noteOn(int noteNumber, int velocity) {
        if (!this.noteOnUsed) {
            return;
        }
        int[] plist = this.lookupIndex(noteNumber, velocity);
        if (plist == null) {
            return;
        }
        for (int i : plist) {
            ModelPerformer p = this.performers[i];
            if (p.isReleaseTriggered()) continue;
            this.player.play(i, null);
        }
    }
}

